// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_event_trigger_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/dom/events/event_target.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"eventTarget",
"eventType",
};


}  // namespace 

EventTriggerOptions* EventTriggerOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  EventTriggerOptions* dictionary = MakeGarbageCollected<EventTriggerOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "EventTriggerOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 EventTriggerOptions::EventTriggerOptions() {
  
}

 EventTriggerOptions::EventTriggerOptions(v8::Isolate* isolate) {
  
}










String EventTriggerOptions::getEventTypeOr(const String& fallback_value) const {
  if (!hasEventType()) {
  return fallback_value;
}
return member_event_type_;
}

String EventTriggerOptions::getEventTypeOr(String&& fallback_value) const {
  if (!hasEventType()) {
  return std::move(fallback_value);
}
return member_event_type_;
}

void EventTriggerOptions::setEventType(const String& value) {
  member_event_type_ = value;
has_event_type_ = true;
}

void EventTriggerOptions::setEventType(String&& value) {
  member_event_type_ = std::move(value);
has_event_type_ = true;
}




void EventTriggerOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_event_target_);
bindings::InputDictionaryBase::Trace(visitor);
}

void EventTriggerOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "EventTriggerOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("eventTarget");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<EventTarget, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_event_target_, member_event_target_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("eventType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_event_type_, member_event_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> EventTriggerOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
