// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_event_modifier_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"altKey",
"ctrlKey",
"metaKey",
"modifierAltGraph",
"modifierCapsLock",
"modifierFn",
"modifierNumLock",
"modifierScrollLock",
"modifierSymbol",
"shiftKey",
};


}  // namespace 

EventModifierInit* EventModifierInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  EventModifierInit* dictionary = MakeGarbageCollected<EventModifierInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "EventModifierInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 EventModifierInit::EventModifierInit() {
  
}

 EventModifierInit::EventModifierInit(v8::Isolate* isolate) : UIEventInit(isolate) {
  
}





















































void EventModifierInit::Trace(Visitor* visitor) const {
  UIEventInit::Trace(visitor);
}

void EventModifierInit::FillTemplateProperties(Vector<std::string_view>& properties) const {
  UIEventInit::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void EventModifierInit::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  UIEventInit::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAltKey()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_alt_key_);
DCHECK(!values[0].IsEmpty());
}
if (hasCtrlKey()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_ctrl_key_);
DCHECK(!values[1].IsEmpty());
}
if (hasMetaKey()) {
  values[2] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_meta_key_);
DCHECK(!values[2].IsEmpty());
}
if (hasModifierAltGraph()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_modifier_alt_graph_);
DCHECK(!values[3].IsEmpty());
}
if (hasModifierCapsLock()) {
  values[4] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_modifier_caps_lock_);
DCHECK(!values[4].IsEmpty());
}
if (hasModifierFn()) {
  values[5] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_modifier_fn_);
DCHECK(!values[5].IsEmpty());
}
if (hasModifierNumLock()) {
  values[6] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_modifier_num_lock_);
DCHECK(!values[6].IsEmpty());
}
if (hasModifierScrollLock()) {
  values[7] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_modifier_scroll_lock_);
DCHECK(!values[7].IsEmpty());
}
if (hasModifierSymbol()) {
  values[8] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_modifier_symbol_);
DCHECK(!values[8].IsEmpty());
}
if (hasShiftKey()) {
  values[9] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_shift_key_);
DCHECK(!values[9].IsEmpty());
}
}

const void* EventModifierInit::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> EventModifierInit::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void EventModifierInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
UIEventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "EventModifierInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("altKey");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_alt_key_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ctrlKey");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_ctrl_key_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("metaKey");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_meta_key_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifierAltGraph");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_modifier_alt_graph_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifierCapsLock");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_modifier_caps_lock_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifierFn");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_modifier_fn_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifierNumLock");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_modifier_num_lock_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifierScrollLock");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_modifier_scroll_lock_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifierSymbol");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_modifier_symbol_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("shiftKey");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_shift_key_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> EventModifierInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
