// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT EventInit : public bindings::DictionaryBase {
  
  public:
static EventInit* Create() {
  return MakeGarbageCollected<EventInit>();
}
static EventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<EventInit>(isolate);
}
static EventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  EventInit();
explicit  EventInit(v8::Isolate* isolate);

bool hasBubbles() const {
  return true;
}
bool bubbles() const {
  return member_bubbles_;
}
void setBubbles(bool value) {
  member_bubbles_ = value;
}

bool hasCancelable() const {
  return true;
}
bool cancelable() const {
  return member_cancelable_;
}
void setCancelable(bool value) {
  member_cancelable_ = value;
}

bool hasComposed() const {
  return true;
}
bool composed() const {
  return member_composed_;
}
void setComposed(bool value) {
  member_composed_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_bubbles_{false};
bool member_cancelable_{false};
bool member_composed_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_INIT_H_
