// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EFFECT_TIMING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EFFECT_TIMING_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_fill_mode.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_playback_direction.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class CSSNumericValue;
class ExceptionState;
class V8UnionCSSNumericValueOrDouble;
class V8UnionCSSNumericValueOrStringOrUnrestrictedDouble;

class CORE_EXPORT EffectTiming : public bindings::DictionaryBase {
  
  public:
static EffectTiming* Create() {
  return MakeGarbageCollected<EffectTiming>();
}
static EffectTiming* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<EffectTiming>(isolate);
}
static EffectTiming* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  EffectTiming();
explicit  EffectTiming(v8::Isolate* isolate);

bool hasDelay() const {
  return true;
}
V8UnionCSSNumericValueOrDouble* delay() const {
  return member_delay_.Get();
}
void setDelay(V8UnionCSSNumericValueOrDouble* value) {
  member_delay_ = value;
DCHECK(member_delay_);
}

bool hasDirection() const {
  return true;
}
V8PlaybackDirection direction() const {
  return member_direction_;
}
void setDirection(V8PlaybackDirection value) {
  member_direction_ = value;
}
void setDirection(V8PlaybackDirection::Enum value) {
  member_direction_ = V8PlaybackDirection(value);
}

bool hasDuration() const {
  return true;
}
V8UnionCSSNumericValueOrStringOrUnrestrictedDouble* duration() const {
  return member_duration_.Get();
}
void setDuration(V8UnionCSSNumericValueOrStringOrUnrestrictedDouble* value) {
  member_duration_ = value;
DCHECK(member_duration_);
}

bool hasEasing() const {
  return true;
}
const String& easing() const {
  return member_easing_;
}
void setEasing(const String& value);
void setEasing(String&& value);

bool hasEndDelay() const {
  return true;
}
V8UnionCSSNumericValueOrDouble* endDelay() const {
  return member_end_delay_.Get();
}
void setEndDelay(V8UnionCSSNumericValueOrDouble* value) {
  member_end_delay_ = value;
DCHECK(member_end_delay_);
}

bool hasFill() const {
  return true;
}
V8FillMode fill() const {
  return member_fill_;
}
void setFill(V8FillMode value) {
  member_fill_ = value;
}
void setFill(V8FillMode::Enum value) {
  member_fill_ = V8FillMode(value);
}

bool hasIterationStart() const {
  return true;
}
double iterationStart() const {
  return member_iteration_start_;
}
void setIterationStart(double value) {
  member_iteration_start_ = value;
}

bool hasIterations() const {
  return true;
}
double iterations() const {
  return member_iterations_;
}
void setIterations(double value) {
  member_iterations_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<V8UnionCSSNumericValueOrDouble> member_delay_;
V8PlaybackDirection member_direction_{V8PlaybackDirection::Enum::kNormal};
Member<V8UnionCSSNumericValueOrStringOrUnrestrictedDouble> member_duration_;
String member_easing_{"linear"};
Member<V8UnionCSSNumericValueOrDouble> member_end_delay_;
V8FillMode member_fill_{V8FillMode::Enum::kAuto};
double member_iteration_start_{0.0};
double member_iterations_{1.0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EFFECT_TIMING_H_
