// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_MATRIX_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_MATRIX_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_matrix_2d_init.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT DOMMatrixInit : public DOMMatrix2DInit {
  
  public:
static DOMMatrixInit* Create() {
  return MakeGarbageCollected<DOMMatrixInit>();
}
static DOMMatrixInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DOMMatrixInit>(isolate);
}
static DOMMatrixInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DOMMatrixInit();
explicit  DOMMatrixInit(v8::Isolate* isolate);

bool hasIs2D() const {
  return has_is_2d_;
}
bool is2D() const {
  DCHECK(hasIs2D());
return member_is_2d_;
}
bool getIs2DOr(bool fallback_value) const {
  if (!hasIs2D()) {
  return fallback_value;
}
return member_is_2d_;
}
void setIs2D(bool value) {
  member_is_2d_ = value;
has_is_2d_ = true;
}

bool hasM13() const {
  return true;
}
double m13() const {
  return member_m_13_;
}
void setM13(double value) {
  member_m_13_ = value;
}

bool hasM14() const {
  return true;
}
double m14() const {
  return member_m_14_;
}
void setM14(double value) {
  member_m_14_ = value;
}

bool hasM23() const {
  return true;
}
double m23() const {
  return member_m_23_;
}
void setM23(double value) {
  member_m_23_ = value;
}

bool hasM24() const {
  return true;
}
double m24() const {
  return member_m_24_;
}
void setM24(double value) {
  member_m_24_ = value;
}

bool hasM31() const {
  return true;
}
double m31() const {
  return member_m_31_;
}
void setM31(double value) {
  member_m_31_ = value;
}

bool hasM32() const {
  return true;
}
double m32() const {
  return member_m_32_;
}
void setM32(double value) {
  member_m_32_ = value;
}

bool hasM33() const {
  return true;
}
double m33() const {
  return member_m_33_;
}
void setM33(double value) {
  member_m_33_ = value;
}

bool hasM34() const {
  return true;
}
double m34() const {
  return member_m_34_;
}
void setM34(double value) {
  member_m_34_ = value;
}

bool hasM43() const {
  return true;
}
double m43() const {
  return member_m_43_;
}
void setM43(double value) {
  member_m_43_ = value;
}

bool hasM44() const {
  return true;
}
double m44() const {
  return member_m_44_;
}
void setM44(double value) {
  member_m_44_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = DOMMatrix2DInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 11;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_is_2d_ = false;

bool member_is_2d_;
double member_m_13_{0};
double member_m_14_{0};
double member_m_23_{0};
double member_m_24_{0};
double member_m_31_{0};
double member_m_32_{0};
double member_m_33_{1};
double member_m_34_{0};
double member_m_43_{0};
double member_m_44_{1};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_MATRIX_INIT_H_
