// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CSS_MATRIX_COMPONENT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CSS_MATRIX_COMPONENT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT CSSMatrixComponentOptions : public bindings::InputDictionaryBase {
  
  public:
static CSSMatrixComponentOptions* Create() {
  return MakeGarbageCollected<CSSMatrixComponentOptions>();
}
static CSSMatrixComponentOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CSSMatrixComponentOptions>(isolate);
}
static CSSMatrixComponentOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CSSMatrixComponentOptions();
explicit  CSSMatrixComponentOptions(v8::Isolate* isolate);

bool hasIs2D() const {
  return has_is_2d_;
}
bool is2D() const {
  DCHECK(hasIs2D());
return member_is_2d_;
}
bool getIs2DOr(bool fallback_value) const {
  if (!hasIs2D()) {
  return fallback_value;
}
return member_is_2d_;
}
void setIs2D(bool value) {
  member_is_2d_ = value;
has_is_2d_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_is_2d_ = false;

bool member_is_2d_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CSS_MATRIX_COMPONENT_OPTIONS_H_
