// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_create_url_callback.h"

#include <tuple>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"

namespace blink {





const char* V8CreateURLCallback::GetHumanReadableName() const {
  return "V8CreateURLCallback";
}

v8::Maybe<String> V8CreateURLCallback::Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const String& arg1_input, const HeapVector<ScriptValue>& arg2_args) {
  const char* const class_like_name = "CreateURLCallback";
const char* const property_name = "invoke";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<String>();
}

v8::Isolate* isolate = GetIsolate();
if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<String>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kDefault, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<String>();
}
return helper.Result<IDLNullable<IDLUSVString>, String>();
}
v8::Local<v8::Value> argv_arr[10];
v8::LocalVector<v8::Value> argv_vec(GetIsolate());
base::span<v8::Local<v8::Value>> argv;
const size_t argc = 1 + arg2_args.size();
if (argc <= 10) {
  argv = base::span(argv_arr, argc);
} else {
  argv_vec.resize(argc);
argv = argv_vec;
}
v8::Local<v8::Value> v8_arg1_input;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_input = ToV8Traits<IDLString>::ToV8(script_state, arg1_input);
argv[0] = v8_arg1_input;
for (wtf_size_t i = 0; i < arg2_args.size(); ++i) {
  v8::Local<v8::Value> v8_arg2_args;
v8_arg2_args = ToV8Traits<IDLAny>::ToV8(script_state, arg2_args[i]);
argv[1 + i] = v8_arg2_args;
}

if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<String>();
}
return helper.Result<IDLNullable<IDLUSVString>, String>();
}

v8::Maybe<String> V8CreateURLCallback::Construct(const String& arg1_input, const HeapVector<ScriptValue>& arg2_args) {
  const char* const class_like_name = "CreateURLCallback";
const char* const property_name = "construct";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<String>();
}

v8::Isolate* isolate = GetIsolate();
if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<String>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kConstructorCall, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(nullptr)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<String>();
}
return helper.Result<IDLNullable<IDLUSVString>, String>();
}
v8::Local<v8::Value> argv_arr[10];
v8::LocalVector<v8::Value> argv_vec(GetIsolate());
base::span<v8::Local<v8::Value>> argv;
const size_t argc = 1 + arg2_args.size();
if (argc <= 10) {
  argv = base::span(argv_arr, argc);
} else {
  argv_vec.resize(argc);
argv = argv_vec;
}
v8::Local<v8::Value> v8_arg1_input;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_input = ToV8Traits<IDLString>::ToV8(script_state, arg1_input);
argv[0] = v8_arg1_input;
for (wtf_size_t i = 0; i < arg2_args.size(); ++i) {
  v8::Local<v8::Value> v8_arg2_args;
v8_arg2_args = ToV8Traits<IDLAny>::ToV8(script_state, arg2_args[i]);
argv[1 + i] = v8_arg2_args;
}

if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<String>();
}
return helper.Result<IDLNullable<IDLUSVString>, String>();
}




}  // namespace blink
