// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CHECK_VISIBILITY_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CHECK_VISIBILITY_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT CheckVisibilityOptions : public bindings::InputDictionaryBase {
  
  public:
static CheckVisibilityOptions* Create() {
  return MakeGarbageCollected<CheckVisibilityOptions>();
}
static CheckVisibilityOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CheckVisibilityOptions>(isolate);
}
static CheckVisibilityOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CheckVisibilityOptions();
explicit  CheckVisibilityOptions(v8::Isolate* isolate);

bool hasCheckOpacity() const {
  return true;
}
bool checkOpacity() const {
  return member_check_opacity_;
}
void setCheckOpacity(bool value) {
  member_check_opacity_ = value;
}

bool hasCheckVisibilityCSS() const {
  return true;
}
bool checkVisibilityCSS() const {
  return member_check_visibility_css_;
}
void setCheckVisibilityCSS(bool value) {
  member_check_visibility_css_ = value;
}

bool hasContentVisibilityAuto() const {
  return true;
}
bool contentVisibilityAuto() const {
  return member_content_visibility_auto_;
}
void setContentVisibilityAuto(bool value) {
  member_content_visibility_auto_ = value;
}

bool hasOpacityProperty() const {
  return true;
}
bool opacityProperty() const {
  return member_opacity_property_;
}
void setOpacityProperty(bool value) {
  member_opacity_property_ = value;
}

bool hasVisibilityProperty() const {
  return true;
}
bool visibilityProperty() const {
  return member_visibility_property_;
}
void setVisibilityProperty(bool value) {
  member_visibility_property_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_check_opacity_{false};
bool member_check_visibility_css_{false};
bool member_content_visibility_auto_{false};
bool member_opacity_property_{false};
bool member_visibility_property_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CHECK_VISIBILITY_OPTIONS_H_
