// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_callback_function_test.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_div_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_internal_enum.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_test_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_test_enum_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_test_interface_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_test_receiver_object_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_test_sequence_callback.h"
#include "third_party/blink/renderer/core/html/html_div_element.h"
#include "third_party/blink/renderer/core/testing/callback_function_test.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8CallbackFunctionTest::IsExposed(ExecutionContext* execution_context) {
  return false;
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8CallbackFunctionTest::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8CallbackFunctionTest::InstallInterfaceTemplate,
    nullptr,
    "CallbackFunctionTest",
    nullptr,
    V8CallbackFunctionTest::kThisTag,
    V8CallbackFunctionTest::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& CallbackFunctionTest::wrapper_type_info_ =
    V8CallbackFunctionTest::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, CallbackFunctionTest>::value,
    "CallbackFunctionTest inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_callback_function_test {

void TestCallbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CallbackFunctionTest_testCallback");
BLINK_BINDINGS_TRACE_EVENT("CallbackFunctionTest.testCallback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
CallbackFunctionTest* blink_receiver = V8CallbackFunctionTest::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_callback = NativeValueTraits<V8TestCallback>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_message_1 = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_message_2 = NativeValueTraits<IDLString>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->testCallback(arg1_callback, arg2_message_1, arg3_message_2, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void TestEnumCallbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CallbackFunctionTest_testEnumCallback");
BLINK_BINDINGS_TRACE_EVENT("CallbackFunctionTest.testEnumCallback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
CallbackFunctionTest* blink_receiver = V8CallbackFunctionTest::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_callback = NativeValueTraits<V8TestEnumCallback>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_enum_value = NativeValueTraits<V8InternalEnum>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->testEnumCallback(arg1_callback, arg2_enum_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TestInterfaceCallbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CallbackFunctionTest_testInterfaceCallback");
BLINK_BINDINGS_TRACE_EVENT("CallbackFunctionTest.testInterfaceCallback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
CallbackFunctionTest* blink_receiver = V8CallbackFunctionTest::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_callback = NativeValueTraits<V8TestInterfaceCallback>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_div_element = NativeValueTraits<HTMLDivElement>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->testInterfaceCallback(arg1_callback, arg2_div_element, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TestNullableCallbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CallbackFunctionTest_testNullableCallback");
BLINK_BINDINGS_TRACE_EVENT("CallbackFunctionTest.testNullableCallback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
CallbackFunctionTest* blink_receiver = V8CallbackFunctionTest::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_callback = NativeValueTraits<IDLNullable<V8TestCallback>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_message_1 = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_message_2 = NativeValueTraits<IDLString>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->testNullableCallback(arg1_callback, arg2_message_1, arg3_message_2, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void TestReceiverObjectCallbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CallbackFunctionTest_testReceiverObjectCallback");
BLINK_BINDINGS_TRACE_EVENT("CallbackFunctionTest.testReceiverObjectCallback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
CallbackFunctionTest* blink_receiver = V8CallbackFunctionTest::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_callback = NativeValueTraits<V8TestReceiverObjectCallback>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->testReceiverObjectCallback(arg1_callback, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TestSequenceCallbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CallbackFunctionTest_testSequenceCallback");
BLINK_BINDINGS_TRACE_EVENT("CallbackFunctionTest.testSequenceCallback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
CallbackFunctionTest* blink_receiver = V8CallbackFunctionTest::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_callback = NativeValueTraits<V8TestSequenceCallback>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_numbers = NativeValueTraits<IDLSequence<IDLLong>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->testSequenceCallback(arg1_callback, std::move(arg2_numbers), exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLSequence<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}


}  // namespace v8_callback_function_test

using namespace v8_callback_function_test;

}  // namespace 

void V8CallbackFunctionTest::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8CallbackFunctionTest::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8CallbackFunctionTest::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"testCallback", TestCallbackOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"testEnumCallback", TestEnumCallbackOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"testInterfaceCallback", TestInterfaceCallbackOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"testNullableCallback", TestNullableCallbackOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"testReceiverObjectCallback", TestReceiverObjectCallbackOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"testSequenceCallback", TestSequenceCallbackOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "CallbackFunctionTest", kOperationTable);
}



}




}  // namespace blink
