// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ADD_EVENT_LISTENER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ADD_EVENT_LISTENER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_listener_options.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AbortSignal;
class ExceptionState;

class CORE_EXPORT AddEventListenerOptions : public EventListenerOptions {
  
  public:
static AddEventListenerOptions* Create() {
  return MakeGarbageCollected<AddEventListenerOptions>();
}
static AddEventListenerOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AddEventListenerOptions>(isolate);
}
static AddEventListenerOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AddEventListenerOptions();
explicit  AddEventListenerOptions(v8::Isolate* isolate);

bool hasOnce() const {
  return true;
}
bool once() const {
  return member_once_;
}
void setOnce(bool value) {
  member_once_ = value;
}

bool hasPassive() const {
  return has_passive_;
}
bool passive() const {
  DCHECK(hasPassive());
return member_passive_;
}
bool getPassiveOr(bool fallback_value) const {
  if (!hasPassive()) {
  return fallback_value;
}
return member_passive_;
}
void setPassive(bool value) {
  member_passive_ = value;
has_passive_ = true;
}

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
DCHECK(member_signal_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventListenerOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_passive_ = false;
bool has_signal_ = false;

bool member_once_{false};
bool member_passive_;
Member<AbortSignal> member_signal_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_ADD_EVENT_LISTENER_OPTIONS_H_
