// third_party/blink/public/mojom/worker/subresource_loader_updater.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/subresource_loader_updater.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/subresource_loader_updater.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/subresource_loader_updater.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/subresource_loader_updater.mojom-import-headers.h"
#include "third_party/blink/public/mojom/worker/subresource_loader_updater.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

SubresourceLoaderUpdater::IPCStableHashFunction SubresourceLoaderUpdater::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SubresourceLoaderUpdater>(message.name())) {
    case messages::SubresourceLoaderUpdater::kUpdateSubresourceLoaderFactories: {
      return &SubresourceLoaderUpdater::UpdateSubresourceLoaderFactories_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SubresourceLoaderUpdater::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SubresourceLoaderUpdater>(message.name())) {
      case messages::SubresourceLoaderUpdater::kUpdateSubresourceLoaderFactories:
            return "Receive blink::mojom::SubresourceLoaderUpdater::UpdateSubresourceLoaderFactories";
    }
  } else {
    switch (static_cast<messages::SubresourceLoaderUpdater>(message.name())) {
      case messages::SubresourceLoaderUpdater::kUpdateSubresourceLoaderFactories:
            return "Receive reply blink::mojom::SubresourceLoaderUpdater::UpdateSubresourceLoaderFactories";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SubresourceLoaderUpdater::UpdateSubresourceLoaderFactories_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e471727;  // IPCStableHash for blink::mojom::SubresourceLoaderUpdater::UpdateSubresourceLoaderFactories
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SubresourceLoaderUpdaterProxy::SubresourceLoaderUpdaterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SubresourceLoaderUpdaterProxy::UpdateSubresourceLoaderFactories(
    ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SubresourceLoaderUpdater::UpdateSubresourceLoaderFactories", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubresourceLoaderUpdater::kUpdateSubresourceLoaderFactories), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
    in_subresource_loader_factories,
    subresource_loader_factories_fragment);

  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subresource_loader_factories.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subresource_loader_factories in SubresourceLoaderUpdater.UpdateSubresourceLoaderFactories request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubresourceLoaderUpdater::Name_);
  message.set_method_name("UpdateSubresourceLoaderFactories");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SubresourceLoaderUpdaterStubDispatch::Accept(
    SubresourceLoaderUpdater* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SubresourceLoaderUpdater>(message->header()->name)) {
    case messages::SubresourceLoaderUpdater::kUpdateSubresourceLoaderFactories: {
      DCHECK(message->is_serialized());
      internal::SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params_Data* params =
          reinterpret_cast<internal::SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SubresourceLoaderUpdater.0
      bool success = true;
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubresourceLoaderUpdater::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSubresourceLoaderFactories(        
        std::move(p_subresource_loader_factories));
      return true;
    }
  }
  return false;
}

// static
bool SubresourceLoaderUpdaterStubDispatch::AcceptWithResponder(
    SubresourceLoaderUpdater* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SubresourceLoaderUpdater>(message->header()->name)) {
    case messages::SubresourceLoaderUpdater::kUpdateSubresourceLoaderFactories: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSubresourceLoaderUpdaterValidationInfo[] = {
    { &internal::SubresourceLoaderUpdater_UpdateSubresourceLoaderFactories_Params_Data::Validate,
     nullptr /* no response */},
};

bool SubresourceLoaderUpdaterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::SubresourceLoaderUpdater::Name_,
    kSubresourceLoaderUpdaterValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void SubresourceLoaderUpdaterInterceptorForTesting::UpdateSubresourceLoaderFactories(::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories) {
  GetForwardingInterface()->UpdateSubresourceLoaderFactories(
    std::move(subresource_loader_factories)
    );
}
SubresourceLoaderUpdaterAsyncWaiter::SubresourceLoaderUpdaterAsyncWaiter(
    SubresourceLoaderUpdater* proxy) : proxy_(proxy) {}

SubresourceLoaderUpdaterAsyncWaiter::~SubresourceLoaderUpdaterAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif