// third_party/blink/public/mojom/worker/shared_worker_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedWorkerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedWorkerHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SharedWorkerHostInterface }
 */
blink.mojom.SharedWorkerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedWorkerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedWorkerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedWorkerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } connectionId
   */

  onConnected(
      connectionId) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SharedWorkerHost_OnConnected_ParamsSpec.$,
        null,
        [
          connectionId
        ],
        false);
  }

  
  /**
   */

  onContextClosed() {
    this.proxy.sendMessage(
        1,
        blink.mojom.SharedWorkerHost_OnContextClosed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DevToolsAgentRemote } agent
   * @param { !blink.mojom.DevToolsAgentHostPendingReceiver } agentHost
   */

  onReadyForInspection(
      agent,
      agentHost) {
    this.proxy.sendMessage(
        2,
        blink.mojom.SharedWorkerHost_OnReadyForInspection_ParamsSpec.$,
        null,
        [
          agent,
          agentHost
        ],
        false);
  }

  
  /**
   * @param { !string } errorMessage
   */

  onScriptLoadFailed(
      errorMessage) {
    this.proxy.sendMessage(
        3,
        blink.mojom.SharedWorkerHost_OnScriptLoadFailed_ParamsSpec.$,
        null,
        [
          errorMessage
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.SharedWorkerExceptionDetails } details
   */

  onReportException(
      details) {
    this.proxy.sendMessage(
        4,
        blink.mojom.SharedWorkerHost_OnReportException_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.WebFeature } feature
   */

  onFeatureUsed(
      feature) {
    this.proxy.sendMessage(
        5,
        blink.mojom.SharedWorkerHost_OnFeatureUsed_ParamsSpec.$,
        null,
        [
          feature
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedWorkerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedWorkerHostReceiver = class {
  /**
   * @param {!blink.mojom.SharedWorkerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedWorkerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorkerHost_OnConnected_ParamsSpec.$,
        null,
        impl.onConnected.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedWorkerHost_OnContextClosed_ParamsSpec.$,
        null,
        impl.onContextClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedWorkerHost_OnReadyForInspection_ParamsSpec.$,
        null,
        impl.onReadyForInspection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedWorkerHost_OnScriptLoadFailed_ParamsSpec.$,
        null,
        impl.onScriptLoadFailed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SharedWorkerHost_OnReportException_ParamsSpec.$,
        null,
        impl.onReportException.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.SharedWorkerHost_OnFeatureUsed_ParamsSpec.$,
        null,
        impl.onFeatureUsed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedWorkerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedWorkerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedWorkerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedWorkerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedWorkerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedWorkerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnected =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorkerHost_OnConnected_ParamsSpec.$,
        null,
        this.onConnected.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onContextClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedWorkerHost_OnContextClosed_ParamsSpec.$,
        null,
        this.onContextClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReadyForInspection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedWorkerHost_OnReadyForInspection_ParamsSpec.$,
        null,
        this.onReadyForInspection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptLoadFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedWorkerHost_OnScriptLoadFailed_ParamsSpec.$,
        null,
        this.onScriptLoadFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReportException =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SharedWorkerHost_OnReportException_ParamsSpec.$,
        null,
        this.onReportException.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFeatureUsed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.SharedWorkerHost_OnFeatureUsed_ParamsSpec.$,
        null,
        this.onFeatureUsed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerHost_OnConnected_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerHost_OnContextClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerHost_OnReadyForInspection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerHost_OnScriptLoadFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerHost_OnReportException_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerHost_OnFeatureUsed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SharedWorkerHost_OnConnected_ParamsSpec.$,
    'SharedWorkerHost_OnConnected_Params',
    [
      mojo.internal.StructField(
        'connectionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedWorkerHost_OnConnected_Params = class {
  constructor() {
    /** @export { !number } */
    this.connectionId;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorkerHost_OnContextClosed_ParamsSpec.$,
    'SharedWorkerHost_OnContextClosed_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.SharedWorkerHost_OnContextClosed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorkerHost_OnReadyForInspection_ParamsSpec.$,
    'SharedWorkerHost_OnReadyForInspection_Params',
    [
      mojo.internal.StructField(
        'agent', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.DevToolsAgentRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'agentHost', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.DevToolsAgentHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedWorkerHost_OnReadyForInspection_Params = class {
  constructor() {
    /** @export { !blink.mojom.DevToolsAgentRemote } */
    this.agent;
    /** @export { !blink.mojom.DevToolsAgentHostPendingReceiver } */
    this.agentHost;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorkerHost_OnScriptLoadFailed_ParamsSpec.$,
    'SharedWorkerHost_OnScriptLoadFailed_Params',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedWorkerHost_OnScriptLoadFailed_Params = class {
  constructor() {
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorkerHost_OnReportException_ParamsSpec.$,
    'SharedWorkerHost_OnReportException_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        blink.mojom.SharedWorkerExceptionDetailsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedWorkerHost_OnReportException_Params = class {
  constructor() {
    /** @export { !blink.mojom.SharedWorkerExceptionDetails } */
    this.details;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorkerHost_OnFeatureUsed_ParamsSpec.$,
    'SharedWorkerHost_OnFeatureUsed_Params',
    [
      mojo.internal.StructField(
        'feature', 0,
        0,
        blink.mojom.WebFeatureSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedWorkerHost_OnFeatureUsed_Params = class {
  constructor() {
    /** @export { !blink.mojom.WebFeature } */
    this.feature;
  }
};

