// third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* SharedWorkerErrorTypeToStringHelper(SharedWorkerErrorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SharedWorkerErrorType::kParseError:
      return "kParseError";
    case SharedWorkerErrorType::kRuntimeError:
      return "kRuntimeError";
    default:
      return nullptr;
  }
}

std::string SharedWorkerErrorTypeToString(SharedWorkerErrorType value) {
  const char *str = SharedWorkerErrorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SharedWorkerErrorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SharedWorkerErrorType value) {
  return os << SharedWorkerErrorTypeToString(value);
}

namespace internal {


// static
bool SharedWorkerExceptionDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedWorkerExceptionDetails_Data* object =
      static_cast<const SharedWorkerExceptionDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;


  if (!::blink::mojom::internal::SharedWorkerErrorType_Data
        ::Validate(object->error_type, validation_context))
    return false;

  return true;
}

SharedWorkerExceptionDetails_Data::SharedWorkerExceptionDetails_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SharedWorkerErrorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SharedWorkerErrorType value) {
  return std::move(context).WriteString(::blink::mojom::SharedWorkerErrorTypeToString(value));
}

} // namespace perfetto