// third_party/blink/public/mojom/worker/shared_worker_connector.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

SharedWorkerConnector::IPCStableHashFunction SharedWorkerConnector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedWorkerConnector>(message.name())) {
    case messages::SharedWorkerConnector::kConnect: {
      return &SharedWorkerConnector::Connect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedWorkerConnector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedWorkerConnector>(message.name())) {
      case messages::SharedWorkerConnector::kConnect:
            return "Receive blink::mojom::SharedWorkerConnector::Connect";
    }
  } else {
    switch (static_cast<messages::SharedWorkerConnector>(message.name())) {
      case messages::SharedWorkerConnector::kConnect:
            return "Receive reply blink::mojom::SharedWorkerConnector::Connect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedWorkerConnector::Connect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6906ff0;  // IPCStableHash for blink::mojom::SharedWorkerConnector::Connect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SharedWorkerConnectorProxy::SharedWorkerConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerConnectorProxy::Connect(
    ::blink::mojom::blink::SharedWorkerInfoPtr in_info, ::mojo::PendingRemote<::blink::mojom::blink::SharedWorkerClient> in_client, ::blink::mojom::blink::SharedWorkerCreationContextType in_creation_context_type, ::blink::MessagePortDescriptor in_message_port, ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken> in_blob_url_token, int64_t in_client_ukm_source_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerConnector::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::blink::mojom::blink::SharedWorkerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::SharedWorkerClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("creation_context_type"), in_creation_context_type,
                        "<value of type ::blink::mojom::blink::SharedWorkerCreationContextType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message_port"), in_message_port,
                        "<value of type ::blink::MessagePortDescriptor>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob_url_token"), in_blob_url_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_ukm_source_id"), in_client_ukm_source_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerConnector::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerConnector_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SharedWorkerInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in SharedWorkerConnector.Connect request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SharedWorkerClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in SharedWorkerConnector.Connect request");

  
  mojo::internal::Serialize<::blink::mojom::SharedWorkerCreationContextType>(
    in_creation_context_type,
    &params->creation_context_type);
  mojo::internal::MessageFragment<
      typename decltype(params->message_port)::BaseType> message_port_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MessagePortDescriptorDataView>(
    in_message_port,
    message_port_fragment);

  params->message_port.Set(
      message_port_fragment.is_null() ? nullptr : message_port_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message_port.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message_port in SharedWorkerConnector.Connect request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
    in_blob_url_token,
    &params->blob_url_token,
    &params.message());

  params->client_ukm_source_id = in_client_ukm_source_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerConnector::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SharedWorkerConnectorStubDispatch::Accept(
    SharedWorkerConnector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedWorkerConnector>(message->header()->name)) {
    case messages::SharedWorkerConnector::kConnect: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerConnector_Connect_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerConnector_Connect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerConnector.0
      bool success = true;
      ::blink::mojom::blink::SharedWorkerInfoPtr p_info{};
      ::mojo::PendingRemote<::blink::mojom::blink::SharedWorkerClient> p_client{};
      ::blink::mojom::blink::SharedWorkerCreationContextType p_creation_context_type{};
      ::blink::MessagePortDescriptor p_message_port{};
      ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken> p_blob_url_token{};
      int64_t p_client_ukm_source_id{};
      SharedWorkerConnector_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadCreationContextType(&p_creation_context_type))
        success = false;
      if (success && !input_data_view.ReadMessagePort(&p_message_port))
        success = false;
      if (success) {
        p_blob_url_token =
            input_data_view.TakeBlobUrlToken<decltype(p_blob_url_token)>();
      }
      if (success)
        p_client_ukm_source_id = input_data_view.client_ukm_source_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(        
        std::move(p_info), 
        std::move(p_client), 
        std::move(p_creation_context_type), 
        std::move(p_message_port), 
        std::move(p_blob_url_token), 
        std::move(p_client_ukm_source_id));
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerConnectorStubDispatch::AcceptWithResponder(
    SharedWorkerConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedWorkerConnector>(message->header()->name)) {
    case messages::SharedWorkerConnector::kConnect: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSharedWorkerConnectorValidationInfo[] = {
    { &internal::SharedWorkerConnector_Connect_Params_Data::Validate,
     nullptr /* no response */},
};

bool SharedWorkerConnectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SharedWorkerConnector::Name_,
    kSharedWorkerConnectorValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void SharedWorkerConnectorInterceptorForTesting::Connect(::blink::mojom::blink::SharedWorkerInfoPtr info, ::mojo::PendingRemote<::blink::mojom::blink::SharedWorkerClient> client, ::blink::mojom::blink::SharedWorkerCreationContextType creation_context_type, ::blink::MessagePortDescriptor message_port, ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken> blob_url_token, int64_t client_ukm_source_id) {
  GetForwardingInterface()->Connect(
    std::move(info)
    , 
    std::move(client)
    , 
    std::move(creation_context_type)
    , 
    std::move(message_port)
    , 
    std::move(blob_url_token)
    , 
    std::move(client_ukm_source_id)
    );
}
SharedWorkerConnectorAsyncWaiter::SharedWorkerConnectorAsyncWaiter(
    SharedWorkerConnector* proxy) : proxy_(proxy) {}

SharedWorkerConnectorAsyncWaiter::~SharedWorkerConnectorAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif