// third_party/blink/public/mojom/worker/shared_worker_client.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

SharedWorkerClient::IPCStableHashFunction SharedWorkerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedWorkerClient>(message.name())) {
    case messages::SharedWorkerClient::kOnCreated: {
      return &SharedWorkerClient::OnCreated_Sym::IPCStableHash;
    }
    case messages::SharedWorkerClient::kOnConnected: {
      return &SharedWorkerClient::OnConnected_Sym::IPCStableHash;
    }
    case messages::SharedWorkerClient::kOnScriptLoadFailed: {
      return &SharedWorkerClient::OnScriptLoadFailed_Sym::IPCStableHash;
    }
    case messages::SharedWorkerClient::kOnReportException: {
      return &SharedWorkerClient::OnReportException_Sym::IPCStableHash;
    }
    case messages::SharedWorkerClient::kOnFeatureUsed: {
      return &SharedWorkerClient::OnFeatureUsed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedWorkerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedWorkerClient>(message.name())) {
      case messages::SharedWorkerClient::kOnCreated:
            return "Receive blink::mojom::SharedWorkerClient::OnCreated";
      case messages::SharedWorkerClient::kOnConnected:
            return "Receive blink::mojom::SharedWorkerClient::OnConnected";
      case messages::SharedWorkerClient::kOnScriptLoadFailed:
            return "Receive blink::mojom::SharedWorkerClient::OnScriptLoadFailed";
      case messages::SharedWorkerClient::kOnReportException:
            return "Receive blink::mojom::SharedWorkerClient::OnReportException";
      case messages::SharedWorkerClient::kOnFeatureUsed:
            return "Receive blink::mojom::SharedWorkerClient::OnFeatureUsed";
    }
  } else {
    switch (static_cast<messages::SharedWorkerClient>(message.name())) {
      case messages::SharedWorkerClient::kOnCreated:
            return "Receive reply blink::mojom::SharedWorkerClient::OnCreated";
      case messages::SharedWorkerClient::kOnConnected:
            return "Receive reply blink::mojom::SharedWorkerClient::OnConnected";
      case messages::SharedWorkerClient::kOnScriptLoadFailed:
            return "Receive reply blink::mojom::SharedWorkerClient::OnScriptLoadFailed";
      case messages::SharedWorkerClient::kOnReportException:
            return "Receive reply blink::mojom::SharedWorkerClient::OnReportException";
      case messages::SharedWorkerClient::kOnFeatureUsed:
            return "Receive reply blink::mojom::SharedWorkerClient::OnFeatureUsed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedWorkerClient::OnCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8b52a5d;  // IPCStableHash for blink::mojom::SharedWorkerClient::OnCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedWorkerClient::OnConnected_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4641dd09;  // IPCStableHash for blink::mojom::SharedWorkerClient::OnConnected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedWorkerClient::OnScriptLoadFailed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x761a1e08;  // IPCStableHash for blink::mojom::SharedWorkerClient::OnScriptLoadFailed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedWorkerClient::OnReportException_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9b9b48e;  // IPCStableHash for blink::mojom::SharedWorkerClient::OnReportException
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedWorkerClient::OnFeatureUsed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x05bf7eac;  // IPCStableHash for blink::mojom::SharedWorkerClient::OnFeatureUsed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SharedWorkerClientProxy::SharedWorkerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerClientProxy::OnCreated(
    ::blink::mojom::blink::SharedWorkerCreationContextType in_creation_context_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerClient::OnCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("creation_context_type"), in_creation_context_type,
                        "<value of type ::blink::mojom::blink::SharedWorkerCreationContextType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerClient::kOnCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerClient_OnCreated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::SharedWorkerCreationContextType>(
    in_creation_context_type,
    &params->creation_context_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedWorkerClientProxy::OnConnected(
    const ::blink::Vector<::blink::mojom::blink::WebFeature>& in_features_used) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerClient::OnConnected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features_used"), in_features_used,
                        "<value of type const ::blink::Vector<::blink::mojom::blink::WebFeature>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerClient::kOnConnected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerClient_OnConnected_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features_used)::BaseType>
      features_used_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& features_used_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebFeature_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
    in_features_used,
    features_used_fragment,
    &features_used_validate_params);

  params->features_used.Set(
      features_used_fragment.is_null() ? nullptr : features_used_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->features_used.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null features_used in SharedWorkerClient.OnConnected request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnConnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedWorkerClientProxy::OnScriptLoadFailed(
    const ::blink::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerClient::OnScriptLoadFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerClient::kOnScriptLoadFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in SharedWorkerClient.OnScriptLoadFailed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnScriptLoadFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedWorkerClientProxy::OnReportException(
    ::blink::mojom::blink::SharedWorkerExceptionDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerClient::OnReportException", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type ::blink::mojom::blink::SharedWorkerExceptionDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerClient::kOnReportException), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerClient_OnReportException_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SharedWorkerExceptionDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in SharedWorkerClient.OnReportException request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnReportException");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedWorkerClientProxy::OnFeatureUsed(
    ::blink::mojom::blink::WebFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedWorkerClient::OnFeatureUsed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type ::blink::mojom::blink::WebFeature>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedWorkerClient::kOnFeatureUsed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerClient_OnFeatureUsed_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebFeature>(
    in_feature,
    &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnFeatureUsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SharedWorkerClientStubDispatch::Accept(
    SharedWorkerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedWorkerClient>(message->header()->name)) {
    case messages::SharedWorkerClient::kOnCreated: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnCreated_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerClient.0
      bool success = true;
      ::blink::mojom::blink::SharedWorkerCreationContextType p_creation_context_type{};
      SharedWorkerClient_OnCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCreationContextType(&p_creation_context_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCreated(        
        std::move(p_creation_context_type));
      return true;
    }
    case messages::SharedWorkerClient::kOnConnected: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnConnected_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnConnected_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerClient.1
      bool success = true;
      ::blink::Vector<::blink::mojom::blink::WebFeature> p_features_used{};
      SharedWorkerClient_OnConnected_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeaturesUsed(&p_features_used))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnected(        
        std::move(p_features_used));
      return true;
    }
    case messages::SharedWorkerClient::kOnScriptLoadFailed: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerClient.2
      bool success = true;
      ::blink::String p_error_message{};
      SharedWorkerClient_OnScriptLoadFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoadFailed(        
        std::move(p_error_message));
      return true;
    }
    case messages::SharedWorkerClient::kOnReportException: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnReportException_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnReportException_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerClient.3
      bool success = true;
      ::blink::mojom::blink::SharedWorkerExceptionDetailsPtr p_details{};
      SharedWorkerClient_OnReportException_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportException(        
        std::move(p_details));
      return true;
    }
    case messages::SharedWorkerClient::kOnFeatureUsed: {
      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnFeatureUsed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnFeatureUsed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedWorkerClient.4
      bool success = true;
      ::blink::mojom::blink::WebFeature p_feature{};
      SharedWorkerClient_OnFeatureUsed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFeatureUsed(        
        std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerClientStubDispatch::AcceptWithResponder(
    SharedWorkerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedWorkerClient>(message->header()->name)) {
    case messages::SharedWorkerClient::kOnCreated: {
      break;
    }
    case messages::SharedWorkerClient::kOnConnected: {
      break;
    }
    case messages::SharedWorkerClient::kOnScriptLoadFailed: {
      break;
    }
    case messages::SharedWorkerClient::kOnReportException: {
      break;
    }
    case messages::SharedWorkerClient::kOnFeatureUsed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSharedWorkerClientValidationInfo[] = {
    { &internal::SharedWorkerClient_OnCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedWorkerClient_OnConnected_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedWorkerClient_OnReportException_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedWorkerClient_OnFeatureUsed_Params_Data::Validate,
     nullptr /* no response */},
};

bool SharedWorkerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SharedWorkerClient::Name_,
    kSharedWorkerClientValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void SharedWorkerClientInterceptorForTesting::OnCreated(::blink::mojom::blink::SharedWorkerCreationContextType creation_context_type) {
  GetForwardingInterface()->OnCreated(
    std::move(creation_context_type)
    );
}
void SharedWorkerClientInterceptorForTesting::OnConnected(const ::blink::Vector<::blink::mojom::blink::WebFeature>& features_used) {
  GetForwardingInterface()->OnConnected(
    std::move(features_used)
    );
}
void SharedWorkerClientInterceptorForTesting::OnScriptLoadFailed(const ::blink::String& error_message) {
  GetForwardingInterface()->OnScriptLoadFailed(
    std::move(error_message)
    );
}
void SharedWorkerClientInterceptorForTesting::OnReportException(::blink::mojom::blink::SharedWorkerExceptionDetailsPtr details) {
  GetForwardingInterface()->OnReportException(
    std::move(details)
    );
}
void SharedWorkerClientInterceptorForTesting::OnFeatureUsed(::blink::mojom::blink::WebFeature feature) {
  GetForwardingInterface()->OnFeatureUsed(
    std::move(feature)
    );
}
SharedWorkerClientAsyncWaiter::SharedWorkerClientAsyncWaiter(
    SharedWorkerClient* proxy) : proxy_(proxy) {}

SharedWorkerClientAsyncWaiter::~SharedWorkerClientAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif