// third_party/blink/public/mojom/websockets/websocket_connector.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  SiteForCookies as network_mojom_SiteForCookies,
  SiteForCookiesSpec as network_mojom_SiteForCookiesSpec
} from '../../../../../services/network/public/mojom/site_for_cookies.mojom.m.js';

import {
  StorageAccessApiStatus as network_mojom_StorageAccessApiStatus,
  StorageAccessApiStatusSpec as network_mojom_StorageAccessApiStatusSpec
} from '../../../../../services/network/public/mojom/storage_access_api.mojom.m.js';

import {
  WebSocketHandshakeClientRemote as network_mojom_WebSocketHandshakeClientRemote,
  WebSocketHandshakeClientPendingReceiver as network_mojom_WebSocketHandshakeClientPendingReceiver
} from '../../../../../services/network/public/mojom/websocket.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebSocketConnectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebSocketConnector', scope);
  }
}

/** @interface */
export class WebSocketConnectorInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !Array<!string> } requestedProtocols
   * @param { !network_mojom_SiteForCookies } siteForCookies
   * @param { ?string } userAgent
   * @param { !network_mojom_StorageAccessApiStatus } storageAccessApiStatus
   * @param { !network_mojom_WebSocketHandshakeClientRemote } handshakeClient
   * @param { ?mojoBase_mojom_UnguessableToken } throttlingProfileId
   */

  connect(url, requestedProtocols, siteForCookies, userAgent, storageAccessApiStatus, handshakeClient, throttlingProfileId) {}
}

/**
 * @implements { WebSocketConnectorInterface }
 */
export class WebSocketConnectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebSocketConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebSocketConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebSocketConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !Array<!string> } requestedProtocols
   * @param { !network_mojom_SiteForCookies } siteForCookies
   * @param { ?string } userAgent
   * @param { !network_mojom_StorageAccessApiStatus } storageAccessApiStatus
   * @param { !network_mojom_WebSocketHandshakeClientRemote } handshakeClient
   * @param { ?mojoBase_mojom_UnguessableToken } throttlingProfileId
   */

  connect(
      url,
      requestedProtocols,
      siteForCookies,
      userAgent,
      storageAccessApiStatus,
      handshakeClient,
      throttlingProfileId) {
    this.proxy.sendMessage(
        0,
        WebSocketConnector_Connect_ParamsSpec.$,
        null,
        [
          url,
          requestedProtocols,
          siteForCookies,
          userAgent,
          storageAccessApiStatus,
          handshakeClient,
          throttlingProfileId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebSocketConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebSocketConnectorReceiver {
  /**
   * @param {!WebSocketConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebSocketConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebSocketConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebSocketConnector_Connect_ParamsSpec.$,
        null,
        impl.connect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebSocketConnector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebSocketConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebSocketConnectorRemote}
   */
  static getRemote() {
    let remote = new WebSocketConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebSocketConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebSocketConnectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebSocketConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebSocketConnector_Connect_ParamsSpec.$,
        null,
        this.connect.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketConnector_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebSocketConnector_Connect_ParamsSpec.$,
    'WebSocketConnector_Connect_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestedProtocols', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'siteForCookies', 16,
        0,
        network_mojom_SiteForCookiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userAgent', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 32,
        0,
        network_mojom_StorageAccessApiStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'handshakeClient', 36,
        0,
        mojo.internal.InterfaceProxy(network_mojom_WebSocketHandshakeClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'throttlingProfileId', 48,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class WebSocketConnector_Connect_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Array<!string> } */
    this.requestedProtocols;
    /** @type { !network_mojom_SiteForCookies } */
    this.siteForCookies;
    /** @type { (string|undefined) } */
    this.userAgent;
    /** @type { !network_mojom_StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @type { !network_mojom_WebSocketHandshakeClientRemote } */
    this.handshakeClient;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.throttlingProfileId;
  }
}

