// third_party/blink/public/mojom/webid/federated_auth_request.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.RequestTokenStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.RequestTokenStatus = {
  
  kSuccess: 0,
  kErrorTooManyRequests: 1,
  kErrorCanceled: 2,
  kError: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.RequestUserInfoStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.RequestUserInfoStatus = {
  
  kSuccess: 0,
  kError: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.DisconnectStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.DisconnectStatus = {
  
  kSuccess: 0,
  kErrorTooManyRequests: 1,
  kError: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.IdpSigninStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.IdpSigninStatus = {
  
  kSignedIn: 0,
  kSignedOut: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.RpContextSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.RpContext = {
  
  kSignIn: 0,
  kSignUp: 1,
  kUse: 2,
  kContinue: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.RpModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.RpMode = {
  
  kActive: 0,
  kPassive: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.RegisterIdpStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.RegisterIdpStatus = {
  
  kSuccess: 0,
  kErrorFeatureDisabled: 1,
  kErrorCrossOriginConfig: 2,
  kErrorNoTransientActivation: 3,
  kErrorDeclined: 4,
  kErrorInvalidConfig: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.Format = {
  
  kSdJwt: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FederatedAuthRequestPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FederatedAuthRequest.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FederatedAuthRequestInterface }
 */
blink.mojom.FederatedAuthRequestRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FederatedAuthRequestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FederatedAuthRequestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FederatedAuthRequestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.IdentityProviderGetParameters> } idpGetParams
   * @param { !blink.mojom.CredentialMediationRequirement } requirement
   * @return {!Promise<{
        status: !blink.mojom.RequestTokenStatus,
        selectedIdentityProviderConfigUrl: ?url.mojom.Url,
        token: ?mojoBase.mojom.Value,
        error: ?blink.mojom.TokenError,
        isAutoSelected: !boolean,
   *  }>}
   */

  requestToken(
      idpGetParams,
      requirement) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FederatedAuthRequest_RequestToken_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_RequestToken_ResponseParamsSpec.$,
        [
          idpGetParams,
          requirement
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.IdentityProviderConfig } provider
   * @return {!Promise<{
        status: !blink.mojom.RequestUserInfoStatus,
        userInfo: ?Array<!blink.mojom.IdentityUserInfo>,
   *  }>}
   */

  requestUserInfo(
      provider) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.FederatedAuthRequest_RequestUserInfo_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec.$,
        [
          provider
        ],
        false);
  }

  
  /**
   */

  cancelTokenRequest() {
    this.proxy.sendMessage(
        2,
        blink.mojom.FederatedAuthRequest_CancelTokenRequest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { ?string } accountId
   * @param { !string } token
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  resolveTokenRequest(
      accountId,
      token) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec.$,
        [
          accountId,
          token
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } origin
   * @param { !blink.mojom.IdpSigninStatus } status
   * @param { ?blink.mojom.LoginStatusOptions } options
   * @return {!Promise}
   */

  setIdpSigninStatus(
      origin,
      status,
      options) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec.$,
        [
          origin,
          status,
          options
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        status: !blink.mojom.RegisterIdpStatus,
   *  }>}
   */

  registerIdP(
      url) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.FederatedAuthRequest_RegisterIdP_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_RegisterIdP_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  unregisterIdP(
      url) {
    return this.proxy.sendMessage(
        6,
        blink.mojom.FederatedAuthRequest_UnregisterIdP_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   */

  closeModalDialogView() {
    this.proxy.sendMessage(
        7,
        blink.mojom.FederatedAuthRequest_CloseModalDialogView_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  preventSilentAccess() {
    return this.proxy.sendMessage(
        8,
        blink.mojom.FederatedAuthRequest_PreventSilentAccess_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.IdentityCredentialDisconnectOptions } options
   * @return {!Promise<{
        status: !blink.mojom.DisconnectStatus,
   *  }>}
   */

  disconnect(
      options) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.FederatedAuthRequest_Disconnect_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_Disconnect_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FederatedAuthRequest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FederatedAuthRequestReceiver = class {
  /**
   * @param {!blink.mojom.FederatedAuthRequestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FederatedAuthRequestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FederatedAuthRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FederatedAuthRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FederatedAuthRequest_RequestToken_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_RequestToken_ResponseParamsSpec.$,
        impl.requestToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FederatedAuthRequest_RequestUserInfo_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec.$,
        impl.requestUserInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FederatedAuthRequest_CancelTokenRequest_ParamsSpec.$,
        null,
        impl.cancelTokenRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec.$,
        impl.resolveTokenRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec.$,
        impl.setIdpSigninStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FederatedAuthRequest_RegisterIdP_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_RegisterIdP_ResponseParamsSpec.$,
        impl.registerIdP.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FederatedAuthRequest_UnregisterIdP_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec.$,
        impl.unregisterIdP.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FederatedAuthRequest_CloseModalDialogView_ParamsSpec.$,
        null,
        impl.closeModalDialogView.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FederatedAuthRequest_PreventSilentAccess_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec.$,
        impl.preventSilentAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FederatedAuthRequest_Disconnect_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_Disconnect_ResponseParamsSpec.$,
        impl.disconnect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FederatedAuthRequest = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FederatedAuthRequest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FederatedAuthRequestRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FederatedAuthRequestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FederatedAuthRequest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FederatedAuthRequestCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FederatedAuthRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FederatedAuthRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FederatedAuthRequest_RequestToken_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_RequestToken_ResponseParamsSpec.$,
        this.requestToken.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestUserInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FederatedAuthRequest_RequestUserInfo_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec.$,
        this.requestUserInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelTokenRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FederatedAuthRequest_CancelTokenRequest_ParamsSpec.$,
        null,
        this.cancelTokenRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveTokenRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec.$,
        this.resolveTokenRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIdpSigninStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec.$,
        this.setIdpSigninStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerIdP =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FederatedAuthRequest_RegisterIdP_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_RegisterIdP_ResponseParamsSpec.$,
        this.registerIdP.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unregisterIdP =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FederatedAuthRequest_UnregisterIdP_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec.$,
        this.unregisterIdP.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeModalDialogView =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FederatedAuthRequest_CloseModalDialogView_ParamsSpec.$,
        null,
        this.closeModalDialogView.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.preventSilentAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FederatedAuthRequest_PreventSilentAccess_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec.$,
        this.preventSilentAccess.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disconnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FederatedAuthRequest_Disconnect_ParamsSpec.$,
        blink.mojom.FederatedAuthRequest_Disconnect_ResponseParamsSpec.$,
        this.disconnect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IdentityProviderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IdentityProviderRequestOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IdentityCredentialDisconnectOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IdentityUserInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LoginStatusAccountSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LoginStatusOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.IdentityProviderGetParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TokenErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_RequestToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_RequestToken_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_RequestUserInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_CancelTokenRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_RegisterIdP_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_RegisterIdP_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_UnregisterIdP_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_CloseModalDialogView_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_PreventSilentAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_Disconnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequest_Disconnect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.IdentityProviderConfigSpec.$,
    'IdentityProviderConfig',
    [
      mojo.internal.StructField(
        'configUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fromIdpRegistrationApi', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientId', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.IdentityProviderConfig = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.configUrl;
    /** @export { !boolean } */
    this.fromIdpRegistrationApi;
    /** @export { (string|undefined) } */
    this.type;
    /** @export { !string } */
    this.clientId;
  }
};



mojo.internal.Struct(
    blink.mojom.IdentityProviderRequestOptionsSpec.$,
    'IdentityProviderRequestOptions',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        blink.mojom.IdentityProviderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nonce', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loginHint', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domainHint', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fields', 32,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paramsJson', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'format_$flag', 48,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "format_$value",
          originalFieldName: "format",
        }
      ),
      mojo.internal.StructField(
        'format_$value', 52,
        0,
        blink.mojom.FormatSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "format",
        }
      ),
    ],
    [[0, 64],]);





/** @record */
blink.mojom.IdentityProviderRequestOptions = class {
  constructor() {
    /** @export { !blink.mojom.IdentityProviderConfig } */
    this.config;
    /** @export { !string } */
    this.nonce;
    /** @export { !string } */
    this.loginHint;
    /** @export { !string } */
    this.domainHint;
    /** @export { (Array<!string>|undefined) } */
    this.fields;
    /** @export { (string|undefined) } */
    this.paramsJson;
    /** @export { (blink.mojom.Format|undefined) } */
    this.format;
  }
};



mojo.internal.Struct(
    blink.mojom.IdentityCredentialDisconnectOptionsSpec.$,
    'IdentityCredentialDisconnectOptions',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        blink.mojom.IdentityProviderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accountHint', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.IdentityCredentialDisconnectOptions = class {
  constructor() {
    /** @export { !blink.mojom.IdentityProviderConfig } */
    this.config;
    /** @export { !string } */
    this.accountHint;
  }
};



mojo.internal.Struct(
    blink.mojom.IdentityUserInfoSpec.$,
    'IdentityUserInfo',
    [
      mojo.internal.StructField(
        'email', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'givenName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'picture', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.IdentityUserInfo = class {
  constructor() {
    /** @export { !string } */
    this.email;
    /** @export { !string } */
    this.givenName;
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.picture;
  }
};



mojo.internal.Struct(
    blink.mojom.LoginStatusAccountSpec.$,
    'LoginStatusAccount',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'email', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'givenName', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'picture', 32,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.LoginStatusAccount = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.email;
    /** @export { !string } */
    this.name;
    /** @export { (string|undefined) } */
    this.givenName;
    /** @export { (url.mojom.Url|undefined) } */
    this.picture;
  }
};



mojo.internal.Struct(
    blink.mojom.LoginStatusOptionsSpec.$,
    'LoginStatusOptions',
    [
      mojo.internal.StructField(
        'accounts', 0,
        0,
        mojo.internal.Array(blink.mojom.LoginStatusAccountSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expiration', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LoginStatusOptions = class {
  constructor() {
    /** @export { !Array<!blink.mojom.LoginStatusAccount> } */
    this.accounts;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.expiration;
  }
};



mojo.internal.Struct(
    blink.mojom.IdentityProviderGetParametersSpec.$,
    'IdentityProviderGetParameters',
    [
      mojo.internal.StructField(
        'providers', 0,
        0,
        mojo.internal.Array(blink.mojom.IdentityProviderRequestOptionsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        blink.mojom.RpContextSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mode', 12,
        0,
        blink.mojom.RpModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.IdentityProviderGetParameters = class {
  constructor() {
    /** @export { !Array<!blink.mojom.IdentityProviderRequestOptions> } */
    this.providers;
    /** @export { !blink.mojom.RpContext } */
    this.context;
    /** @export { !blink.mojom.RpMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    blink.mojom.TokenErrorSpec.$,
    'TokenError',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.TokenError = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.code;
    /** @export { (string|undefined) } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_RequestToken_ParamsSpec.$,
    'FederatedAuthRequest_RequestToken_Params',
    [
      mojo.internal.StructField(
        'idpGetParams', 0,
        0,
        mojo.internal.Array(blink.mojom.IdentityProviderGetParametersSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requirement', 8,
        0,
        blink.mojom.CredentialMediationRequirementSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.FederatedAuthRequest_RequestToken_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.IdentityProviderGetParameters> } */
    this.idpGetParams;
    /** @export { !blink.mojom.CredentialMediationRequirement } */
    this.requirement;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_RequestToken_ResponseParamsSpec.$,
    'FederatedAuthRequest_RequestToken_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.RequestTokenStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectedIdentityProviderConfigUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'token', 16,
        0,
        mojoBase.mojom.ValueSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 32,
        0,
        blink.mojom.TokenErrorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAutoSelected', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.FederatedAuthRequest_RequestToken_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.RequestTokenStatus } */
    this.status;
    /** @export { (url.mojom.Url|undefined) } */
    this.selectedIdentityProviderConfigUrl;
    /** @export { (mojoBase.mojom.Value|undefined) } */
    this.token;
    /** @export { (blink.mojom.TokenError|undefined) } */
    this.error;
    /** @export { !boolean } */
    this.isAutoSelected;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_RequestUserInfo_ParamsSpec.$,
    'FederatedAuthRequest_RequestUserInfo_Params',
    [
      mojo.internal.StructField(
        'provider', 0,
        0,
        blink.mojom.IdentityProviderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FederatedAuthRequest_RequestUserInfo_Params = class {
  constructor() {
    /** @export { !blink.mojom.IdentityProviderConfig } */
    this.provider;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_RequestUserInfo_ResponseParamsSpec.$,
    'FederatedAuthRequest_RequestUserInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.RequestUserInfoStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userInfo', 8,
        0,
        mojo.internal.Array(blink.mojom.IdentityUserInfoSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.FederatedAuthRequest_RequestUserInfo_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.RequestUserInfoStatus } */
    this.status;
    /** @export { (Array<!blink.mojom.IdentityUserInfo>|undefined) } */
    this.userInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_CancelTokenRequest_ParamsSpec.$,
    'FederatedAuthRequest_CancelTokenRequest_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FederatedAuthRequest_CancelTokenRequest_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ParamsSpec.$,
    'FederatedAuthRequest_ResolveTokenRequest_Params',
    [
      mojo.internal.StructField(
        'accountId', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'token', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.FederatedAuthRequest_ResolveTokenRequest_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.accountId;
    /** @export { !string } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ResponseParamsSpec.$,
    'FederatedAuthRequest_ResolveTokenRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FederatedAuthRequest_ResolveTokenRequest_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ParamsSpec.$,
    'FederatedAuthRequest_SetIdpSigninStatus_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        blink.mojom.IdpSigninStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        blink.mojom.LoginStatusOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !blink.mojom.IdpSigninStatus } */
    this.status;
    /** @export { (blink.mojom.LoginStatusOptions|undefined) } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsSpec.$,
    'FederatedAuthRequest_SetIdpSigninStatus_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FederatedAuthRequest_SetIdpSigninStatus_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_RegisterIdP_ParamsSpec.$,
    'FederatedAuthRequest_RegisterIdP_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FederatedAuthRequest_RegisterIdP_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_RegisterIdP_ResponseParamsSpec.$,
    'FederatedAuthRequest_RegisterIdP_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.RegisterIdpStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FederatedAuthRequest_RegisterIdP_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.RegisterIdpStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_UnregisterIdP_ParamsSpec.$,
    'FederatedAuthRequest_UnregisterIdP_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FederatedAuthRequest_UnregisterIdP_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_UnregisterIdP_ResponseParamsSpec.$,
    'FederatedAuthRequest_UnregisterIdP_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FederatedAuthRequest_UnregisterIdP_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_CloseModalDialogView_ParamsSpec.$,
    'FederatedAuthRequest_CloseModalDialogView_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FederatedAuthRequest_CloseModalDialogView_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_PreventSilentAccess_ParamsSpec.$,
    'FederatedAuthRequest_PreventSilentAccess_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FederatedAuthRequest_PreventSilentAccess_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_PreventSilentAccess_ResponseParamsSpec.$,
    'FederatedAuthRequest_PreventSilentAccess_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FederatedAuthRequest_PreventSilentAccess_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_Disconnect_ParamsSpec.$,
    'FederatedAuthRequest_Disconnect_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.IdentityCredentialDisconnectOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FederatedAuthRequest_Disconnect_Params = class {
  constructor() {
    /** @export { !blink.mojom.IdentityCredentialDisconnectOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequest_Disconnect_ResponseParamsSpec.$,
    'FederatedAuthRequest_Disconnect_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.DisconnectStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FederatedAuthRequest_Disconnect_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.DisconnectStatus } */
    this.status;
  }
};

