// third_party/blink/public/mojom/webid/digital_identity_request.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_DIGITAL_IDENTITY_REQUEST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_DIGITAL_IDENTITY_REQUEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class DigitalIdentityRequestProxy;

template <typename ImplRefTraits>
class DigitalIdentityRequestStub;

class DigitalIdentityRequestRequestValidator;
class DigitalIdentityRequestResponseValidator;


class PLATFORM_EXPORT DigitalIdentityRequest
    : public DigitalIdentityRequestInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DigitalIdentityRequest";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DigitalIdentityRequestInterfaceBase;
  using Proxy_ = DigitalIdentityRequestProxy;

  template <typename ImplRefTraits>
  using Stub_ = DigitalIdentityRequestStub<ImplRefTraits>;

  using RequestValidator_ = DigitalIdentityRequestRequestValidator;
  using ResponseValidator_ = DigitalIdentityRequestResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetMinVersion = 0,
    kCreateMinVersion = 0,
    kAbortMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Get_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Create_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Abort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DigitalIdentityRequest() = default;

  using GetCallback = base::OnceCallback<void(RequestDigitalIdentityStatus, const ::blink::String&, std::optional<::base::Value>)>;
  using GetMojoCallback = base::OnceCallback<void(RequestDigitalIdentityStatus, const ::blink::String&, std::optional<::base::Value>)>;

  virtual void Get(::blink::Vector<DigitalCredentialGetRequestPtr> digital_credential_requests, GetCallback callback) = 0;

  using CreateCallback = base::OnceCallback<void(RequestDigitalIdentityStatus, const ::blink::String&, std::optional<::base::Value>)>;
  using CreateMojoCallback = base::OnceCallback<void(RequestDigitalIdentityStatus, const ::blink::String&, std::optional<::base::Value>)>;

  virtual void Create(::blink::Vector<DigitalCredentialCreateRequestPtr> digital_credential_requests, CreateCallback callback) = 0;

  virtual void Abort() = 0;
};



class PLATFORM_EXPORT DigitalIdentityRequestProxy
    : public DigitalIdentityRequest {
 public:
  using InterfaceType = DigitalIdentityRequest;

  explicit DigitalIdentityRequestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Get(::blink::Vector<DigitalCredentialGetRequestPtr> digital_credential_requests, GetCallback callback) final;
  
  void Create(::blink::Vector<DigitalCredentialCreateRequestPtr> digital_credential_requests, CreateCallback callback) final;
  
  void Abort() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT DigitalIdentityRequestStubDispatch {
 public:
  static bool Accept(DigitalIdentityRequest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DigitalIdentityRequest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DigitalIdentityRequest>>
class DigitalIdentityRequestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DigitalIdentityRequestStub() = default;
  ~DigitalIdentityRequestStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DigitalIdentityRequestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DigitalIdentityRequestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT DigitalIdentityRequestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT DigitalIdentityRequestResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class PLATFORM_EXPORT DigitalCredentialGetRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DigitalCredentialGetRequest, T>::value>;
  using DataView = DigitalCredentialGetRequestDataView;
  using Data_ = internal::DigitalCredentialGetRequest_Data;

  template <typename... Args>
  static DigitalCredentialGetRequestPtr New(Args&&... args) {
    return DigitalCredentialGetRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DigitalCredentialGetRequestPtr From(const U& u) {
    return mojo::TypeConverter<DigitalCredentialGetRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DigitalCredentialGetRequest>::Convert(*this);
  }


  DigitalCredentialGetRequest();

  DigitalCredentialGetRequest(
      const ::blink::String& protocol,
      ::base::Value data);

DigitalCredentialGetRequest(const DigitalCredentialGetRequest&) = delete;
DigitalCredentialGetRequest& operator=(const DigitalCredentialGetRequest&) = delete;

  ~DigitalCredentialGetRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DigitalCredentialGetRequestPtr>
  DigitalCredentialGetRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DigitalCredentialGetRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DigitalCredentialGetRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DigitalCredentialGetRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DigitalCredentialGetRequest::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DigitalCredentialGetRequest::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DigitalCredentialGetRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DigitalCredentialGetRequest_UnserializedMessageContext<
            UserType, DigitalCredentialGetRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DigitalCredentialGetRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DigitalCredentialGetRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DigitalCredentialGetRequest_UnserializedMessageContext<
            UserType, DigitalCredentialGetRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DigitalCredentialGetRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String protocol;
  
  ::base::Value data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DigitalCredentialGetRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DigitalCredentialGetRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DigitalCredentialGetRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DigitalCredentialGetRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DigitalCredentialCreateRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DigitalCredentialCreateRequest, T>::value>;
  using DataView = DigitalCredentialCreateRequestDataView;
  using Data_ = internal::DigitalCredentialCreateRequest_Data;

  template <typename... Args>
  static DigitalCredentialCreateRequestPtr New(Args&&... args) {
    return DigitalCredentialCreateRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DigitalCredentialCreateRequestPtr From(const U& u) {
    return mojo::TypeConverter<DigitalCredentialCreateRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DigitalCredentialCreateRequest>::Convert(*this);
  }


  DigitalCredentialCreateRequest();

  DigitalCredentialCreateRequest(
      const ::blink::String& protocol,
      ::base::Value data);

DigitalCredentialCreateRequest(const DigitalCredentialCreateRequest&) = delete;
DigitalCredentialCreateRequest& operator=(const DigitalCredentialCreateRequest&) = delete;

  ~DigitalCredentialCreateRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DigitalCredentialCreateRequestPtr>
  DigitalCredentialCreateRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DigitalCredentialCreateRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DigitalCredentialCreateRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DigitalCredentialCreateRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DigitalCredentialCreateRequest::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DigitalCredentialCreateRequest::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DigitalCredentialCreateRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DigitalCredentialCreateRequest_UnserializedMessageContext<
            UserType, DigitalCredentialCreateRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DigitalCredentialCreateRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DigitalCredentialCreateRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DigitalCredentialCreateRequest_UnserializedMessageContext<
            UserType, DigitalCredentialCreateRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DigitalCredentialCreateRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String protocol;
  
  ::base::Value data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DigitalCredentialCreateRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DigitalCredentialCreateRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DigitalCredentialCreateRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DigitalCredentialCreateRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DigitalCredentialGetRequestPtr DigitalCredentialGetRequest::Clone() const {
  return New(
      mojo::Clone(protocol),
      mojo::Clone(data)
  );
}

template <typename T, DigitalCredentialGetRequest::EnableIfSame<T>*>
bool DigitalCredentialGetRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, DigitalCredentialGetRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.protocol < rhs.protocol)
    return true;
  if (rhs.protocol < lhs.protocol)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
DigitalCredentialCreateRequestPtr DigitalCredentialCreateRequest::Clone() const {
  return New(
      mojo::Clone(protocol),
      mojo::Clone(data)
  );
}

template <typename T, DigitalCredentialCreateRequest::EnableIfSame<T>*>
bool DigitalCredentialCreateRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, DigitalCredentialCreateRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.protocol < rhs.protocol)
    return true;
  if (rhs.protocol < lhs.protocol)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DigitalCredentialGetRequest::DataView,
                                         ::blink::mojom::blink::DigitalCredentialGetRequestPtr> {
  static bool IsNull(const ::blink::mojom::blink::DigitalCredentialGetRequestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DigitalCredentialGetRequestPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DigitalCredentialGetRequest::protocol)& protocol(
      const ::blink::mojom::blink::DigitalCredentialGetRequestPtr& input) {
    return input->protocol;
  }

  static const decltype(::blink::mojom::blink::DigitalCredentialGetRequest::data)& data(
      const ::blink::mojom::blink::DigitalCredentialGetRequestPtr& input) {
    return input->data;
  }

  static bool Read(::blink::mojom::blink::DigitalCredentialGetRequest::DataView input, ::blink::mojom::blink::DigitalCredentialGetRequestPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DigitalCredentialCreateRequest::DataView,
                                         ::blink::mojom::blink::DigitalCredentialCreateRequestPtr> {
  static bool IsNull(const ::blink::mojom::blink::DigitalCredentialCreateRequestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DigitalCredentialCreateRequestPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DigitalCredentialCreateRequest::protocol)& protocol(
      const ::blink::mojom::blink::DigitalCredentialCreateRequestPtr& input) {
    return input->protocol;
  }

  static const decltype(::blink::mojom::blink::DigitalCredentialCreateRequest::data)& data(
      const ::blink::mojom::blink::DigitalCredentialCreateRequestPtr& input) {
    return input->data;
  }

  static bool Read(::blink::mojom::blink::DigitalCredentialCreateRequest::DataView input, ::blink::mojom::blink::DigitalCredentialCreateRequestPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_DIGITAL_IDENTITY_REQUEST_MOJOM_BLINK_H_