// third_party/blink/public/mojom/webauthn/authenticator.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  PaymentCurrencyAmount as payments_mojom_PaymentCurrencyAmount,
  PaymentCurrencyAmountSpec as payments_mojom_PaymentCurrencyAmountSpec
} from '../../../../../components/payments/mojom/payment_request_data.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  CredentialInfo as blink_mojom_CredentialInfo,
  CredentialInfoSpec as blink_mojom_CredentialInfoSpec
} from '../credentialmanagement/credential_manager.mojom.m.js';


/**
 * @const { !number }
 */
export const PUBLIC_KEY_CREDENTIAL_DESCRIPTOR_LIST_MAX_SIZE = 64;


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AuthenticatorStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AuthenticatorStatus = {
  
  SUCCESS: 0,
  PENDING_REQUEST: 1,
  NOT_ALLOWED_ERROR: 2,
  INVALID_DOMAIN: 3,
  CREDENTIAL_EXCLUDED: 4,
  NOT_IMPLEMENTED: 5,
  NOT_FOCUSED: 6,
  RESIDENT_CREDENTIALS_UNSUPPORTED: 7,
  USER_VERIFICATION_UNSUPPORTED: 8,
  ALGORITHM_UNSUPPORTED: 9,
  EMPTY_ALLOW_CREDENTIALS: 10,
  ANDROID_NOT_SUPPORTED_ERROR: 11,
  PROTECTION_POLICY_INCONSISTENT: 12,
  ABORT_ERROR: 13,
  OPAQUE_DOMAIN: 14,
  INVALID_PROTOCOL: 15,
  BAD_RELYING_PARTY_ID: 16,
  BAD_RELYING_PARTY_ID_ATTEMPTED_FETCH: 17,
  BAD_RELYING_PARTY_ID_WRONG_CONTENT_TYPE: 18,
  BAD_RELYING_PARTY_ID_JSON_PARSE_ERROR: 19,
  BAD_RELYING_PARTY_ID_NO_JSON_MATCH: 20,
  BAD_RELYING_PARTY_ID_NO_JSON_MATCH_HIT_LIMITS: 21,
  CANNOT_READ_AND_WRITE_LARGE_BLOB: 22,
  INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB: 23,
  FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION: 24,
  REMOTE_DESKTOP_CLIENT_OVERRIDE_NOT_AUTHORIZED: 25,
  DEVICE_PUBLIC_KEY_ATTESTATION_REJECTED: 26,
  CERTIFICATE_ERROR: 27,
  ERROR_WITH_DOM_EXCEPTION_DETAILS: 28,
  IMMEDIATE_NOT_FOUND: 29,
  UNKNOWN_ERROR: 30,
  MIN_VALUE: 0,
  MAX_VALUE: 30,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AuthenticatorTransportSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AuthenticatorTransport = {
  
  USB: 0,
  NFC: 1,
  BLE: 2,
  HYBRID: 3,
  INTERNAL: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HintSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const Hint = {
  
  SECURITY_KEY: 0,
  CLIENT_DEVICE: 1,
  HYBRID: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UserVerificationRequirementSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UserVerificationRequirement = {
  
  REQUIRED: 0,
  PREFERRED: 1,
  DISCOURAGED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const Mediation = {
  
  MODAL: 0,
  CONDITIONAL: 1,
  IMMEDIATE: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ResidentKeyRequirementSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ResidentKeyRequirement = {
  
  DISCOURAGED: 0,
  PREFERRED: 1,
  REQUIRED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AuthenticatorAttachmentSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AuthenticatorAttachment = {
  
  NO_PREFERENCE: 0,
  PLATFORM: 1,
  CROSS_PLATFORM: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ProtectionPolicySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ProtectionPolicy = {
  
  UNSPECIFIED: 0,
  NONE: 1,
  UV_OR_CRED_ID_REQUIRED: 2,
  UV_REQUIRED: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LargeBlobSupportSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LargeBlobSupport = {
  
  NOT_REQUESTED: 0,
  REQUIRED: 1,
  PREFERRED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AttestationConveyancePreferenceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AttestationConveyancePreference = {
  
  NONE: 0,
  INDIRECT: 1,
  DIRECT: 2,
  ENTERPRISE: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PublicKeyCredentialTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PublicKeyCredentialType = {
  
  PUBLIC_KEY: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AuthenticatorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.Authenticator', scope);
  }
}

/** @interface */
export class AuthenticatorInterface {
  
  /**
   * @param { !PublicKeyCredentialCreationOptions } options
   * @return {!Promise<{
        status: !AuthenticatorStatus,
        credential: ?MakeCredentialAuthenticatorResponse,
        domExceptionDetails: ?WebAuthnDOMExceptionDetails,
   *  }>}
   */

  makeCredential(options) {}
  
  /**
   * @param { !GetCredentialOptions } options
   * @return {!Promise<{
        response: !GetCredentialResponse,
   *  }>}
   */

  getCredential(options) {}
  
  /**
   * @return {!Promise<{
        available: !boolean,
   *  }>}
   */

  isUserVerifyingPlatformAuthenticatorAvailable() {}
  
  /**
   * @return {!Promise<{
        available: !boolean,
   *  }>}
   */

  isConditionalMediationAvailable() {}
  
  /**
   * @param { !PublicKeyCredentialReportOptions } options
   * @return {!Promise<{
        status: !AuthenticatorStatus,
        domExceptionDetails: ?WebAuthnDOMExceptionDetails,
   *  }>}
   */

  report(options) {}
  
  /**
   * @return {!Promise<{
        capabilities: !Array<!WebAuthnClientCapability>,
   *  }>}
   */

  getClientCapabilities() {}
  
  /**
   */

  cancel() {}
}

/**
 * @implements { AuthenticatorInterface }
 */
export class AuthenticatorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AuthenticatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AuthenticatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AuthenticatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PublicKeyCredentialCreationOptions } options
   * @return {!Promise<{
        status: !AuthenticatorStatus,
        credential: ?MakeCredentialAuthenticatorResponse,
        domExceptionDetails: ?WebAuthnDOMExceptionDetails,
   *  }>}
   */

  makeCredential(
      options) {
    return this.proxy.sendMessage(
        0,
        Authenticator_MakeCredential_ParamsSpec.$,
        Authenticator_MakeCredential_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !GetCredentialOptions } options
   * @return {!Promise<{
        response: !GetCredentialResponse,
   *  }>}
   */

  getCredential(
      options) {
    return this.proxy.sendMessage(
        1,
        Authenticator_GetCredential_ParamsSpec.$,
        Authenticator_GetCredential_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        available: !boolean,
   *  }>}
   */

  isUserVerifyingPlatformAuthenticatorAvailable() {
    return this.proxy.sendMessage(
        2,
        Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec.$,
        Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        available: !boolean,
   *  }>}
   */

  isConditionalMediationAvailable() {
    return this.proxy.sendMessage(
        3,
        Authenticator_IsConditionalMediationAvailable_ParamsSpec.$,
        Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !PublicKeyCredentialReportOptions } options
   * @return {!Promise<{
        status: !AuthenticatorStatus,
        domExceptionDetails: ?WebAuthnDOMExceptionDetails,
   *  }>}
   */

  report(
      options) {
    return this.proxy.sendMessage(
        4,
        Authenticator_Report_ParamsSpec.$,
        Authenticator_Report_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        capabilities: !Array<!WebAuthnClientCapability>,
   *  }>}
   */

  getClientCapabilities() {
    return this.proxy.sendMessage(
        5,
        Authenticator_GetClientCapabilities_ParamsSpec.$,
        Authenticator_GetClientCapabilities_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        6,
        Authenticator_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Authenticator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AuthenticatorReceiver {
  /**
   * @param {!AuthenticatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AuthenticatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AuthenticatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AuthenticatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Authenticator_MakeCredential_ParamsSpec.$,
        Authenticator_MakeCredential_ResponseParamsSpec.$,
        impl.makeCredential.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Authenticator_GetCredential_ParamsSpec.$,
        Authenticator_GetCredential_ResponseParamsSpec.$,
        impl.getCredential.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec.$,
        Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec.$,
        impl.isUserVerifyingPlatformAuthenticatorAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Authenticator_IsConditionalMediationAvailable_ParamsSpec.$,
        Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec.$,
        impl.isConditionalMediationAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Authenticator_Report_ParamsSpec.$,
        Authenticator_Report_ResponseParamsSpec.$,
        impl.report.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Authenticator_GetClientCapabilities_ParamsSpec.$,
        Authenticator_GetClientCapabilities_ResponseParamsSpec.$,
        impl.getClientCapabilities.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Authenticator_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Authenticator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.Authenticator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AuthenticatorRemote}
   */
  static getRemote() {
    let remote = new AuthenticatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Authenticator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AuthenticatorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AuthenticatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AuthenticatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.makeCredential =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Authenticator_MakeCredential_ParamsSpec.$,
        Authenticator_MakeCredential_ResponseParamsSpec.$,
        this.makeCredential.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCredential =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Authenticator_GetCredential_ParamsSpec.$,
        Authenticator_GetCredential_ResponseParamsSpec.$,
        this.getCredential.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isUserVerifyingPlatformAuthenticatorAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec.$,
        Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec.$,
        this.isUserVerifyingPlatformAuthenticatorAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isConditionalMediationAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Authenticator_IsConditionalMediationAvailable_ParamsSpec.$,
        Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec.$,
        this.isConditionalMediationAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.report =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Authenticator_Report_ParamsSpec.$,
        Authenticator_Report_ResponseParamsSpec.$,
        this.report.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getClientCapabilities =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Authenticator_GetClientCapabilities_ParamsSpec.$,
        Authenticator_GetClientCapabilities_ResponseParamsSpec.$,
        this.getClientCapabilities.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Authenticator_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CommonCredentialInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SupplementalPubKeysResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuthenticationExtensionsPaymentResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MakeCredentialAuthenticatorResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GetAssertionAuthenticatorResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuthenticationExtensionsClientOutputsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PublicKeyCredentialRpEntitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PublicKeyCredentialUserEntitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PublicKeyCredentialParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CableAuthenticationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PRFValuesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentCredentialInstrumentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ShownPaymentEntityLogoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteDesktopClientOverrideSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SupplementalPubKeysRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PublicKeyCredentialRequestOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuthenticationExtensionsClientInputsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GetCredentialOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuthenticatorSelectionCriteriaSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PublicKeyCredentialCreationOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PublicKeyCredentialDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebAuthnDOMExceptionDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PublicKeyCredentialReportOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AllAcceptedCredentialsOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CurrentUserDetailsOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebAuthnClientCapabilitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GetAssertionResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_MakeCredential_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_MakeCredential_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_GetCredential_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_GetCredential_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_IsConditionalMediationAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_Report_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_Report_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_GetClientCapabilities_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_GetClientCapabilities_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Authenticator_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const GetCredentialResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CommonCredentialInfoSpec.$,
    'CommonCredentialInfo',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rawId', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientDataJson', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authenticatorData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CommonCredentialInfo {
  constructor() {
    /** @type { !string } */
    this.id;
    /** @type { !Array<!number> } */
    this.rawId;
    /** @type { !Array<!number> } */
    this.clientDataJson;
    /** @type { !Array<!number> } */
    this.authenticatorData;
  }
}



mojo.internal.Struct(
    SupplementalPubKeysResponseSpec.$,
    'SupplementalPubKeysResponse',
    [
      mojo.internal.StructField(
        'signatures', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SupplementalPubKeysResponse {
  constructor() {
    /** @type { !Array<!Array<!number>> } */
    this.signatures;
  }
}



mojo.internal.Struct(
    AuthenticationExtensionsPaymentResponseSpec.$,
    'AuthenticationExtensionsPaymentResponse',
    [
      mojo.internal.StructField(
        'browserBoundSignature', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AuthenticationExtensionsPaymentResponse {
  constructor() {
    /** @type { !Array<!number> } */
    this.browserBoundSignature;
  }
}



mojo.internal.Struct(
    MakeCredentialAuthenticatorResponseSpec.$,
    'MakeCredentialAuthenticatorResponse',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        CommonCredentialInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authenticatorAttachment', 8,
        0,
        AuthenticatorAttachmentSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attestationObject', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transports', 24,
        0,
        mojo.internal.Array(AuthenticatorTransportSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoHmacCreateSecret', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hmacCreateSecret', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoPrf', 12,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prf', 12,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prfResults', 32,
        0,
        PRFValuesSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoCredBlob', 12,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credBlob', 12,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'publicKeyDer', 40,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'publicKeyAlgo', 48,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoCredProps', 12,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasCredPropsRk', 12,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credPropsRk', 13,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoLargeBlob', 13,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supportsLargeBlob', 13,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supplementalPubKeys', 56,
        0,
        SupplementalPubKeysResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payment', 64,
        0,
        AuthenticationExtensionsPaymentResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class MakeCredentialAuthenticatorResponse {
  constructor() {
    /** @type { !CommonCredentialInfo } */
    this.info;
    /** @type { !AuthenticatorAttachment } */
    this.authenticatorAttachment;
    /** @type { !Array<!number> } */
    this.attestationObject;
    /** @type { !Array<!AuthenticatorTransport> } */
    this.transports;
    /** @type { !boolean } */
    this.echoHmacCreateSecret;
    /** @type { !boolean } */
    this.hmacCreateSecret;
    /** @type { !boolean } */
    this.echoPrf;
    /** @type { !boolean } */
    this.prf;
    /** @type { (PRFValues|undefined) } */
    this.prfResults;
    /** @type { !boolean } */
    this.echoCredBlob;
    /** @type { !boolean } */
    this.credBlob;
    /** @type { (Array<!number>|undefined) } */
    this.publicKeyDer;
    /** @type { !number } */
    this.publicKeyAlgo;
    /** @type { !boolean } */
    this.echoCredProps;
    /** @type { !boolean } */
    this.hasCredPropsRk;
    /** @type { !boolean } */
    this.credPropsRk;
    /** @type { !boolean } */
    this.echoLargeBlob;
    /** @type { !boolean } */
    this.supportsLargeBlob;
    /** @type { (SupplementalPubKeysResponse|undefined) } */
    this.supplementalPubKeys;
    /** @type { (AuthenticationExtensionsPaymentResponse|undefined) } */
    this.payment;
  }
}



mojo.internal.Struct(
    GetAssertionAuthenticatorResponseSpec.$,
    'GetAssertionAuthenticatorResponse',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        CommonCredentialInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authenticatorAttachment', 8,
        0,
        AuthenticatorAttachmentSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'signature', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userHandle', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extensions', 32,
        0,
        AuthenticationExtensionsClientOutputsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class GetAssertionAuthenticatorResponse {
  constructor() {
    /** @type { !CommonCredentialInfo } */
    this.info;
    /** @type { !AuthenticatorAttachment } */
    this.authenticatorAttachment;
    /** @type { !Array<!number> } */
    this.signature;
    /** @type { (Array<!number>|undefined) } */
    this.userHandle;
    /** @type { !AuthenticationExtensionsClientOutputs } */
    this.extensions;
  }
}



mojo.internal.Struct(
    AuthenticationExtensionsClientOutputsSpec.$,
    'AuthenticationExtensionsClientOutputs',
    [
      mojo.internal.StructField(
        'echoAppidExtension', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'appidExtension', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoPrf', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prfResults', 8,
        0,
        PRFValuesSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prfNotEvaluated', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoLargeBlob', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'largeBlob', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoLargeBlobWritten', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'largeBlobWritten', 0,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'getCredBlob', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supplementalPubKeys', 32,
        0,
        SupplementalPubKeysResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payment', 40,
        0,
        AuthenticationExtensionsPaymentResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AuthenticationExtensionsClientOutputs {
  constructor() {
    /** @type { !boolean } */
    this.echoAppidExtension;
    /** @type { !boolean } */
    this.appidExtension;
    /** @type { !boolean } */
    this.echoPrf;
    /** @type { (PRFValues|undefined) } */
    this.prfResults;
    /** @type { !boolean } */
    this.prfNotEvaluated;
    /** @type { !boolean } */
    this.echoLargeBlob;
    /** @type { (Array<!number>|undefined) } */
    this.largeBlob;
    /** @type { !boolean } */
    this.echoLargeBlobWritten;
    /** @type { !boolean } */
    this.largeBlobWritten;
    /** @type { (Array<!number>|undefined) } */
    this.getCredBlob;
    /** @type { (SupplementalPubKeysResponse|undefined) } */
    this.supplementalPubKeys;
    /** @type { (AuthenticationExtensionsPaymentResponse|undefined) } */
    this.payment;
  }
}



mojo.internal.Struct(
    PublicKeyCredentialRpEntitySpec.$,
    'PublicKeyCredentialRpEntity',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PublicKeyCredentialRpEntity {
  constructor() {
    /** @type { !string } */
    this.id;
    /** @type { !string } */
    this.name;
  }
}



mojo.internal.Struct(
    PublicKeyCredentialUserEntitySpec.$,
    'PublicKeyCredentialUserEntity',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PublicKeyCredentialUserEntity {
  constructor() {
    /** @type { !Array<!number> } */
    this.id;
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.displayName;
  }
}



mojo.internal.Struct(
    PublicKeyCredentialParametersSpec.$,
    'PublicKeyCredentialParameters',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        PublicKeyCredentialTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'algorithmIdentifier', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PublicKeyCredentialParameters {
  constructor() {
    /** @type { !PublicKeyCredentialType } */
    this.type;
    /** @type { !number } */
    this.algorithmIdentifier;
  }
}



mojo.internal.Struct(
    CableAuthenticationSpec.$,
    'CableAuthentication',
    [
      mojo.internal.StructField(
        'version', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientEid', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authenticatorEid', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionPreKey', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serverLinkData', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'experiments', 40,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class CableAuthentication {
  constructor() {
    /** @type { !number } */
    this.version;
    /** @type { (Array<!number>|undefined) } */
    this.clientEid;
    /** @type { (Array<!number>|undefined) } */
    this.authenticatorEid;
    /** @type { (Array<!number>|undefined) } */
    this.sessionPreKey;
    /** @type { (Array<!number>|undefined) } */
    this.serverLinkData;
    /** @type { (Array<!number>|undefined) } */
    this.experiments;
  }
}



mojo.internal.Struct(
    PRFValuesSpec.$,
    'PRFValues',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'first', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'second', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PRFValues {
  constructor() {
    /** @type { (Array<!number>|undefined) } */
    this.id;
    /** @type { !Array<!number> } */
    this.first;
    /** @type { (Array<!number>|undefined) } */
    this.second;
  }
}



mojo.internal.Struct(
    PaymentOptionsSpec.$,
    'PaymentOptions',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        payments_mojom_PaymentCurrencyAmountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'instrument', 8,
        0,
        PaymentCredentialInstrumentSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payeeName', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payeeOrigin', 24,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paymentEntitiesLogos', 32,
        0,
        mojo.internal.Array(ShownPaymentEntityLogoSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'browserBoundPublicKey', 40,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class PaymentOptions {
  constructor() {
    /** @type { !payments_mojom_PaymentCurrencyAmount } */
    this.total;
    /** @type { !PaymentCredentialInstrument } */
    this.instrument;
    /** @type { (string|undefined) } */
    this.payeeName;
    /** @type { (url_mojom_Origin|undefined) } */
    this.payeeOrigin;
    /** @type { (Array<!ShownPaymentEntityLogo>|undefined) } */
    this.paymentEntitiesLogos;
    /** @type { (Array<!number>|undefined) } */
    this.browserBoundPublicKey;
  }
}



mojo.internal.Struct(
    PaymentCredentialInstrumentSpec.$,
    'PaymentCredentialInstrument',
    [
      mojo.internal.StructField(
        'displayName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icon', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'iconMustBeShown', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PaymentCredentialInstrument {
  constructor() {
    /** @type { !string } */
    this.displayName;
    /** @type { !url_mojom_Url } */
    this.icon;
    /** @type { !boolean } */
    this.iconMustBeShown;
    /** @type { (string|undefined) } */
    this.details;
  }
}



mojo.internal.Struct(
    ShownPaymentEntityLogoSpec.$,
    'ShownPaymentEntityLogo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ShownPaymentEntityLogo {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.label;
  }
}



mojo.internal.Struct(
    RemoteDesktopClientOverrideSpec.$,
    'RemoteDesktopClientOverride',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sameOriginWithAncestors', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteDesktopClientOverride {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !boolean } */
    this.sameOriginWithAncestors;
  }
}



mojo.internal.Struct(
    SupplementalPubKeysRequestSpec.$,
    'SupplementalPubKeysRequest',
    [
      mojo.internal.StructField(
        'deviceScopeRequested', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'providerScopeRequested', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attestation', 4,
        0,
        AttestationConveyancePreferenceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attestationFormats', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SupplementalPubKeysRequest {
  constructor() {
    /** @type { !boolean } */
    this.deviceScopeRequested;
    /** @type { !boolean } */
    this.providerScopeRequested;
    /** @type { !AttestationConveyancePreference } */
    this.attestation;
    /** @type { !Array<!string> } */
    this.attestationFormats;
  }
}



mojo.internal.Struct(
    PublicKeyCredentialRequestOptionsSpec.$,
    'PublicKeyCredentialRequestOptions',
    [
      mojo.internal.StructField(
        'challenge', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'challengeUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'relyingPartyId', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowCredentials', 32,
        0,
        mojo.internal.Array(PublicKeyCredentialDescriptorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hints', 40,
        0,
        mojo.internal.Array(HintSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userVerification', 48,
        0,
        UserVerificationRequirementSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extensions', 56,
        0,
        AuthenticationExtensionsClientInputsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class PublicKeyCredentialRequestOptions {
  constructor() {
    /** @type { (Array<!number>|undefined) } */
    this.challenge;
    /** @type { (url_mojom_Url|undefined) } */
    this.challengeUrl;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.timeout;
    /** @type { !string } */
    this.relyingPartyId;
    /** @type { !Array<!PublicKeyCredentialDescriptor> } */
    this.allowCredentials;
    /** @type { !Array<!Hint> } */
    this.hints;
    /** @type { !UserVerificationRequirement } */
    this.userVerification;
    /** @type { !AuthenticationExtensionsClientInputs } */
    this.extensions;
  }
}



mojo.internal.Struct(
    AuthenticationExtensionsClientInputsSpec.$,
    'AuthenticationExtensionsClientInputs',
    [
      mojo.internal.StructField(
        'appid', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cableAuthenticationData', 8,
        0,
        mojo.internal.Array(CableAuthenticationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prf', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prfInputs', 24,
        0,
        mojo.internal.Array(PRFValuesSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'largeBlobRead', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'largeBlobWrite', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'getCredBlob', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteDesktopClientOverride', 40,
        0,
        RemoteDesktopClientOverrideSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supplementalPubKeys', 48,
        0,
        SupplementalPubKeysRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paymentBrowserBoundKeyParameters', 56,
        0,
        mojo.internal.Array(PublicKeyCredentialParametersSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class AuthenticationExtensionsClientInputs {
  constructor() {
    /** @type { (string|undefined) } */
    this.appid;
    /** @type { !Array<!CableAuthentication> } */
    this.cableAuthenticationData;
    /** @type { !boolean } */
    this.prf;
    /** @type { !Array<!PRFValues> } */
    this.prfInputs;
    /** @type { !boolean } */
    this.largeBlobRead;
    /** @type { (Array<!number>|undefined) } */
    this.largeBlobWrite;
    /** @type { !boolean } */
    this.getCredBlob;
    /** @type { (RemoteDesktopClientOverride|undefined) } */
    this.remoteDesktopClientOverride;
    /** @type { (SupplementalPubKeysRequest|undefined) } */
    this.supplementalPubKeys;
    /** @type { (Array<!PublicKeyCredentialParameters>|undefined) } */
    this.paymentBrowserBoundKeyParameters;
  }
}



mojo.internal.Struct(
    GetCredentialOptionsSpec.$,
    'GetCredentialOptions',
    [
      mojo.internal.StructField(
        'mediation', 0,
        0,
        MediationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'publicKey', 8,
        0,
        PublicKeyCredentialRequestOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'password', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GetCredentialOptions {
  constructor() {
    /** @type { !Mediation } */
    this.mediation;
    /** @type { (PublicKeyCredentialRequestOptions|undefined) } */
    this.publicKey;
    /** @type { !boolean } */
    this.password;
  }
}



mojo.internal.Struct(
    AuthenticatorSelectionCriteriaSpec.$,
    'AuthenticatorSelectionCriteria',
    [
      mojo.internal.StructField(
        'authenticatorAttachment', 0,
        0,
        AuthenticatorAttachmentSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'residentKey', 4,
        0,
        ResidentKeyRequirementSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userVerification', 8,
        0,
        UserVerificationRequirementSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AuthenticatorSelectionCriteria {
  constructor() {
    /** @type { !AuthenticatorAttachment } */
    this.authenticatorAttachment;
    /** @type { !ResidentKeyRequirement } */
    this.residentKey;
    /** @type { !UserVerificationRequirement } */
    this.userVerification;
  }
}



mojo.internal.Struct(
    PublicKeyCredentialCreationOptionsSpec.$,
    'PublicKeyCredentialCreationOptions',
    [
      mojo.internal.StructField(
        'relyingParty', 0,
        0,
        PublicKeyCredentialRpEntitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'user', 8,
        0,
        PublicKeyCredentialUserEntitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'challenge', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'publicKeyParameters', 24,
        0,
        mojo.internal.Array(PublicKeyCredentialParametersSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 32,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'excludeCredentials', 40,
        0,
        mojo.internal.Array(PublicKeyCredentialDescriptorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'authenticatorSelection', 48,
        0,
        AuthenticatorSelectionCriteriaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hints', 56,
        0,
        mojo.internal.Array(HintSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attestation', 64,
        0,
        AttestationConveyancePreferenceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hmacCreateSecret', 68,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prfEnable', 68,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prfInput', 72,
        0,
        PRFValuesSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protectionPolicy', 80,
        0,
        ProtectionPolicySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enforceProtectionPolicy', 68,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'appidExclude', 88,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credProps', 68,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'largeBlobEnable', 84,
        0,
        LargeBlobSupportSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPaymentCredentialCreation', 68,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credBlob', 96,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minPinLengthRequested', 68,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteDesktopClientOverride', 104,
        0,
        RemoteDesktopClientOverrideSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supplementalPubKeys', 112,
        0,
        SupplementalPubKeysRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paymentBrowserBoundKeyParameters', 120,
        0,
        mojo.internal.Array(PublicKeyCredentialParametersSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attestationFormats', 128,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isConditional', 68,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 144],]);



/**
 * @record
 */
export class PublicKeyCredentialCreationOptions {
  constructor() {
    /** @type { !PublicKeyCredentialRpEntity } */
    this.relyingParty;
    /** @type { !PublicKeyCredentialUserEntity } */
    this.user;
    /** @type { !Array<!number> } */
    this.challenge;
    /** @type { !Array<!PublicKeyCredentialParameters> } */
    this.publicKeyParameters;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.timeout;
    /** @type { !Array<!PublicKeyCredentialDescriptor> } */
    this.excludeCredentials;
    /** @type { (AuthenticatorSelectionCriteria|undefined) } */
    this.authenticatorSelection;
    /** @type { !Array<!Hint> } */
    this.hints;
    /** @type { !AttestationConveyancePreference } */
    this.attestation;
    /** @type { !boolean } */
    this.hmacCreateSecret;
    /** @type { !boolean } */
    this.prfEnable;
    /** @type { (PRFValues|undefined) } */
    this.prfInput;
    /** @type { !ProtectionPolicy } */
    this.protectionPolicy;
    /** @type { !boolean } */
    this.enforceProtectionPolicy;
    /** @type { (string|undefined) } */
    this.appidExclude;
    /** @type { !boolean } */
    this.credProps;
    /** @type { !LargeBlobSupport } */
    this.largeBlobEnable;
    /** @type { !boolean } */
    this.isPaymentCredentialCreation;
    /** @type { (Array<!number>|undefined) } */
    this.credBlob;
    /** @type { !boolean } */
    this.minPinLengthRequested;
    /** @type { (RemoteDesktopClientOverride|undefined) } */
    this.remoteDesktopClientOverride;
    /** @type { (SupplementalPubKeysRequest|undefined) } */
    this.supplementalPubKeys;
    /** @type { (Array<!PublicKeyCredentialParameters>|undefined) } */
    this.paymentBrowserBoundKeyParameters;
    /** @type { !Array<!string> } */
    this.attestationFormats;
    /** @type { !boolean } */
    this.isConditional;
  }
}



mojo.internal.Struct(
    PublicKeyCredentialDescriptorSpec.$,
    'PublicKeyCredentialDescriptor',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        PublicKeyCredentialTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transports', 16,
        0,
        mojo.internal.Array(AuthenticatorTransportSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PublicKeyCredentialDescriptor {
  constructor() {
    /** @type { !PublicKeyCredentialType } */
    this.type;
    /** @type { !Array<!number> } */
    this.id;
    /** @type { !Array<!AuthenticatorTransport> } */
    this.transports;
  }
}



mojo.internal.Struct(
    WebAuthnDOMExceptionDetailsSpec.$,
    'WebAuthnDOMExceptionDetails',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebAuthnDOMExceptionDetails {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    PublicKeyCredentialReportOptionsSpec.$,
    'PublicKeyCredentialReportOptions',
    [
      mojo.internal.StructField(
        'relyingPartyId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unknownCredentialId', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allAcceptedCredentials', 16,
        0,
        AllAcceptedCredentialsOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentUserDetails', 24,
        0,
        CurrentUserDetailsOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PublicKeyCredentialReportOptions {
  constructor() {
    /** @type { !string } */
    this.relyingPartyId;
    /** @type { (Array<!number>|undefined) } */
    this.unknownCredentialId;
    /** @type { (AllAcceptedCredentialsOptions|undefined) } */
    this.allAcceptedCredentials;
    /** @type { (CurrentUserDetailsOptions|undefined) } */
    this.currentUserDetails;
  }
}



mojo.internal.Struct(
    AllAcceptedCredentialsOptionsSpec.$,
    'AllAcceptedCredentialsOptions',
    [
      mojo.internal.StructField(
        'userId', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allAcceptedCredentialsIds', 8,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AllAcceptedCredentialsOptions {
  constructor() {
    /** @type { !Array<!number> } */
    this.userId;
    /** @type { !Array<!Array<!number>> } */
    this.allAcceptedCredentialsIds;
  }
}



mojo.internal.Struct(
    CurrentUserDetailsOptionsSpec.$,
    'CurrentUserDetailsOptions',
    [
      mojo.internal.StructField(
        'userId', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CurrentUserDetailsOptions {
  constructor() {
    /** @type { !Array<!number> } */
    this.userId;
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.displayName;
  }
}



mojo.internal.Struct(
    WebAuthnClientCapabilitySpec.$,
    'WebAuthnClientCapability',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supported', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebAuthnClientCapability {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !boolean } */
    this.supported;
  }
}



mojo.internal.Struct(
    GetAssertionResponseSpec.$,
    'GetAssertionResponse',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        AuthenticatorStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credential', 8,
        0,
        GetAssertionAuthenticatorResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domExceptionDetails', 16,
        0,
        WebAuthnDOMExceptionDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class GetAssertionResponse {
  constructor() {
    /** @type { !AuthenticatorStatus } */
    this.status;
    /** @type { (GetAssertionAuthenticatorResponse|undefined) } */
    this.credential;
    /** @type { (WebAuthnDOMExceptionDetails|undefined) } */
    this.domExceptionDetails;
  }
}



mojo.internal.Struct(
    Authenticator_MakeCredential_ParamsSpec.$,
    'Authenticator_MakeCredential_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        PublicKeyCredentialCreationOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Authenticator_MakeCredential_Params {
  constructor() {
    /** @type { !PublicKeyCredentialCreationOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    Authenticator_MakeCredential_ResponseParamsSpec.$,
    'Authenticator_MakeCredential_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        AuthenticatorStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credential', 8,
        0,
        MakeCredentialAuthenticatorResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domExceptionDetails', 16,
        0,
        WebAuthnDOMExceptionDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Authenticator_MakeCredential_ResponseParams {
  constructor() {
    /** @type { !AuthenticatorStatus } */
    this.status;
    /** @type { (MakeCredentialAuthenticatorResponse|undefined) } */
    this.credential;
    /** @type { (WebAuthnDOMExceptionDetails|undefined) } */
    this.domExceptionDetails;
  }
}



mojo.internal.Struct(
    Authenticator_GetCredential_ParamsSpec.$,
    'Authenticator_GetCredential_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        GetCredentialOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Authenticator_GetCredential_Params {
  constructor() {
    /** @type { !GetCredentialOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    Authenticator_GetCredential_ResponseParamsSpec.$,
    'Authenticator_GetCredential_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        GetCredentialResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Authenticator_GetCredential_ResponseParams {
  constructor() {
    /** @type { !GetCredentialResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsSpec.$,
    'Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsSpec.$,
    'Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams',
    [
      mojo.internal.StructField(
        'available', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.available;
  }
}



mojo.internal.Struct(
    Authenticator_IsConditionalMediationAvailable_ParamsSpec.$,
    'Authenticator_IsConditionalMediationAvailable_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Authenticator_IsConditionalMediationAvailable_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Authenticator_IsConditionalMediationAvailable_ResponseParamsSpec.$,
    'Authenticator_IsConditionalMediationAvailable_ResponseParams',
    [
      mojo.internal.StructField(
        'available', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Authenticator_IsConditionalMediationAvailable_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.available;
  }
}



mojo.internal.Struct(
    Authenticator_Report_ParamsSpec.$,
    'Authenticator_Report_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        PublicKeyCredentialReportOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Authenticator_Report_Params {
  constructor() {
    /** @type { !PublicKeyCredentialReportOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    Authenticator_Report_ResponseParamsSpec.$,
    'Authenticator_Report_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        AuthenticatorStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domExceptionDetails', 8,
        0,
        WebAuthnDOMExceptionDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Authenticator_Report_ResponseParams {
  constructor() {
    /** @type { !AuthenticatorStatus } */
    this.status;
    /** @type { (WebAuthnDOMExceptionDetails|undefined) } */
    this.domExceptionDetails;
  }
}



mojo.internal.Struct(
    Authenticator_GetClientCapabilities_ParamsSpec.$,
    'Authenticator_GetClientCapabilities_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Authenticator_GetClientCapabilities_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Authenticator_GetClientCapabilities_ResponseParamsSpec.$,
    'Authenticator_GetClientCapabilities_ResponseParams',
    [
      mojo.internal.StructField(
        'capabilities', 0,
        0,
        mojo.internal.Array(WebAuthnClientCapabilitySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Authenticator_GetClientCapabilities_ResponseParams {
  constructor() {
    /** @type { !Array<!WebAuthnClientCapability> } */
    this.capabilities;
  }
}



mojo.internal.Struct(
    Authenticator_Cancel_ParamsSpec.$,
    'Authenticator_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Authenticator_Cancel_Params {
  constructor() {
  }
}

mojo.internal.Union(
    GetCredentialResponseSpec.$, 'GetCredentialResponse',
    {
      'getAssertionResponse': {
        'ordinal': 0,
        'type': GetAssertionResponseSpec.$,
      },
      'passwordResponse': {
        'ordinal': 1,
        'type': blink_mojom_CredentialInfoSpec.$,
      },
    });

/**
 * @typedef { {
 *   getAssertionResponse: (!GetAssertionResponse|undefined),
 *   passwordResponse: (!blink_mojom_CredentialInfo|undefined),
 * } }
 */
export const GetCredentialResponse = {};
