// third_party/blink/public/mojom/webauthn/authenticator.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace blink::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_MakeCredential_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PublicKeyCredentialCreationOptions_Data> options;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_MakeCredential_Params_Data>;

  Authenticator_MakeCredential_Params_Data();
  ~Authenticator_MakeCredential_Params_Data() = delete;
};
static_assert(sizeof(Authenticator_MakeCredential_Params_Data) == 16,
              "Bad sizeof(Authenticator_MakeCredential_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_MakeCredential_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::MakeCredentialAuthenticatorResponse_Data> credential;
  mojo::internal::Pointer<internal::WebAuthnDOMExceptionDetails_Data> dom_exception_details;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_MakeCredential_ResponseParams_Data>;

  Authenticator_MakeCredential_ResponseParams_Data();
  ~Authenticator_MakeCredential_ResponseParams_Data() = delete;
};
static_assert(sizeof(Authenticator_MakeCredential_ResponseParams_Data) == 32,
              "Bad sizeof(Authenticator_MakeCredential_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_GetCredential_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::GetCredentialOptions_Data> options;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_GetCredential_Params_Data>;

  Authenticator_GetCredential_Params_Data();
  ~Authenticator_GetCredential_Params_Data() = delete;
};
static_assert(sizeof(Authenticator_GetCredential_Params_Data) == 16,
              "Bad sizeof(Authenticator_GetCredential_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_GetCredential_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::GetCredentialResponse_Data response;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_GetCredential_ResponseParams_Data>;

  Authenticator_GetCredential_ResponseParams_Data();
  ~Authenticator_GetCredential_ResponseParams_Data() = delete;
};
static_assert(sizeof(Authenticator_GetCredential_ResponseParams_Data) == 24,
              "Bad sizeof(Authenticator_GetCredential_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data>;

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data();
  ~Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data() = delete;
};
static_assert(sizeof(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data) == 8,
              "Bad sizeof(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t available : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data>;

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data();
  ~Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data() = delete;
};
static_assert(sizeof(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data) == 16,
              "Bad sizeof(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_IsConditionalMediationAvailable_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_IsConditionalMediationAvailable_Params_Data>;

  Authenticator_IsConditionalMediationAvailable_Params_Data();
  ~Authenticator_IsConditionalMediationAvailable_Params_Data() = delete;
};
static_assert(sizeof(Authenticator_IsConditionalMediationAvailable_Params_Data) == 8,
              "Bad sizeof(Authenticator_IsConditionalMediationAvailable_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_IsConditionalMediationAvailable_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t available : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Authenticator_IsConditionalMediationAvailable_ResponseParams_Data>;

  Authenticator_IsConditionalMediationAvailable_ResponseParams_Data();
  ~Authenticator_IsConditionalMediationAvailable_ResponseParams_Data() = delete;
};
static_assert(sizeof(Authenticator_IsConditionalMediationAvailable_ResponseParams_Data) == 16,
              "Bad sizeof(Authenticator_IsConditionalMediationAvailable_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_Report_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PublicKeyCredentialReportOptions_Data> options;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_Report_Params_Data>;

  Authenticator_Report_Params_Data();
  ~Authenticator_Report_Params_Data() = delete;
};
static_assert(sizeof(Authenticator_Report_Params_Data) == 16,
              "Bad sizeof(Authenticator_Report_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_Report_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::WebAuthnDOMExceptionDetails_Data> dom_exception_details;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_Report_ResponseParams_Data>;

  Authenticator_Report_ResponseParams_Data();
  ~Authenticator_Report_ResponseParams_Data() = delete;
};
static_assert(sizeof(Authenticator_Report_ResponseParams_Data) == 24,
              "Bad sizeof(Authenticator_Report_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_GetClientCapabilities_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_GetClientCapabilities_Params_Data>;

  Authenticator_GetClientCapabilities_Params_Data();
  ~Authenticator_GetClientCapabilities_Params_Data() = delete;
};
static_assert(sizeof(Authenticator_GetClientCapabilities_Params_Data) == 8,
              "Bad sizeof(Authenticator_GetClientCapabilities_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_GetClientCapabilities_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::WebAuthnClientCapability_Data>>> capabilities;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_GetClientCapabilities_ResponseParams_Data>;

  Authenticator_GetClientCapabilities_ResponseParams_Data();
  ~Authenticator_GetClientCapabilities_ResponseParams_Data() = delete;
};
static_assert(sizeof(Authenticator_GetClientCapabilities_ResponseParams_Data) == 16,
              "Bad sizeof(Authenticator_GetClientCapabilities_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Authenticator_Cancel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Authenticator_Cancel_Params_Data>;

  Authenticator_Cancel_Params_Data();
  ~Authenticator_Cancel_Params_Data() = delete;
};
static_assert(sizeof(Authenticator_Cancel_Params_Data) == 8,
              "Bad sizeof(Authenticator_Cancel_Params_Data)");

}  // namespace internal


class Authenticator_MakeCredential_ParamsDataView {
 public:
  Authenticator_MakeCredential_ParamsDataView() = default;

  Authenticator_MakeCredential_ParamsDataView(
      internal::Authenticator_MakeCredential_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptionsDataView(
      PublicKeyCredentialCreationOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::PublicKeyCredentialCreationOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Authenticator_MakeCredential_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Authenticator_MakeCredential_ResponseParamsDataView {
 public:
  Authenticator_MakeCredential_ResponseParamsDataView() = default;

  Authenticator_MakeCredential_ResponseParamsDataView(
      internal::Authenticator_MakeCredential_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::AuthenticatorStatus>(
        data_value, output);
  }
  AuthenticatorStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AuthenticatorStatus>(data_->status));
  }
  inline void GetCredentialDataView(
      MakeCredentialAuthenticatorResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredential(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MakeCredentialAuthenticatorResponseDataView, UserType>(),
    "Attempting to read the optional `credential` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCredential` instead "
    "of `ReadCredential if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->credential.Get();
    return mojo::internal::Deserialize<::blink::mojom::MakeCredentialAuthenticatorResponseDataView>(
        pointer, output, message_);
  }
  inline void GetDomExceptionDetailsDataView(
      WebAuthnDOMExceptionDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomExceptionDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::WebAuthnDOMExceptionDetailsDataView, UserType>(),
    "Attempting to read the optional `dom_exception_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDomExceptionDetails` instead "
    "of `ReadDomExceptionDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->dom_exception_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebAuthnDOMExceptionDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Authenticator_MakeCredential_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Authenticator_GetCredential_ParamsDataView {
 public:
  Authenticator_GetCredential_ParamsDataView() = default;

  Authenticator_GetCredential_ParamsDataView(
      internal::Authenticator_GetCredential_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptionsDataView(
      GetCredentialOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::GetCredentialOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Authenticator_GetCredential_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Authenticator_GetCredential_ResponseParamsDataView {
 public:
  Authenticator_GetCredential_ResponseParamsDataView() = default;

  Authenticator_GetCredential_ResponseParamsDataView(
      internal::Authenticator_GetCredential_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResponseDataView(
      GetCredentialResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
    auto* pointer = !data_->response.is_null() ? &data_->response : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::GetCredentialResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::Authenticator_GetCredential_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsDataView {
 public:
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsDataView() = default;

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsDataView(
      internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data* data_ = nullptr;
};


class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsDataView {
 public:
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsDataView() = default;

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsDataView(
      internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool available() const {
    return data_->available;
  }
 private:
  internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data* data_ = nullptr;
};


class Authenticator_IsConditionalMediationAvailable_ParamsDataView {
 public:
  Authenticator_IsConditionalMediationAvailable_ParamsDataView() = default;

  Authenticator_IsConditionalMediationAvailable_ParamsDataView(
      internal::Authenticator_IsConditionalMediationAvailable_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Authenticator_IsConditionalMediationAvailable_Params_Data* data_ = nullptr;
};


class Authenticator_IsConditionalMediationAvailable_ResponseParamsDataView {
 public:
  Authenticator_IsConditionalMediationAvailable_ResponseParamsDataView() = default;

  Authenticator_IsConditionalMediationAvailable_ResponseParamsDataView(
      internal::Authenticator_IsConditionalMediationAvailable_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool available() const {
    return data_->available;
  }
 private:
  internal::Authenticator_IsConditionalMediationAvailable_ResponseParams_Data* data_ = nullptr;
};


class Authenticator_Report_ParamsDataView {
 public:
  Authenticator_Report_ParamsDataView() = default;

  Authenticator_Report_ParamsDataView(
      internal::Authenticator_Report_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptionsDataView(
      PublicKeyCredentialReportOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::PublicKeyCredentialReportOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Authenticator_Report_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Authenticator_Report_ResponseParamsDataView {
 public:
  Authenticator_Report_ResponseParamsDataView() = default;

  Authenticator_Report_ResponseParamsDataView(
      internal::Authenticator_Report_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::AuthenticatorStatus>(
        data_value, output);
  }
  AuthenticatorStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AuthenticatorStatus>(data_->status));
  }
  inline void GetDomExceptionDetailsDataView(
      WebAuthnDOMExceptionDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomExceptionDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::WebAuthnDOMExceptionDetailsDataView, UserType>(),
    "Attempting to read the optional `dom_exception_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDomExceptionDetails` instead "
    "of `ReadDomExceptionDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->dom_exception_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebAuthnDOMExceptionDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Authenticator_Report_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Authenticator_GetClientCapabilities_ParamsDataView {
 public:
  Authenticator_GetClientCapabilities_ParamsDataView() = default;

  Authenticator_GetClientCapabilities_ParamsDataView(
      internal::Authenticator_GetClientCapabilities_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Authenticator_GetClientCapabilities_Params_Data* data_ = nullptr;
};


class Authenticator_GetClientCapabilities_ResponseParamsDataView {
 public:
  Authenticator_GetClientCapabilities_ResponseParamsDataView() = default;

  Authenticator_GetClientCapabilities_ResponseParamsDataView(
      internal::Authenticator_GetClientCapabilities_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCapabilitiesDataView(
      mojo::ArrayDataView<WebAuthnClientCapabilityDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCapabilities(UserType* output) {
    
    auto* pointer = data_->capabilities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebAuthnClientCapabilityDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Authenticator_GetClientCapabilities_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Authenticator_Cancel_ParamsDataView {
 public:
  Authenticator_Cancel_ParamsDataView() = default;

  Authenticator_Cancel_ParamsDataView(
      internal::Authenticator_Cancel_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Authenticator_Cancel_Params_Data* data_ = nullptr;
};

inline void Authenticator_MakeCredential_ParamsDataView::GetOptionsDataView(
    PublicKeyCredentialCreationOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = PublicKeyCredentialCreationOptionsDataView(pointer, message_);
}


inline void Authenticator_MakeCredential_ResponseParamsDataView::GetCredentialDataView(
    MakeCredentialAuthenticatorResponseDataView* output) {
  auto pointer = data_->credential.Get();
  *output = MakeCredentialAuthenticatorResponseDataView(pointer, message_);
}
inline void Authenticator_MakeCredential_ResponseParamsDataView::GetDomExceptionDetailsDataView(
    WebAuthnDOMExceptionDetailsDataView* output) {
  auto pointer = data_->dom_exception_details.Get();
  *output = WebAuthnDOMExceptionDetailsDataView(pointer, message_);
}


inline void Authenticator_GetCredential_ParamsDataView::GetOptionsDataView(
    GetCredentialOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = GetCredentialOptionsDataView(pointer, message_);
}


inline void Authenticator_GetCredential_ResponseParamsDataView::GetResponseDataView(
    GetCredentialResponseDataView* output) {
  auto pointer = &data_->response;
  *output = GetCredentialResponseDataView(pointer, message_);
}










inline void Authenticator_Report_ParamsDataView::GetOptionsDataView(
    PublicKeyCredentialReportOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = PublicKeyCredentialReportOptionsDataView(pointer, message_);
}


inline void Authenticator_Report_ResponseParamsDataView::GetDomExceptionDetailsDataView(
    WebAuthnDOMExceptionDetailsDataView* output) {
  auto pointer = data_->dom_exception_details.Get();
  *output = WebAuthnDOMExceptionDetailsDataView(pointer, message_);
}




inline void Authenticator_GetClientCapabilities_ResponseParamsDataView::GetCapabilitiesDataView(
    mojo::ArrayDataView<WebAuthnClientCapabilityDataView>* output) {
  auto pointer = data_->capabilities.Get();
  *output = mojo::ArrayDataView<WebAuthnClientCapabilityDataView>(pointer, message_);
}





}  // blink::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_PARAMS_DATA_H_