// third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_USER_AGENT_USER_AGENT_METADATA_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_USER_AGENT_USER_AGENT_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "third_party/blink/public/common/user_agent/user_agent_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {





class BLINK_COMMON_EXPORT UserAgentBrandVersion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserAgentBrandVersion, T>::value>;
  using DataView = UserAgentBrandVersionDataView;
  using Data_ = internal::UserAgentBrandVersion_Data;

  template <typename... Args>
  static UserAgentBrandVersionPtr New(Args&&... args) {
    return UserAgentBrandVersionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserAgentBrandVersionPtr From(const U& u) {
    return mojo::TypeConverter<UserAgentBrandVersionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserAgentBrandVersion>::Convert(*this);
  }


  UserAgentBrandVersion();

  UserAgentBrandVersion(
      const std::string& brand,
      const std::string& version);


  ~UserAgentBrandVersion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserAgentBrandVersionPtr>
  UserAgentBrandVersionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserAgentBrandVersion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserAgentBrandVersion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserAgentBrandVersion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserAgentBrandVersion::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserAgentBrandVersion::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserAgentBrandVersion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserAgentBrandVersion_UnserializedMessageContext<
            UserType, UserAgentBrandVersion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserAgentBrandVersion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserAgentBrandVersion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserAgentBrandVersion_UnserializedMessageContext<
            UserType, UserAgentBrandVersion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserAgentBrandVersion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string brand;
  
  std::string version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserAgentBrandVersion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserAgentBrandVersion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserAgentBrandVersion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserAgentBrandVersion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class BLINK_COMMON_EXPORT UserAgentMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserAgentMetadata, T>::value>;
  using DataView = UserAgentMetadataDataView;
  using Data_ = internal::UserAgentMetadata_Data;

  template <typename... Args>
  static UserAgentMetadataPtr New(Args&&... args) {
    return UserAgentMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserAgentMetadataPtr From(const U& u) {
    return mojo::TypeConverter<UserAgentMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserAgentMetadata>::Convert(*this);
  }


  UserAgentMetadata();

  UserAgentMetadata(
      std::vector<::blink::UserAgentBrandVersion> brand_version_list,
      std::vector<::blink::UserAgentBrandVersion> brand_full_version_list,
      const std::string& full_version,
      const std::string& platform,
      const std::string& platform_version,
      const std::string& architecture,
      const std::string& model,
      bool mobile,
      const std::string& bitness,
      bool wow64,
      std::vector<std::string> form_factors);


  ~UserAgentMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserAgentMetadataPtr>
  UserAgentMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserAgentMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserAgentMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserAgentMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserAgentMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserAgentMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserAgentMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserAgentMetadata_UnserializedMessageContext<
            UserType, UserAgentMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserAgentMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserAgentMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserAgentMetadata_UnserializedMessageContext<
            UserType, UserAgentMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserAgentMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::blink::UserAgentBrandVersion> brand_version_list;
  
  std::vector<::blink::UserAgentBrandVersion> brand_full_version_list;
  
  std::string full_version;
  
  std::string platform;
  
  std::string platform_version;
  
  std::string architecture;
  
  std::string model;
  
  bool mobile;
  
  std::string bitness;
  
  bool wow64;
  
  std::vector<std::string> form_factors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserAgentMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserAgentMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserAgentMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserAgentMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT UserAgentOverride {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserAgentOverride, T>::value>;
  using DataView = UserAgentOverrideDataView;
  using Data_ = internal::UserAgentOverride_Data;

  template <typename... Args>
  static UserAgentOverridePtr New(Args&&... args) {
    return UserAgentOverridePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserAgentOverridePtr From(const U& u) {
    return mojo::TypeConverter<UserAgentOverridePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserAgentOverride>::Convert(*this);
  }


  UserAgentOverride();

  UserAgentOverride(
      const std::string& ua_string_override,
      const std::optional<::blink::UserAgentMetadata>& ua_metadata_override);


  ~UserAgentOverride();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserAgentOverridePtr>
  UserAgentOverridePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserAgentOverride::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserAgentOverride::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserAgentOverride::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserAgentOverride::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserAgentOverride::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserAgentOverride::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserAgentOverride_UnserializedMessageContext<
            UserType, UserAgentOverride::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserAgentOverride::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserAgentOverride::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserAgentOverride_UnserializedMessageContext<
            UserType, UserAgentOverride::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserAgentOverride::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string ua_string_override;
  
  std::optional<::blink::UserAgentMetadata> ua_metadata_override;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserAgentOverride::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserAgentOverride::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserAgentOverride::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserAgentOverride::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
UserAgentBrandVersionPtr UserAgentBrandVersion::Clone() const {
  return New(
      mojo::Clone(brand),
      mojo::Clone(version)
  );
}

template <typename T, UserAgentBrandVersion::EnableIfSame<T>*>
bool UserAgentBrandVersion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->brand, other_struct.brand))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  return true;
}

template <typename T, UserAgentBrandVersion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.brand < rhs.brand)
    return true;
  if (rhs.brand < lhs.brand)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  return false;
}
template <typename StructPtrType>
UserAgentMetadataPtr UserAgentMetadata::Clone() const {
  return New(
      mojo::Clone(brand_version_list),
      mojo::Clone(brand_full_version_list),
      mojo::Clone(full_version),
      mojo::Clone(platform),
      mojo::Clone(platform_version),
      mojo::Clone(architecture),
      mojo::Clone(model),
      mojo::Clone(mobile),
      mojo::Clone(bitness),
      mojo::Clone(wow64),
      mojo::Clone(form_factors)
  );
}

template <typename T, UserAgentMetadata::EnableIfSame<T>*>
bool UserAgentMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->brand_version_list, other_struct.brand_version_list))
    return false;
  if (!mojo::Equals(this->brand_full_version_list, other_struct.brand_full_version_list))
    return false;
  if (!mojo::Equals(this->full_version, other_struct.full_version))
    return false;
  if (!mojo::Equals(this->platform, other_struct.platform))
    return false;
  if (!mojo::Equals(this->platform_version, other_struct.platform_version))
    return false;
  if (!mojo::Equals(this->architecture, other_struct.architecture))
    return false;
  if (!mojo::Equals(this->model, other_struct.model))
    return false;
  if (!mojo::Equals(this->mobile, other_struct.mobile))
    return false;
  if (!mojo::Equals(this->bitness, other_struct.bitness))
    return false;
  if (!mojo::Equals(this->wow64, other_struct.wow64))
    return false;
  if (!mojo::Equals(this->form_factors, other_struct.form_factors))
    return false;
  return true;
}

template <typename T, UserAgentMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.brand_version_list < rhs.brand_version_list)
    return true;
  if (rhs.brand_version_list < lhs.brand_version_list)
    return false;
  if (lhs.brand_full_version_list < rhs.brand_full_version_list)
    return true;
  if (rhs.brand_full_version_list < lhs.brand_full_version_list)
    return false;
  if (lhs.full_version < rhs.full_version)
    return true;
  if (rhs.full_version < lhs.full_version)
    return false;
  if (lhs.platform < rhs.platform)
    return true;
  if (rhs.platform < lhs.platform)
    return false;
  if (lhs.platform_version < rhs.platform_version)
    return true;
  if (rhs.platform_version < lhs.platform_version)
    return false;
  if (lhs.architecture < rhs.architecture)
    return true;
  if (rhs.architecture < lhs.architecture)
    return false;
  if (lhs.model < rhs.model)
    return true;
  if (rhs.model < lhs.model)
    return false;
  if (lhs.mobile < rhs.mobile)
    return true;
  if (rhs.mobile < lhs.mobile)
    return false;
  if (lhs.bitness < rhs.bitness)
    return true;
  if (rhs.bitness < lhs.bitness)
    return false;
  if (lhs.wow64 < rhs.wow64)
    return true;
  if (rhs.wow64 < lhs.wow64)
    return false;
  if (lhs.form_factors < rhs.form_factors)
    return true;
  if (rhs.form_factors < lhs.form_factors)
    return false;
  return false;
}
template <typename StructPtrType>
UserAgentOverridePtr UserAgentOverride::Clone() const {
  return New(
      mojo::Clone(ua_string_override),
      mojo::Clone(ua_metadata_override)
  );
}

template <typename T, UserAgentOverride::EnableIfSame<T>*>
bool UserAgentOverride::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ua_string_override, other_struct.ua_string_override))
    return false;
  if (!mojo::Equals(this->ua_metadata_override, other_struct.ua_metadata_override))
    return false;
  return true;
}

template <typename T, UserAgentOverride::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ua_string_override < rhs.ua_string_override)
    return true;
  if (rhs.ua_string_override < lhs.ua_string_override)
    return false;
  if (lhs.ua_metadata_override < rhs.ua_metadata_override)
    return true;
  if (rhs.ua_metadata_override < lhs.ua_metadata_override)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::UserAgentBrandVersion::DataView,
                                         ::blink::mojom::UserAgentBrandVersionPtr> {
  static bool IsNull(const ::blink::mojom::UserAgentBrandVersionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::UserAgentBrandVersionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::UserAgentBrandVersion::brand)& brand(
      const ::blink::mojom::UserAgentBrandVersionPtr& input) {
    return input->brand;
  }

  static const decltype(::blink::mojom::UserAgentBrandVersion::version)& version(
      const ::blink::mojom::UserAgentBrandVersionPtr& input) {
    return input->version;
  }

  static bool Read(::blink::mojom::UserAgentBrandVersion::DataView input, ::blink::mojom::UserAgentBrandVersionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::UserAgentMetadata::DataView,
                                         ::blink::mojom::UserAgentMetadataPtr> {
  static bool IsNull(const ::blink::mojom::UserAgentMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::UserAgentMetadataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::UserAgentMetadata::brand_version_list)& brand_version_list(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->brand_version_list;
  }

  static const decltype(::blink::mojom::UserAgentMetadata::brand_full_version_list)& brand_full_version_list(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->brand_full_version_list;
  }

  static const decltype(::blink::mojom::UserAgentMetadata::full_version)& full_version(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->full_version;
  }

  static const decltype(::blink::mojom::UserAgentMetadata::platform)& platform(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->platform;
  }

  static const decltype(::blink::mojom::UserAgentMetadata::platform_version)& platform_version(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->platform_version;
  }

  static const decltype(::blink::mojom::UserAgentMetadata::architecture)& architecture(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->architecture;
  }

  static const decltype(::blink::mojom::UserAgentMetadata::model)& model(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->model;
  }

  static decltype(::blink::mojom::UserAgentMetadata::mobile) mobile(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->mobile;
  }

  static const decltype(::blink::mojom::UserAgentMetadata::bitness)& bitness(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->bitness;
  }

  static decltype(::blink::mojom::UserAgentMetadata::wow64) wow64(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->wow64;
  }

  static const decltype(::blink::mojom::UserAgentMetadata::form_factors)& form_factors(
      const ::blink::mojom::UserAgentMetadataPtr& input) {
    return input->form_factors;
  }

  static bool Read(::blink::mojom::UserAgentMetadata::DataView input, ::blink::mojom::UserAgentMetadataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::UserAgentOverride::DataView,
                                         ::blink::mojom::UserAgentOverridePtr> {
  static bool IsNull(const ::blink::mojom::UserAgentOverridePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::UserAgentOverridePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::UserAgentOverride::ua_string_override)& ua_string_override(
      const ::blink::mojom::UserAgentOverridePtr& input) {
    return input->ua_string_override;
  }

  static const decltype(::blink::mojom::UserAgentOverride::ua_metadata_override)& ua_metadata_override(
      const ::blink::mojom::UserAgentOverridePtr& input) {
    return input->ua_metadata_override;
  }

  static bool Read(::blink::mojom::UserAgentOverride::DataView input, ::blink::mojom::UserAgentOverridePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_USER_AGENT_USER_AGENT_METADATA_MOJOM_H_