// third_party/blink/public/mojom/usb/web_usb_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UsbDeviceRemote as device_mojom_UsbDeviceRemote,
  UsbDevicePendingReceiver as device_mojom_UsbDevicePendingReceiver,
  UsbDeviceInfo as device_mojom_UsbDeviceInfo,
  UsbDeviceInfoSpec as device_mojom_UsbDeviceInfoSpec
} from '../../../../../services/device/public/mojom/usb_device.mojom.m.js';

import {
  UsbDeviceFilter as device_mojom_UsbDeviceFilter,
  UsbDeviceFilterSpec as device_mojom_UsbDeviceFilterSpec
} from '../../../../../services/device/public/mojom/usb_enumeration_options.mojom.m.js';

import {
  UsbDeviceManagerClientRemote as device_mojom_UsbDeviceManagerClientRemote,
  UsbDeviceManagerClientPendingReceiver as device_mojom_UsbDeviceManagerClientPendingReceiver
} from '../../../../../services/device/public/mojom/usb_manager_client.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebUsbServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebUsbService', scope);
  }
}

/** @interface */
export class WebUsbServiceInterface {
  
  /**
   * @return {!Promise<{
        results: !Array<!device_mojom_UsbDeviceInfo>,
   *  }>}
   */

  getDevices() {}
  
  /**
   * @param { !string } guid
   * @param { !device_mojom_UsbDevicePendingReceiver } deviceReceiver
   */

  getDevice(guid, deviceReceiver) {}
  
  /**
   * @param { !WebUsbRequestDeviceOptions } options
   * @return {!Promise<{
        result: ?device_mojom_UsbDeviceInfo,
   *  }>}
   */

  getPermission(options) {}
  
  /**
   * @param { !string } guid
   * @return {!Promise}
   */

  forgetDevice(guid) {}
  
  /**
   * @param { !Object } client
   */

  setClient(client) {}
}

/**
 * @implements { WebUsbServiceInterface }
 */
export class WebUsbServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebUsbServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebUsbServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebUsbServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        results: !Array<!device_mojom_UsbDeviceInfo>,
   *  }>}
   */

  getDevices() {
    return this.proxy.sendMessage(
        0,
        WebUsbService_GetDevices_ParamsSpec.$,
        WebUsbService_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } guid
   * @param { !device_mojom_UsbDevicePendingReceiver } deviceReceiver
   */

  getDevice(
      guid,
      deviceReceiver) {
    this.proxy.sendMessage(
        1,
        WebUsbService_GetDevice_ParamsSpec.$,
        null,
        [
          guid,
          deviceReceiver
        ],
        false);
  }

  
  /**
   * @param { !WebUsbRequestDeviceOptions } options
   * @return {!Promise<{
        result: ?device_mojom_UsbDeviceInfo,
   *  }>}
   */

  getPermission(
      options) {
    return this.proxy.sendMessage(
        2,
        WebUsbService_GetPermission_ParamsSpec.$,
        WebUsbService_GetPermission_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !string } guid
   * @return {!Promise}
   */

  forgetDevice(
      guid) {
    return this.proxy.sendMessage(
        3,
        WebUsbService_ForgetDevice_ParamsSpec.$,
        WebUsbService_ForgetDevice_ResponseParamsSpec.$,
        [
          guid
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        4,
        WebUsbService_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebUsbService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebUsbServiceReceiver {
  /**
   * @param {!WebUsbServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebUsbServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebUsbServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebUsbServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebUsbService_GetDevices_ParamsSpec.$,
        WebUsbService_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebUsbService_GetDevice_ParamsSpec.$,
        null,
        impl.getDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebUsbService_GetPermission_ParamsSpec.$,
        WebUsbService_GetPermission_ResponseParamsSpec.$,
        impl.getPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WebUsbService_ForgetDevice_ParamsSpec.$,
        WebUsbService_ForgetDevice_ResponseParamsSpec.$,
        impl.forgetDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WebUsbService_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebUsbService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebUsbService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebUsbServiceRemote}
   */
  static getRemote() {
    let remote = new WebUsbServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebUsbService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebUsbServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebUsbServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebUsbServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebUsbService_GetDevices_ParamsSpec.$,
        WebUsbService_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebUsbService_GetDevice_ParamsSpec.$,
        null,
        this.getDevice.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebUsbService_GetPermission_ParamsSpec.$,
        WebUsbService_GetPermission_ResponseParamsSpec.$,
        this.getPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forgetDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WebUsbService_ForgetDevice_ParamsSpec.$,
        WebUsbService_ForgetDevice_ResponseParamsSpec.$,
        this.forgetDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WebUsbService_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebUsbRequestDeviceOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebUsbService_GetDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebUsbService_GetDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebUsbService_GetDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebUsbService_GetPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebUsbService_GetPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebUsbService_ForgetDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebUsbService_ForgetDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebUsbService_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebUsbRequestDeviceOptionsSpec.$,
    'WebUsbRequestDeviceOptions',
    [
      mojo.internal.StructField(
        'filters', 0,
        0,
        mojo.internal.Array(device_mojom_UsbDeviceFilterSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exclusionFilters', 8,
        0,
        mojo.internal.Array(device_mojom_UsbDeviceFilterSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebUsbRequestDeviceOptions {
  constructor() {
    /** @type { !Array<!device_mojom_UsbDeviceFilter> } */
    this.filters;
    /** @type { !Array<!device_mojom_UsbDeviceFilter> } */
    this.exclusionFilters;
  }
}



mojo.internal.Struct(
    WebUsbService_GetDevices_ParamsSpec.$,
    'WebUsbService_GetDevices_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebUsbService_GetDevices_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebUsbService_GetDevices_ResponseParamsSpec.$,
    'WebUsbService_GetDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'results', 0,
        0,
        mojo.internal.Array(device_mojom_UsbDeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebUsbService_GetDevices_ResponseParams {
  constructor() {
    /** @type { !Array<!device_mojom_UsbDeviceInfo> } */
    this.results;
  }
}



mojo.internal.Struct(
    WebUsbService_GetDevice_ParamsSpec.$,
    'WebUsbService_GetDevice_Params',
    [
      mojo.internal.StructField(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(device_mojom_UsbDevicePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebUsbService_GetDevice_Params {
  constructor() {
    /** @type { !string } */
    this.guid;
    /** @type { !device_mojom_UsbDevicePendingReceiver } */
    this.deviceReceiver;
  }
}



mojo.internal.Struct(
    WebUsbService_GetPermission_ParamsSpec.$,
    'WebUsbService_GetPermission_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        WebUsbRequestDeviceOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebUsbService_GetPermission_Params {
  constructor() {
    /** @type { !WebUsbRequestDeviceOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    WebUsbService_GetPermission_ResponseParamsSpec.$,
    'WebUsbService_GetPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device_mojom_UsbDeviceInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebUsbService_GetPermission_ResponseParams {
  constructor() {
    /** @type { (device_mojom_UsbDeviceInfo|undefined) } */
    this.result;
  }
}



mojo.internal.Struct(
    WebUsbService_ForgetDevice_ParamsSpec.$,
    'WebUsbService_ForgetDevice_Params',
    [
      mojo.internal.StructField(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebUsbService_ForgetDevice_Params {
  constructor() {
    /** @type { !string } */
    this.guid;
  }
}



mojo.internal.Struct(
    WebUsbService_ForgetDevice_ResponseParamsSpec.$,
    'WebUsbService_ForgetDevice_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebUsbService_ForgetDevice_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    WebUsbService_SetClient_ParamsSpec.$,
    'WebUsbService_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(device_mojom_UsbDeviceManagerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebUsbService_SetClient_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
  }
}

