// third_party/blink/public/mojom/tokens/tokens.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TOKENS_TOKENS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TOKENS_TOKENS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/tokens/tokens.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/tokens/tokens.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/tokens/token_mojom_traits_helper.h"
#include "third_party/blink/public/common/tokens/tokens_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

























class BLINK_COMMON_EXPORT FrameToken {
 public:
  using DataView = FrameTokenDataView;
  using Data_ = internal::FrameToken_Data;
  using Tag = Data_::FrameToken_Tag;

  template <typename... Args>
  static FrameTokenPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |local_frame_token|.
  static FrameTokenPtr NewLocalFrameToken(
      const ::blink::LocalFrameToken& value);
  // Construct an instance holding |remote_frame_token|.
  static FrameTokenPtr NewRemoteFrameToken(
      const ::blink::RemoteFrameToken& value);

  template <typename U>
  static FrameTokenPtr From(const U& u) {
    return mojo::TypeConverter<FrameTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameToken>::Convert(*this);
  }
  ~FrameToken();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  FrameToken(const FrameToken& other) = delete;
  FrameToken& operator=(const FrameToken& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FrameTokenPtr>
  FrameTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FrameToken>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FrameToken>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_local_frame_token() const { return tag_ == Tag::kLocalFrameToken; }
  const ::blink::LocalFrameToken& get_local_frame_token() const {
    CHECK(tag_ == Tag::kLocalFrameToken);
    return data_.local_frame_token;
  }
  ::blink::LocalFrameToken& get_local_frame_token() {
    CHECK(tag_ == Tag::kLocalFrameToken);
    return data_.local_frame_token;
  }
  void set_local_frame_token(const ::blink::LocalFrameToken& local_frame_token);

  bool is_remote_frame_token() const { return tag_ == Tag::kRemoteFrameToken; }
  const ::blink::RemoteFrameToken& get_remote_frame_token() const {
    CHECK(tag_ == Tag::kRemoteFrameToken);
    return data_.remote_frame_token;
  }
  ::blink::RemoteFrameToken& get_remote_frame_token() {
    CHECK(tag_ == Tag::kRemoteFrameToken);
    return data_.remote_frame_token;
  }
  void set_remote_frame_token(const ::blink::RemoteFrameToken& remote_frame_token);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameToken::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FrameToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLocalFrameToken)>,
        const ::blink::LocalFrameToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRemoteFrameToken)>,
        const ::blink::RemoteFrameToken& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::LocalFrameToken local_frame_token;
    ::blink::RemoteFrameToken remote_frame_token;
  };

  FrameToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kLocalFrameToken)>,
      const ::blink::LocalFrameToken& value);
  FrameToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kRemoteFrameToken)>,
      const ::blink::RemoteFrameToken& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT WorkerToken {
 public:
  using DataView = WorkerTokenDataView;
  using Data_ = internal::WorkerToken_Data;
  using Tag = Data_::WorkerToken_Tag;

  template <typename... Args>
  static WorkerTokenPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |dedicated_worker_token|.
  static WorkerTokenPtr NewDedicatedWorkerToken(
      const ::blink::DedicatedWorkerToken& value);
  // Construct an instance holding |service_worker_token|.
  static WorkerTokenPtr NewServiceWorkerToken(
      const ::blink::ServiceWorkerToken& value);
  // Construct an instance holding |shared_worker_token|.
  static WorkerTokenPtr NewSharedWorkerToken(
      const ::blink::SharedWorkerToken& value);

  template <typename U>
  static WorkerTokenPtr From(const U& u) {
    return mojo::TypeConverter<WorkerTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WorkerToken>::Convert(*this);
  }
  ~WorkerToken();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WorkerToken(const WorkerToken& other) = delete;
  WorkerToken& operator=(const WorkerToken& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WorkerTokenPtr>
  WorkerTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WorkerToken>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WorkerToken>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_dedicated_worker_token() const { return tag_ == Tag::kDedicatedWorkerToken; }
  const ::blink::DedicatedWorkerToken& get_dedicated_worker_token() const {
    CHECK(tag_ == Tag::kDedicatedWorkerToken);
    return data_.dedicated_worker_token;
  }
  ::blink::DedicatedWorkerToken& get_dedicated_worker_token() {
    CHECK(tag_ == Tag::kDedicatedWorkerToken);
    return data_.dedicated_worker_token;
  }
  void set_dedicated_worker_token(const ::blink::DedicatedWorkerToken& dedicated_worker_token);

  bool is_service_worker_token() const { return tag_ == Tag::kServiceWorkerToken; }
  const ::blink::ServiceWorkerToken& get_service_worker_token() const {
    CHECK(tag_ == Tag::kServiceWorkerToken);
    return data_.service_worker_token;
  }
  ::blink::ServiceWorkerToken& get_service_worker_token() {
    CHECK(tag_ == Tag::kServiceWorkerToken);
    return data_.service_worker_token;
  }
  void set_service_worker_token(const ::blink::ServiceWorkerToken& service_worker_token);

  bool is_shared_worker_token() const { return tag_ == Tag::kSharedWorkerToken; }
  const ::blink::SharedWorkerToken& get_shared_worker_token() const {
    CHECK(tag_ == Tag::kSharedWorkerToken);
    return data_.shared_worker_token;
  }
  ::blink::SharedWorkerToken& get_shared_worker_token() {
    CHECK(tag_ == Tag::kSharedWorkerToken);
    return data_.shared_worker_token;
  }
  void set_shared_worker_token(const ::blink::SharedWorkerToken& shared_worker_token);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WorkerToken::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WorkerToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDedicatedWorkerToken)>,
        const ::blink::DedicatedWorkerToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kServiceWorkerToken)>,
        const ::blink::ServiceWorkerToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedWorkerToken)>,
        const ::blink::SharedWorkerToken& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::DedicatedWorkerToken dedicated_worker_token;
    ::blink::ServiceWorkerToken service_worker_token;
    ::blink::SharedWorkerToken shared_worker_token;
  };

  WorkerToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kDedicatedWorkerToken)>,
      const ::blink::DedicatedWorkerToken& value);
  WorkerToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kServiceWorkerToken)>,
      const ::blink::ServiceWorkerToken& value);
  WorkerToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedWorkerToken)>,
      const ::blink::SharedWorkerToken& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT WorkletToken {
 public:
  using DataView = WorkletTokenDataView;
  using Data_ = internal::WorkletToken_Data;
  using Tag = Data_::WorkletToken_Tag;

  template <typename... Args>
  static WorkletTokenPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |animation_worklet_token|.
  static WorkletTokenPtr NewAnimationWorkletToken(
      const ::blink::AnimationWorkletToken& value);
  // Construct an instance holding |audio_worklet_token|.
  static WorkletTokenPtr NewAudioWorkletToken(
      const ::blink::AudioWorkletToken& value);
  // Construct an instance holding |layout_worklet_token|.
  static WorkletTokenPtr NewLayoutWorkletToken(
      LayoutWorkletTokenPtr value);
  // Construct an instance holding |paint_worklet_token|.
  static WorkletTokenPtr NewPaintWorkletToken(
      const ::blink::PaintWorkletToken& value);
  // Construct an instance holding |shared_storage_worklet_token|.
  static WorkletTokenPtr NewSharedStorageWorkletToken(
      SharedStorageWorkletTokenPtr value);

  template <typename U>
  static WorkletTokenPtr From(const U& u) {
    return mojo::TypeConverter<WorkletTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WorkletToken>::Convert(*this);
  }
  ~WorkletToken();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WorkletToken(const WorkletToken& other) = delete;
  WorkletToken& operator=(const WorkletToken& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WorkletTokenPtr>
  WorkletTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WorkletToken>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WorkletToken>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_animation_worklet_token() const { return tag_ == Tag::kAnimationWorkletToken; }
  const ::blink::AnimationWorkletToken& get_animation_worklet_token() const {
    CHECK(tag_ == Tag::kAnimationWorkletToken);
    return data_.animation_worklet_token;
  }
  ::blink::AnimationWorkletToken& get_animation_worklet_token() {
    CHECK(tag_ == Tag::kAnimationWorkletToken);
    return data_.animation_worklet_token;
  }
  void set_animation_worklet_token(const ::blink::AnimationWorkletToken& animation_worklet_token);

  bool is_audio_worklet_token() const { return tag_ == Tag::kAudioWorkletToken; }
  const ::blink::AudioWorkletToken& get_audio_worklet_token() const {
    CHECK(tag_ == Tag::kAudioWorkletToken);
    return data_.audio_worklet_token;
  }
  ::blink::AudioWorkletToken& get_audio_worklet_token() {
    CHECK(tag_ == Tag::kAudioWorkletToken);
    return data_.audio_worklet_token;
  }
  void set_audio_worklet_token(const ::blink::AudioWorkletToken& audio_worklet_token);

  bool is_layout_worklet_token() const { return tag_ == Tag::kLayoutWorkletToken; }
  const LayoutWorkletTokenPtr& get_layout_worklet_token() const {
    CHECK(tag_ == Tag::kLayoutWorkletToken);
    return data_.layout_worklet_token;
  }
  LayoutWorkletTokenPtr& get_layout_worklet_token() {
    CHECK(tag_ == Tag::kLayoutWorkletToken);
    return data_.layout_worklet_token;
  }
  void set_layout_worklet_token(LayoutWorkletTokenPtr layout_worklet_token);

  bool is_paint_worklet_token() const { return tag_ == Tag::kPaintWorkletToken; }
  const ::blink::PaintWorkletToken& get_paint_worklet_token() const {
    CHECK(tag_ == Tag::kPaintWorkletToken);
    return data_.paint_worklet_token;
  }
  ::blink::PaintWorkletToken& get_paint_worklet_token() {
    CHECK(tag_ == Tag::kPaintWorkletToken);
    return data_.paint_worklet_token;
  }
  void set_paint_worklet_token(const ::blink::PaintWorkletToken& paint_worklet_token);

  bool is_shared_storage_worklet_token() const { return tag_ == Tag::kSharedStorageWorkletToken; }
  const SharedStorageWorkletTokenPtr& get_shared_storage_worklet_token() const {
    CHECK(tag_ == Tag::kSharedStorageWorkletToken);
    return data_.shared_storage_worklet_token;
  }
  SharedStorageWorkletTokenPtr& get_shared_storage_worklet_token() {
    CHECK(tag_ == Tag::kSharedStorageWorkletToken);
    return data_.shared_storage_worklet_token;
  }
  void set_shared_storage_worklet_token(SharedStorageWorkletTokenPtr shared_storage_worklet_token);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WorkletToken::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WorkletToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAnimationWorkletToken)>,
        const ::blink::AnimationWorkletToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAudioWorkletToken)>,
        const ::blink::AudioWorkletToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLayoutWorkletToken)>,
        LayoutWorkletTokenPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPaintWorkletToken)>,
        const ::blink::PaintWorkletToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedStorageWorkletToken)>,
        SharedStorageWorkletTokenPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::AnimationWorkletToken animation_worklet_token;
    ::blink::AudioWorkletToken audio_worklet_token;
    LayoutWorkletTokenPtr layout_worklet_token;
    ::blink::PaintWorkletToken paint_worklet_token;
    SharedStorageWorkletTokenPtr shared_storage_worklet_token;
  };

  WorkletToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kAnimationWorkletToken)>,
      const ::blink::AnimationWorkletToken& value);
  WorkletToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kAudioWorkletToken)>,
      const ::blink::AudioWorkletToken& value);
  WorkletToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kLayoutWorkletToken)>,
      LayoutWorkletTokenPtr value);
  WorkletToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kPaintWorkletToken)>,
      const ::blink::PaintWorkletToken& value);
  WorkletToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedStorageWorkletToken)>,
      SharedStorageWorkletTokenPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT ExecutionContextToken {
 public:
  using DataView = ExecutionContextTokenDataView;
  using Data_ = internal::ExecutionContextToken_Data;
  using Tag = Data_::ExecutionContextToken_Tag;

  template <typename... Args>
  static ExecutionContextTokenPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |local_frame_token|.
  static ExecutionContextTokenPtr NewLocalFrameToken(
      const ::blink::LocalFrameToken& value);
  // Construct an instance holding |dedicated_worker_token|.
  static ExecutionContextTokenPtr NewDedicatedWorkerToken(
      const ::blink::DedicatedWorkerToken& value);
  // Construct an instance holding |service_worker_token|.
  static ExecutionContextTokenPtr NewServiceWorkerToken(
      const ::blink::ServiceWorkerToken& value);
  // Construct an instance holding |shared_worker_token|.
  static ExecutionContextTokenPtr NewSharedWorkerToken(
      const ::blink::SharedWorkerToken& value);
  // Construct an instance holding |animation_worklet_token|.
  static ExecutionContextTokenPtr NewAnimationWorkletToken(
      const ::blink::AnimationWorkletToken& value);
  // Construct an instance holding |audio_worklet_token|.
  static ExecutionContextTokenPtr NewAudioWorkletToken(
      const ::blink::AudioWorkletToken& value);
  // Construct an instance holding |layout_worklet_token|.
  static ExecutionContextTokenPtr NewLayoutWorkletToken(
      LayoutWorkletTokenPtr value);
  // Construct an instance holding |paint_worklet_token|.
  static ExecutionContextTokenPtr NewPaintWorkletToken(
      const ::blink::PaintWorkletToken& value);
  // Construct an instance holding |shared_storage_worklet_token|.
  static ExecutionContextTokenPtr NewSharedStorageWorkletToken(
      SharedStorageWorkletTokenPtr value);
  // Construct an instance holding |shadow_realm_token|.
  static ExecutionContextTokenPtr NewShadowRealmToken(
      const ::blink::ShadowRealmToken& value);

  template <typename U>
  static ExecutionContextTokenPtr From(const U& u) {
    return mojo::TypeConverter<ExecutionContextTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExecutionContextToken>::Convert(*this);
  }
  ~ExecutionContextToken();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ExecutionContextToken(const ExecutionContextToken& other) = delete;
  ExecutionContextToken& operator=(const ExecutionContextToken& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ExecutionContextTokenPtr>
  ExecutionContextTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ExecutionContextToken>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ExecutionContextToken>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_local_frame_token() const { return tag_ == Tag::kLocalFrameToken; }
  const ::blink::LocalFrameToken& get_local_frame_token() const {
    CHECK(tag_ == Tag::kLocalFrameToken);
    return data_.local_frame_token;
  }
  ::blink::LocalFrameToken& get_local_frame_token() {
    CHECK(tag_ == Tag::kLocalFrameToken);
    return data_.local_frame_token;
  }
  void set_local_frame_token(const ::blink::LocalFrameToken& local_frame_token);

  bool is_dedicated_worker_token() const { return tag_ == Tag::kDedicatedWorkerToken; }
  const ::blink::DedicatedWorkerToken& get_dedicated_worker_token() const {
    CHECK(tag_ == Tag::kDedicatedWorkerToken);
    return data_.dedicated_worker_token;
  }
  ::blink::DedicatedWorkerToken& get_dedicated_worker_token() {
    CHECK(tag_ == Tag::kDedicatedWorkerToken);
    return data_.dedicated_worker_token;
  }
  void set_dedicated_worker_token(const ::blink::DedicatedWorkerToken& dedicated_worker_token);

  bool is_service_worker_token() const { return tag_ == Tag::kServiceWorkerToken; }
  const ::blink::ServiceWorkerToken& get_service_worker_token() const {
    CHECK(tag_ == Tag::kServiceWorkerToken);
    return data_.service_worker_token;
  }
  ::blink::ServiceWorkerToken& get_service_worker_token() {
    CHECK(tag_ == Tag::kServiceWorkerToken);
    return data_.service_worker_token;
  }
  void set_service_worker_token(const ::blink::ServiceWorkerToken& service_worker_token);

  bool is_shared_worker_token() const { return tag_ == Tag::kSharedWorkerToken; }
  const ::blink::SharedWorkerToken& get_shared_worker_token() const {
    CHECK(tag_ == Tag::kSharedWorkerToken);
    return data_.shared_worker_token;
  }
  ::blink::SharedWorkerToken& get_shared_worker_token() {
    CHECK(tag_ == Tag::kSharedWorkerToken);
    return data_.shared_worker_token;
  }
  void set_shared_worker_token(const ::blink::SharedWorkerToken& shared_worker_token);

  bool is_animation_worklet_token() const { return tag_ == Tag::kAnimationWorkletToken; }
  const ::blink::AnimationWorkletToken& get_animation_worklet_token() const {
    CHECK(tag_ == Tag::kAnimationWorkletToken);
    return data_.animation_worklet_token;
  }
  ::blink::AnimationWorkletToken& get_animation_worklet_token() {
    CHECK(tag_ == Tag::kAnimationWorkletToken);
    return data_.animation_worklet_token;
  }
  void set_animation_worklet_token(const ::blink::AnimationWorkletToken& animation_worklet_token);

  bool is_audio_worklet_token() const { return tag_ == Tag::kAudioWorkletToken; }
  const ::blink::AudioWorkletToken& get_audio_worklet_token() const {
    CHECK(tag_ == Tag::kAudioWorkletToken);
    return data_.audio_worklet_token;
  }
  ::blink::AudioWorkletToken& get_audio_worklet_token() {
    CHECK(tag_ == Tag::kAudioWorkletToken);
    return data_.audio_worklet_token;
  }
  void set_audio_worklet_token(const ::blink::AudioWorkletToken& audio_worklet_token);

  bool is_layout_worklet_token() const { return tag_ == Tag::kLayoutWorkletToken; }
  const LayoutWorkletTokenPtr& get_layout_worklet_token() const {
    CHECK(tag_ == Tag::kLayoutWorkletToken);
    return data_.layout_worklet_token;
  }
  LayoutWorkletTokenPtr& get_layout_worklet_token() {
    CHECK(tag_ == Tag::kLayoutWorkletToken);
    return data_.layout_worklet_token;
  }
  void set_layout_worklet_token(LayoutWorkletTokenPtr layout_worklet_token);

  bool is_paint_worklet_token() const { return tag_ == Tag::kPaintWorkletToken; }
  const ::blink::PaintWorkletToken& get_paint_worklet_token() const {
    CHECK(tag_ == Tag::kPaintWorkletToken);
    return data_.paint_worklet_token;
  }
  ::blink::PaintWorkletToken& get_paint_worklet_token() {
    CHECK(tag_ == Tag::kPaintWorkletToken);
    return data_.paint_worklet_token;
  }
  void set_paint_worklet_token(const ::blink::PaintWorkletToken& paint_worklet_token);

  bool is_shared_storage_worklet_token() const { return tag_ == Tag::kSharedStorageWorkletToken; }
  const SharedStorageWorkletTokenPtr& get_shared_storage_worklet_token() const {
    CHECK(tag_ == Tag::kSharedStorageWorkletToken);
    return data_.shared_storage_worklet_token;
  }
  SharedStorageWorkletTokenPtr& get_shared_storage_worklet_token() {
    CHECK(tag_ == Tag::kSharedStorageWorkletToken);
    return data_.shared_storage_worklet_token;
  }
  void set_shared_storage_worklet_token(SharedStorageWorkletTokenPtr shared_storage_worklet_token);

  bool is_shadow_realm_token() const { return tag_ == Tag::kShadowRealmToken; }
  const ::blink::ShadowRealmToken& get_shadow_realm_token() const {
    CHECK(tag_ == Tag::kShadowRealmToken);
    return data_.shadow_realm_token;
  }
  ::blink::ShadowRealmToken& get_shadow_realm_token() {
    CHECK(tag_ == Tag::kShadowRealmToken);
    return data_.shadow_realm_token;
  }
  void set_shadow_realm_token(const ::blink::ShadowRealmToken& shadow_realm_token);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExecutionContextToken::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ExecutionContextToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLocalFrameToken)>,
        const ::blink::LocalFrameToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDedicatedWorkerToken)>,
        const ::blink::DedicatedWorkerToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kServiceWorkerToken)>,
        const ::blink::ServiceWorkerToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedWorkerToken)>,
        const ::blink::SharedWorkerToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAnimationWorkletToken)>,
        const ::blink::AnimationWorkletToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAudioWorkletToken)>,
        const ::blink::AudioWorkletToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLayoutWorkletToken)>,
        LayoutWorkletTokenPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPaintWorkletToken)>,
        const ::blink::PaintWorkletToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedStorageWorkletToken)>,
        SharedStorageWorkletTokenPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kShadowRealmToken)>,
        const ::blink::ShadowRealmToken& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::LocalFrameToken local_frame_token;
    ::blink::DedicatedWorkerToken dedicated_worker_token;
    ::blink::ServiceWorkerToken service_worker_token;
    ::blink::SharedWorkerToken shared_worker_token;
    ::blink::AnimationWorkletToken animation_worklet_token;
    ::blink::AudioWorkletToken audio_worklet_token;
    LayoutWorkletTokenPtr layout_worklet_token;
    ::blink::PaintWorkletToken paint_worklet_token;
    SharedStorageWorkletTokenPtr shared_storage_worklet_token;
    ::blink::ShadowRealmToken shadow_realm_token;
  };

  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kLocalFrameToken)>,
      const ::blink::LocalFrameToken& value);
  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kDedicatedWorkerToken)>,
      const ::blink::DedicatedWorkerToken& value);
  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kServiceWorkerToken)>,
      const ::blink::ServiceWorkerToken& value);
  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedWorkerToken)>,
      const ::blink::SharedWorkerToken& value);
  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kAnimationWorkletToken)>,
      const ::blink::AnimationWorkletToken& value);
  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kAudioWorkletToken)>,
      const ::blink::AudioWorkletToken& value);
  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kLayoutWorkletToken)>,
      LayoutWorkletTokenPtr value);
  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kPaintWorkletToken)>,
      const ::blink::PaintWorkletToken& value);
  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedStorageWorkletToken)>,
      SharedStorageWorkletTokenPtr value);
  ExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kShadowRealmToken)>,
      const ::blink::ShadowRealmToken& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT WebGPUExecutionContextToken {
 public:
  using DataView = WebGPUExecutionContextTokenDataView;
  using Data_ = internal::WebGPUExecutionContextToken_Data;
  using Tag = Data_::WebGPUExecutionContextToken_Tag;

  template <typename... Args>
  static WebGPUExecutionContextTokenPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |document_token|.
  static WebGPUExecutionContextTokenPtr NewDocumentToken(
      const ::blink::DocumentToken& value);
  // Construct an instance holding |dedicated_worker_token|.
  static WebGPUExecutionContextTokenPtr NewDedicatedWorkerToken(
      const ::blink::DedicatedWorkerToken& value);
  // Construct an instance holding |shared_worker_token|.
  static WebGPUExecutionContextTokenPtr NewSharedWorkerToken(
      const ::blink::SharedWorkerToken& value);
  // Construct an instance holding |service_worker_token|.
  static WebGPUExecutionContextTokenPtr NewServiceWorkerToken(
      const ::blink::ServiceWorkerToken& value);

  template <typename U>
  static WebGPUExecutionContextTokenPtr From(const U& u) {
    return mojo::TypeConverter<WebGPUExecutionContextTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebGPUExecutionContextToken>::Convert(*this);
  }
  ~WebGPUExecutionContextToken();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebGPUExecutionContextToken(const WebGPUExecutionContextToken& other) = delete;
  WebGPUExecutionContextToken& operator=(const WebGPUExecutionContextToken& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebGPUExecutionContextTokenPtr>
  WebGPUExecutionContextTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebGPUExecutionContextToken>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebGPUExecutionContextToken>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_document_token() const { return tag_ == Tag::kDocumentToken; }
  const ::blink::DocumentToken& get_document_token() const {
    CHECK(tag_ == Tag::kDocumentToken);
    return data_.document_token;
  }
  ::blink::DocumentToken& get_document_token() {
    CHECK(tag_ == Tag::kDocumentToken);
    return data_.document_token;
  }
  void set_document_token(const ::blink::DocumentToken& document_token);

  bool is_dedicated_worker_token() const { return tag_ == Tag::kDedicatedWorkerToken; }
  const ::blink::DedicatedWorkerToken& get_dedicated_worker_token() const {
    CHECK(tag_ == Tag::kDedicatedWorkerToken);
    return data_.dedicated_worker_token;
  }
  ::blink::DedicatedWorkerToken& get_dedicated_worker_token() {
    CHECK(tag_ == Tag::kDedicatedWorkerToken);
    return data_.dedicated_worker_token;
  }
  void set_dedicated_worker_token(const ::blink::DedicatedWorkerToken& dedicated_worker_token);

  bool is_shared_worker_token() const { return tag_ == Tag::kSharedWorkerToken; }
  const ::blink::SharedWorkerToken& get_shared_worker_token() const {
    CHECK(tag_ == Tag::kSharedWorkerToken);
    return data_.shared_worker_token;
  }
  ::blink::SharedWorkerToken& get_shared_worker_token() {
    CHECK(tag_ == Tag::kSharedWorkerToken);
    return data_.shared_worker_token;
  }
  void set_shared_worker_token(const ::blink::SharedWorkerToken& shared_worker_token);

  bool is_service_worker_token() const { return tag_ == Tag::kServiceWorkerToken; }
  const ::blink::ServiceWorkerToken& get_service_worker_token() const {
    CHECK(tag_ == Tag::kServiceWorkerToken);
    return data_.service_worker_token;
  }
  ::blink::ServiceWorkerToken& get_service_worker_token() {
    CHECK(tag_ == Tag::kServiceWorkerToken);
    return data_.service_worker_token;
  }
  void set_service_worker_token(const ::blink::ServiceWorkerToken& service_worker_token);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebGPUExecutionContextToken::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebGPUExecutionContextToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDocumentToken)>,
        const ::blink::DocumentToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDedicatedWorkerToken)>,
        const ::blink::DedicatedWorkerToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedWorkerToken)>,
        const ::blink::SharedWorkerToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kServiceWorkerToken)>,
        const ::blink::ServiceWorkerToken& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::DocumentToken document_token;
    ::blink::DedicatedWorkerToken dedicated_worker_token;
    ::blink::SharedWorkerToken shared_worker_token;
    ::blink::ServiceWorkerToken service_worker_token;
  };

  WebGPUExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kDocumentToken)>,
      const ::blink::DocumentToken& value);
  WebGPUExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kDedicatedWorkerToken)>,
      const ::blink::DedicatedWorkerToken& value);
  WebGPUExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedWorkerToken)>,
      const ::blink::SharedWorkerToken& value);
  WebGPUExecutionContextToken(
      std::in_place_index_t<static_cast<size_t>(Tag::kServiceWorkerToken)>,
      const ::blink::ServiceWorkerToken& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT DocumentToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DocumentToken, T>::value>;
  using DataView = DocumentTokenDataView;
  using Data_ = internal::DocumentToken_Data;

  template <typename... Args>
  static DocumentTokenPtr New(Args&&... args) {
    return DocumentTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DocumentTokenPtr From(const U& u) {
    return mojo::TypeConverter<DocumentTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DocumentToken>::Convert(*this);
  }


  DocumentToken();

  explicit DocumentToken(
      const ::base::UnguessableToken& value);


  ~DocumentToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DocumentTokenPtr>
  DocumentTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DocumentToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DocumentToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DocumentToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DocumentToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DocumentToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DocumentToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DocumentToken_UnserializedMessageContext<
            UserType, DocumentToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DocumentToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DocumentToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DocumentToken_UnserializedMessageContext<
            UserType, DocumentToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DocumentToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DocumentToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DocumentToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DocumentToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DocumentToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT LocalFrameToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocalFrameToken, T>::value>;
  using DataView = LocalFrameTokenDataView;
  using Data_ = internal::LocalFrameToken_Data;

  template <typename... Args>
  static LocalFrameTokenPtr New(Args&&... args) {
    return LocalFrameTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocalFrameTokenPtr From(const U& u) {
    return mojo::TypeConverter<LocalFrameTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalFrameToken>::Convert(*this);
  }


  LocalFrameToken();

  explicit LocalFrameToken(
      const ::base::UnguessableToken& value);


  ~LocalFrameToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocalFrameTokenPtr>
  LocalFrameTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocalFrameToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LocalFrameToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LocalFrameToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalFrameToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalFrameToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalFrameToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocalFrameToken_UnserializedMessageContext<
            UserType, LocalFrameToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LocalFrameToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LocalFrameToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocalFrameToken_UnserializedMessageContext<
            UserType, LocalFrameToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocalFrameToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocalFrameToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocalFrameToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocalFrameToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocalFrameToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT RemoteFrameToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RemoteFrameToken, T>::value>;
  using DataView = RemoteFrameTokenDataView;
  using Data_ = internal::RemoteFrameToken_Data;

  template <typename... Args>
  static RemoteFrameTokenPtr New(Args&&... args) {
    return RemoteFrameTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RemoteFrameTokenPtr From(const U& u) {
    return mojo::TypeConverter<RemoteFrameTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RemoteFrameToken>::Convert(*this);
  }


  RemoteFrameToken();

  explicit RemoteFrameToken(
      const ::base::UnguessableToken& value);


  ~RemoteFrameToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RemoteFrameTokenPtr>
  RemoteFrameTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RemoteFrameToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RemoteFrameToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RemoteFrameToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RemoteFrameToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RemoteFrameToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RemoteFrameToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RemoteFrameToken_UnserializedMessageContext<
            UserType, RemoteFrameToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RemoteFrameToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RemoteFrameToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RemoteFrameToken_UnserializedMessageContext<
            UserType, RemoteFrameToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RemoteFrameToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RemoteFrameToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RemoteFrameToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RemoteFrameToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RemoteFrameToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT DedicatedWorkerToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DedicatedWorkerToken, T>::value>;
  using DataView = DedicatedWorkerTokenDataView;
  using Data_ = internal::DedicatedWorkerToken_Data;

  template <typename... Args>
  static DedicatedWorkerTokenPtr New(Args&&... args) {
    return DedicatedWorkerTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DedicatedWorkerTokenPtr From(const U& u) {
    return mojo::TypeConverter<DedicatedWorkerTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DedicatedWorkerToken>::Convert(*this);
  }


  DedicatedWorkerToken();

  explicit DedicatedWorkerToken(
      const ::base::UnguessableToken& value);


  ~DedicatedWorkerToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DedicatedWorkerTokenPtr>
  DedicatedWorkerTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DedicatedWorkerToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DedicatedWorkerToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DedicatedWorkerToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DedicatedWorkerToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DedicatedWorkerToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DedicatedWorkerToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DedicatedWorkerToken_UnserializedMessageContext<
            UserType, DedicatedWorkerToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DedicatedWorkerToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DedicatedWorkerToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DedicatedWorkerToken_UnserializedMessageContext<
            UserType, DedicatedWorkerToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DedicatedWorkerToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DedicatedWorkerToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DedicatedWorkerToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DedicatedWorkerToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DedicatedWorkerToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ServiceWorkerToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerToken, T>::value>;
  using DataView = ServiceWorkerTokenDataView;
  using Data_ = internal::ServiceWorkerToken_Data;

  template <typename... Args>
  static ServiceWorkerTokenPtr New(Args&&... args) {
    return ServiceWorkerTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerTokenPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerToken>::Convert(*this);
  }


  ServiceWorkerToken();

  explicit ServiceWorkerToken(
      const ::base::UnguessableToken& value);


  ~ServiceWorkerToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerTokenPtr>
  ServiceWorkerTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerToken_UnserializedMessageContext<
            UserType, ServiceWorkerToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerToken_UnserializedMessageContext<
            UserType, ServiceWorkerToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SharedWorkerToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedWorkerToken, T>::value>;
  using DataView = SharedWorkerTokenDataView;
  using Data_ = internal::SharedWorkerToken_Data;

  template <typename... Args>
  static SharedWorkerTokenPtr New(Args&&... args) {
    return SharedWorkerTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedWorkerTokenPtr From(const U& u) {
    return mojo::TypeConverter<SharedWorkerTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedWorkerToken>::Convert(*this);
  }


  SharedWorkerToken();

  explicit SharedWorkerToken(
      const ::base::UnguessableToken& value);


  ~SharedWorkerToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedWorkerTokenPtr>
  SharedWorkerTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedWorkerToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedWorkerToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedWorkerToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedWorkerToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedWorkerToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedWorkerToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedWorkerToken_UnserializedMessageContext<
            UserType, SharedWorkerToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedWorkerToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedWorkerToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedWorkerToken_UnserializedMessageContext<
            UserType, SharedWorkerToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedWorkerToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedWorkerToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedWorkerToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedWorkerToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedWorkerToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT AnimationWorkletToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnimationWorkletToken, T>::value>;
  using DataView = AnimationWorkletTokenDataView;
  using Data_ = internal::AnimationWorkletToken_Data;

  template <typename... Args>
  static AnimationWorkletTokenPtr New(Args&&... args) {
    return AnimationWorkletTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnimationWorkletTokenPtr From(const U& u) {
    return mojo::TypeConverter<AnimationWorkletTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnimationWorkletToken>::Convert(*this);
  }


  AnimationWorkletToken();

  explicit AnimationWorkletToken(
      const ::base::UnguessableToken& value);


  ~AnimationWorkletToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnimationWorkletTokenPtr>
  AnimationWorkletTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnimationWorkletToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnimationWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnimationWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnimationWorkletToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnimationWorkletToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnimationWorkletToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnimationWorkletToken_UnserializedMessageContext<
            UserType, AnimationWorkletToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnimationWorkletToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnimationWorkletToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnimationWorkletToken_UnserializedMessageContext<
            UserType, AnimationWorkletToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnimationWorkletToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnimationWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnimationWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnimationWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnimationWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT AudioWorkletToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioWorkletToken, T>::value>;
  using DataView = AudioWorkletTokenDataView;
  using Data_ = internal::AudioWorkletToken_Data;

  template <typename... Args>
  static AudioWorkletTokenPtr New(Args&&... args) {
    return AudioWorkletTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioWorkletTokenPtr From(const U& u) {
    return mojo::TypeConverter<AudioWorkletTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioWorkletToken>::Convert(*this);
  }


  AudioWorkletToken();

  explicit AudioWorkletToken(
      const ::base::UnguessableToken& value);


  ~AudioWorkletToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioWorkletTokenPtr>
  AudioWorkletTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioWorkletToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioWorkletToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioWorkletToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioWorkletToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioWorkletToken_UnserializedMessageContext<
            UserType, AudioWorkletToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioWorkletToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioWorkletToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioWorkletToken_UnserializedMessageContext<
            UserType, AudioWorkletToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioWorkletToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT LayoutWorkletToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayoutWorkletToken, T>::value>;
  using DataView = LayoutWorkletTokenDataView;
  using Data_ = internal::LayoutWorkletToken_Data;

  template <typename... Args>
  static LayoutWorkletTokenPtr New(Args&&... args) {
    return LayoutWorkletTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayoutWorkletTokenPtr From(const U& u) {
    return mojo::TypeConverter<LayoutWorkletTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayoutWorkletToken>::Convert(*this);
  }


  LayoutWorkletToken();

  explicit LayoutWorkletToken(
      const ::base::UnguessableToken& value);


  ~LayoutWorkletToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayoutWorkletTokenPtr>
  LayoutWorkletTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayoutWorkletToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayoutWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayoutWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayoutWorkletToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayoutWorkletToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayoutWorkletToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayoutWorkletToken_UnserializedMessageContext<
            UserType, LayoutWorkletToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayoutWorkletToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayoutWorkletToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayoutWorkletToken_UnserializedMessageContext<
            UserType, LayoutWorkletToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayoutWorkletToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayoutWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayoutWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayoutWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayoutWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PaintWorkletToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaintWorkletToken, T>::value>;
  using DataView = PaintWorkletTokenDataView;
  using Data_ = internal::PaintWorkletToken_Data;

  template <typename... Args>
  static PaintWorkletTokenPtr New(Args&&... args) {
    return PaintWorkletTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaintWorkletTokenPtr From(const U& u) {
    return mojo::TypeConverter<PaintWorkletTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintWorkletToken>::Convert(*this);
  }


  PaintWorkletToken();

  explicit PaintWorkletToken(
      const ::base::UnguessableToken& value);


  ~PaintWorkletToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaintWorkletTokenPtr>
  PaintWorkletTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaintWorkletToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaintWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaintWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaintWorkletToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaintWorkletToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintWorkletToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaintWorkletToken_UnserializedMessageContext<
            UserType, PaintWorkletToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaintWorkletToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaintWorkletToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaintWorkletToken_UnserializedMessageContext<
            UserType, PaintWorkletToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaintWorkletToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaintWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaintWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaintWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaintWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SharedStorageWorkletToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageWorkletToken, T>::value>;
  using DataView = SharedStorageWorkletTokenDataView;
  using Data_ = internal::SharedStorageWorkletToken_Data;

  template <typename... Args>
  static SharedStorageWorkletTokenPtr New(Args&&... args) {
    return SharedStorageWorkletTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageWorkletTokenPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageWorkletTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageWorkletToken>::Convert(*this);
  }


  SharedStorageWorkletToken();

  explicit SharedStorageWorkletToken(
      const ::base::UnguessableToken& value);


  ~SharedStorageWorkletToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageWorkletTokenPtr>
  SharedStorageWorkletTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageWorkletToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageWorkletToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageWorkletToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageWorkletToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageWorkletToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageWorkletToken_UnserializedMessageContext<
            UserType, SharedStorageWorkletToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageWorkletToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageWorkletToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageWorkletToken_UnserializedMessageContext<
            UserType, SharedStorageWorkletToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageWorkletToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageWorkletToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageWorkletToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ShadowRealmToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ShadowRealmToken, T>::value>;
  using DataView = ShadowRealmTokenDataView;
  using Data_ = internal::ShadowRealmToken_Data;

  template <typename... Args>
  static ShadowRealmTokenPtr New(Args&&... args) {
    return ShadowRealmTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ShadowRealmTokenPtr From(const U& u) {
    return mojo::TypeConverter<ShadowRealmTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ShadowRealmToken>::Convert(*this);
  }


  ShadowRealmToken();

  explicit ShadowRealmToken(
      const ::base::UnguessableToken& value);


  ~ShadowRealmToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ShadowRealmTokenPtr>
  ShadowRealmTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ShadowRealmToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ShadowRealmToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ShadowRealmToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ShadowRealmToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ShadowRealmToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ShadowRealmToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ShadowRealmToken_UnserializedMessageContext<
            UserType, ShadowRealmToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ShadowRealmToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ShadowRealmToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ShadowRealmToken_UnserializedMessageContext<
            UserType, ShadowRealmToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ShadowRealmToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ShadowRealmToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ShadowRealmToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ShadowRealmToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ShadowRealmToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT AttributionSrcToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AttributionSrcToken, T>::value>;
  using DataView = AttributionSrcTokenDataView;
  using Data_ = internal::AttributionSrcToken_Data;

  template <typename... Args>
  static AttributionSrcTokenPtr New(Args&&... args) {
    return AttributionSrcTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AttributionSrcTokenPtr From(const U& u) {
    return mojo::TypeConverter<AttributionSrcTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AttributionSrcToken>::Convert(*this);
  }


  AttributionSrcToken();

  explicit AttributionSrcToken(
      const ::base::UnguessableToken& value);


  ~AttributionSrcToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AttributionSrcTokenPtr>
  AttributionSrcTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AttributionSrcToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AttributionSrcToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AttributionSrcToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributionSrcToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributionSrcToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AttributionSrcToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AttributionSrcToken_UnserializedMessageContext<
            UserType, AttributionSrcToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AttributionSrcToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AttributionSrcToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AttributionSrcToken_UnserializedMessageContext<
            UserType, AttributionSrcToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AttributionSrcToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AttributionSrcToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AttributionSrcToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AttributionSrcToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AttributionSrcToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ClipboardSequenceNumberToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClipboardSequenceNumberToken, T>::value>;
  using DataView = ClipboardSequenceNumberTokenDataView;
  using Data_ = internal::ClipboardSequenceNumberToken_Data;

  template <typename... Args>
  static ClipboardSequenceNumberTokenPtr New(Args&&... args) {
    return ClipboardSequenceNumberTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClipboardSequenceNumberTokenPtr From(const U& u) {
    return mojo::TypeConverter<ClipboardSequenceNumberTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClipboardSequenceNumberToken>::Convert(*this);
  }


  ClipboardSequenceNumberToken();

  explicit ClipboardSequenceNumberToken(
      const ::base::UnguessableToken& value);


  ~ClipboardSequenceNumberToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClipboardSequenceNumberTokenPtr>
  ClipboardSequenceNumberTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClipboardSequenceNumberToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClipboardSequenceNumberToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClipboardSequenceNumberToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipboardSequenceNumberToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipboardSequenceNumberToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClipboardSequenceNumberToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClipboardSequenceNumberToken_UnserializedMessageContext<
            UserType, ClipboardSequenceNumberToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClipboardSequenceNumberToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClipboardSequenceNumberToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClipboardSequenceNumberToken_UnserializedMessageContext<
            UserType, ClipboardSequenceNumberToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClipboardSequenceNumberToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClipboardSequenceNumberToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClipboardSequenceNumberToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClipboardSequenceNumberToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClipboardSequenceNumberToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SameDocNavigationScreenshotDestinationToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SameDocNavigationScreenshotDestinationToken, T>::value>;
  using DataView = SameDocNavigationScreenshotDestinationTokenDataView;
  using Data_ = internal::SameDocNavigationScreenshotDestinationToken_Data;

  template <typename... Args>
  static SameDocNavigationScreenshotDestinationTokenPtr New(Args&&... args) {
    return SameDocNavigationScreenshotDestinationTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SameDocNavigationScreenshotDestinationTokenPtr From(const U& u) {
    return mojo::TypeConverter<SameDocNavigationScreenshotDestinationTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SameDocNavigationScreenshotDestinationToken>::Convert(*this);
  }


  SameDocNavigationScreenshotDestinationToken();

  explicit SameDocNavigationScreenshotDestinationToken(
      const ::base::UnguessableToken& value);


  ~SameDocNavigationScreenshotDestinationToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SameDocNavigationScreenshotDestinationTokenPtr>
  SameDocNavigationScreenshotDestinationTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SameDocNavigationScreenshotDestinationToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SameDocNavigationScreenshotDestinationToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SameDocNavigationScreenshotDestinationToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SameDocNavigationScreenshotDestinationToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SameDocNavigationScreenshotDestinationToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SameDocNavigationScreenshotDestinationToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SameDocNavigationScreenshotDestinationToken_UnserializedMessageContext<
            UserType, SameDocNavigationScreenshotDestinationToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SameDocNavigationScreenshotDestinationToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SameDocNavigationScreenshotDestinationToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SameDocNavigationScreenshotDestinationToken_UnserializedMessageContext<
            UserType, SameDocNavigationScreenshotDestinationToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SameDocNavigationScreenshotDestinationToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SameDocNavigationScreenshotDestinationToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SameDocNavigationScreenshotDestinationToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SameDocNavigationScreenshotDestinationToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SameDocNavigationScreenshotDestinationToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT V8ContextToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<V8ContextToken, T>::value>;
  using DataView = V8ContextTokenDataView;
  using Data_ = internal::V8ContextToken_Data;

  template <typename... Args>
  static V8ContextTokenPtr New(Args&&... args) {
    return V8ContextTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static V8ContextTokenPtr From(const U& u) {
    return mojo::TypeConverter<V8ContextTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, V8ContextToken>::Convert(*this);
  }


  V8ContextToken();

  explicit V8ContextToken(
      const ::base::UnguessableToken& value);


  ~V8ContextToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = V8ContextTokenPtr>
  V8ContextTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, V8ContextToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, V8ContextToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, V8ContextToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        V8ContextToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        V8ContextToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        V8ContextToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::V8ContextToken_UnserializedMessageContext<
            UserType, V8ContextToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<V8ContextToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return V8ContextToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::V8ContextToken_UnserializedMessageContext<
            UserType, V8ContextToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<V8ContextToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, V8ContextToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, V8ContextToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, V8ContextToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, V8ContextToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ViewTransitionToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewTransitionToken, T>::value>;
  using DataView = ViewTransitionTokenDataView;
  using Data_ = internal::ViewTransitionToken_Data;

  template <typename... Args>
  static ViewTransitionTokenPtr New(Args&&... args) {
    return ViewTransitionTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewTransitionTokenPtr From(const U& u) {
    return mojo::TypeConverter<ViewTransitionTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewTransitionToken>::Convert(*this);
  }


  ViewTransitionToken();

  explicit ViewTransitionToken(
      const ::base::UnguessableToken& value);


  ~ViewTransitionToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewTransitionTokenPtr>
  ViewTransitionTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewTransitionToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewTransitionToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewTransitionToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewTransitionToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewTransitionToken_UnserializedMessageContext<
            UserType, ViewTransitionToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewTransitionToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewTransitionToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewTransitionToken_UnserializedMessageContext<
            UserType, ViewTransitionToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewTransitionToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewTransitionToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewTransitionToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewTransitionToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewTransitionToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebNNContextToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebNNContextToken, T>::value>;
  using DataView = WebNNContextTokenDataView;
  using Data_ = internal::WebNNContextToken_Data;

  template <typename... Args>
  static WebNNContextTokenPtr New(Args&&... args) {
    return WebNNContextTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebNNContextTokenPtr From(const U& u) {
    return mojo::TypeConverter<WebNNContextTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebNNContextToken>::Convert(*this);
  }


  WebNNContextToken();

  explicit WebNNContextToken(
      const ::base::UnguessableToken& value);


  ~WebNNContextToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebNNContextTokenPtr>
  WebNNContextTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebNNContextToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebNNContextToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebNNContextToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebNNContextToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebNNContextToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebNNContextToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebNNContextToken_UnserializedMessageContext<
            UserType, WebNNContextToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebNNContextToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebNNContextToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebNNContextToken_UnserializedMessageContext<
            UserType, WebNNContextToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebNNContextToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebNNContextToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebNNContextToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebNNContextToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebNNContextToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebNNPendingConstantToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebNNPendingConstantToken, T>::value>;
  using DataView = WebNNPendingConstantTokenDataView;
  using Data_ = internal::WebNNPendingConstantToken_Data;

  template <typename... Args>
  static WebNNPendingConstantTokenPtr New(Args&&... args) {
    return WebNNPendingConstantTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebNNPendingConstantTokenPtr From(const U& u) {
    return mojo::TypeConverter<WebNNPendingConstantTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebNNPendingConstantToken>::Convert(*this);
  }


  WebNNPendingConstantToken();

  explicit WebNNPendingConstantToken(
      const ::base::UnguessableToken& value);


  ~WebNNPendingConstantToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebNNPendingConstantTokenPtr>
  WebNNPendingConstantTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebNNPendingConstantToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebNNPendingConstantToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebNNPendingConstantToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebNNPendingConstantToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebNNPendingConstantToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebNNPendingConstantToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebNNPendingConstantToken_UnserializedMessageContext<
            UserType, WebNNPendingConstantToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebNNPendingConstantToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebNNPendingConstantToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebNNPendingConstantToken_UnserializedMessageContext<
            UserType, WebNNPendingConstantToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebNNPendingConstantToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebNNPendingConstantToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebNNPendingConstantToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebNNPendingConstantToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebNNPendingConstantToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebNNTensorToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebNNTensorToken, T>::value>;
  using DataView = WebNNTensorTokenDataView;
  using Data_ = internal::WebNNTensorToken_Data;

  template <typename... Args>
  static WebNNTensorTokenPtr New(Args&&... args) {
    return WebNNTensorTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebNNTensorTokenPtr From(const U& u) {
    return mojo::TypeConverter<WebNNTensorTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebNNTensorToken>::Convert(*this);
  }


  WebNNTensorToken();

  explicit WebNNTensorToken(
      const ::base::UnguessableToken& value);


  ~WebNNTensorToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebNNTensorTokenPtr>
  WebNNTensorTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebNNTensorToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebNNTensorToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebNNTensorToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebNNTensorToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebNNTensorToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebNNTensorToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebNNTensorToken_UnserializedMessageContext<
            UserType, WebNNTensorToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebNNTensorToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebNNTensorToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebNNTensorToken_UnserializedMessageContext<
            UserType, WebNNTensorToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebNNTensorToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebNNTensorToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebNNTensorToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebNNTensorToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebNNTensorToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
FrameTokenPtr FrameToken::Clone() const {
  switch (tag_) {
    case Tag::kLocalFrameToken:
      return NewLocalFrameToken(
          mojo::Clone(data_.local_frame_token));
    case Tag::kRemoteFrameToken:
      return NewRemoteFrameToken(
          mojo::Clone(data_.remote_frame_token));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FrameToken>::value>::type*>
bool FrameToken::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kLocalFrameToken:
      return mojo::Equals(data_.local_frame_token, other.data_.local_frame_token);
    case Tag::kRemoteFrameToken:
      return mojo::Equals(data_.remote_frame_token, other.data_.remote_frame_token);
  }

  return false;
}
template <typename UnionPtrType>
WorkerTokenPtr WorkerToken::Clone() const {
  switch (tag_) {
    case Tag::kDedicatedWorkerToken:
      return NewDedicatedWorkerToken(
          mojo::Clone(data_.dedicated_worker_token));
    case Tag::kServiceWorkerToken:
      return NewServiceWorkerToken(
          mojo::Clone(data_.service_worker_token));
    case Tag::kSharedWorkerToken:
      return NewSharedWorkerToken(
          mojo::Clone(data_.shared_worker_token));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WorkerToken>::value>::type*>
bool WorkerToken::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kDedicatedWorkerToken:
      return mojo::Equals(data_.dedicated_worker_token, other.data_.dedicated_worker_token);
    case Tag::kServiceWorkerToken:
      return mojo::Equals(data_.service_worker_token, other.data_.service_worker_token);
    case Tag::kSharedWorkerToken:
      return mojo::Equals(data_.shared_worker_token, other.data_.shared_worker_token);
  }

  return false;
}
template <typename UnionPtrType>
WorkletTokenPtr WorkletToken::Clone() const {
  switch (tag_) {
    case Tag::kAnimationWorkletToken:
      return NewAnimationWorkletToken(
          mojo::Clone(data_.animation_worklet_token));
    case Tag::kAudioWorkletToken:
      return NewAudioWorkletToken(
          mojo::Clone(data_.audio_worklet_token));
    case Tag::kLayoutWorkletToken:
      return NewLayoutWorkletToken(
          mojo::Clone(data_.layout_worklet_token));
    case Tag::kPaintWorkletToken:
      return NewPaintWorkletToken(
          mojo::Clone(data_.paint_worklet_token));
    case Tag::kSharedStorageWorkletToken:
      return NewSharedStorageWorkletToken(
          mojo::Clone(data_.shared_storage_worklet_token));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WorkletToken>::value>::type*>
bool WorkletToken::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kAnimationWorkletToken:
      return mojo::Equals(data_.animation_worklet_token, other.data_.animation_worklet_token);
    case Tag::kAudioWorkletToken:
      return mojo::Equals(data_.audio_worklet_token, other.data_.audio_worklet_token);
    case Tag::kLayoutWorkletToken:
      return mojo::Equals(data_.layout_worklet_token, other.data_.layout_worklet_token);
    case Tag::kPaintWorkletToken:
      return mojo::Equals(data_.paint_worklet_token, other.data_.paint_worklet_token);
    case Tag::kSharedStorageWorkletToken:
      return mojo::Equals(data_.shared_storage_worklet_token, other.data_.shared_storage_worklet_token);
  }

  return false;
}
template <typename UnionPtrType>
ExecutionContextTokenPtr ExecutionContextToken::Clone() const {
  switch (tag_) {
    case Tag::kLocalFrameToken:
      return NewLocalFrameToken(
          mojo::Clone(data_.local_frame_token));
    case Tag::kDedicatedWorkerToken:
      return NewDedicatedWorkerToken(
          mojo::Clone(data_.dedicated_worker_token));
    case Tag::kServiceWorkerToken:
      return NewServiceWorkerToken(
          mojo::Clone(data_.service_worker_token));
    case Tag::kSharedWorkerToken:
      return NewSharedWorkerToken(
          mojo::Clone(data_.shared_worker_token));
    case Tag::kAnimationWorkletToken:
      return NewAnimationWorkletToken(
          mojo::Clone(data_.animation_worklet_token));
    case Tag::kAudioWorkletToken:
      return NewAudioWorkletToken(
          mojo::Clone(data_.audio_worklet_token));
    case Tag::kLayoutWorkletToken:
      return NewLayoutWorkletToken(
          mojo::Clone(data_.layout_worklet_token));
    case Tag::kPaintWorkletToken:
      return NewPaintWorkletToken(
          mojo::Clone(data_.paint_worklet_token));
    case Tag::kSharedStorageWorkletToken:
      return NewSharedStorageWorkletToken(
          mojo::Clone(data_.shared_storage_worklet_token));
    case Tag::kShadowRealmToken:
      return NewShadowRealmToken(
          mojo::Clone(data_.shadow_realm_token));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ExecutionContextToken>::value>::type*>
bool ExecutionContextToken::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kLocalFrameToken:
      return mojo::Equals(data_.local_frame_token, other.data_.local_frame_token);
    case Tag::kDedicatedWorkerToken:
      return mojo::Equals(data_.dedicated_worker_token, other.data_.dedicated_worker_token);
    case Tag::kServiceWorkerToken:
      return mojo::Equals(data_.service_worker_token, other.data_.service_worker_token);
    case Tag::kSharedWorkerToken:
      return mojo::Equals(data_.shared_worker_token, other.data_.shared_worker_token);
    case Tag::kAnimationWorkletToken:
      return mojo::Equals(data_.animation_worklet_token, other.data_.animation_worklet_token);
    case Tag::kAudioWorkletToken:
      return mojo::Equals(data_.audio_worklet_token, other.data_.audio_worklet_token);
    case Tag::kLayoutWorkletToken:
      return mojo::Equals(data_.layout_worklet_token, other.data_.layout_worklet_token);
    case Tag::kPaintWorkletToken:
      return mojo::Equals(data_.paint_worklet_token, other.data_.paint_worklet_token);
    case Tag::kSharedStorageWorkletToken:
      return mojo::Equals(data_.shared_storage_worklet_token, other.data_.shared_storage_worklet_token);
    case Tag::kShadowRealmToken:
      return mojo::Equals(data_.shadow_realm_token, other.data_.shadow_realm_token);
  }

  return false;
}
template <typename UnionPtrType>
WebGPUExecutionContextTokenPtr WebGPUExecutionContextToken::Clone() const {
  switch (tag_) {
    case Tag::kDocumentToken:
      return NewDocumentToken(
          mojo::Clone(data_.document_token));
    case Tag::kDedicatedWorkerToken:
      return NewDedicatedWorkerToken(
          mojo::Clone(data_.dedicated_worker_token));
    case Tag::kSharedWorkerToken:
      return NewSharedWorkerToken(
          mojo::Clone(data_.shared_worker_token));
    case Tag::kServiceWorkerToken:
      return NewServiceWorkerToken(
          mojo::Clone(data_.service_worker_token));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebGPUExecutionContextToken>::value>::type*>
bool WebGPUExecutionContextToken::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kDocumentToken:
      return mojo::Equals(data_.document_token, other.data_.document_token);
    case Tag::kDedicatedWorkerToken:
      return mojo::Equals(data_.dedicated_worker_token, other.data_.dedicated_worker_token);
    case Tag::kSharedWorkerToken:
      return mojo::Equals(data_.shared_worker_token, other.data_.shared_worker_token);
    case Tag::kServiceWorkerToken:
      return mojo::Equals(data_.service_worker_token, other.data_.service_worker_token);
  }

  return false;
}
template <typename StructPtrType>
DocumentTokenPtr DocumentToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, DocumentToken::EnableIfSame<T>*>
bool DocumentToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, DocumentToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
LocalFrameTokenPtr LocalFrameToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, LocalFrameToken::EnableIfSame<T>*>
bool LocalFrameToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, LocalFrameToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
RemoteFrameTokenPtr RemoteFrameToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, RemoteFrameToken::EnableIfSame<T>*>
bool RemoteFrameToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, RemoteFrameToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
DedicatedWorkerTokenPtr DedicatedWorkerToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, DedicatedWorkerToken::EnableIfSame<T>*>
bool DedicatedWorkerToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, DedicatedWorkerToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerTokenPtr ServiceWorkerToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, ServiceWorkerToken::EnableIfSame<T>*>
bool ServiceWorkerToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ServiceWorkerToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
SharedWorkerTokenPtr SharedWorkerToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, SharedWorkerToken::EnableIfSame<T>*>
bool SharedWorkerToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SharedWorkerToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
AnimationWorkletTokenPtr AnimationWorkletToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, AnimationWorkletToken::EnableIfSame<T>*>
bool AnimationWorkletToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, AnimationWorkletToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
AudioWorkletTokenPtr AudioWorkletToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, AudioWorkletToken::EnableIfSame<T>*>
bool AudioWorkletToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, AudioWorkletToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
LayoutWorkletTokenPtr LayoutWorkletToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, LayoutWorkletToken::EnableIfSame<T>*>
bool LayoutWorkletToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, LayoutWorkletToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
PaintWorkletTokenPtr PaintWorkletToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, PaintWorkletToken::EnableIfSame<T>*>
bool PaintWorkletToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, PaintWorkletToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
SharedStorageWorkletTokenPtr SharedStorageWorkletToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, SharedStorageWorkletToken::EnableIfSame<T>*>
bool SharedStorageWorkletToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SharedStorageWorkletToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
ShadowRealmTokenPtr ShadowRealmToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, ShadowRealmToken::EnableIfSame<T>*>
bool ShadowRealmToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ShadowRealmToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
AttributionSrcTokenPtr AttributionSrcToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, AttributionSrcToken::EnableIfSame<T>*>
bool AttributionSrcToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, AttributionSrcToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
ClipboardSequenceNumberTokenPtr ClipboardSequenceNumberToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, ClipboardSequenceNumberToken::EnableIfSame<T>*>
bool ClipboardSequenceNumberToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ClipboardSequenceNumberToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
SameDocNavigationScreenshotDestinationTokenPtr SameDocNavigationScreenshotDestinationToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, SameDocNavigationScreenshotDestinationToken::EnableIfSame<T>*>
bool SameDocNavigationScreenshotDestinationToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SameDocNavigationScreenshotDestinationToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
V8ContextTokenPtr V8ContextToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, V8ContextToken::EnableIfSame<T>*>
bool V8ContextToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, V8ContextToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
ViewTransitionTokenPtr ViewTransitionToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, ViewTransitionToken::EnableIfSame<T>*>
bool ViewTransitionToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ViewTransitionToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
WebNNContextTokenPtr WebNNContextToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, WebNNContextToken::EnableIfSame<T>*>
bool WebNNContextToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, WebNNContextToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
WebNNPendingConstantTokenPtr WebNNPendingConstantToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, WebNNPendingConstantToken::EnableIfSame<T>*>
bool WebNNPendingConstantToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, WebNNPendingConstantToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
WebNNTensorTokenPtr WebNNTensorToken::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, WebNNTensorToken::EnableIfSame<T>*>
bool WebNNTensorToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, WebNNTensorToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DocumentToken::DataView,
                                         ::blink::mojom::DocumentTokenPtr> {
  static bool IsNull(const ::blink::mojom::DocumentTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DocumentTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DocumentToken::value)& value(
      const ::blink::mojom::DocumentTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::DocumentToken::DataView input, ::blink::mojom::DocumentTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::LocalFrameToken::DataView,
                                         ::blink::mojom::LocalFrameTokenPtr> {
  static bool IsNull(const ::blink::mojom::LocalFrameTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::LocalFrameTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::LocalFrameToken::value)& value(
      const ::blink::mojom::LocalFrameTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::LocalFrameToken::DataView input, ::blink::mojom::LocalFrameTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RemoteFrameToken::DataView,
                                         ::blink::mojom::RemoteFrameTokenPtr> {
  static bool IsNull(const ::blink::mojom::RemoteFrameTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RemoteFrameTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::RemoteFrameToken::value)& value(
      const ::blink::mojom::RemoteFrameTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::RemoteFrameToken::DataView input, ::blink::mojom::RemoteFrameTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DedicatedWorkerToken::DataView,
                                         ::blink::mojom::DedicatedWorkerTokenPtr> {
  static bool IsNull(const ::blink::mojom::DedicatedWorkerTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DedicatedWorkerTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DedicatedWorkerToken::value)& value(
      const ::blink::mojom::DedicatedWorkerTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::DedicatedWorkerToken::DataView input, ::blink::mojom::DedicatedWorkerTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerToken::DataView,
                                         ::blink::mojom::ServiceWorkerTokenPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerToken::value)& value(
      const ::blink::mojom::ServiceWorkerTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::ServiceWorkerToken::DataView input, ::blink::mojom::ServiceWorkerTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SharedWorkerToken::DataView,
                                         ::blink::mojom::SharedWorkerTokenPtr> {
  static bool IsNull(const ::blink::mojom::SharedWorkerTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SharedWorkerTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SharedWorkerToken::value)& value(
      const ::blink::mojom::SharedWorkerTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::SharedWorkerToken::DataView input, ::blink::mojom::SharedWorkerTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AnimationWorkletToken::DataView,
                                         ::blink::mojom::AnimationWorkletTokenPtr> {
  static bool IsNull(const ::blink::mojom::AnimationWorkletTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AnimationWorkletTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AnimationWorkletToken::value)& value(
      const ::blink::mojom::AnimationWorkletTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::AnimationWorkletToken::DataView input, ::blink::mojom::AnimationWorkletTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AudioWorkletToken::DataView,
                                         ::blink::mojom::AudioWorkletTokenPtr> {
  static bool IsNull(const ::blink::mojom::AudioWorkletTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AudioWorkletTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AudioWorkletToken::value)& value(
      const ::blink::mojom::AudioWorkletTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::AudioWorkletToken::DataView input, ::blink::mojom::AudioWorkletTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::LayoutWorkletToken::DataView,
                                         ::blink::mojom::LayoutWorkletTokenPtr> {
  static bool IsNull(const ::blink::mojom::LayoutWorkletTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::LayoutWorkletTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::LayoutWorkletToken::value)& value(
      const ::blink::mojom::LayoutWorkletTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::LayoutWorkletToken::DataView input, ::blink::mojom::LayoutWorkletTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PaintWorkletToken::DataView,
                                         ::blink::mojom::PaintWorkletTokenPtr> {
  static bool IsNull(const ::blink::mojom::PaintWorkletTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PaintWorkletTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PaintWorkletToken::value)& value(
      const ::blink::mojom::PaintWorkletTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::PaintWorkletToken::DataView input, ::blink::mojom::PaintWorkletTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SharedStorageWorkletToken::DataView,
                                         ::blink::mojom::SharedStorageWorkletTokenPtr> {
  static bool IsNull(const ::blink::mojom::SharedStorageWorkletTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SharedStorageWorkletTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SharedStorageWorkletToken::value)& value(
      const ::blink::mojom::SharedStorageWorkletTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::SharedStorageWorkletToken::DataView input, ::blink::mojom::SharedStorageWorkletTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ShadowRealmToken::DataView,
                                         ::blink::mojom::ShadowRealmTokenPtr> {
  static bool IsNull(const ::blink::mojom::ShadowRealmTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ShadowRealmTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ShadowRealmToken::value)& value(
      const ::blink::mojom::ShadowRealmTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::ShadowRealmToken::DataView input, ::blink::mojom::ShadowRealmTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AttributionSrcToken::DataView,
                                         ::blink::mojom::AttributionSrcTokenPtr> {
  static bool IsNull(const ::blink::mojom::AttributionSrcTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AttributionSrcTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AttributionSrcToken::value)& value(
      const ::blink::mojom::AttributionSrcTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::AttributionSrcToken::DataView input, ::blink::mojom::AttributionSrcTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ClipboardSequenceNumberToken::DataView,
                                         ::blink::mojom::ClipboardSequenceNumberTokenPtr> {
  static bool IsNull(const ::blink::mojom::ClipboardSequenceNumberTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ClipboardSequenceNumberTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ClipboardSequenceNumberToken::value)& value(
      const ::blink::mojom::ClipboardSequenceNumberTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::ClipboardSequenceNumberToken::DataView input, ::blink::mojom::ClipboardSequenceNumberTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SameDocNavigationScreenshotDestinationToken::DataView,
                                         ::blink::mojom::SameDocNavigationScreenshotDestinationTokenPtr> {
  static bool IsNull(const ::blink::mojom::SameDocNavigationScreenshotDestinationTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SameDocNavigationScreenshotDestinationTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SameDocNavigationScreenshotDestinationToken::value)& value(
      const ::blink::mojom::SameDocNavigationScreenshotDestinationTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::SameDocNavigationScreenshotDestinationToken::DataView input, ::blink::mojom::SameDocNavigationScreenshotDestinationTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::V8ContextToken::DataView,
                                         ::blink::mojom::V8ContextTokenPtr> {
  static bool IsNull(const ::blink::mojom::V8ContextTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::V8ContextTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::V8ContextToken::value)& value(
      const ::blink::mojom::V8ContextTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::V8ContextToken::DataView input, ::blink::mojom::V8ContextTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ViewTransitionToken::DataView,
                                         ::blink::mojom::ViewTransitionTokenPtr> {
  static bool IsNull(const ::blink::mojom::ViewTransitionTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ViewTransitionTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ViewTransitionToken::value)& value(
      const ::blink::mojom::ViewTransitionTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::ViewTransitionToken::DataView input, ::blink::mojom::ViewTransitionTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebNNContextToken::DataView,
                                         ::blink::mojom::WebNNContextTokenPtr> {
  static bool IsNull(const ::blink::mojom::WebNNContextTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebNNContextTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebNNContextToken::value)& value(
      const ::blink::mojom::WebNNContextTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::WebNNContextToken::DataView input, ::blink::mojom::WebNNContextTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebNNPendingConstantToken::DataView,
                                         ::blink::mojom::WebNNPendingConstantTokenPtr> {
  static bool IsNull(const ::blink::mojom::WebNNPendingConstantTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebNNPendingConstantTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebNNPendingConstantToken::value)& value(
      const ::blink::mojom::WebNNPendingConstantTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::WebNNPendingConstantToken::DataView input, ::blink::mojom::WebNNPendingConstantTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebNNTensorToken::DataView,
                                         ::blink::mojom::WebNNTensorTokenPtr> {
  static bool IsNull(const ::blink::mojom::WebNNTensorTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebNNTensorTokenPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebNNTensorToken::value)& value(
      const ::blink::mojom::WebNNTensorTokenPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::WebNNTensorToken::DataView input, ::blink::mojom::WebNNTensorTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::FrameToken::DataView,
                                        ::blink::mojom::FrameTokenPtr> {
  static bool IsNull(const ::blink::mojom::FrameTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FrameTokenPtr* output) { output->reset(); }

  static ::blink::mojom::FrameToken::Tag GetTag(const ::blink::mojom::FrameTokenPtr& input) {
    return input->which();
  }

  static const ::blink::LocalFrameToken& local_frame_token(const ::blink::mojom::FrameTokenPtr& input) {
    return input->get_local_frame_token();
  }

  static const ::blink::RemoteFrameToken& remote_frame_token(const ::blink::mojom::FrameTokenPtr& input) {
    return input->get_remote_frame_token();
  }

  static bool Read(::blink::mojom::FrameToken::DataView input, ::blink::mojom::FrameTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::WorkerToken::DataView,
                                        ::blink::mojom::WorkerTokenPtr> {
  static bool IsNull(const ::blink::mojom::WorkerTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WorkerTokenPtr* output) { output->reset(); }

  static ::blink::mojom::WorkerToken::Tag GetTag(const ::blink::mojom::WorkerTokenPtr& input) {
    return input->which();
  }

  static const ::blink::DedicatedWorkerToken& dedicated_worker_token(const ::blink::mojom::WorkerTokenPtr& input) {
    return input->get_dedicated_worker_token();
  }

  static const ::blink::ServiceWorkerToken& service_worker_token(const ::blink::mojom::WorkerTokenPtr& input) {
    return input->get_service_worker_token();
  }

  static const ::blink::SharedWorkerToken& shared_worker_token(const ::blink::mojom::WorkerTokenPtr& input) {
    return input->get_shared_worker_token();
  }

  static bool Read(::blink::mojom::WorkerToken::DataView input, ::blink::mojom::WorkerTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::WorkletToken::DataView,
                                        ::blink::mojom::WorkletTokenPtr> {
  static bool IsNull(const ::blink::mojom::WorkletTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WorkletTokenPtr* output) { output->reset(); }

  static ::blink::mojom::WorkletToken::Tag GetTag(const ::blink::mojom::WorkletTokenPtr& input) {
    return input->which();
  }

  static const ::blink::AnimationWorkletToken& animation_worklet_token(const ::blink::mojom::WorkletTokenPtr& input) {
    return input->get_animation_worklet_token();
  }

  static const ::blink::AudioWorkletToken& audio_worklet_token(const ::blink::mojom::WorkletTokenPtr& input) {
    return input->get_audio_worklet_token();
  }

  static const ::blink::mojom::LayoutWorkletTokenPtr& layout_worklet_token(const ::blink::mojom::WorkletTokenPtr& input) {
    return input->get_layout_worklet_token();
  }

  static const ::blink::PaintWorkletToken& paint_worklet_token(const ::blink::mojom::WorkletTokenPtr& input) {
    return input->get_paint_worklet_token();
  }

  static const ::blink::mojom::SharedStorageWorkletTokenPtr& shared_storage_worklet_token(const ::blink::mojom::WorkletTokenPtr& input) {
    return input->get_shared_storage_worklet_token();
  }

  static bool Read(::blink::mojom::WorkletToken::DataView input, ::blink::mojom::WorkletTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::ExecutionContextToken::DataView,
                                        ::blink::mojom::ExecutionContextTokenPtr> {
  static bool IsNull(const ::blink::mojom::ExecutionContextTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ExecutionContextTokenPtr* output) { output->reset(); }

  static ::blink::mojom::ExecutionContextToken::Tag GetTag(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->which();
  }

  static const ::blink::LocalFrameToken& local_frame_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_local_frame_token();
  }

  static const ::blink::DedicatedWorkerToken& dedicated_worker_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_dedicated_worker_token();
  }

  static const ::blink::ServiceWorkerToken& service_worker_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_service_worker_token();
  }

  static const ::blink::SharedWorkerToken& shared_worker_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_shared_worker_token();
  }

  static const ::blink::AnimationWorkletToken& animation_worklet_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_animation_worklet_token();
  }

  static const ::blink::AudioWorkletToken& audio_worklet_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_audio_worklet_token();
  }

  static const ::blink::mojom::LayoutWorkletTokenPtr& layout_worklet_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_layout_worklet_token();
  }

  static const ::blink::PaintWorkletToken& paint_worklet_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_paint_worklet_token();
  }

  static const ::blink::mojom::SharedStorageWorkletTokenPtr& shared_storage_worklet_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_shared_storage_worklet_token();
  }

  static const ::blink::ShadowRealmToken& shadow_realm_token(const ::blink::mojom::ExecutionContextTokenPtr& input) {
    return input->get_shadow_realm_token();
  }

  static bool Read(::blink::mojom::ExecutionContextToken::DataView input, ::blink::mojom::ExecutionContextTokenPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::WebGPUExecutionContextToken::DataView,
                                        ::blink::mojom::WebGPUExecutionContextTokenPtr> {
  static bool IsNull(const ::blink::mojom::WebGPUExecutionContextTokenPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebGPUExecutionContextTokenPtr* output) { output->reset(); }

  static ::blink::mojom::WebGPUExecutionContextToken::Tag GetTag(const ::blink::mojom::WebGPUExecutionContextTokenPtr& input) {
    return input->which();
  }

  static const ::blink::DocumentToken& document_token(const ::blink::mojom::WebGPUExecutionContextTokenPtr& input) {
    return input->get_document_token();
  }

  static const ::blink::DedicatedWorkerToken& dedicated_worker_token(const ::blink::mojom::WebGPUExecutionContextTokenPtr& input) {
    return input->get_dedicated_worker_token();
  }

  static const ::blink::SharedWorkerToken& shared_worker_token(const ::blink::mojom::WebGPUExecutionContextTokenPtr& input) {
    return input->get_shared_worker_token();
  }

  static const ::blink::ServiceWorkerToken& service_worker_token(const ::blink::mojom::WebGPUExecutionContextTokenPtr& input) {
    return input->get_service_worker_token();
  }

  static bool Read(::blink::mojom::WebGPUExecutionContextToken::DataView input, ::blink::mojom::WebGPUExecutionContextTokenPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_TOKENS_TOKENS_MOJOM_H_