// third_party/blink/public/mojom/subapps/sub_apps_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SubAppsServiceResultCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SubAppsServiceResultCode = {
  
  kSuccess: 0,
  kFailure: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SubAppsServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SubAppsService', scope);
  }
}

/** @interface */
export class SubAppsServiceInterface {
  
  /**
   * @param { !Array<!SubAppsServiceAddParameters> } subAppsToAdd
   * @return {!Promise<{
        result: !Array<!SubAppsServiceAddResult>,
   *  }>}
   */

  add(subAppsToAdd) {}
  
  /**
   * @return {!Promise<{
        result: !SubAppsServiceListResult,
   *  }>}
   */

  list() {}
  
  /**
   * @param { !Array<!string> } manifestIdPaths
   * @return {!Promise<{
        result: !Array<!SubAppsServiceRemoveResult>,
   *  }>}
   */

  remove(manifestIdPaths) {}
}

/**
 * @implements { SubAppsServiceInterface }
 */
export class SubAppsServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SubAppsServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SubAppsServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SubAppsServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!SubAppsServiceAddParameters> } subAppsToAdd
   * @return {!Promise<{
        result: !Array<!SubAppsServiceAddResult>,
   *  }>}
   */

  add(
      subAppsToAdd) {
    return this.proxy.sendMessage(
        0,
        SubAppsService_Add_ParamsSpec.$,
        SubAppsService_Add_ResponseParamsSpec.$,
        [
          subAppsToAdd
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !SubAppsServiceListResult,
   *  }>}
   */

  list() {
    return this.proxy.sendMessage(
        1,
        SubAppsService_List_ParamsSpec.$,
        SubAppsService_List_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } manifestIdPaths
   * @return {!Promise<{
        result: !Array<!SubAppsServiceRemoveResult>,
   *  }>}
   */

  remove(
      manifestIdPaths) {
    return this.proxy.sendMessage(
        2,
        SubAppsService_Remove_ParamsSpec.$,
        SubAppsService_Remove_ResponseParamsSpec.$,
        [
          manifestIdPaths
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SubAppsService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SubAppsServiceReceiver {
  /**
   * @param {!SubAppsServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SubAppsServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SubAppsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SubAppsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SubAppsService_Add_ParamsSpec.$,
        SubAppsService_Add_ResponseParamsSpec.$,
        impl.add.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SubAppsService_List_ParamsSpec.$,
        SubAppsService_List_ResponseParamsSpec.$,
        impl.list.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SubAppsService_Remove_ParamsSpec.$,
        SubAppsService_Remove_ResponseParamsSpec.$,
        impl.remove.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SubAppsService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SubAppsService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SubAppsServiceRemote}
   */
  static getRemote() {
    let remote = new SubAppsServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SubAppsService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SubAppsServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SubAppsServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SubAppsServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.add =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SubAppsService_Add_ParamsSpec.$,
        SubAppsService_Add_ResponseParamsSpec.$,
        this.add.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.list =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SubAppsService_List_ParamsSpec.$,
        SubAppsService_List_ResponseParamsSpec.$,
        this.list.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.remove =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SubAppsService_Remove_ParamsSpec.$,
        SubAppsService_Remove_ResponseParamsSpec.$,
        this.remove.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsServiceAddParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsServiceAddResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsServiceListResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsServiceListResultEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsServiceRemoveResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsService_Add_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsService_Add_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsService_List_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsService_List_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsService_Remove_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubAppsService_Remove_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SubAppsServiceAddParametersSpec.$,
    'SubAppsServiceAddParameters',
    [
      mojo.internal.StructField(
        'manifestIdPath', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'installUrlPath', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SubAppsServiceAddParameters {
  constructor() {
    /** @type { !string } */
    this.manifestIdPath;
    /** @type { !string } */
    this.installUrlPath;
  }
}



mojo.internal.Struct(
    SubAppsServiceAddResultSpec.$,
    'SubAppsServiceAddResult',
    [
      mojo.internal.StructField(
        'manifestIdPath', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resultCode', 8,
        0,
        SubAppsServiceResultCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SubAppsServiceAddResult {
  constructor() {
    /** @type { !string } */
    this.manifestIdPath;
    /** @type { !SubAppsServiceResultCode } */
    this.resultCode;
  }
}



mojo.internal.Struct(
    SubAppsServiceListResultSpec.$,
    'SubAppsServiceListResult',
    [
      mojo.internal.StructField(
        'resultCode', 0,
        0,
        SubAppsServiceResultCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subAppsList', 8,
        0,
        mojo.internal.Array(SubAppsServiceListResultEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SubAppsServiceListResult {
  constructor() {
    /** @type { !SubAppsServiceResultCode } */
    this.resultCode;
    /** @type { !Array<!SubAppsServiceListResultEntry> } */
    this.subAppsList;
  }
}



mojo.internal.Struct(
    SubAppsServiceListResultEntrySpec.$,
    'SubAppsServiceListResultEntry',
    [
      mojo.internal.StructField(
        'manifestIdPath', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'appName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SubAppsServiceListResultEntry {
  constructor() {
    /** @type { !string } */
    this.manifestIdPath;
    /** @type { !string } */
    this.appName;
  }
}



mojo.internal.Struct(
    SubAppsServiceRemoveResultSpec.$,
    'SubAppsServiceRemoveResult',
    [
      mojo.internal.StructField(
        'manifestIdPath', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resultCode', 8,
        0,
        SubAppsServiceResultCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SubAppsServiceRemoveResult {
  constructor() {
    /** @type { !string } */
    this.manifestIdPath;
    /** @type { !SubAppsServiceResultCode } */
    this.resultCode;
  }
}



mojo.internal.Struct(
    SubAppsService_Add_ParamsSpec.$,
    'SubAppsService_Add_Params',
    [
      mojo.internal.StructField(
        'subAppsToAdd', 0,
        0,
        mojo.internal.Array(SubAppsServiceAddParametersSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SubAppsService_Add_Params {
  constructor() {
    /** @type { !Array<!SubAppsServiceAddParameters> } */
    this.subAppsToAdd;
  }
}



mojo.internal.Struct(
    SubAppsService_Add_ResponseParamsSpec.$,
    'SubAppsService_Add_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Array(SubAppsServiceAddResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SubAppsService_Add_ResponseParams {
  constructor() {
    /** @type { !Array<!SubAppsServiceAddResult> } */
    this.result;
  }
}



mojo.internal.Struct(
    SubAppsService_List_ParamsSpec.$,
    'SubAppsService_List_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SubAppsService_List_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SubAppsService_List_ResponseParamsSpec.$,
    'SubAppsService_List_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SubAppsServiceListResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SubAppsService_List_ResponseParams {
  constructor() {
    /** @type { !SubAppsServiceListResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SubAppsService_Remove_ParamsSpec.$,
    'SubAppsService_Remove_Params',
    [
      mojo.internal.StructField(
        'manifestIdPaths', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SubAppsService_Remove_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.manifestIdPaths;
  }
}



mojo.internal.Struct(
    SubAppsService_Remove_ResponseParamsSpec.$,
    'SubAppsService_Remove_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Array(SubAppsServiceRemoveResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SubAppsService_Remove_ResponseParams {
  constructor() {
    /** @type { !Array<!SubAppsServiceRemoveResult> } */
    this.result;
  }
}

