// third_party/blink/public/mojom/subapps/sub_apps_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SUBAPPS_SUB_APPS_SERVICE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SUBAPPS_SUB_APPS_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/subapps/sub_apps_service.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/subapps/sub_apps_service.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/subapps/sub_apps_service.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class SubAppsServiceProxy;

template <typename ImplRefTraits>
class SubAppsServiceStub;

class SubAppsServiceRequestValidator;
class SubAppsServiceResponseValidator;


class PLATFORM_EXPORT SubAppsService
    : public SubAppsServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SubAppsService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SubAppsServiceInterfaceBase;
  using Proxy_ = SubAppsServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SubAppsServiceStub<ImplRefTraits>;

  using RequestValidator_ = SubAppsServiceRequestValidator;
  using ResponseValidator_ = SubAppsServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddMinVersion = 0,
    kListMinVersion = 0,
    kRemoveMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Add_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct List_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Remove_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SubAppsService() = default;

  using AddCallback = base::OnceCallback<void(::blink::Vector<SubAppsServiceAddResultPtr>)>;
  using AddMojoCallback = base::OnceCallback<void(::blink::Vector<SubAppsServiceAddResultPtr>)>;

  virtual void Add(::blink::Vector<SubAppsServiceAddParametersPtr> sub_apps_to_add, AddCallback callback) = 0;

  using ListCallback = base::OnceCallback<void(SubAppsServiceListResultPtr)>;
  using ListMojoCallback = base::OnceCallback<void(SubAppsServiceListResultPtr)>;

  virtual void List(ListCallback callback) = 0;

  using RemoveCallback = base::OnceCallback<void(::blink::Vector<SubAppsServiceRemoveResultPtr>)>;
  using RemoveMojoCallback = base::OnceCallback<void(::blink::Vector<SubAppsServiceRemoveResultPtr>)>;

  virtual void Remove(const ::blink::Vector<::blink::String>& manifest_id_paths, RemoveCallback callback) = 0;
};



class PLATFORM_EXPORT SubAppsServiceProxy
    : public SubAppsService {
 public:
  using InterfaceType = SubAppsService;

  explicit SubAppsServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Add(::blink::Vector<SubAppsServiceAddParametersPtr> sub_apps_to_add, AddCallback callback) final;
  
  void List(ListCallback callback) final;
  
  void Remove(const ::blink::Vector<::blink::String>& manifest_id_paths, RemoveCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT SubAppsServiceStubDispatch {
 public:
  static bool Accept(SubAppsService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SubAppsService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SubAppsService>>
class SubAppsServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SubAppsServiceStub() = default;
  ~SubAppsServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SubAppsServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SubAppsServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SubAppsServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT SubAppsServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT SubAppsServiceAddParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubAppsServiceAddParameters, T>::value>;
  using DataView = SubAppsServiceAddParametersDataView;
  using Data_ = internal::SubAppsServiceAddParameters_Data;

  template <typename... Args>
  static SubAppsServiceAddParametersPtr New(Args&&... args) {
    return SubAppsServiceAddParametersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubAppsServiceAddParametersPtr From(const U& u) {
    return mojo::TypeConverter<SubAppsServiceAddParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubAppsServiceAddParameters>::Convert(*this);
  }


  SubAppsServiceAddParameters();

  SubAppsServiceAddParameters(
      const ::blink::String& manifest_id_path,
      const ::blink::String& install_url_path);


  ~SubAppsServiceAddParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubAppsServiceAddParametersPtr>
  SubAppsServiceAddParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubAppsServiceAddParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubAppsServiceAddParameters::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubAppsServiceAddParameters::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceAddParameters::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceAddParameters::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubAppsServiceAddParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubAppsServiceAddParameters_UnserializedMessageContext<
            UserType, SubAppsServiceAddParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubAppsServiceAddParameters::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubAppsServiceAddParameters::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubAppsServiceAddParameters_UnserializedMessageContext<
            UserType, SubAppsServiceAddParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubAppsServiceAddParameters::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String manifest_id_path;
  
  ::blink::String install_url_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubAppsServiceAddParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubAppsServiceAddParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubAppsServiceAddParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubAppsServiceAddParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SubAppsServiceAddResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubAppsServiceAddResult, T>::value>;
  using DataView = SubAppsServiceAddResultDataView;
  using Data_ = internal::SubAppsServiceAddResult_Data;

  template <typename... Args>
  static SubAppsServiceAddResultPtr New(Args&&... args) {
    return SubAppsServiceAddResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubAppsServiceAddResultPtr From(const U& u) {
    return mojo::TypeConverter<SubAppsServiceAddResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubAppsServiceAddResult>::Convert(*this);
  }


  SubAppsServiceAddResult();

  SubAppsServiceAddResult(
      const ::blink::String& manifest_id_path,
      SubAppsServiceResultCode result_code);


  ~SubAppsServiceAddResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubAppsServiceAddResultPtr>
  SubAppsServiceAddResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubAppsServiceAddResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubAppsServiceAddResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubAppsServiceAddResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceAddResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceAddResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubAppsServiceAddResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubAppsServiceAddResult_UnserializedMessageContext<
            UserType, SubAppsServiceAddResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubAppsServiceAddResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubAppsServiceAddResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubAppsServiceAddResult_UnserializedMessageContext<
            UserType, SubAppsServiceAddResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubAppsServiceAddResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String manifest_id_path;
  
  SubAppsServiceResultCode result_code;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubAppsServiceAddResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubAppsServiceAddResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubAppsServiceAddResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubAppsServiceAddResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT SubAppsServiceListResultEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubAppsServiceListResultEntry, T>::value>;
  using DataView = SubAppsServiceListResultEntryDataView;
  using Data_ = internal::SubAppsServiceListResultEntry_Data;

  template <typename... Args>
  static SubAppsServiceListResultEntryPtr New(Args&&... args) {
    return SubAppsServiceListResultEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubAppsServiceListResultEntryPtr From(const U& u) {
    return mojo::TypeConverter<SubAppsServiceListResultEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubAppsServiceListResultEntry>::Convert(*this);
  }


  SubAppsServiceListResultEntry();

  SubAppsServiceListResultEntry(
      const ::blink::String& manifest_id_path,
      const ::blink::String& app_name);


  ~SubAppsServiceListResultEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubAppsServiceListResultEntryPtr>
  SubAppsServiceListResultEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubAppsServiceListResultEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubAppsServiceListResultEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubAppsServiceListResultEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceListResultEntry::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceListResultEntry::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubAppsServiceListResultEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubAppsServiceListResultEntry_UnserializedMessageContext<
            UserType, SubAppsServiceListResultEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubAppsServiceListResultEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubAppsServiceListResultEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubAppsServiceListResultEntry_UnserializedMessageContext<
            UserType, SubAppsServiceListResultEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubAppsServiceListResultEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String manifest_id_path;
  
  ::blink::String app_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubAppsServiceListResultEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubAppsServiceListResultEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubAppsServiceListResultEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubAppsServiceListResultEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SubAppsServiceRemoveResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubAppsServiceRemoveResult, T>::value>;
  using DataView = SubAppsServiceRemoveResultDataView;
  using Data_ = internal::SubAppsServiceRemoveResult_Data;

  template <typename... Args>
  static SubAppsServiceRemoveResultPtr New(Args&&... args) {
    return SubAppsServiceRemoveResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubAppsServiceRemoveResultPtr From(const U& u) {
    return mojo::TypeConverter<SubAppsServiceRemoveResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubAppsServiceRemoveResult>::Convert(*this);
  }


  SubAppsServiceRemoveResult();

  SubAppsServiceRemoveResult(
      const ::blink::String& manifest_id_path,
      SubAppsServiceResultCode result_code);


  ~SubAppsServiceRemoveResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubAppsServiceRemoveResultPtr>
  SubAppsServiceRemoveResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubAppsServiceRemoveResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubAppsServiceRemoveResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubAppsServiceRemoveResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceRemoveResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceRemoveResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubAppsServiceRemoveResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubAppsServiceRemoveResult_UnserializedMessageContext<
            UserType, SubAppsServiceRemoveResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubAppsServiceRemoveResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubAppsServiceRemoveResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubAppsServiceRemoveResult_UnserializedMessageContext<
            UserType, SubAppsServiceRemoveResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubAppsServiceRemoveResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String manifest_id_path;
  
  SubAppsServiceResultCode result_code;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubAppsServiceRemoveResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubAppsServiceRemoveResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubAppsServiceRemoveResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubAppsServiceRemoveResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT SubAppsServiceListResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubAppsServiceListResult, T>::value>;
  using DataView = SubAppsServiceListResultDataView;
  using Data_ = internal::SubAppsServiceListResult_Data;

  template <typename... Args>
  static SubAppsServiceListResultPtr New(Args&&... args) {
    return SubAppsServiceListResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubAppsServiceListResultPtr From(const U& u) {
    return mojo::TypeConverter<SubAppsServiceListResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubAppsServiceListResult>::Convert(*this);
  }


  SubAppsServiceListResult();

  SubAppsServiceListResult(
      SubAppsServiceResultCode result_code,
      ::blink::Vector<SubAppsServiceListResultEntryPtr> sub_apps_list);

SubAppsServiceListResult(const SubAppsServiceListResult&) = delete;
SubAppsServiceListResult& operator=(const SubAppsServiceListResult&) = delete;

  ~SubAppsServiceListResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubAppsServiceListResultPtr>
  SubAppsServiceListResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubAppsServiceListResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubAppsServiceListResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubAppsServiceListResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceListResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubAppsServiceListResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubAppsServiceListResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubAppsServiceListResult_UnserializedMessageContext<
            UserType, SubAppsServiceListResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubAppsServiceListResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubAppsServiceListResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubAppsServiceListResult_UnserializedMessageContext<
            UserType, SubAppsServiceListResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubAppsServiceListResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SubAppsServiceResultCode result_code;
  
  ::blink::Vector<SubAppsServiceListResultEntryPtr> sub_apps_list;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubAppsServiceListResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubAppsServiceListResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubAppsServiceListResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubAppsServiceListResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}



template <typename StructPtrType>
SubAppsServiceAddParametersPtr SubAppsServiceAddParameters::Clone() const {
  return New(
      mojo::Clone(manifest_id_path),
      mojo::Clone(install_url_path)
  );
}

template <typename T, SubAppsServiceAddParameters::EnableIfSame<T>*>
bool SubAppsServiceAddParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->manifest_id_path, other_struct.manifest_id_path))
    return false;
  if (!mojo::Equals(this->install_url_path, other_struct.install_url_path))
    return false;
  return true;
}

template <typename T, SubAppsServiceAddParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.manifest_id_path < rhs.manifest_id_path)
    return true;
  if (rhs.manifest_id_path < lhs.manifest_id_path)
    return false;
  if (lhs.install_url_path < rhs.install_url_path)
    return true;
  if (rhs.install_url_path < lhs.install_url_path)
    return false;
  return false;
}
template <typename StructPtrType>
SubAppsServiceAddResultPtr SubAppsServiceAddResult::Clone() const {
  return New(
      mojo::Clone(manifest_id_path),
      mojo::Clone(result_code)
  );
}

template <typename T, SubAppsServiceAddResult::EnableIfSame<T>*>
bool SubAppsServiceAddResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->manifest_id_path, other_struct.manifest_id_path))
    return false;
  if (!mojo::Equals(this->result_code, other_struct.result_code))
    return false;
  return true;
}

template <typename T, SubAppsServiceAddResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.manifest_id_path < rhs.manifest_id_path)
    return true;
  if (rhs.manifest_id_path < lhs.manifest_id_path)
    return false;
  if (lhs.result_code < rhs.result_code)
    return true;
  if (rhs.result_code < lhs.result_code)
    return false;
  return false;
}
template <typename StructPtrType>
SubAppsServiceListResultPtr SubAppsServiceListResult::Clone() const {
  return New(
      mojo::Clone(result_code),
      mojo::Clone(sub_apps_list)
  );
}

template <typename T, SubAppsServiceListResult::EnableIfSame<T>*>
bool SubAppsServiceListResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->result_code, other_struct.result_code))
    return false;
  if (!mojo::Equals(this->sub_apps_list, other_struct.sub_apps_list))
    return false;
  return true;
}

template <typename T, SubAppsServiceListResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.result_code < rhs.result_code)
    return true;
  if (rhs.result_code < lhs.result_code)
    return false;
  if (lhs.sub_apps_list < rhs.sub_apps_list)
    return true;
  if (rhs.sub_apps_list < lhs.sub_apps_list)
    return false;
  return false;
}
template <typename StructPtrType>
SubAppsServiceListResultEntryPtr SubAppsServiceListResultEntry::Clone() const {
  return New(
      mojo::Clone(manifest_id_path),
      mojo::Clone(app_name)
  );
}

template <typename T, SubAppsServiceListResultEntry::EnableIfSame<T>*>
bool SubAppsServiceListResultEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->manifest_id_path, other_struct.manifest_id_path))
    return false;
  if (!mojo::Equals(this->app_name, other_struct.app_name))
    return false;
  return true;
}

template <typename T, SubAppsServiceListResultEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.manifest_id_path < rhs.manifest_id_path)
    return true;
  if (rhs.manifest_id_path < lhs.manifest_id_path)
    return false;
  if (lhs.app_name < rhs.app_name)
    return true;
  if (rhs.app_name < lhs.app_name)
    return false;
  return false;
}
template <typename StructPtrType>
SubAppsServiceRemoveResultPtr SubAppsServiceRemoveResult::Clone() const {
  return New(
      mojo::Clone(manifest_id_path),
      mojo::Clone(result_code)
  );
}

template <typename T, SubAppsServiceRemoveResult::EnableIfSame<T>*>
bool SubAppsServiceRemoveResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->manifest_id_path, other_struct.manifest_id_path))
    return false;
  if (!mojo::Equals(this->result_code, other_struct.result_code))
    return false;
  return true;
}

template <typename T, SubAppsServiceRemoveResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.manifest_id_path < rhs.manifest_id_path)
    return true;
  if (rhs.manifest_id_path < lhs.manifest_id_path)
    return false;
  if (lhs.result_code < rhs.result_code)
    return true;
  if (rhs.result_code < lhs.result_code)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SubAppsServiceAddParameters::DataView,
                                         ::blink::mojom::blink::SubAppsServiceAddParametersPtr> {
  static bool IsNull(const ::blink::mojom::blink::SubAppsServiceAddParametersPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SubAppsServiceAddParametersPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SubAppsServiceAddParameters::manifest_id_path)& manifest_id_path(
      const ::blink::mojom::blink::SubAppsServiceAddParametersPtr& input) {
    return input->manifest_id_path;
  }

  static const decltype(::blink::mojom::blink::SubAppsServiceAddParameters::install_url_path)& install_url_path(
      const ::blink::mojom::blink::SubAppsServiceAddParametersPtr& input) {
    return input->install_url_path;
  }

  static bool Read(::blink::mojom::blink::SubAppsServiceAddParameters::DataView input, ::blink::mojom::blink::SubAppsServiceAddParametersPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SubAppsServiceAddResult::DataView,
                                         ::blink::mojom::blink::SubAppsServiceAddResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::SubAppsServiceAddResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SubAppsServiceAddResultPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SubAppsServiceAddResult::manifest_id_path)& manifest_id_path(
      const ::blink::mojom::blink::SubAppsServiceAddResultPtr& input) {
    return input->manifest_id_path;
  }

  static decltype(::blink::mojom::blink::SubAppsServiceAddResult::result_code) result_code(
      const ::blink::mojom::blink::SubAppsServiceAddResultPtr& input) {
    return input->result_code;
  }

  static bool Read(::blink::mojom::blink::SubAppsServiceAddResult::DataView input, ::blink::mojom::blink::SubAppsServiceAddResultPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SubAppsServiceListResult::DataView,
                                         ::blink::mojom::blink::SubAppsServiceListResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::SubAppsServiceListResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SubAppsServiceListResultPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::SubAppsServiceListResult::result_code) result_code(
      const ::blink::mojom::blink::SubAppsServiceListResultPtr& input) {
    return input->result_code;
  }

  static const decltype(::blink::mojom::blink::SubAppsServiceListResult::sub_apps_list)& sub_apps_list(
      const ::blink::mojom::blink::SubAppsServiceListResultPtr& input) {
    return input->sub_apps_list;
  }

  static bool Read(::blink::mojom::blink::SubAppsServiceListResult::DataView input, ::blink::mojom::blink::SubAppsServiceListResultPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SubAppsServiceListResultEntry::DataView,
                                         ::blink::mojom::blink::SubAppsServiceListResultEntryPtr> {
  static bool IsNull(const ::blink::mojom::blink::SubAppsServiceListResultEntryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SubAppsServiceListResultEntryPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SubAppsServiceListResultEntry::manifest_id_path)& manifest_id_path(
      const ::blink::mojom::blink::SubAppsServiceListResultEntryPtr& input) {
    return input->manifest_id_path;
  }

  static const decltype(::blink::mojom::blink::SubAppsServiceListResultEntry::app_name)& app_name(
      const ::blink::mojom::blink::SubAppsServiceListResultEntryPtr& input) {
    return input->app_name;
  }

  static bool Read(::blink::mojom::blink::SubAppsServiceListResultEntry::DataView input, ::blink::mojom::blink::SubAppsServiceListResultEntryPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SubAppsServiceRemoveResult::DataView,
                                         ::blink::mojom::blink::SubAppsServiceRemoveResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::SubAppsServiceRemoveResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SubAppsServiceRemoveResultPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SubAppsServiceRemoveResult::manifest_id_path)& manifest_id_path(
      const ::blink::mojom::blink::SubAppsServiceRemoveResultPtr& input) {
    return input->manifest_id_path;
  }

  static decltype(::blink::mojom::blink::SubAppsServiceRemoveResult::result_code) result_code(
      const ::blink::mojom::blink::SubAppsServiceRemoveResultPtr& input) {
    return input->result_code;
  }

  static bool Read(::blink::mojom::blink::SubAppsServiceRemoveResult::DataView input, ::blink::mojom::blink::SubAppsServiceRemoveResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SUBAPPS_SUB_APPS_SERVICE_MOJOM_BLINK_H_