// third_party/blink/public/mojom/storage_key/storage_key.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-params-data.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-import-headers.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-test-utils.h"


namespace blink::mojom {
StorageKey::StorageKey()
    : origin(),
      top_level_site(),
      nonce(),
      ancestor_chain_bit(),
      top_level_site_if_third_party_enabled(),
      ancestor_chain_bit_if_third_party_enabled() {}

StorageKey::StorageKey(
    const ::url::Origin& origin_in,
    const ::net::SchemefulSite& top_level_site_in,
    const std::optional<::base::UnguessableToken>& nonce_in,
    ::blink::mojom::AncestorChainBit ancestor_chain_bit_in,
    const ::net::SchemefulSite& top_level_site_if_third_party_enabled_in,
    ::blink::mojom::AncestorChainBit ancestor_chain_bit_if_third_party_enabled_in)
    : origin(std::move(origin_in)),
      top_level_site(std::move(top_level_site_in)),
      nonce(std::move(nonce_in)),
      ancestor_chain_bit(std::move(ancestor_chain_bit_in)),
      top_level_site_if_third_party_enabled(std::move(top_level_site_if_third_party_enabled_in)),
      ancestor_chain_bit_if_third_party_enabled(std::move(ancestor_chain_bit_if_third_party_enabled_in)) {}

StorageKey::~StorageKey() = default;

void StorageKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_level_site"), this->top_level_site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SchemefulSite&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nonce"), this->nonce,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ancestor_chain_bit"), this->ancestor_chain_bit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::AncestorChainBit>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_level_site_if_third_party_enabled"), this->top_level_site_if_third_party_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SchemefulSite&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ancestor_chain_bit_if_third_party_enabled"), this->ancestor_chain_bit_if_third_party_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::AncestorChainBit>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StorageKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::StorageKey::DataView, ::blink::mojom::StorageKeyPtr>::Read(
    ::blink::mojom::StorageKey::DataView input,
    ::blink::mojom::StorageKeyPtr* output) {
  bool success = true;
  ::blink::mojom::StorageKeyPtr result(::blink::mojom::StorageKey::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadTopLevelSite(&result->top_level_site))
        success = false;
      if (success && !input.ReadNonce(&result->nonce))
        success = false;
      if (success && !input.ReadAncestorChainBit(&result->ancestor_chain_bit))
        success = false;
      if (success && !input.ReadTopLevelSiteIfThirdPartyEnabled(&result->top_level_site_if_third_party_enabled))
        success = false;
      if (success && !input.ReadAncestorChainBitIfThirdPartyEnabled(&result->ancestor_chain_bit_if_third_party_enabled))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {




}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif