// third_party/blink/public/mojom/speech/speech_synthesis.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-params-data.h"
#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-import-headers.h"
#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-test-utils.h"


namespace blink::mojom {
SpeechSynthesisUtterance::SpeechSynthesisUtterance()
    : text(),
      lang(),
      voice(),
      volume(),
      rate(),
      pitch() {}

SpeechSynthesisUtterance::SpeechSynthesisUtterance(
    const std::string& text_in,
    const std::string& lang_in,
    const std::string& voice_in,
    double volume_in,
    double rate_in,
    double pitch_in)
    : text(std::move(text_in)),
      lang(std::move(lang_in)),
      voice(std::move(voice_in)),
      volume(std::move(volume_in)),
      rate(std::move(rate_in)),
      pitch(std::move(pitch_in)) {}

SpeechSynthesisUtterance::~SpeechSynthesisUtterance() = default;
size_t SpeechSynthesisUtterance::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->text);
  seed = mojo::internal::Hash(seed, this->lang);
  seed = mojo::internal::Hash(seed, this->voice);
  seed = mojo::internal::Hash(seed, this->volume);
  seed = mojo::internal::Hash(seed, this->rate);
  seed = mojo::internal::Hash(seed, this->pitch);
  return seed;
}

void SpeechSynthesisUtterance::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lang"), this->lang,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "voice"), this->voice,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "volume"), this->volume,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rate"), this->rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pitch"), this->pitch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpeechSynthesisUtterance::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpeechSynthesisVoice::SpeechSynthesisVoice()
    : voice_uri(),
      name(),
      lang(),
      is_local_service(),
      is_default() {}

SpeechSynthesisVoice::SpeechSynthesisVoice(
    const std::string& voice_uri_in,
    const std::string& name_in,
    const std::string& lang_in,
    bool is_local_service_in,
    bool is_default_in)
    : voice_uri(std::move(voice_uri_in)),
      name(std::move(name_in)),
      lang(std::move(lang_in)),
      is_local_service(std::move(is_local_service_in)),
      is_default(std::move(is_default_in)) {}

SpeechSynthesisVoice::~SpeechSynthesisVoice() = default;
size_t SpeechSynthesisVoice::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->voice_uri);
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->lang);
  seed = mojo::internal::Hash(seed, this->is_local_service);
  seed = mojo::internal::Hash(seed, this->is_default);
  return seed;
}

void SpeechSynthesisVoice::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "voice_uri"), this->voice_uri,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lang"), this->lang,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_local_service"), this->is_local_service,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_default"), this->is_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpeechSynthesisVoice::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SpeechSynthesisVoiceListObserver::IPCStableHashFunction SpeechSynthesisVoiceListObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechSynthesisVoiceListObserver>(message.name())) {
    case messages::SpeechSynthesisVoiceListObserver::kOnSetVoiceList: {
      return &SpeechSynthesisVoiceListObserver::OnSetVoiceList_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechSynthesisVoiceListObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechSynthesisVoiceListObserver>(message.name())) {
      case messages::SpeechSynthesisVoiceListObserver::kOnSetVoiceList:
            return "Receive blink::mojom::SpeechSynthesisVoiceListObserver::OnSetVoiceList";
    }
  } else {
    switch (static_cast<messages::SpeechSynthesisVoiceListObserver>(message.name())) {
      case messages::SpeechSynthesisVoiceListObserver::kOnSetVoiceList:
            return "Receive reply blink::mojom::SpeechSynthesisVoiceListObserver::OnSetVoiceList";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechSynthesisVoiceListObserver::OnSetVoiceList_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa542fa4d;  // IPCStableHash for blink::mojom::SpeechSynthesisVoiceListObserver::OnSetVoiceList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechSynthesisVoiceListObserverProxy::SpeechSynthesisVoiceListObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechSynthesisVoiceListObserverProxy::OnSetVoiceList(
    std::vector<SpeechSynthesisVoicePtr> in_voice_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SpeechSynthesisVoiceListObserver::OnSetVoiceList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("voice_list"), in_voice_list,
                        "<value of type std::vector<SpeechSynthesisVoicePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesisVoiceListObserver::kOnSetVoiceList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->voice_list)::BaseType>
      voice_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& voice_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SpeechSynthesisVoiceDataView>>(
    in_voice_list,
    voice_list_fragment,
    &voice_list_validate_params);

  params->voice_list.Set(
      voice_list_fragment.is_null() ? nullptr : voice_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->voice_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null voice_list in SpeechSynthesisVoiceListObserver.OnSetVoiceList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisVoiceListObserver::Name_);
  message.set_method_name("OnSetVoiceList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechSynthesisVoiceListObserverStubDispatch::Accept(
    SpeechSynthesisVoiceListObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechSynthesisVoiceListObserver>(message->header()->name)) {
    case messages::SpeechSynthesisVoiceListObserver::kOnSetVoiceList: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesisVoiceListObserver.0
      bool success = true;
      std::vector<SpeechSynthesisVoicePtr> p_voice_list{};
      SpeechSynthesisVoiceListObserver_OnSetVoiceList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVoiceList(&p_voice_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisVoiceListObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSetVoiceList(        
        std::move(p_voice_list));
      return true;
    }
  }
  return false;
}

// static
bool SpeechSynthesisVoiceListObserverStubDispatch::AcceptWithResponder(
    SpeechSynthesisVoiceListObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechSynthesisVoiceListObserver>(message->header()->name)) {
    case messages::SpeechSynthesisVoiceListObserver::kOnSetVoiceList: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechSynthesisVoiceListObserverValidationInfo[] = {
    { &internal::SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechSynthesisVoiceListObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::SpeechSynthesisVoiceListObserver::Name_,
    kSpeechSynthesisVoiceListObserverValidationInfo);
}

// The declaration includes the definition on other builds.

SpeechSynthesisClient::IPCStableHashFunction SpeechSynthesisClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechSynthesisClient>(message.name())) {
    case messages::SpeechSynthesisClient::kOnStartedSpeaking: {
      return &SpeechSynthesisClient::OnStartedSpeaking_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesisClient::kOnFinishedSpeaking: {
      return &SpeechSynthesisClient::OnFinishedSpeaking_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesisClient::kOnPausedSpeaking: {
      return &SpeechSynthesisClient::OnPausedSpeaking_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesisClient::kOnResumedSpeaking: {
      return &SpeechSynthesisClient::OnResumedSpeaking_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesisClient::kOnEncounteredWordBoundary: {
      return &SpeechSynthesisClient::OnEncounteredWordBoundary_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesisClient::kOnEncounteredSentenceBoundary: {
      return &SpeechSynthesisClient::OnEncounteredSentenceBoundary_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesisClient::kOnEncounteredSpeakingError: {
      return &SpeechSynthesisClient::OnEncounteredSpeakingError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechSynthesisClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechSynthesisClient>(message.name())) {
      case messages::SpeechSynthesisClient::kOnStartedSpeaking:
            return "Receive blink::mojom::SpeechSynthesisClient::OnStartedSpeaking";
      case messages::SpeechSynthesisClient::kOnFinishedSpeaking:
            return "Receive blink::mojom::SpeechSynthesisClient::OnFinishedSpeaking";
      case messages::SpeechSynthesisClient::kOnPausedSpeaking:
            return "Receive blink::mojom::SpeechSynthesisClient::OnPausedSpeaking";
      case messages::SpeechSynthesisClient::kOnResumedSpeaking:
            return "Receive blink::mojom::SpeechSynthesisClient::OnResumedSpeaking";
      case messages::SpeechSynthesisClient::kOnEncounteredWordBoundary:
            return "Receive blink::mojom::SpeechSynthesisClient::OnEncounteredWordBoundary";
      case messages::SpeechSynthesisClient::kOnEncounteredSentenceBoundary:
            return "Receive blink::mojom::SpeechSynthesisClient::OnEncounteredSentenceBoundary";
      case messages::SpeechSynthesisClient::kOnEncounteredSpeakingError:
            return "Receive blink::mojom::SpeechSynthesisClient::OnEncounteredSpeakingError";
    }
  } else {
    switch (static_cast<messages::SpeechSynthesisClient>(message.name())) {
      case messages::SpeechSynthesisClient::kOnStartedSpeaking:
            return "Receive reply blink::mojom::SpeechSynthesisClient::OnStartedSpeaking";
      case messages::SpeechSynthesisClient::kOnFinishedSpeaking:
            return "Receive reply blink::mojom::SpeechSynthesisClient::OnFinishedSpeaking";
      case messages::SpeechSynthesisClient::kOnPausedSpeaking:
            return "Receive reply blink::mojom::SpeechSynthesisClient::OnPausedSpeaking";
      case messages::SpeechSynthesisClient::kOnResumedSpeaking:
            return "Receive reply blink::mojom::SpeechSynthesisClient::OnResumedSpeaking";
      case messages::SpeechSynthesisClient::kOnEncounteredWordBoundary:
            return "Receive reply blink::mojom::SpeechSynthesisClient::OnEncounteredWordBoundary";
      case messages::SpeechSynthesisClient::kOnEncounteredSentenceBoundary:
            return "Receive reply blink::mojom::SpeechSynthesisClient::OnEncounteredSentenceBoundary";
      case messages::SpeechSynthesisClient::kOnEncounteredSpeakingError:
            return "Receive reply blink::mojom::SpeechSynthesisClient::OnEncounteredSpeakingError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechSynthesisClient::OnStartedSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10c07e4c;  // IPCStableHash for blink::mojom::SpeechSynthesisClient::OnStartedSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesisClient::OnFinishedSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea72b74d;  // IPCStableHash for blink::mojom::SpeechSynthesisClient::OnFinishedSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesisClient::OnPausedSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8c385284;  // IPCStableHash for blink::mojom::SpeechSynthesisClient::OnPausedSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesisClient::OnResumedSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x166e975f;  // IPCStableHash for blink::mojom::SpeechSynthesisClient::OnResumedSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesisClient::OnEncounteredWordBoundary_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x02424a31;  // IPCStableHash for blink::mojom::SpeechSynthesisClient::OnEncounteredWordBoundary
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesisClient::OnEncounteredSentenceBoundary_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a330863;  // IPCStableHash for blink::mojom::SpeechSynthesisClient::OnEncounteredSentenceBoundary
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesisClient::OnEncounteredSpeakingError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a9086ef;  // IPCStableHash for blink::mojom::SpeechSynthesisClient::OnEncounteredSpeakingError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechSynthesisClientProxy::SpeechSynthesisClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechSynthesisClientProxy::OnStartedSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SpeechSynthesisClient::OnStartedSpeaking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesisClient::kOnStartedSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnStartedSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnStartedSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisClientProxy::OnFinishedSpeaking(
    SpeechSynthesisErrorCode in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SpeechSynthesisClient::OnFinishedSpeaking", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type SpeechSynthesisErrorCode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesisClient::kOnFinishedSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnFinishedSpeaking_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::SpeechSynthesisErrorCode>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnFinishedSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisClientProxy::OnPausedSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SpeechSynthesisClient::OnPausedSpeaking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesisClient::kOnPausedSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnPausedSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnPausedSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisClientProxy::OnResumedSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SpeechSynthesisClient::OnResumedSpeaking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesisClient::kOnResumedSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnResumedSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnResumedSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisClientProxy::OnEncounteredWordBoundary(
    uint32_t in_char_index, uint32_t in_char_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SpeechSynthesisClient::OnEncounteredWordBoundary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_index"), in_char_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_length"), in_char_length,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesisClient::kOnEncounteredWordBoundary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnEncounteredWordBoundary_Params_Data> params(
          message);
  params.Allocate();

  params->char_index = in_char_index;

  params->char_length = in_char_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnEncounteredWordBoundary");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisClientProxy::OnEncounteredSentenceBoundary(
    uint32_t in_char_index, uint32_t in_char_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SpeechSynthesisClient::OnEncounteredSentenceBoundary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_index"), in_char_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_length"), in_char_length,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesisClient::kOnEncounteredSentenceBoundary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params_Data> params(
          message);
  params.Allocate();

  params->char_index = in_char_index;

  params->char_length = in_char_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnEncounteredSentenceBoundary");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisClientProxy::OnEncounteredSpeakingError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SpeechSynthesisClient::OnEncounteredSpeakingError");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesisClient::kOnEncounteredSpeakingError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesisClient_OnEncounteredSpeakingError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesisClient::Name_);
  message.set_method_name("OnEncounteredSpeakingError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechSynthesisClientStubDispatch::Accept(
    SpeechSynthesisClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechSynthesisClient>(message->header()->name)) {
    case messages::SpeechSynthesisClient::kOnStartedSpeaking: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnStartedSpeaking_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnStartedSpeaking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesisClient.0
      bool success = true;
      SpeechSynthesisClient_OnStartedSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartedSpeaking(        );
      return true;
    }
    case messages::SpeechSynthesisClient::kOnFinishedSpeaking: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnFinishedSpeaking_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnFinishedSpeaking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesisClient.1
      bool success = true;
      SpeechSynthesisErrorCode p_error_code{};
      SpeechSynthesisClient_OnFinishedSpeaking_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorCode(&p_error_code))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFinishedSpeaking(        
        std::move(p_error_code));
      return true;
    }
    case messages::SpeechSynthesisClient::kOnPausedSpeaking: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnPausedSpeaking_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnPausedSpeaking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesisClient.2
      bool success = true;
      SpeechSynthesisClient_OnPausedSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPausedSpeaking(        );
      return true;
    }
    case messages::SpeechSynthesisClient::kOnResumedSpeaking: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnResumedSpeaking_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnResumedSpeaking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesisClient.3
      bool success = true;
      SpeechSynthesisClient_OnResumedSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResumedSpeaking(        );
      return true;
    }
    case messages::SpeechSynthesisClient::kOnEncounteredWordBoundary: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnEncounteredWordBoundary_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnEncounteredWordBoundary_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesisClient.4
      bool success = true;
      uint32_t p_char_index{};
      uint32_t p_char_length{};
      SpeechSynthesisClient_OnEncounteredWordBoundary_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_char_index = input_data_view.char_index();
      if (success)
        p_char_length = input_data_view.char_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEncounteredWordBoundary(        
        std::move(p_char_index), 
        std::move(p_char_length));
      return true;
    }
    case messages::SpeechSynthesisClient::kOnEncounteredSentenceBoundary: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesisClient.5
      bool success = true;
      uint32_t p_char_index{};
      uint32_t p_char_length{};
      SpeechSynthesisClient_OnEncounteredSentenceBoundary_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_char_index = input_data_view.char_index();
      if (success)
        p_char_length = input_data_view.char_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEncounteredSentenceBoundary(        
        std::move(p_char_index), 
        std::move(p_char_length));
      return true;
    }
    case messages::SpeechSynthesisClient::kOnEncounteredSpeakingError: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesisClient_OnEncounteredSpeakingError_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesisClient_OnEncounteredSpeakingError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesisClient.6
      bool success = true;
      SpeechSynthesisClient_OnEncounteredSpeakingError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesisClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEncounteredSpeakingError(        );
      return true;
    }
  }
  return false;
}

// static
bool SpeechSynthesisClientStubDispatch::AcceptWithResponder(
    SpeechSynthesisClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechSynthesisClient>(message->header()->name)) {
    case messages::SpeechSynthesisClient::kOnStartedSpeaking: {
      break;
    }
    case messages::SpeechSynthesisClient::kOnFinishedSpeaking: {
      break;
    }
    case messages::SpeechSynthesisClient::kOnPausedSpeaking: {
      break;
    }
    case messages::SpeechSynthesisClient::kOnResumedSpeaking: {
      break;
    }
    case messages::SpeechSynthesisClient::kOnEncounteredWordBoundary: {
      break;
    }
    case messages::SpeechSynthesisClient::kOnEncounteredSentenceBoundary: {
      break;
    }
    case messages::SpeechSynthesisClient::kOnEncounteredSpeakingError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechSynthesisClientValidationInfo[] = {
    { &internal::SpeechSynthesisClient_OnStartedSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesisClient_OnFinishedSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesisClient_OnPausedSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesisClient_OnResumedSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesisClient_OnEncounteredWordBoundary_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesisClient_OnEncounteredSpeakingError_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechSynthesisClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::SpeechSynthesisClient::Name_,
    kSpeechSynthesisClientValidationInfo);
}

// The declaration includes the definition on other builds.

SpeechSynthesis::IPCStableHashFunction SpeechSynthesis::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechSynthesis>(message.name())) {
    case messages::SpeechSynthesis::kAddVoiceListObserver: {
      return &SpeechSynthesis::AddVoiceListObserver_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesis::kSpeak: {
      return &SpeechSynthesis::Speak_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesis::kPause: {
      return &SpeechSynthesis::Pause_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesis::kResume: {
      return &SpeechSynthesis::Resume_Sym::IPCStableHash;
    }
    case messages::SpeechSynthesis::kCancel: {
      return &SpeechSynthesis::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechSynthesis::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechSynthesis>(message.name())) {
      case messages::SpeechSynthesis::kAddVoiceListObserver:
            return "Receive blink::mojom::SpeechSynthesis::AddVoiceListObserver";
      case messages::SpeechSynthesis::kSpeak:
            return "Receive blink::mojom::SpeechSynthesis::Speak";
      case messages::SpeechSynthesis::kPause:
            return "Receive blink::mojom::SpeechSynthesis::Pause";
      case messages::SpeechSynthesis::kResume:
            return "Receive blink::mojom::SpeechSynthesis::Resume";
      case messages::SpeechSynthesis::kCancel:
            return "Receive blink::mojom::SpeechSynthesis::Cancel";
    }
  } else {
    switch (static_cast<messages::SpeechSynthesis>(message.name())) {
      case messages::SpeechSynthesis::kAddVoiceListObserver:
            return "Receive reply blink::mojom::SpeechSynthesis::AddVoiceListObserver";
      case messages::SpeechSynthesis::kSpeak:
            return "Receive reply blink::mojom::SpeechSynthesis::Speak";
      case messages::SpeechSynthesis::kPause:
            return "Receive reply blink::mojom::SpeechSynthesis::Pause";
      case messages::SpeechSynthesis::kResume:
            return "Receive reply blink::mojom::SpeechSynthesis::Resume";
      case messages::SpeechSynthesis::kCancel:
            return "Receive reply blink::mojom::SpeechSynthesis::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechSynthesis::AddVoiceListObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x45042926;  // IPCStableHash for blink::mojom::SpeechSynthesis::AddVoiceListObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesis::Speak_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad9c0373;  // IPCStableHash for blink::mojom::SpeechSynthesis::Speak
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesis::Pause_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b4ae048;  // IPCStableHash for blink::mojom::SpeechSynthesis::Pause
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesis::Resume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9964020e;  // IPCStableHash for blink::mojom::SpeechSynthesis::Resume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechSynthesis::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x58ce4efb;  // IPCStableHash for blink::mojom::SpeechSynthesis::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechSynthesisProxy::SpeechSynthesisProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechSynthesisProxy::AddVoiceListObserver(
    ::mojo::PendingRemote<SpeechSynthesisVoiceListObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SpeechSynthesis::AddVoiceListObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<SpeechSynthesisVoiceListObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesis::kAddVoiceListObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_AddVoiceListObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SpeechSynthesisVoiceListObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in SpeechSynthesis.AddVoiceListObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("AddVoiceListObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisProxy::Speak(
    SpeechSynthesisUtterancePtr in_utterance, ::mojo::PendingRemote<SpeechSynthesisClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SpeechSynthesis::Speak", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("utterance"), in_utterance,
                        "<value of type SpeechSynthesisUtterancePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<SpeechSynthesisClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesis::kSpeak), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_Speak_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->utterance)::BaseType> utterance_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SpeechSynthesisUtteranceDataView>(
    in_utterance,
    utterance_fragment);

  params->utterance.Set(
      utterance_fragment.is_null() ? nullptr : utterance_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->utterance.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null utterance in SpeechSynthesis.Speak request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SpeechSynthesisClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in SpeechSynthesis.Speak request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("Speak");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisProxy::Pause(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SpeechSynthesis::Pause");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesis::kPause), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_Pause_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("Pause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisProxy::Resume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SpeechSynthesis::Resume");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesis::kResume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_Resume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechSynthesisProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SpeechSynthesis::Cancel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechSynthesis::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechSynthesis_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechSynthesis::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechSynthesisStubDispatch::Accept(
    SpeechSynthesis* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechSynthesis>(message->header()->name)) {
    case messages::SpeechSynthesis::kAddVoiceListObserver: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_AddVoiceListObserver_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_AddVoiceListObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesis.0
      bool success = true;
      ::mojo::PendingRemote<SpeechSynthesisVoiceListObserver> p_observer{};
      SpeechSynthesis_AddVoiceListObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVoiceListObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::SpeechSynthesis::kSpeak: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_Speak_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_Speak_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesis.1
      bool success = true;
      SpeechSynthesisUtterancePtr p_utterance{};
      ::mojo::PendingRemote<SpeechSynthesisClient> p_client{};
      SpeechSynthesis_Speak_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUtterance(&p_utterance))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Speak(        
        std::move(p_utterance), 
        std::move(p_client));
      return true;
    }
    case messages::SpeechSynthesis::kPause: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_Pause_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_Pause_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesis.2
      bool success = true;
      SpeechSynthesis_Pause_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Pause(        );
      return true;
    }
    case messages::SpeechSynthesis::kResume: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_Resume_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_Resume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesis.3
      bool success = true;
      SpeechSynthesis_Resume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(        );
      return true;
    }
    case messages::SpeechSynthesis::kCancel: {
      DCHECK(message->is_serialized());
      internal::SpeechSynthesis_Cancel_Params_Data* params =
          reinterpret_cast<internal::SpeechSynthesis_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechSynthesis.4
      bool success = true;
      SpeechSynthesis_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechSynthesis::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        );
      return true;
    }
  }
  return false;
}

// static
bool SpeechSynthesisStubDispatch::AcceptWithResponder(
    SpeechSynthesis* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechSynthesis>(message->header()->name)) {
    case messages::SpeechSynthesis::kAddVoiceListObserver: {
      break;
    }
    case messages::SpeechSynthesis::kSpeak: {
      break;
    }
    case messages::SpeechSynthesis::kPause: {
      break;
    }
    case messages::SpeechSynthesis::kResume: {
      break;
    }
    case messages::SpeechSynthesis::kCancel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechSynthesisValidationInfo[] = {
    { &internal::SpeechSynthesis_AddVoiceListObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesis_Speak_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesis_Pause_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesis_Resume_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechSynthesis_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechSynthesisRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::SpeechSynthesis::Name_,
    kSpeechSynthesisValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::SpeechSynthesisUtterance::DataView, ::blink::mojom::SpeechSynthesisUtterancePtr>::Read(
    ::blink::mojom::SpeechSynthesisUtterance::DataView input,
    ::blink::mojom::SpeechSynthesisUtterancePtr* output) {
  bool success = true;
  ::blink::mojom::SpeechSynthesisUtterancePtr result(::blink::mojom::SpeechSynthesisUtterance::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadLang(&result->lang))
        success = false;
      if (success && !input.ReadVoice(&result->voice))
        success = false;
      if (success)
        result->volume = input.volume();
      if (success)
        result->rate = input.rate();
      if (success)
        result->pitch = input.pitch();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SpeechSynthesisVoice::DataView, ::blink::mojom::SpeechSynthesisVoicePtr>::Read(
    ::blink::mojom::SpeechSynthesisVoice::DataView input,
    ::blink::mojom::SpeechSynthesisVoicePtr* output) {
  bool success = true;
  ::blink::mojom::SpeechSynthesisVoicePtr result(::blink::mojom::SpeechSynthesisVoice::New());
  
      if (success && !input.ReadVoiceUri(&result->voice_uri))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadLang(&result->lang))
        success = false;
      if (success)
        result->is_local_service = input.is_local_service();
      if (success)
        result->is_default = input.is_default();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void SpeechSynthesisVoiceListObserverInterceptorForTesting::OnSetVoiceList(std::vector<SpeechSynthesisVoicePtr> voice_list) {
  GetForwardingInterface()->OnSetVoiceList(
    std::move(voice_list)
    );
}
SpeechSynthesisVoiceListObserverAsyncWaiter::SpeechSynthesisVoiceListObserverAsyncWaiter(
    SpeechSynthesisVoiceListObserver* proxy) : proxy_(proxy) {}

SpeechSynthesisVoiceListObserverAsyncWaiter::~SpeechSynthesisVoiceListObserverAsyncWaiter() = default;





void SpeechSynthesisClientInterceptorForTesting::OnStartedSpeaking() {
  GetForwardingInterface()->OnStartedSpeaking();
}
void SpeechSynthesisClientInterceptorForTesting::OnFinishedSpeaking(SpeechSynthesisErrorCode error_code) {
  GetForwardingInterface()->OnFinishedSpeaking(
    std::move(error_code)
    );
}
void SpeechSynthesisClientInterceptorForTesting::OnPausedSpeaking() {
  GetForwardingInterface()->OnPausedSpeaking();
}
void SpeechSynthesisClientInterceptorForTesting::OnResumedSpeaking() {
  GetForwardingInterface()->OnResumedSpeaking();
}
void SpeechSynthesisClientInterceptorForTesting::OnEncounteredWordBoundary(uint32_t char_index, uint32_t char_length) {
  GetForwardingInterface()->OnEncounteredWordBoundary(
    std::move(char_index)
    , 
    std::move(char_length)
    );
}
void SpeechSynthesisClientInterceptorForTesting::OnEncounteredSentenceBoundary(uint32_t char_index, uint32_t char_length) {
  GetForwardingInterface()->OnEncounteredSentenceBoundary(
    std::move(char_index)
    , 
    std::move(char_length)
    );
}
void SpeechSynthesisClientInterceptorForTesting::OnEncounteredSpeakingError() {
  GetForwardingInterface()->OnEncounteredSpeakingError();
}
SpeechSynthesisClientAsyncWaiter::SpeechSynthesisClientAsyncWaiter(
    SpeechSynthesisClient* proxy) : proxy_(proxy) {}

SpeechSynthesisClientAsyncWaiter::~SpeechSynthesisClientAsyncWaiter() = default;





void SpeechSynthesisInterceptorForTesting::AddVoiceListObserver(::mojo::PendingRemote<SpeechSynthesisVoiceListObserver> observer) {
  GetForwardingInterface()->AddVoiceListObserver(
    std::move(observer)
    );
}
void SpeechSynthesisInterceptorForTesting::Speak(SpeechSynthesisUtterancePtr utterance, ::mojo::PendingRemote<SpeechSynthesisClient> client) {
  GetForwardingInterface()->Speak(
    std::move(utterance)
    , 
    std::move(client)
    );
}
void SpeechSynthesisInterceptorForTesting::Pause() {
  GetForwardingInterface()->Pause();
}
void SpeechSynthesisInterceptorForTesting::Resume() {
  GetForwardingInterface()->Resume();
}
void SpeechSynthesisInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
SpeechSynthesisAsyncWaiter::SpeechSynthesisAsyncWaiter(
    SpeechSynthesis* proxy) : proxy_(proxy) {}

SpeechSynthesisAsyncWaiter::~SpeechSynthesisAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif