// third_party/blink/public/mojom/speech/speech_synthesis.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::SpeechSynthesisErrorCode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SpeechSynthesisErrorCode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeechSynthesisErrorCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SpeechSynthesisErrorCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SpeechSynthesisErrorCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeechSynthesisUtteranceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpeechSynthesisUtteranceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SpeechSynthesisUtterance_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in SpeechSynthesisUtterance struct");

    decltype(Traits::lang(input)) in_lang = Traits::lang(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lang)::BaseType> lang_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_lang,
      lang_fragment);

    fragment->lang.Set(
        lang_fragment.is_null() ? nullptr : lang_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lang.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lang in SpeechSynthesisUtterance struct");

    decltype(Traits::voice(input)) in_voice = Traits::voice(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->voice)::BaseType> voice_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_voice,
      voice_fragment);

    fragment->voice.Set(
        voice_fragment.is_null() ? nullptr : voice_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->voice.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null voice in SpeechSynthesisUtterance struct");

    fragment->volume = Traits::volume(input);

    fragment->rate = Traits::rate(input);

    fragment->pitch = Traits::pitch(input);
  }

  static bool Deserialize(::blink::mojom::internal::SpeechSynthesisUtterance_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SpeechSynthesisUtteranceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeechSynthesisVoiceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpeechSynthesisVoiceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SpeechSynthesisVoice_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::voice_uri(input)) in_voice_uri = Traits::voice_uri(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->voice_uri)::BaseType> voice_uri_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_voice_uri,
      voice_uri_fragment);

    fragment->voice_uri.Set(
        voice_uri_fragment.is_null() ? nullptr : voice_uri_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->voice_uri.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null voice_uri in SpeechSynthesisVoice struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in SpeechSynthesisVoice struct");

    decltype(Traits::lang(input)) in_lang = Traits::lang(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lang)::BaseType> lang_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_lang,
      lang_fragment);

    fragment->lang.Set(
        lang_fragment.is_null() ? nullptr : lang_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lang.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lang in SpeechSynthesisVoice struct");

    fragment->is_local_service = Traits::is_local_service(input);

    fragment->is_default = Traits::is_default(input);
  }

  static bool Deserialize(::blink::mojom::internal::SpeechSynthesisVoice_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SpeechSynthesisVoiceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SpeechSynthesisUtteranceDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SpeechSynthesisUtteranceDataView::GetLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->lang.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SpeechSynthesisUtteranceDataView::GetVoiceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->voice.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SpeechSynthesisVoiceDataView::GetVoiceUriDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->voice_uri.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SpeechSynthesisVoiceDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SpeechSynthesisVoiceDataView::GetLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->lang.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SpeechSynthesisErrorCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SpeechSynthesisErrorCode value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_SHARED_H_