// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-params-data.h"
#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-import-headers.h"
#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-test-utils.h"


namespace blink::mojom {
SpeculationCandidate::SpeculationCandidate()
    : url(),
      action(SpeculationAction::kPrefetch),
      referrer(),
      requires_anonymous_client_ip_when_cross_origin(false),
      target_browsing_context_name_hint(SpeculationTargetHint::kNoHint),
      eagerness(SpeculationEagerness::kConservative),
      no_vary_search_hint(),
      injection_type(SpeculationInjectionType::kNone),
      tags() {}

SpeculationCandidate::SpeculationCandidate(
    const ::GURL& url_in,
    SpeculationAction action_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    bool requires_anonymous_client_ip_when_cross_origin_in,
    SpeculationTargetHint target_browsing_context_name_hint_in,
    SpeculationEagerness eagerness_in,
    ::network::mojom::NoVarySearchPtr no_vary_search_hint_in,
    SpeculationInjectionType injection_type_in,
    std::vector<std::optional<std::string>> tags_in)
    : url(std::move(url_in)),
      action(std::move(action_in)),
      referrer(std::move(referrer_in)),
      requires_anonymous_client_ip_when_cross_origin(std::move(requires_anonymous_client_ip_when_cross_origin_in)),
      target_browsing_context_name_hint(std::move(target_browsing_context_name_hint_in)),
      eagerness(std::move(eagerness_in)),
      no_vary_search_hint(std::move(no_vary_search_hint_in)),
      injection_type(std::move(injection_type_in)),
      tags(std::move(tags_in)) {}

SpeculationCandidate::~SpeculationCandidate() = default;

void SpeculationCandidate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SpeculationAction>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requires_anonymous_client_ip_when_cross_origin"), this->requires_anonymous_client_ip_when_cross_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_browsing_context_name_hint"), this->target_browsing_context_name_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SpeculationTargetHint>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "eagerness"), this->eagerness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SpeculationEagerness>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_vary_search_hint"), this->no_vary_search_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::NoVarySearchPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "injection_type"), this->injection_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SpeculationInjectionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tags"), this->tags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::optional<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpeculationCandidate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SpeculationHost::IPCStableHashFunction SpeculationHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeculationHost>(message.name())) {
    case messages::SpeculationHost::kUpdateSpeculationCandidates: {
      return &SpeculationHost::UpdateSpeculationCandidates_Sym::IPCStableHash;
    }
    case messages::SpeculationHost::kOnLCPPredicted: {
      return &SpeculationHost::OnLCPPredicted_Sym::IPCStableHash;
    }
    case messages::SpeculationHost::kInitiatePreview: {
      return &SpeculationHost::InitiatePreview_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeculationHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeculationHost>(message.name())) {
      case messages::SpeculationHost::kUpdateSpeculationCandidates:
            return "Receive blink::mojom::SpeculationHost::UpdateSpeculationCandidates";
      case messages::SpeculationHost::kOnLCPPredicted:
            return "Receive blink::mojom::SpeculationHost::OnLCPPredicted";
      case messages::SpeculationHost::kInitiatePreview:
            return "Receive blink::mojom::SpeculationHost::InitiatePreview";
    }
  } else {
    switch (static_cast<messages::SpeculationHost>(message.name())) {
      case messages::SpeculationHost::kUpdateSpeculationCandidates:
            return "Receive reply blink::mojom::SpeculationHost::UpdateSpeculationCandidates";
      case messages::SpeculationHost::kOnLCPPredicted:
            return "Receive reply blink::mojom::SpeculationHost::OnLCPPredicted";
      case messages::SpeculationHost::kInitiatePreview:
            return "Receive reply blink::mojom::SpeculationHost::InitiatePreview";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeculationHost::UpdateSpeculationCandidates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e4a6a1a;  // IPCStableHash for blink::mojom::SpeculationHost::UpdateSpeculationCandidates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeculationHost::OnLCPPredicted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73161007;  // IPCStableHash for blink::mojom::SpeculationHost::OnLCPPredicted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeculationHost::InitiatePreview_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4ca75702;  // IPCStableHash for blink::mojom::SpeculationHost::InitiatePreview
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeculationHostProxy::SpeculationHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeculationHostProxy::UpdateSpeculationCandidates(
    std::vector<SpeculationCandidatePtr> in_candidates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SpeculationHost::UpdateSpeculationCandidates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("candidates"), in_candidates,
                        "<value of type std::vector<SpeculationCandidatePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeculationHost::kUpdateSpeculationCandidates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeculationHost_UpdateSpeculationCandidates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->candidates)::BaseType>
      candidates_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& candidates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SpeculationCandidateDataView>>(
    in_candidates,
    candidates_fragment,
    &candidates_validate_params);

  params->candidates.Set(
      candidates_fragment.is_null() ? nullptr : candidates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->candidates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null candidates in SpeculationHost.UpdateSpeculationCandidates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeculationHost::Name_);
  message.set_method_name("UpdateSpeculationCandidates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeculationHostProxy::OnLCPPredicted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SpeculationHost::OnLCPPredicted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeculationHost::kOnLCPPredicted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeculationHost_OnLCPPredicted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeculationHost::Name_);
  message.set_method_name("OnLCPPredicted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeculationHostProxy::InitiatePreview(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SpeculationHost::InitiatePreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeculationHost::kInitiatePreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeculationHost_InitiatePreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in SpeculationHost.InitiatePreview request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeculationHost::Name_);
  message.set_method_name("InitiatePreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeculationHostStubDispatch::Accept(
    SpeculationHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeculationHost>(message->header()->name)) {
    case messages::SpeculationHost::kUpdateSpeculationCandidates: {
      DCHECK(message->is_serialized());
      internal::SpeculationHost_UpdateSpeculationCandidates_Params_Data* params =
          reinterpret_cast<internal::SpeculationHost_UpdateSpeculationCandidates_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeculationHost.0
      bool success = true;
      std::vector<SpeculationCandidatePtr> p_candidates{};
      SpeculationHost_UpdateSpeculationCandidates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCandidates(&p_candidates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeculationHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSpeculationCandidates(        
        std::move(p_candidates));
      return true;
    }
    case messages::SpeculationHost::kOnLCPPredicted: {
      DCHECK(message->is_serialized());
      internal::SpeculationHost_OnLCPPredicted_Params_Data* params =
          reinterpret_cast<internal::SpeculationHost_OnLCPPredicted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeculationHost.1
      bool success = true;
      SpeculationHost_OnLCPPredicted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeculationHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLCPPredicted(        );
      return true;
    }
    case messages::SpeculationHost::kInitiatePreview: {
      DCHECK(message->is_serialized());
      internal::SpeculationHost_InitiatePreview_Params_Data* params =
          reinterpret_cast<internal::SpeculationHost_InitiatePreview_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeculationHost.2
      bool success = true;
      ::GURL p_url{};
      SpeculationHost_InitiatePreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeculationHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitiatePreview(        
        std::move(p_url));
      return true;
    }
  }
  return false;
}

// static
bool SpeculationHostStubDispatch::AcceptWithResponder(
    SpeculationHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeculationHost>(message->header()->name)) {
    case messages::SpeculationHost::kUpdateSpeculationCandidates: {
      break;
    }
    case messages::SpeculationHost::kOnLCPPredicted: {
      break;
    }
    case messages::SpeculationHost::kInitiatePreview: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeculationHostValidationInfo[] = {
    { &internal::SpeculationHost_UpdateSpeculationCandidates_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeculationHost_OnLCPPredicted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeculationHost_InitiatePreview_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeculationHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::SpeculationHost::Name_,
    kSpeculationHostValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::SpeculationCandidate::DataView, ::blink::mojom::SpeculationCandidatePtr>::Read(
    ::blink::mojom::SpeculationCandidate::DataView input,
    ::blink::mojom::SpeculationCandidatePtr* output) {
  bool success = true;
  ::blink::mojom::SpeculationCandidatePtr result(::blink::mojom::SpeculationCandidate::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success)
        result->requires_anonymous_client_ip_when_cross_origin = input.requires_anonymous_client_ip_when_cross_origin();
      if (success && !input.ReadTargetBrowsingContextNameHint(&result->target_browsing_context_name_hint))
        success = false;
      if (success && !input.ReadEagerness(&result->eagerness))
        success = false;
      if (success && !input.ReadNoVarySearchHint(&result->no_vary_search_hint))
        success = false;
      if (success && !input.ReadInjectionType(&result->injection_type))
        success = false;
      if (success && !input.ReadTags(&result->tags))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void SpeculationHostInterceptorForTesting::UpdateSpeculationCandidates(std::vector<SpeculationCandidatePtr> candidates) {
  GetForwardingInterface()->UpdateSpeculationCandidates(
    std::move(candidates)
    );
}
void SpeculationHostInterceptorForTesting::OnLCPPredicted() {
  GetForwardingInterface()->OnLCPPredicted();
}
void SpeculationHostInterceptorForTesting::InitiatePreview(const ::GURL& url) {
  GetForwardingInterface()->InitiatePreview(
    std::move(url)
    );
}
SpeculationHostAsyncWaiter::SpeculationHostAsyncWaiter(
    SpeculationHost* proxy) : proxy_(proxy) {}

SpeculationHostAsyncWaiter::~SpeculationHostAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif