// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SpeculationActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SpeculationAction = {
  
  kPrefetch: 0,
  kPrefetchWithSubresources: 1,
  kPrerender: 2,
  kPrerenderUntilScript: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SpeculationTargetHintSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SpeculationTargetHint = {
  
  kNoHint: 0,
  kBlank: 1,
  kSelf: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SpeculationEagernessSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SpeculationEagerness = {
  
  kConservative: 0,
  kModerate: 1,
  kImmediate: 2,
  kEager: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SpeculationInjectionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SpeculationInjectionType = {
  
  kNone: 0,
  kMainWorldScript: 1,
  kIsolatedWorldScript: 2,
  kAutoSpeculationRules: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SpeculationHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SpeculationHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SpeculationHostInterface }
 */
blink.mojom.SpeculationHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SpeculationHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SpeculationHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SpeculationHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.SpeculationCandidate> } candidates
   */

  updateSpeculationCandidates(
      candidates) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SpeculationHost_UpdateSpeculationCandidates_ParamsSpec.$,
        null,
        [
          candidates
        ],
        false);
  }

  
  /**
   */

  onLCPPredicted() {
    this.proxy.sendMessage(
        1,
        blink.mojom.SpeculationHost_OnLCPPredicted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   */

  initiatePreview(
      url) {
    this.proxy.sendMessage(
        2,
        blink.mojom.SpeculationHost_InitiatePreview_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeculationHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SpeculationHostReceiver = class {
  /**
   * @param {!blink.mojom.SpeculationHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SpeculationHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SpeculationHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SpeculationHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SpeculationHost_UpdateSpeculationCandidates_ParamsSpec.$,
        null,
        impl.updateSpeculationCandidates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SpeculationHost_OnLCPPredicted_ParamsSpec.$,
        null,
        impl.onLCPPredicted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SpeculationHost_InitiatePreview_ParamsSpec.$,
        null,
        impl.initiatePreview.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SpeculationHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SpeculationHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SpeculationHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SpeculationHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeculationHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SpeculationHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SpeculationHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SpeculationHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateSpeculationCandidates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SpeculationHost_UpdateSpeculationCandidates_ParamsSpec.$,
        null,
        this.updateSpeculationCandidates.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLCPPredicted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SpeculationHost_OnLCPPredicted_ParamsSpec.$,
        null,
        this.onLCPPredicted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initiatePreview =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SpeculationHost_InitiatePreview_ParamsSpec.$,
        null,
        this.initiatePreview.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeculationCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeculationHost_UpdateSpeculationCandidates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeculationHost_OnLCPPredicted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SpeculationHost_InitiatePreview_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SpeculationCandidateSpec.$,
    'SpeculationCandidate',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'action', 8,
        0,
        blink.mojom.SpeculationActionSpec.$,
        blink.mojom.SpeculationAction.kPrefetch,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 16,
        0,
        blink.mojom.ReferrerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requiresAnonymousClientIpWhenCrossOrigin', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetBrowsingContextNameHint', 24,
        0,
        blink.mojom.SpeculationTargetHintSpec.$,
        blink.mojom.SpeculationTargetHint.kNoHint,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eagerness', 28,
        0,
        blink.mojom.SpeculationEagernessSpec.$,
        blink.mojom.SpeculationEagerness.kConservative,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'noVarySearchHint', 32,
        0,
        network.mojom.NoVarySearchSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'injectionType', 40,
        0,
        blink.mojom.SpeculationInjectionTypeSpec.$,
        blink.mojom.SpeculationInjectionType.kNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tags', 48,
        0,
        mojo.internal.Array(mojo.internal.String, true),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
blink.mojom.SpeculationCandidate = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !blink.mojom.SpeculationAction } */
    this.action;
    /** @export { !blink.mojom.Referrer } */
    this.referrer;
    /** @export { !boolean } */
    this.requiresAnonymousClientIpWhenCrossOrigin;
    /** @export { !blink.mojom.SpeculationTargetHint } */
    this.targetBrowsingContextNameHint;
    /** @export { !blink.mojom.SpeculationEagerness } */
    this.eagerness;
    /** @export { (network.mojom.NoVarySearch|undefined) } */
    this.noVarySearchHint;
    /** @export { !blink.mojom.SpeculationInjectionType } */
    this.injectionType;
    /** @export { !Array<?string> } */
    this.tags;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeculationHost_UpdateSpeculationCandidates_ParamsSpec.$,
    'SpeculationHost_UpdateSpeculationCandidates_Params',
    [
      mojo.internal.StructField(
        'candidates', 0,
        0,
        mojo.internal.Array(blink.mojom.SpeculationCandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SpeculationHost_UpdateSpeculationCandidates_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.SpeculationCandidate> } */
    this.candidates;
  }
};



mojo.internal.Struct(
    blink.mojom.SpeculationHost_OnLCPPredicted_ParamsSpec.$,
    'SpeculationHost_OnLCPPredicted_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.SpeculationHost_OnLCPPredicted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SpeculationHost_InitiatePreview_ParamsSpec.$,
    'SpeculationHost_InitiatePreview_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SpeculationHost_InitiatePreview_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};

