// third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerStreamCallbackPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerStreamCallback', scope);
  }
}

/** @interface */
export class ServiceWorkerStreamCallbackInterface {
  
  /**
   */

  onCompleted() {}
  
  /**
   */

  onAborted() {}
}

/**
 * @implements { ServiceWorkerStreamCallbackInterface }
 */
export class ServiceWorkerStreamCallbackRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerStreamCallbackPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerStreamCallbackPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerStreamCallbackPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onCompleted() {
    this.proxy.sendMessage(
        0,
        ServiceWorkerStreamCallback_OnCompleted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onAborted() {
    this.proxy.sendMessage(
        1,
        ServiceWorkerStreamCallback_OnAborted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerStreamCallback
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerStreamCallbackReceiver {
  /**
   * @param {!ServiceWorkerStreamCallbackInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerStreamCallbackRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerStreamCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerStreamCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerStreamCallback_OnCompleted_ParamsSpec.$,
        null,
        impl.onCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerStreamCallback_OnAborted_ParamsSpec.$,
        null,
        impl.onAborted.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerStreamCallback {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerStreamCallback";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerStreamCallbackRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerStreamCallbackRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerStreamCallback
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerStreamCallbackCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerStreamCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerStreamCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerStreamCallback_OnCompleted_ParamsSpec.$,
        null,
        this.onCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAborted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerStreamCallback_OnAborted_ParamsSpec.$,
        null,
        this.onAborted.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerStreamHandleSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerStreamCallback_OnCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerStreamCallback_OnAborted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerStreamHandleSpec.$,
    'ServiceWorkerStreamHandle',
    [
      mojo.internal.StructField(
        'stream', 0,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'callbackReceiver', 4,
        0,
        mojo.internal.InterfaceRequest(ServiceWorkerStreamCallbackPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerStreamHandle {
  constructor() {
    /** @type { !MojoHandle } */
    this.stream;
    /** @type { !ServiceWorkerStreamCallbackPendingReceiver } */
    this.callbackReceiver;
  }
}



mojo.internal.Struct(
    ServiceWorkerStreamCallback_OnCompleted_ParamsSpec.$,
    'ServiceWorkerStreamCallback_OnCompleted_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerStreamCallback_OnCompleted_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerStreamCallback_OnAborted_ParamsSpec.$,
    'ServiceWorkerStreamCallback_OnAborted_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerStreamCallback_OnAborted_Params {
  constructor() {
  }
}

