// third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_STREAM_HANDLE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_STREAM_HANDLE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class ServiceWorkerStreamCallbackProxy;

template <typename ImplRefTraits>
class ServiceWorkerStreamCallbackStub;

class ServiceWorkerStreamCallbackRequestValidator;


class PLATFORM_EXPORT ServiceWorkerStreamCallback
    : public ServiceWorkerStreamCallbackInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ServiceWorkerStreamCallback";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerStreamCallbackInterfaceBase;
  using Proxy_ = ServiceWorkerStreamCallbackProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerStreamCallbackStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerStreamCallbackRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCompletedMinVersion = 0,
    kOnAbortedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAborted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerStreamCallback() = default;

  virtual void OnCompleted() = 0;

  virtual void OnAborted() = 0;
};



class PLATFORM_EXPORT ServiceWorkerStreamCallbackProxy
    : public ServiceWorkerStreamCallback {
 public:
  using InterfaceType = ServiceWorkerStreamCallback;

  explicit ServiceWorkerStreamCallbackProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCompleted() final;
  
  void OnAborted() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT ServiceWorkerStreamCallbackStubDispatch {
 public:
  static bool Accept(ServiceWorkerStreamCallback* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerStreamCallback* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerStreamCallback>>
class ServiceWorkerStreamCallbackStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerStreamCallbackStub() = default;
  ~ServiceWorkerStreamCallbackStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStreamCallbackStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStreamCallbackStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT ServiceWorkerStreamCallbackRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT ServiceWorkerStreamHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerStreamHandle, T>::value>;
  using DataView = ServiceWorkerStreamHandleDataView;
  using Data_ = internal::ServiceWorkerStreamHandle_Data;

  template <typename... Args>
  static ServiceWorkerStreamHandlePtr New(Args&&... args) {
    return ServiceWorkerStreamHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerStreamHandlePtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerStreamHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerStreamHandle>::Convert(*this);
  }


  ServiceWorkerStreamHandle();

  ServiceWorkerStreamHandle(
      ::mojo::ScopedDataPipeConsumerHandle stream,
      ::mojo::PendingReceiver<ServiceWorkerStreamCallback> callback_receiver);

ServiceWorkerStreamHandle(const ServiceWorkerStreamHandle&) = delete;
ServiceWorkerStreamHandle& operator=(const ServiceWorkerStreamHandle&) = delete;

  ~ServiceWorkerStreamHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerStreamHandlePtr>
  ServiceWorkerStreamHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerStreamHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerStreamHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerStreamHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerStreamHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerStreamHandle_UnserializedMessageContext<
            UserType, ServiceWorkerStreamHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerStreamHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerStreamHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerStreamHandle_UnserializedMessageContext<
            UserType, ServiceWorkerStreamHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerStreamHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::ScopedDataPipeConsumerHandle stream;
  
  ::mojo::PendingReceiver<ServiceWorkerStreamCallback> callback_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerStreamHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerStreamHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerStreamHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerStreamHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerStreamHandlePtr ServiceWorkerStreamHandle::Clone() const {
  return New(
      mojo::Clone(stream),
      mojo::Clone(callback_receiver)
  );
}

template <typename T, ServiceWorkerStreamHandle::EnableIfSame<T>*>
bool ServiceWorkerStreamHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stream, other_struct.stream))
    return false;
  if (!mojo::Equals(this->callback_receiver, other_struct.callback_receiver))
    return false;
  return true;
}

template <typename T, ServiceWorkerStreamHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stream < rhs.stream)
    return true;
  if (rhs.stream < lhs.stream)
    return false;
  if (lhs.callback_receiver < rhs.callback_receiver)
    return true;
  if (rhs.callback_receiver < lhs.callback_receiver)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ServiceWorkerStreamHandle::DataView,
                                         ::blink::mojom::blink::ServiceWorkerStreamHandlePtr> {
  static bool IsNull(const ::blink::mojom::blink::ServiceWorkerStreamHandlePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ServiceWorkerStreamHandlePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::ServiceWorkerStreamHandle::stream)& stream(
       ::blink::mojom::blink::ServiceWorkerStreamHandlePtr& input) {
    return input->stream;
  }

  static  decltype(::blink::mojom::blink::ServiceWorkerStreamHandle::callback_receiver)& callback_receiver(
       ::blink::mojom::blink::ServiceWorkerStreamHandlePtr& input) {
    return input->callback_receiver;
  }

  static bool Read(::blink::mojom::blink::ServiceWorkerStreamHandle::DataView input, ::blink::mojom::blink::ServiceWorkerStreamHandlePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_STREAM_HANDLE_MOJOM_BLINK_H_