// third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-import-headers.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-test-utils.h"


namespace blink::mojom {
ServiceWorkerRouterRunningStatusCondition::ServiceWorkerRouterRunningStatusCondition()
    : status() {}

ServiceWorkerRouterRunningStatusCondition::ServiceWorkerRouterRunningStatusCondition(
    ServiceWorkerRouterRunningStatusEnum status_in)
    : status(std::move(status_in)) {}

ServiceWorkerRouterRunningStatusCondition::~ServiceWorkerRouterRunningStatusCondition() = default;
size_t ServiceWorkerRouterRunningStatusCondition::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->status);
  return seed;
}

void ServiceWorkerRouterRunningStatusCondition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerRouterRunningStatusEnum>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterRunningStatusCondition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterRequestCondition::ServiceWorkerRouterRequestCondition()
    : method(),
      has_mode(false),
      mode(),
      has_destination(false),
      destination() {}

ServiceWorkerRouterRequestCondition::ServiceWorkerRouterRequestCondition(
    const std::optional<std::string>& method_in,
    bool has_mode_in,
    ::network::mojom::RequestMode mode_in,
    bool has_destination_in,
    ::network::mojom::RequestDestination destination_in)
    : method(std::move(method_in)),
      has_mode(std::move(has_mode_in)),
      mode(std::move(mode_in)),
      has_destination(std::move(has_destination_in)),
      destination(std::move(destination_in)) {}

ServiceWorkerRouterRequestCondition::~ServiceWorkerRouterRequestCondition() = default;

void ServiceWorkerRouterRequestCondition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_mode"), this->has_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::RequestMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_destination"), this->has_destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination"), this->destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::RequestDestination>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterRequestCondition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterOrCondition::ServiceWorkerRouterOrCondition()
    : conditions() {}

ServiceWorkerRouterOrCondition::ServiceWorkerRouterOrCondition(
    std::vector<ServiceWorkerRouterConditionPtr> conditions_in)
    : conditions(std::move(conditions_in)) {}

ServiceWorkerRouterOrCondition::~ServiceWorkerRouterOrCondition() = default;

void ServiceWorkerRouterOrCondition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conditions"), this->conditions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ServiceWorkerRouterConditionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterOrCondition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterNotCondition::ServiceWorkerRouterNotCondition()
    : condition() {}

ServiceWorkerRouterNotCondition::ServiceWorkerRouterNotCondition(
    ServiceWorkerRouterConditionPtr condition_in)
    : condition(std::move(condition_in)) {}

ServiceWorkerRouterNotCondition::~ServiceWorkerRouterNotCondition() = default;

void ServiceWorkerRouterNotCondition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "condition"), this->condition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerRouterConditionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterNotCondition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterCondition::ServiceWorkerRouterCondition()
    : url_pattern(),
      request(),
      running_status(),
      or_condition(),
      not_condition() {}

ServiceWorkerRouterCondition::ServiceWorkerRouterCondition(
    const std::optional<::blink::SafeUrlPattern>& url_pattern_in,
    ServiceWorkerRouterRequestConditionPtr request_in,
    ServiceWorkerRouterRunningStatusConditionPtr running_status_in,
    ServiceWorkerRouterOrConditionPtr or_condition_in,
    ServiceWorkerRouterNotConditionPtr not_condition_in)
    : url_pattern(std::move(url_pattern_in)),
      request(std::move(request_in)),
      running_status(std::move(running_status_in)),
      or_condition(std::move(or_condition_in)),
      not_condition(std::move(not_condition_in)) {}

ServiceWorkerRouterCondition::~ServiceWorkerRouterCondition() = default;

void ServiceWorkerRouterCondition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_pattern"), this->url_pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::SafeUrlPattern>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request"), this->request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerRouterRequestConditionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "running_status"), this->running_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerRouterRunningStatusConditionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "or_condition"), this->or_condition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerRouterOrConditionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "not_condition"), this->not_condition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerRouterNotConditionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterCondition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterNetworkSource::ServiceWorkerRouterNetworkSource() {}

ServiceWorkerRouterNetworkSource::~ServiceWorkerRouterNetworkSource() = default;
size_t ServiceWorkerRouterNetworkSource::Hash(size_t seed) const {
  return seed;
}

void ServiceWorkerRouterNetworkSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool ServiceWorkerRouterNetworkSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterRaceNetworkAndFetchEventSource::ServiceWorkerRouterRaceNetworkAndFetchEventSource() {}

ServiceWorkerRouterRaceNetworkAndFetchEventSource::~ServiceWorkerRouterRaceNetworkAndFetchEventSource() = default;
size_t ServiceWorkerRouterRaceNetworkAndFetchEventSource::Hash(size_t seed) const {
  return seed;
}

void ServiceWorkerRouterRaceNetworkAndFetchEventSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool ServiceWorkerRouterRaceNetworkAndFetchEventSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterFetchEventSource::ServiceWorkerRouterFetchEventSource() {}

ServiceWorkerRouterFetchEventSource::~ServiceWorkerRouterFetchEventSource() = default;
size_t ServiceWorkerRouterFetchEventSource::Hash(size_t seed) const {
  return seed;
}

void ServiceWorkerRouterFetchEventSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool ServiceWorkerRouterFetchEventSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterCacheSource::ServiceWorkerRouterCacheSource()
    : cache_name() {}

ServiceWorkerRouterCacheSource::ServiceWorkerRouterCacheSource(
    const std::optional<std::string>& cache_name_in)
    : cache_name(std::move(cache_name_in)) {}

ServiceWorkerRouterCacheSource::~ServiceWorkerRouterCacheSource() = default;

void ServiceWorkerRouterCacheSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_name"), this->cache_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterCacheSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterRaceNetworkAndCacheSource::ServiceWorkerRouterRaceNetworkAndCacheSource()
    : cache_source() {}

ServiceWorkerRouterRaceNetworkAndCacheSource::ServiceWorkerRouterRaceNetworkAndCacheSource(
    ServiceWorkerRouterCacheSourcePtr cache_source_in)
    : cache_source(std::move(cache_source_in)) {}

ServiceWorkerRouterRaceNetworkAndCacheSource::~ServiceWorkerRouterRaceNetworkAndCacheSource() = default;

void ServiceWorkerRouterRaceNetworkAndCacheSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_source"), this->cache_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerRouterCacheSourcePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterRaceNetworkAndCacheSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterRule::ServiceWorkerRouterRule()
    : condition(),
      sources() {}

ServiceWorkerRouterRule::ServiceWorkerRouterRule(
    ServiceWorkerRouterConditionPtr condition_in,
    std::vector<ServiceWorkerRouterSourcePtr> sources_in)
    : condition(std::move(condition_in)),
      sources(std::move(sources_in)) {}

ServiceWorkerRouterRule::~ServiceWorkerRouterRule() = default;

void ServiceWorkerRouterRule::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "condition"), this->condition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ServiceWorkerRouterConditionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sources"), this->sources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ServiceWorkerRouterSourcePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterRule::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterRules::ServiceWorkerRouterRules()
    : rules() {}

ServiceWorkerRouterRules::ServiceWorkerRouterRules(
    std::vector<ServiceWorkerRouterRulePtr> rules_in)
    : rules(std::move(rules_in)) {}

ServiceWorkerRouterRules::~ServiceWorkerRouterRules() = default;

void ServiceWorkerRouterRules::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rules"), this->rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ServiceWorkerRouterRulePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRouterSourcePtr
ServiceWorkerRouterSource::NewNetworkSource(
    ServiceWorkerRouterNetworkSourcePtr value) {
  return ServiceWorkerRouterSourcePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNetworkSource)>,
      std::move(value));
}

ServiceWorkerRouterSourcePtr
ServiceWorkerRouterSource::NewRaceNetworkAndFetchEventSource(
    ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr value) {
  return ServiceWorkerRouterSourcePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRaceNetworkAndFetchEventSource)>,
      std::move(value));
}

ServiceWorkerRouterSourcePtr
ServiceWorkerRouterSource::NewFetchEventSource(
    ServiceWorkerRouterFetchEventSourcePtr value) {
  return ServiceWorkerRouterSourcePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFetchEventSource)>,
      std::move(value));
}

ServiceWorkerRouterSourcePtr
ServiceWorkerRouterSource::NewCacheSource(
    ServiceWorkerRouterCacheSourcePtr value) {
  return ServiceWorkerRouterSourcePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCacheSource)>,
      std::move(value));
}

ServiceWorkerRouterSourcePtr
ServiceWorkerRouterSource::NewRaceNetworkAndCacheSource(
    ServiceWorkerRouterRaceNetworkAndCacheSourcePtr value) {
  return ServiceWorkerRouterSourcePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRaceNetworkAndCacheSource)>,
      std::move(value));
}

ServiceWorkerRouterSource::ServiceWorkerRouterSource(
    std::in_place_index_t<static_cast<size_t>(Tag::kNetworkSource)>,
    ServiceWorkerRouterNetworkSourcePtr value)
    : tag_(Tag::kNetworkSource),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNetworkSource)>,
            std::move(value)) {}

ServiceWorkerRouterSource::ServiceWorkerRouterSource(
    std::in_place_index_t<static_cast<size_t>(Tag::kRaceNetworkAndFetchEventSource)>,
    ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr value)
    : tag_(Tag::kRaceNetworkAndFetchEventSource),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRaceNetworkAndFetchEventSource)>,
            std::move(value)) {}

ServiceWorkerRouterSource::ServiceWorkerRouterSource(
    std::in_place_index_t<static_cast<size_t>(Tag::kFetchEventSource)>,
    ServiceWorkerRouterFetchEventSourcePtr value)
    : tag_(Tag::kFetchEventSource),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFetchEventSource)>,
            std::move(value)) {}

ServiceWorkerRouterSource::ServiceWorkerRouterSource(
    std::in_place_index_t<static_cast<size_t>(Tag::kCacheSource)>,
    ServiceWorkerRouterCacheSourcePtr value)
    : tag_(Tag::kCacheSource),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCacheSource)>,
            std::move(value)) {}

ServiceWorkerRouterSource::ServiceWorkerRouterSource(
    std::in_place_index_t<static_cast<size_t>(Tag::kRaceNetworkAndCacheSource)>,
    ServiceWorkerRouterRaceNetworkAndCacheSourcePtr value)
    : tag_(Tag::kRaceNetworkAndCacheSource),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRaceNetworkAndCacheSource)>,
            std::move(value)) {}
ServiceWorkerRouterSource::~ServiceWorkerRouterSource() {
  DestroyActive();
}

void ServiceWorkerRouterSource::set_network_source(ServiceWorkerRouterNetworkSourcePtr network_source) {
  if (tag_ == Tag::kNetworkSource) {
    data_.network_source = std::move(network_source);
  } else {
    DestroyActive();
    tag_ = Tag::kNetworkSource;
    new (&data_.network_source) ServiceWorkerRouterNetworkSourcePtr(
        std::move(network_source));
  }
}

void ServiceWorkerRouterSource::set_race_network_and_fetch_event_source(ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr race_network_and_fetch_event_source) {
  if (tag_ == Tag::kRaceNetworkAndFetchEventSource) {
    data_.race_network_and_fetch_event_source = std::move(race_network_and_fetch_event_source);
  } else {
    DestroyActive();
    tag_ = Tag::kRaceNetworkAndFetchEventSource;
    new (&data_.race_network_and_fetch_event_source) ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr(
        std::move(race_network_and_fetch_event_source));
  }
}

void ServiceWorkerRouterSource::set_fetch_event_source(ServiceWorkerRouterFetchEventSourcePtr fetch_event_source) {
  if (tag_ == Tag::kFetchEventSource) {
    data_.fetch_event_source = std::move(fetch_event_source);
  } else {
    DestroyActive();
    tag_ = Tag::kFetchEventSource;
    new (&data_.fetch_event_source) ServiceWorkerRouterFetchEventSourcePtr(
        std::move(fetch_event_source));
  }
}

void ServiceWorkerRouterSource::set_cache_source(ServiceWorkerRouterCacheSourcePtr cache_source) {
  if (tag_ == Tag::kCacheSource) {
    data_.cache_source = std::move(cache_source);
  } else {
    DestroyActive();
    tag_ = Tag::kCacheSource;
    new (&data_.cache_source) ServiceWorkerRouterCacheSourcePtr(
        std::move(cache_source));
  }
}

void ServiceWorkerRouterSource::set_race_network_and_cache_source(ServiceWorkerRouterRaceNetworkAndCacheSourcePtr race_network_and_cache_source) {
  if (tag_ == Tag::kRaceNetworkAndCacheSource) {
    data_.race_network_and_cache_source = std::move(race_network_and_cache_source);
  } else {
    DestroyActive();
    tag_ = Tag::kRaceNetworkAndCacheSource;
    new (&data_.race_network_and_cache_source) ServiceWorkerRouterRaceNetworkAndCacheSourcePtr(
        std::move(race_network_and_cache_source));
  }
}


ServiceWorkerRouterSource::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNetworkSource)>,
    ServiceWorkerRouterNetworkSourcePtr value)
    : network_source(std::move(value)) {}

ServiceWorkerRouterSource::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRaceNetworkAndFetchEventSource)>,
    ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr value)
    : race_network_and_fetch_event_source(std::move(value)) {}

ServiceWorkerRouterSource::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFetchEventSource)>,
    ServiceWorkerRouterFetchEventSourcePtr value)
    : fetch_event_source(std::move(value)) {}

ServiceWorkerRouterSource::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCacheSource)>,
    ServiceWorkerRouterCacheSourcePtr value)
    : cache_source(std::move(value)) {}

ServiceWorkerRouterSource::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRaceNetworkAndCacheSource)>,
    ServiceWorkerRouterRaceNetworkAndCacheSourcePtr value)
    : race_network_and_cache_source(std::move(value)) {}

void ServiceWorkerRouterSource::DestroyActive() {
  switch (tag_) {

    case Tag::kNetworkSource:
      std::destroy_at(&data_.network_source);
      break;
    case Tag::kRaceNetworkAndFetchEventSource:
      std::destroy_at(&data_.race_network_and_fetch_event_source);
      break;
    case Tag::kFetchEventSource:
      std::destroy_at(&data_.fetch_event_source);
      break;
    case Tag::kCacheSource:
      std::destroy_at(&data_.cache_source);
      break;
    case Tag::kRaceNetworkAndCacheSource:
      std::destroy_at(&data_.race_network_and_cache_source);
      break;
  }
}

bool ServiceWorkerRouterSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterRunningStatusCondition::DataView, ::blink::mojom::ServiceWorkerRouterRunningStatusConditionPtr>::Read(
    ::blink::mojom::ServiceWorkerRouterRunningStatusCondition::DataView input,
    ::blink::mojom::ServiceWorkerRouterRunningStatusConditionPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterRunningStatusConditionPtr result(::blink::mojom::ServiceWorkerRouterRunningStatusCondition::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterRequestCondition::DataView, ::blink::mojom::ServiceWorkerRouterRequestConditionPtr>::Read(
    ::blink::mojom::ServiceWorkerRouterRequestCondition::DataView input,
    ::blink::mojom::ServiceWorkerRouterRequestConditionPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterRequestConditionPtr result(::blink::mojom::ServiceWorkerRouterRequestCondition::New());
  
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success)
        result->has_mode = input.has_mode();
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success)
        result->has_destination = input.has_destination();
      if (success && !input.ReadDestination(&result->destination))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterOrCondition::DataView, ::blink::mojom::ServiceWorkerRouterOrConditionPtr>::Read(
    ::blink::mojom::ServiceWorkerRouterOrCondition::DataView input,
    ::blink::mojom::ServiceWorkerRouterOrConditionPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterOrConditionPtr result(::blink::mojom::ServiceWorkerRouterOrCondition::New());
  
      if (success && !input.ReadConditions(&result->conditions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterNotCondition::DataView, ::blink::mojom::ServiceWorkerRouterNotConditionPtr>::Read(
    ::blink::mojom::ServiceWorkerRouterNotCondition::DataView input,
    ::blink::mojom::ServiceWorkerRouterNotConditionPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterNotConditionPtr result(::blink::mojom::ServiceWorkerRouterNotCondition::New());
  
      if (success && !input.ReadCondition(&result->condition))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterCondition::DataView, ::blink::mojom::ServiceWorkerRouterConditionPtr>::Read(
    ::blink::mojom::ServiceWorkerRouterCondition::DataView input,
    ::blink::mojom::ServiceWorkerRouterConditionPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterConditionPtr result(::blink::mojom::ServiceWorkerRouterCondition::New());
  
      if (success && !input.ReadUrlPattern(&result->url_pattern))
        success = false;
      if (success && !input.ReadRequest(&result->request))
        success = false;
      if (success && !input.ReadRunningStatus(&result->running_status))
        success = false;
      if (success && !input.ReadOrCondition(&result->or_condition))
        success = false;
      if (success && !input.ReadNotCondition(&result->not_condition))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterNetworkSource::DataView, ::blink::mojom::ServiceWorkerRouterNetworkSourcePtr>::Read(
    ::blink::mojom::ServiceWorkerRouterNetworkSource::DataView input,
    ::blink::mojom::ServiceWorkerRouterNetworkSourcePtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterNetworkSourcePtr result(::blink::mojom::ServiceWorkerRouterNetworkSource::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView, ::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr>::Read(
    ::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSource::DataView input,
    ::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr result(::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSource::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterFetchEventSource::DataView, ::blink::mojom::ServiceWorkerRouterFetchEventSourcePtr>::Read(
    ::blink::mojom::ServiceWorkerRouterFetchEventSource::DataView input,
    ::blink::mojom::ServiceWorkerRouterFetchEventSourcePtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterFetchEventSourcePtr result(::blink::mojom::ServiceWorkerRouterFetchEventSource::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterCacheSource::DataView, ::blink::mojom::ServiceWorkerRouterCacheSourcePtr>::Read(
    ::blink::mojom::ServiceWorkerRouterCacheSource::DataView input,
    ::blink::mojom::ServiceWorkerRouterCacheSourcePtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterCacheSourcePtr result(::blink::mojom::ServiceWorkerRouterCacheSource::New());
  
      if (success && !input.ReadCacheName(&result->cache_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSource::DataView, ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr>::Read(
    ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSource::DataView input,
    ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr result(::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSource::New());
  
      if (success && !input.ReadCacheSource(&result->cache_source))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterRule::DataView, ::blink::mojom::ServiceWorkerRouterRulePtr>::Read(
    ::blink::mojom::ServiceWorkerRouterRule::DataView input,
    ::blink::mojom::ServiceWorkerRouterRulePtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterRulePtr result(::blink::mojom::ServiceWorkerRouterRule::New());
  
      if (success && !input.ReadCondition(&result->condition))
        success = false;
      if (success && !input.ReadSources(&result->sources))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRouterRules::DataView, ::blink::mojom::ServiceWorkerRouterRulesPtr>::Read(
    ::blink::mojom::ServiceWorkerRouterRules::DataView input,
    ::blink::mojom::ServiceWorkerRouterRulesPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRouterRulesPtr result(::blink::mojom::ServiceWorkerRouterRules::New());
  
      if (success && !input.ReadRules(&result->rules))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::ServiceWorkerRouterSource::DataView, ::blink::mojom::ServiceWorkerRouterSourcePtr>::Read(
    ::blink::mojom::ServiceWorkerRouterSource::DataView input,
    ::blink::mojom::ServiceWorkerRouterSourcePtr* output) {
  using UnionType = ::blink::mojom::ServiceWorkerRouterSource;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNetworkSource: {
      ::blink::mojom::ServiceWorkerRouterNetworkSourcePtr result_network_source{};
      if (!input.ReadNetworkSource(&result_network_source))
        return false;

      *output = UnionType::NewNetworkSource(
          std::move(result_network_source));
      break;
    }
    case Tag::kRaceNetworkAndFetchEventSource: {
      ::blink::mojom::ServiceWorkerRouterRaceNetworkAndFetchEventSourcePtr result_race_network_and_fetch_event_source{};
      if (!input.ReadRaceNetworkAndFetchEventSource(&result_race_network_and_fetch_event_source))
        return false;

      *output = UnionType::NewRaceNetworkAndFetchEventSource(
          std::move(result_race_network_and_fetch_event_source));
      break;
    }
    case Tag::kFetchEventSource: {
      ::blink::mojom::ServiceWorkerRouterFetchEventSourcePtr result_fetch_event_source{};
      if (!input.ReadFetchEventSource(&result_fetch_event_source))
        return false;

      *output = UnionType::NewFetchEventSource(
          std::move(result_fetch_event_source));
      break;
    }
    case Tag::kCacheSource: {
      ::blink::mojom::ServiceWorkerRouterCacheSourcePtr result_cache_source{};
      if (!input.ReadCacheSource(&result_cache_source))
        return false;

      *output = UnionType::NewCacheSource(
          std::move(result_cache_source));
      break;
    }
    case Tag::kRaceNetworkAndCacheSource: {
      ::blink::mojom::ServiceWorkerRouterRaceNetworkAndCacheSourcePtr result_race_network_and_cache_source{};
      if (!input.ReadRaceNetworkAndCacheSource(&result_race_network_and_cache_source))
        return false;

      *output = UnionType::NewRaceNetworkAndCacheSource(
          std::move(result_race_network_and_cache_source));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {




}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif