// third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.ServiceWorkerErrorType');
goog.require('blink.mojom.ServiceWorkerUpdateViaCache');
goog.require('blink.mojom.FetchClientSettingsObject');
goog.require('blink.mojom.NavigationPreloadState');
goog.require('blink.mojom.ServiceWorkerObjectInfo');
goog.require('url.mojom.Url');






goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHostReceiver');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHostCallbackRouter');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHostInterface');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHostRemote');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerRegistrationObjectHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ServiceWorkerRegistrationObjectHostInterface = class {
  
  /**
   * @param { !blink.mojom.FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  update(outsideFetchClientSettingsObject) {}
  
  /**
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  unregister() {}
  
  /**
   * @param { !boolean } enable
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  enableNavigationPreload(enable) {}
  
  /**
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
        state: ?blink.mojom.NavigationPreloadState,
   *  }>}
   */

  getNavigationPreloadState() {}
  
  /**
   * @param { !string } value
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  setNavigationPreloadHeader(value) {}
};

/**
 * @export
 * @implements { blink.mojom.ServiceWorkerRegistrationObjectHostInterface }
 */
blink.mojom.ServiceWorkerRegistrationObjectHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerRegistrationObjectHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerRegistrationObjectHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerRegistrationObjectHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  update(
      outsideFetchClientSettingsObject) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec.$,
        [
          outsideFetchClientSettingsObject
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  unregister() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  enableNavigationPreload(
      enable) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec.$,
        [
          enable
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
        state: ?blink.mojom.NavigationPreloadState,
   *  }>}
   */

  getNavigationPreloadState() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  setNavigationPreloadHeader(
      value) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerRegistrationObjectHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHostReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerRegistrationObjectHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerRegistrationObjectHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerRegistrationObjectHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerRegistrationObjectHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec.$,
        impl.update.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec.$,
        impl.unregister.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec.$,
        impl.enableNavigationPreload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec.$,
        impl.getNavigationPreloadState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec.$,
        impl.setNavigationPreloadHeader.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerRegistrationObjectHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerRegistrationObjectHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerRegistrationObjectHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerRegistrationObjectHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerRegistrationObjectHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerRegistrationObjectHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.update =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec.$,
        this.update.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unregister =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec.$,
        this.unregister.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableNavigationPreload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec.$,
        this.enableNavigationPreload.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNavigationPreloadState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec.$,
        this.getNavigationPreloadState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNavigationPreloadHeader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec.$,
        blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec.$,
        this.setNavigationPreloadHeader.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ServiceWorkerRegistrationObject');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectReceiver');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectCallbackRouter');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectInterface');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectRemote');
goog.provide('blink.mojom.ServiceWorkerRegistrationObjectPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerRegistrationObject.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ServiceWorkerRegistrationObjectInterface = class {
  
  /**
   * @param { !blink.mojom.ChangedServiceWorkerObjectsMask } changedMask
   * @param { ?blink.mojom.ServiceWorkerObjectInfo } installing
   * @param { ?blink.mojom.ServiceWorkerObjectInfo } waiting
   * @param { ?blink.mojom.ServiceWorkerObjectInfo } active
   */

  setServiceWorkerObjects(changedMask, installing, waiting, active) {}
  
  /**
   * @param { !blink.mojom.ServiceWorkerUpdateViaCache } updateViaCache
   */

  setUpdateViaCache(updateViaCache) {}
  
  /**
   */

  updateFound() {}
};

/**
 * @export
 * @implements { blink.mojom.ServiceWorkerRegistrationObjectInterface }
 */
blink.mojom.ServiceWorkerRegistrationObjectRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerRegistrationObjectPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerRegistrationObjectPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerRegistrationObjectPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.ChangedServiceWorkerObjectsMask } changedMask
   * @param { ?blink.mojom.ServiceWorkerObjectInfo } installing
   * @param { ?blink.mojom.ServiceWorkerObjectInfo } waiting
   * @param { ?blink.mojom.ServiceWorkerObjectInfo } active
   */

  setServiceWorkerObjects(
      changedMask,
      installing,
      waiting,
      active) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec.$,
        null,
        [
          changedMask,
          installing,
          waiting,
          active
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ServiceWorkerUpdateViaCache } updateViaCache
   */

  setUpdateViaCache(
      updateViaCache) {
    this.proxy.sendMessage(
        1,
        blink.mojom.ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec.$,
        null,
        [
          updateViaCache
        ],
        false);
  }

  
  /**
   */

  updateFound() {
    this.proxy.sendMessage(
        2,
        blink.mojom.ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerRegistrationObject
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerRegistrationObjectInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerRegistrationObjectRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerRegistrationObjectRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerRegistrationObjectRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec.$,
        null,
        impl.setServiceWorkerObjects.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec.$,
        null,
        impl.setUpdateViaCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec.$,
        null,
        impl.updateFound.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerRegistrationObject = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerRegistrationObject";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerRegistrationObjectRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerRegistrationObjectRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerRegistrationObject
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerRegistrationObjectRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerRegistrationObjectRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setServiceWorkerObjects =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec.$,
        null,
        this.setServiceWorkerObjects.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUpdateViaCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec.$,
        null,
        this.setUpdateViaCache.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateFound =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec.$,
        null,
        this.updateFound.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ChangedServiceWorkerObjectsMaskSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ChangedServiceWorkerObjectsMaskSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ChangedServiceWorkerObjectsMaskSpec.$,
    'ChangedServiceWorkerObjectsMask',
    [
      mojo.internal.StructField(
        'installing', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'waiting', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'active', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ChangedServiceWorkerObjectsMask');

/** @record */
blink.mojom.ChangedServiceWorkerObjectsMask = class {
  constructor() {
    /** @export { !boolean } */
    this.installing;
    /** @export { !boolean } */
    this.waiting;
    /** @export { !boolean } */
    this.active;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectInfoSpec.$,
    'ServiceWorkerRegistrationObjectInfo',
    [
      mojo.internal.StructField(
        'registrationId', 0,
        0,
        mojo.internal.Int64,
        blink.mojom.INVALID_SERVICE_WORKER_REGISTRATION_ID,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scope', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updateViaCache', 16,
        0,
        blink.mojom.ServiceWorkerUpdateViaCacheSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostRemote', 20,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.ServiceWorkerRegistrationObjectHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 28,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.ServiceWorkerRegistrationObjectPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'installing', 32,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'waiting', 40,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'active', 48,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectInfo');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectInfo = class {
  constructor() {
    /** @export { !bigint } */
    this.registrationId;
    /** @export { !url.mojom.Url } */
    this.scope;
    /** @export { !blink.mojom.ServiceWorkerUpdateViaCache } */
    this.updateViaCache;
    /** @export { !Object } */
    this.hostRemote;
    /** @export { !Object } */
    this.receiver;
    /** @export { (blink.mojom.ServiceWorkerObjectInfo|undefined) } */
    this.installing;
    /** @export { (blink.mojom.ServiceWorkerObjectInfo|undefined) } */
    this.waiting;
    /** @export { (blink.mojom.ServiceWorkerObjectInfo|undefined) } */
    this.active;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_Update_Params',
    [
      mojo.internal.StructField(
        'outsideFetchClientSettingsObject', 0,
        0,
        blink.mojom.FetchClientSettingsObjectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_Update_Params');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_Update_Params = class {
  constructor() {
    /** @export { !blink.mojom.FetchClientSettingsObject } */
    this.outsideFetchClientSettingsObject;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_Update_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ServiceWorkerErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_Update_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerErrorType } */
    this.error;
    /** @export { (string|undefined) } */
    this.errorMsg;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_Unregister_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_Params');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ServiceWorkerErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerErrorType } */
    this.error;
    /** @export { (string|undefined) } */
    this.errorMsg;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enable;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ServiceWorkerErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerErrorType } */
    this.error;
    /** @export { (string|undefined) } */
    this.errorMsg;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ServiceWorkerErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'state', 16,
        0,
        blink.mojom.NavigationPreloadStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerErrorType } */
    this.error;
    /** @export { (string|undefined) } */
    this.errorMsg;
    /** @export { (blink.mojom.NavigationPreloadState|undefined) } */
    this.state;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsSpec.$,
    'ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ServiceWorkerErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerErrorType } */
    this.error;
    /** @export { (string|undefined) } */
    this.errorMsg;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsSpec.$,
    'ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params',
    [
      mojo.internal.StructField(
        'changedMask', 0,
        0,
        blink.mojom.ChangedServiceWorkerObjectsMaskSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'installing', 8,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'waiting', 16,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'active', 24,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params');

/** @record */
blink.mojom.ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params = class {
  constructor() {
    /** @export { !blink.mojom.ChangedServiceWorkerObjectsMask } */
    this.changedMask;
    /** @export { (blink.mojom.ServiceWorkerObjectInfo|undefined) } */
    this.installing;
    /** @export { (blink.mojom.ServiceWorkerObjectInfo|undefined) } */
    this.waiting;
    /** @export { (blink.mojom.ServiceWorkerObjectInfo|undefined) } */
    this.active;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsSpec.$,
    'ServiceWorkerRegistrationObject_SetUpdateViaCache_Params',
    [
      mojo.internal.StructField(
        'updateViaCache', 0,
        0,
        blink.mojom.ServiceWorkerUpdateViaCacheSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObject_SetUpdateViaCache_Params');

/** @record */
blink.mojom.ServiceWorkerRegistrationObject_SetUpdateViaCache_Params = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerUpdateViaCache } */
    this.updateViaCache;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerRegistrationObject_UpdateFound_ParamsSpec.$,
    'ServiceWorkerRegistrationObject_UpdateFound_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerRegistrationObject_UpdateFound_Params');

/** @record */
blink.mojom.ServiceWorkerRegistrationObject_UpdateFound_Params = class {
  constructor() {
  }
};

