// third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  DataElementChunkedDataPipe as network_mojom_DataElementChunkedDataPipe,
  DataElementChunkedDataPipeSpec as network_mojom_DataElementChunkedDataPipeSpec
} from '../../../../../services/network/public/mojom/url_request.mojom.m.js';

import {
  FetchAPIResponse as blink_mojom_FetchAPIResponse,
  FetchAPIResponseSpec as blink_mojom_FetchAPIResponseSpec
} from '../fetch/fetch_api_response.mojom.m.js';

import {
  ServiceWorkerStreamHandle as blink_mojom_ServiceWorkerStreamHandle,
  ServiceWorkerStreamHandleSpec as blink_mojom_ServiceWorkerStreamHandleSpec
} from './service_worker_stream_handle.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerFetchResponseCallbackPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerFetchResponseCallback', scope);
  }
}

/** @interface */
export class ServiceWorkerFetchResponseCallbackInterface {
  
  /**
   * @param { !blink_mojom_FetchAPIResponse } response
   * @param { !ServiceWorkerFetchEventTiming } timing
   */

  onResponse(response, timing) {}
  
  /**
   * @param { !blink_mojom_FetchAPIResponse } response
   * @param { !blink_mojom_ServiceWorkerStreamHandle } bodyAsStream
   * @param { !ServiceWorkerFetchEventTiming } timing
   */

  onResponseStream(response, bodyAsStream, timing) {}
  
  /**
   * @param { ?network_mojom_DataElementChunkedDataPipe } requestBody
   * @param { !ServiceWorkerFetchEventTiming } timing
   */

  onFallback(requestBody, timing) {}
}

/**
 * @implements { ServiceWorkerFetchResponseCallbackInterface }
 */
export class ServiceWorkerFetchResponseCallbackRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerFetchResponseCallbackPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerFetchResponseCallbackPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerFetchResponseCallbackPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_FetchAPIResponse } response
   * @param { !ServiceWorkerFetchEventTiming } timing
   */

  onResponse(
      response,
      timing) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec.$,
        null,
        [
          response,
          timing
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FetchAPIResponse } response
   * @param { !blink_mojom_ServiceWorkerStreamHandle } bodyAsStream
   * @param { !ServiceWorkerFetchEventTiming } timing
   */

  onResponseStream(
      response,
      bodyAsStream,
      timing) {
    this.proxy.sendMessage(
        1,
        ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec.$,
        null,
        [
          response,
          bodyAsStream,
          timing
        ],
        false);
  }

  
  /**
   * @param { ?network_mojom_DataElementChunkedDataPipe } requestBody
   * @param { !ServiceWorkerFetchEventTiming } timing
   */

  onFallback(
      requestBody,
      timing) {
    this.proxy.sendMessage(
        2,
        ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec.$,
        null,
        [
          requestBody,
          timing
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerFetchResponseCallback
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerFetchResponseCallbackReceiver {
  /**
   * @param {!ServiceWorkerFetchResponseCallbackInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerFetchResponseCallbackRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerFetchResponseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerFetchResponseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec.$,
        null,
        impl.onResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec.$,
        null,
        impl.onResponseStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec.$,
        null,
        impl.onFallback.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerFetchResponseCallback {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerFetchResponseCallback";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerFetchResponseCallbackRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerFetchResponseCallbackRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerFetchResponseCallback
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerFetchResponseCallbackCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerFetchResponseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerFetchResponseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec.$,
        null,
        this.onResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponseStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec.$,
        null,
        this.onResponseStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec.$,
        null,
        this.onFallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerFetchEventTimingSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerFetchEventTimingSpec.$,
    'ServiceWorkerFetchEventTiming',
    [
      mojo.internal.StructField(
        'dispatchEventTime', 0,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'respondWithSettledTime', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerFetchEventTiming {
  constructor() {
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.dispatchEventTime;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.respondWithSettledTime;
  }
}



mojo.internal.Struct(
    ServiceWorkerFetchResponseCallback_OnResponse_ParamsSpec.$,
    'ServiceWorkerFetchResponseCallback_OnResponse_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        blink_mojom_FetchAPIResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timing', 8,
        0,
        ServiceWorkerFetchEventTimingSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerFetchResponseCallback_OnResponse_Params {
  constructor() {
    /** @type { !blink_mojom_FetchAPIResponse } */
    this.response;
    /** @type { !ServiceWorkerFetchEventTiming } */
    this.timing;
  }
}



mojo.internal.Struct(
    ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsSpec.$,
    'ServiceWorkerFetchResponseCallback_OnResponseStream_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        blink_mojom_FetchAPIResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bodyAsStream', 8,
        0,
        blink_mojom_ServiceWorkerStreamHandleSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timing', 16,
        0,
        ServiceWorkerFetchEventTimingSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerFetchResponseCallback_OnResponseStream_Params {
  constructor() {
    /** @type { !blink_mojom_FetchAPIResponse } */
    this.response;
    /** @type { !blink_mojom_ServiceWorkerStreamHandle } */
    this.bodyAsStream;
    /** @type { !ServiceWorkerFetchEventTiming } */
    this.timing;
  }
}



mojo.internal.Struct(
    ServiceWorkerFetchResponseCallback_OnFallback_ParamsSpec.$,
    'ServiceWorkerFetchResponseCallback_OnFallback_Params',
    [
      mojo.internal.StructField(
        'requestBody', 0,
        0,
        network_mojom_DataElementChunkedDataPipeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timing', 8,
        0,
        ServiceWorkerFetchEventTimingSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerFetchResponseCallback_OnFallback_Params {
  constructor() {
    /** @type { (network_mojom_DataElementChunkedDataPipe|undefined) } */
    this.requestBody;
    /** @type { !ServiceWorkerFetchEventTiming } */
    this.timing;
  }
}

