// third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"


namespace blink::mojom::blink {
ServiceWorkerFetchEventTiming::ServiceWorkerFetchEventTiming()
    : dispatch_event_time(),
      respond_with_settled_time() {}

ServiceWorkerFetchEventTiming::ServiceWorkerFetchEventTiming(
    ::base::TimeTicks dispatch_event_time_in,
    ::base::TimeTicks respond_with_settled_time_in)
    : dispatch_event_time(std::move(dispatch_event_time_in)),
      respond_with_settled_time(std::move(respond_with_settled_time_in)) {}

ServiceWorkerFetchEventTiming::~ServiceWorkerFetchEventTiming() = default;

void ServiceWorkerFetchEventTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dispatch_event_time"), this->dispatch_event_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "respond_with_settled_time"), this->respond_with_settled_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerFetchEventTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ServiceWorkerFetchResponseCallback::IPCStableHashFunction ServiceWorkerFetchResponseCallback::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerFetchResponseCallback>(message.name())) {
    case messages::ServiceWorkerFetchResponseCallback::kOnResponse: {
      return &ServiceWorkerFetchResponseCallback::OnResponse_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerFetchResponseCallback::kOnResponseStream: {
      return &ServiceWorkerFetchResponseCallback::OnResponseStream_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerFetchResponseCallback::kOnFallback: {
      return &ServiceWorkerFetchResponseCallback::OnFallback_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerFetchResponseCallback::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerFetchResponseCallback>(message.name())) {
      case messages::ServiceWorkerFetchResponseCallback::kOnResponse:
            return "Receive blink::mojom::ServiceWorkerFetchResponseCallback::OnResponse";
      case messages::ServiceWorkerFetchResponseCallback::kOnResponseStream:
            return "Receive blink::mojom::ServiceWorkerFetchResponseCallback::OnResponseStream";
      case messages::ServiceWorkerFetchResponseCallback::kOnFallback:
            return "Receive blink::mojom::ServiceWorkerFetchResponseCallback::OnFallback";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerFetchResponseCallback>(message.name())) {
      case messages::ServiceWorkerFetchResponseCallback::kOnResponse:
            return "Receive reply blink::mojom::ServiceWorkerFetchResponseCallback::OnResponse";
      case messages::ServiceWorkerFetchResponseCallback::kOnResponseStream:
            return "Receive reply blink::mojom::ServiceWorkerFetchResponseCallback::OnResponseStream";
      case messages::ServiceWorkerFetchResponseCallback::kOnFallback:
            return "Receive reply blink::mojom::ServiceWorkerFetchResponseCallback::OnFallback";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerFetchResponseCallback::OnResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb277b2e9;  // IPCStableHash for blink::mojom::ServiceWorkerFetchResponseCallback::OnResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerFetchResponseCallback::OnResponseStream_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x94faefd0;  // IPCStableHash for blink::mojom::ServiceWorkerFetchResponseCallback::OnResponseStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerFetchResponseCallback::OnFallback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f3d2bbd;  // IPCStableHash for blink::mojom::ServiceWorkerFetchResponseCallback::OnFallback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceWorkerFetchResponseCallbackProxy::ServiceWorkerFetchResponseCallbackProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerFetchResponseCallbackProxy::OnResponse(
    ::blink::mojom::blink::FetchAPIResponsePtr in_response, ServiceWorkerFetchEventTimingPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerFetchResponseCallback::OnResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type ::blink::mojom::blink::FetchAPIResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ServiceWorkerFetchEventTimingPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerFetchResponseCallback::kOnResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerFetchResponseCallback_OnResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ServiceWorkerFetchResponseCallback.OnResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchEventTimingDataView>(
    in_timing,
    timing_fragment);

  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timing in ServiceWorkerFetchResponseCallback.OnResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerFetchResponseCallback::Name_);
  message.set_method_name("OnResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerFetchResponseCallbackProxy::OnResponseStream(
    ::blink::mojom::blink::FetchAPIResponsePtr in_response, ::blink::mojom::blink::ServiceWorkerStreamHandlePtr in_body_as_stream, ServiceWorkerFetchEventTimingPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerFetchResponseCallback::OnResponseStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type ::blink::mojom::blink::FetchAPIResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("body_as_stream"), in_body_as_stream,
                        "<value of type ::blink::mojom::blink::ServiceWorkerStreamHandlePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ServiceWorkerFetchEventTimingPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerFetchResponseCallback::kOnResponseStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerFetchResponseCallback_OnResponseStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ServiceWorkerFetchResponseCallback.OnResponseStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->body_as_stream)::BaseType> body_as_stream_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerStreamHandleDataView>(
    in_body_as_stream,
    body_as_stream_fragment);

  params->body_as_stream.Set(
      body_as_stream_fragment.is_null() ? nullptr : body_as_stream_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->body_as_stream.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null body_as_stream in ServiceWorkerFetchResponseCallback.OnResponseStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchEventTimingDataView>(
    in_timing,
    timing_fragment);

  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timing in ServiceWorkerFetchResponseCallback.OnResponseStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerFetchResponseCallback::Name_);
  message.set_method_name("OnResponseStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerFetchResponseCallbackProxy::OnFallback(
    std::optional<::network::DataElementChunkedDataPipe> in_request_body, ServiceWorkerFetchEventTimingPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerFetchResponseCallback::OnFallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_body"), in_request_body,
                        "<value of type std::optional<::network::DataElementChunkedDataPipe>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ServiceWorkerFetchEventTimingPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerFetchResponseCallback::kOnFallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerFetchResponseCallback_OnFallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_body)::BaseType> request_body_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::DataElementChunkedDataPipeDataView>(
    in_request_body,
    request_body_fragment);

  params->request_body.Set(
      request_body_fragment.is_null() ? nullptr : request_body_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchEventTimingDataView>(
    in_timing,
    timing_fragment);

  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timing in ServiceWorkerFetchResponseCallback.OnFallback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerFetchResponseCallback::Name_);
  message.set_method_name("OnFallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ServiceWorkerFetchResponseCallbackStubDispatch::Accept(
    ServiceWorkerFetchResponseCallback* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerFetchResponseCallback>(message->header()->name)) {
    case messages::ServiceWorkerFetchResponseCallback::kOnResponse: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerFetchResponseCallback_OnResponse_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerFetchResponseCallback_OnResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerFetchResponseCallback.0
      bool success = true;
      ::blink::mojom::blink::FetchAPIResponsePtr p_response{};
      ServiceWorkerFetchEventTimingPtr p_timing{};
      ServiceWorkerFetchResponseCallback_OnResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerFetchResponseCallback::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponse(        
        std::move(p_response), 
        std::move(p_timing));
      return true;
    }
    case messages::ServiceWorkerFetchResponseCallback::kOnResponseStream: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerFetchResponseCallback_OnResponseStream_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerFetchResponseCallback_OnResponseStream_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerFetchResponseCallback.1
      bool success = true;
      ::blink::mojom::blink::FetchAPIResponsePtr p_response{};
      ::blink::mojom::blink::ServiceWorkerStreamHandlePtr p_body_as_stream{};
      ServiceWorkerFetchEventTimingPtr p_timing{};
      ServiceWorkerFetchResponseCallback_OnResponseStream_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (success && !input_data_view.ReadBodyAsStream(&p_body_as_stream))
        success = false;
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerFetchResponseCallback::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponseStream(        
        std::move(p_response), 
        std::move(p_body_as_stream), 
        std::move(p_timing));
      return true;
    }
    case messages::ServiceWorkerFetchResponseCallback::kOnFallback: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerFetchResponseCallback_OnFallback_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerFetchResponseCallback_OnFallback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerFetchResponseCallback.2
      bool success = true;
      std::optional<::network::DataElementChunkedDataPipe> p_request_body{};
      ServiceWorkerFetchEventTimingPtr p_timing{};
      ServiceWorkerFetchResponseCallback_OnFallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestBody(&p_request_body))
        success = false;
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerFetchResponseCallback::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFallback(        
        std::move(p_request_body), 
        std::move(p_timing));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerFetchResponseCallbackStubDispatch::AcceptWithResponder(
    ServiceWorkerFetchResponseCallback* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerFetchResponseCallback>(message->header()->name)) {
    case messages::ServiceWorkerFetchResponseCallback::kOnResponse: {
      break;
    }
    case messages::ServiceWorkerFetchResponseCallback::kOnResponseStream: {
      break;
    }
    case messages::ServiceWorkerFetchResponseCallback::kOnFallback: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerFetchResponseCallbackValidationInfo[] = {
    { &internal::ServiceWorkerFetchResponseCallback_OnResponse_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerFetchResponseCallback_OnResponseStream_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerFetchResponseCallback_OnFallback_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerFetchResponseCallbackRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorkerFetchResponseCallback::Name_,
    kServiceWorkerFetchResponseCallbackValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ServiceWorkerFetchEventTiming::DataView, ::blink::mojom::blink::ServiceWorkerFetchEventTimingPtr>::Read(
    ::blink::mojom::blink::ServiceWorkerFetchEventTiming::DataView input,
    ::blink::mojom::blink::ServiceWorkerFetchEventTimingPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerFetchEventTimingPtr result(::blink::mojom::blink::ServiceWorkerFetchEventTiming::New());
  
      if (success && !input.ReadDispatchEventTime(&result->dispatch_event_time))
        success = false;
      if (success && !input.ReadRespondWithSettledTime(&result->respond_with_settled_time))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ServiceWorkerFetchResponseCallbackInterceptorForTesting::OnResponse(::blink::mojom::blink::FetchAPIResponsePtr response, ServiceWorkerFetchEventTimingPtr timing) {
  GetForwardingInterface()->OnResponse(
    std::move(response)
    , 
    std::move(timing)
    );
}
void ServiceWorkerFetchResponseCallbackInterceptorForTesting::OnResponseStream(::blink::mojom::blink::FetchAPIResponsePtr response, ::blink::mojom::blink::ServiceWorkerStreamHandlePtr body_as_stream, ServiceWorkerFetchEventTimingPtr timing) {
  GetForwardingInterface()->OnResponseStream(
    std::move(response)
    , 
    std::move(body_as_stream)
    , 
    std::move(timing)
    );
}
void ServiceWorkerFetchResponseCallbackInterceptorForTesting::OnFallback(std::optional<::network::DataElementChunkedDataPipe> request_body, ServiceWorkerFetchEventTimingPtr timing) {
  GetForwardingInterface()->OnFallback(
    std::move(request_body)
    , 
    std::move(timing)
    );
}
ServiceWorkerFetchResponseCallbackAsyncWaiter::ServiceWorkerFetchResponseCallbackAsyncWaiter(
    ServiceWorkerFetchResponseCallback* proxy) : proxy_(proxy) {}

ServiceWorkerFetchResponseCallbackAsyncWaiter::~ServiceWorkerFetchResponseCallbackAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif