// third_party/blink/public/mojom/service_worker/service_worker.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-blink.h"
#include "third_party/blink/renderer/core/core_export.h"


namespace blink::mojom::blink {


class CORE_EXPORT ServiceWorkerHostInterceptorForTesting : public ServiceWorkerHost {
  virtual ServiceWorkerHost* GetForwardingInterface() = 0;
  void SetCachedMetadata(const ::blink::KURL& url, ::base::span<const ::uint8_t> data) override;
  void ClearCachedMetadata(const ::blink::KURL& url) override;
  void GetClients(::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr options, GetClientsCallback callback) override;
  void GetClient(const ::blink::String& client_uuid, GetClientCallback callback) override;
  void OpenNewTab(const ::blink::KURL& url, OpenNewTabCallback callback) override;
  void OpenPaymentHandlerWindow(const ::blink::KURL& url, OpenPaymentHandlerWindowCallback callback) override;
  void PostMessageToClient(const ::blink::String& client_uuid, ::blink::BlinkTransferableMessage message) override;
  void FocusClient(const ::blink::String& client_uuid, FocusClientCallback callback) override;
  void NavigateClient(const ::blink::String& client_uuid, const ::blink::KURL& url, NavigateClientCallback callback) override;
  void SkipWaiting(SkipWaitingCallback callback) override;
  void ClaimClients(ClaimClientsCallback callback) override;
  void AddRoutes(const ::blink::ServiceWorkerRouterRules& rules, AddRoutesCallback callback) override;
};
class CORE_EXPORT ServiceWorkerHostAsyncWaiter {
 public:
  explicit ServiceWorkerHostAsyncWaiter(ServiceWorkerHost* proxy);

  ServiceWorkerHostAsyncWaiter(const ServiceWorkerHostAsyncWaiter&) = delete;
  ServiceWorkerHostAsyncWaiter& operator=(const ServiceWorkerHostAsyncWaiter&) = delete;

  ~ServiceWorkerHostAsyncWaiter();
  void GetClients(
      ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr options, ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr>* out_clients);
  ::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr> GetClients(::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr options);
  void GetClient(
      const ::blink::String& client_uuid, ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client);
  ::blink::mojom::blink::ServiceWorkerClientInfoPtr GetClient(const ::blink::String& client_uuid);
  void OpenNewTab(
      const ::blink::KURL& url, bool* out_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client, ::blink::String* out_error_msg);
  
  void OpenPaymentHandlerWindow(
      const ::blink::KURL& url, bool* out_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client, ::blink::String* out_error_msg);
  
  void FocusClient(
      const ::blink::String& client_uuid, FocusResultPtr* out_result);
  FocusResultPtr FocusClient(const ::blink::String& client_uuid);
  void NavigateClient(
      const ::blink::String& client_uuid, const ::blink::KURL& url, bool* out_success, ::blink::mojom::blink::ServiceWorkerClientInfoPtr* out_client, ::blink::String* out_error_msg);
  
  void SkipWaiting(
      bool* out_success);
  bool SkipWaiting();
  void ClaimClients(
      ::blink::mojom::blink::ServiceWorkerErrorType* out_error, ::blink::String* out_error_msg);
  
  void AddRoutes(
      const ::blink::ServiceWorkerRouterRules& rules, bool* out_is_parse_error);
  bool AddRoutes(const ::blink::ServiceWorkerRouterRules& rules);

 private:
  ServiceWorkerHost* const proxy_;
};


class CORE_EXPORT ServiceWorkerInterceptorForTesting : public ServiceWorker {
  virtual ServiceWorker* GetForwardingInterface() = 0;
  void InitializeGlobalScope(::mojo::PendingAssociatedRemote<ServiceWorkerHost> service_worker_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::AssociatedInterfaceProvider> associated_interfaces_to_browser, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::AssociatedInterfaceProvider> associated_interfaces_from_browser, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr registration_info, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr service_worker_info, FetchHandlerExistence fetch_handler_existence, ::blink::mojom::blink::AncestorFrameType ancestor_frame_type, const ::blink::BlinkStorageKey& storage_key) override;
  void DispatchInstallEvent(DispatchInstallEventCallback callback) override;
  void DispatchActivateEvent(DispatchActivateEventCallback callback) override;
  void DispatchBackgroundFetchAbortEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchAbortEventCallback callback) override;
  void DispatchBackgroundFetchClickEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchClickEventCallback callback) override;
  void DispatchBackgroundFetchFailEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchFailEventCallback callback) override;
  void DispatchBackgroundFetchSuccessEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchSuccessEventCallback callback) override;
  void DispatchCookieChangeEvent(::network::mojom::blink::CookieChangeInfoPtr change, DispatchCookieChangeEventCallback callback) override;
  void DispatchFetchEventForMainResource(::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForMainResourceCallback callback) override;
  void DispatchNotificationClickEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, int32_t action_index, const ::blink::String& reply, DispatchNotificationClickEventCallback callback) override;
  void DispatchNotificationCloseEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, DispatchNotificationCloseEventCallback callback) override;
  void DispatchPushEvent(const ::blink::String& payload, DispatchPushEventCallback callback) override;
  void DispatchPushEventRecordingNetworkRequests(const ::blink::String& payload, DispatchPushEventRecordingNetworkRequestsCallback callback) override;
  void DispatchPushSubscriptionChangeEvent(::blink::mojom::blink::PushSubscriptionPtr old_subscription, ::blink::mojom::blink::PushSubscriptionPtr new_subscription, DispatchPushSubscriptionChangeEventCallback callback) override;
  void DispatchSyncEvent(const ::blink::String& tag, bool last_chance, ::base::TimeDelta timeout, DispatchSyncEventCallback callback) override;
  void DispatchPeriodicSyncEvent(const ::blink::String& tag, ::base::TimeDelta timeout, DispatchPeriodicSyncEventCallback callback) override;
  void DispatchAbortPaymentEvent(::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_abort_payment, DispatchAbortPaymentEventCallback callback) override;
  void DispatchCanMakePaymentEvent(::payments::mojom::blink::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_can_make_payment, DispatchCanMakePaymentEventCallback callback) override;
  void DispatchPaymentRequestEvent(::payments::mojom::blink::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> response_callback, DispatchPaymentRequestEventCallback callback) override;
  void DispatchExtendableMessageEvent(ExtendableMessageEventPtr event, DispatchExtendableMessageEventCallback callback) override;
  void DispatchContentDeleteEvent(const ::blink::String& id, DispatchContentDeleteEventCallback callback) override;
  void Ping(PingCallback callback) override;
  void SetIdleDelay(::base::TimeDelta delay) override;
  void AddKeepAlive() override;
  void ClearKeepAlive() override;
  void AddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel level, const ::blink::String& message) override;
  void ExecuteScriptForTest(const ::blink::String& javascript, bool wants_result, ExecuteScriptForTestCallback callback) override;
};
class CORE_EXPORT ServiceWorkerAsyncWaiter {
 public:
  explicit ServiceWorkerAsyncWaiter(ServiceWorker* proxy);

  ServiceWorkerAsyncWaiter(const ServiceWorkerAsyncWaiter&) = delete;
  ServiceWorkerAsyncWaiter& operator=(const ServiceWorkerAsyncWaiter&) = delete;

  ~ServiceWorkerAsyncWaiter();
  void DispatchInstallEvent(
      ::blink::mojom::blink::ServiceWorkerEventStatus* out_status, uint32_t* out_fetch_count);
  
  void DispatchActivateEvent(
      ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchActivateEvent();
  void DispatchBackgroundFetchAbortEvent(
      ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchBackgroundFetchAbortEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration);
  void DispatchBackgroundFetchClickEvent(
      ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchBackgroundFetchClickEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration);
  void DispatchBackgroundFetchFailEvent(
      ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchBackgroundFetchFailEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration);
  void DispatchBackgroundFetchSuccessEvent(
      ::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchBackgroundFetchSuccessEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration);
  void DispatchCookieChangeEvent(
      ::network::mojom::blink::CookieChangeInfoPtr change, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchCookieChangeEvent(::network::mojom::blink::CookieChangeInfoPtr change);
  void DispatchFetchEventForMainResource(
      ::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchFetchEventForMainResource(::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback);
  void DispatchNotificationClickEvent(
      const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, int32_t action_index, const ::blink::String& reply, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchNotificationClickEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, int32_t action_index, const ::blink::String& reply);
  void DispatchNotificationCloseEvent(
      const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchNotificationCloseEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data);
  void DispatchPushEvent(
      const ::blink::String& payload, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchPushEvent(const ::blink::String& payload);
  void DispatchPushEventRecordingNetworkRequests(
      const ::blink::String& payload, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status, std::optional<::blink::Vector<::blink::KURL>>* out_requested_urls);
  
  void DispatchPushSubscriptionChangeEvent(
      ::blink::mojom::blink::PushSubscriptionPtr old_subscription, ::blink::mojom::blink::PushSubscriptionPtr new_subscription, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchPushSubscriptionChangeEvent(::blink::mojom::blink::PushSubscriptionPtr old_subscription, ::blink::mojom::blink::PushSubscriptionPtr new_subscription);
  void DispatchSyncEvent(
      const ::blink::String& tag, bool last_chance, ::base::TimeDelta timeout, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchSyncEvent(const ::blink::String& tag, bool last_chance, ::base::TimeDelta timeout);
  void DispatchPeriodicSyncEvent(
      const ::blink::String& tag, ::base::TimeDelta timeout, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchPeriodicSyncEvent(const ::blink::String& tag, ::base::TimeDelta timeout);
  void DispatchAbortPaymentEvent(
      ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_abort_payment, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchAbortPaymentEvent(::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_abort_payment);
  void DispatchCanMakePaymentEvent(
      ::payments::mojom::blink::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_can_make_payment, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchCanMakePaymentEvent(::payments::mojom::blink::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_can_make_payment);
  void DispatchPaymentRequestEvent(
      ::payments::mojom::blink::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> response_callback, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchPaymentRequestEvent(::payments::mojom::blink::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> response_callback);
  void DispatchExtendableMessageEvent(
      ExtendableMessageEventPtr event, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchExtendableMessageEvent(ExtendableMessageEventPtr event);
  void DispatchContentDeleteEvent(
      const ::blink::String& id, ::blink::mojom::blink::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::blink::ServiceWorkerEventStatus DispatchContentDeleteEvent(const ::blink::String& id);
  void Ping(
      );
  
  void ExecuteScriptForTest(
      const ::blink::String& javascript, bool wants_result, ::base::Value* out_result, ::blink::String* out_error);
  

 private:
  ServiceWorker* const proxy_;
};




}  // blink::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_BLINK_TEST_UTILS_H_