// third_party/blink/public/mojom/service_worker/embedded_worker.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-shared.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preference_watcher.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/subresource_loader_updater.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/worker_content_settings_proxy.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class EmbeddedWorkerStartParamsDataView;

class EmbeddedWorkerStartTimingDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::EmbeddedWorkerStartParamsDataView> {
  using Data = ::blink::mojom::internal::EmbeddedWorkerStartParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EmbeddedWorkerStartTimingDataView> {
  using Data = ::blink::mojom::internal::EmbeddedWorkerStartTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class EmbeddedWorkerInstanceClientInterfaceBase {};

using EmbeddedWorkerInstanceClientPtrDataView =
    mojo::InterfacePtrDataView<EmbeddedWorkerInstanceClientInterfaceBase>;
using EmbeddedWorkerInstanceClientRequestDataView =
    mojo::InterfaceRequestDataView<EmbeddedWorkerInstanceClientInterfaceBase>;
using EmbeddedWorkerInstanceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<EmbeddedWorkerInstanceClientInterfaceBase>;
using EmbeddedWorkerInstanceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<EmbeddedWorkerInstanceClientInterfaceBase>;
class EmbeddedWorkerInstanceHostInterfaceBase {};

using EmbeddedWorkerInstanceHostPtrDataView =
    mojo::InterfacePtrDataView<EmbeddedWorkerInstanceHostInterfaceBase>;
using EmbeddedWorkerInstanceHostRequestDataView =
    mojo::InterfaceRequestDataView<EmbeddedWorkerInstanceHostInterfaceBase>;
using EmbeddedWorkerInstanceHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<EmbeddedWorkerInstanceHostInterfaceBase>;
using EmbeddedWorkerInstanceHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<EmbeddedWorkerInstanceHostInterfaceBase>;


class EmbeddedWorkerStartParamsDataView {
 public:
  EmbeddedWorkerStartParamsDataView() = default;

  EmbeddedWorkerStartParamsDataView(
      internal::EmbeddedWorkerStartParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t service_worker_version_id() const {
    return data_->service_worker_version_id;
  }
  inline void GetScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetScriptUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptUrl(UserType* output) {
    
    auto* pointer = data_->script_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScriptType(UserType* output) const {
    auto data_value = data_->script_type;
    return mojo::internal::Deserialize<::blink::mojom::ScriptType>(
        data_value, output);
  }
  ::blink::mojom::ScriptType script_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScriptType>(data_->script_type));
  }
  inline void GetOutsideFetchClientSettingsObjectDataView(
      ::blink::mojom::FetchClientSettingsObjectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutsideFetchClientSettingsObject(UserType* output) {
    
    auto* pointer = data_->outside_fetch_client_settings_object.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchClientSettingsObjectDataView>(
        pointer, output, message_);
  }
  inline void GetUserAgentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserAgent(UserType* output) {
    
    auto* pointer = data_->user_agent.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUaMetadataDataView(
      ::blink::mojom::UserAgentMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUaMetadata(UserType* output) {
    
    auto* pointer = data_->ua_metadata.Get();
    return mojo::internal::Deserialize<::blink::mojom::UserAgentMetadataDataView>(
        pointer, output, message_);
  }
  int32_t service_worker_route_id() const {
    return data_->service_worker_route_id;
  }
  inline void GetDevtoolsWorkerTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsWorkerToken(UserType* output) {
    
    auto* pointer = data_->devtools_worker_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetScriptUrlToSkipThrottlingDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptUrlToSkipThrottling(UserType* output) {
    
    auto* pointer = data_->script_url_to_skip_throttling.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool wait_for_debugger() const {
    return data_->wait_for_debugger;
  }
  bool is_installed() const {
    return data_->is_installed;
  }
  inline void GetRendererPreferencesDataView(
      ::blink::mojom::RendererPreferencesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererPreferences(UserType* output) {
    
    auto* pointer = data_->renderer_preferences.Get();
    return mojo::internal::Deserialize<::blink::mojom::RendererPreferencesDataView>(
        pointer, output, message_);
  }
  inline void GetForcedEnabledRuntimeFeaturesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadForcedEnabledRuntimeFeatures(UserType* output) {
    
    auto* pointer = data_->forced_enabled_runtime_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeServiceWorkerReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::ServiceWorkerInterfaceBase>>(
            &data_->service_worker_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeInterfaceProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::service_manager::mojom::InterfaceProviderInterfaceBase>>(
            &data_->interface_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeControllerReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
            &data_->controller_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetInstalledScriptsInfoDataView(
      ::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstalledScriptsInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView, UserType>(),
    "Attempting to read the optional `installed_scripts_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInstalledScriptsInfo` instead "
    "of `ReadInstalledScriptsInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->installed_scripts_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeInstanceHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::EmbeddedWorkerInstanceHostAssociatedPtrInfoDataView>(
            &data_->instance_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetProviderInfoDataView(
      ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProviderInfo(UserType* output) {
    
    auto* pointer = data_->provider_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerProviderInfoForStartWorkerDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeContentSettingsProxy() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::WorkerContentSettingsProxyInterfaceBase>>(
            &data_->content_settings_proxy, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakePreferenceWatcherReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::RendererPreferenceWatcherInterfaceBase>>(
            &data_->preference_watcher_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetSubresourceLoaderFactoriesDataView(
      ::blink::mojom::URLLoaderFactoryBundleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubresourceLoaderFactories(UserType* output) {
    
    auto* pointer = data_->subresource_loader_factories.Get();
    return mojo::internal::Deserialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeSubresourceLoaderUpdater() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::SubresourceLoaderUpdaterInterfaceBase>>(
            &data_->subresource_loader_updater, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetServiceWorkerTokenDataView(
      ::blink::mojom::ServiceWorkerTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerToken(UserType* output) {
    
    auto* pointer = data_->service_worker_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerTokenDataView>(
        pointer, output, message_);
  }
  int64_t ukm_source_id() const {
    return data_->ukm_source_id;
  }
  inline void GetMainScriptLoadParamsDataView(
      ::blink::mojom::WorkerMainScriptLoadParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainScriptLoadParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::WorkerMainScriptLoadParamsDataView, UserType>(),
    "Attempting to read the optional `main_script_load_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMainScriptLoadParams` instead "
    "of `ReadMainScriptLoadParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->main_script_load_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::WorkerMainScriptLoadParamsDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyContainerDataView(
      ::blink::mojom::PolicyContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PolicyContainerDataView, UserType>(),
    "Attempting to read the optional `policy_container` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPolicyContainer` instead "
    "of `ReadPolicyContainer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->policy_container.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerDataView>(
        pointer, output, message_);
  }
  inline void GetStorageKeyDataView(
      ::blink::mojom::StorageKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorageKey(UserType* output) {
    
    auto* pointer = data_->storage_key.Get();
    return mojo::internal::Deserialize<::blink::mojom::StorageKeyDataView>(
        pointer, output, message_);
  }
  inline void GetCorsExemptHeaderListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsExemptHeaderList(UserType* output) {
    
    auto* pointer = data_->cors_exempt_header_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCoepReportingObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
            &data_->coep_reporting_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDipReportingObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
            &data_->dip_reporting_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetCanvasNoiseTokenDataView(
      ::blink::mojom::NoiseTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCanvasNoiseToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::NoiseTokenDataView, UserType>(),
    "Attempting to read the optional `canvas_noise_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCanvasNoiseToken` instead "
    "of `ReadCanvasNoiseToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->canvas_noise_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::NoiseTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::EmbeddedWorkerStartParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EmbeddedWorkerStartTimingDataView {
 public:
  EmbeddedWorkerStartTimingDataView() = default;

  EmbeddedWorkerStartTimingDataView(
      internal::EmbeddedWorkerStartTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStartWorkerReceivedTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartWorkerReceivedTime(UserType* output) {
    
    auto* pointer = data_->start_worker_received_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetScriptEvaluationStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptEvaluationStartTime(UserType* output) {
    
    auto* pointer = data_->script_evaluation_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetScriptEvaluationEndTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptEvaluationEndTime(UserType* output) {
    
    auto* pointer = data_->script_evaluation_end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::EmbeddedWorkerStartTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_DATA_VIEW_H_