// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/service_worker/controller_service_worker.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var cross_origin_embedder_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cross_origin_embedder_policy.mojom', '../../../../../services/network/public/mojom/cross_origin_embedder_policy.mojom.js');
  }
  var document_isolation_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/document_isolation_policy.mojom', '../../../../../services/network/public/mojom/document_isolation_policy.mojom.js');
  }
  var cache_storage$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/cache_storage/cache_storage.mojom', '../cache_storage/cache_storage.mojom.js');
  }
  var controller_service_worker_mode$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/controller_service_worker_mode.mojom', 'controller_service_worker_mode.mojom.js');
  }
  var dispatch_fetch_event_params$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom', 'dispatch_fetch_event_params.mojom.js');
  }
  var service_worker_embedded_worker_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_embedded_worker_status.mojom', 'service_worker_embedded_worker_status.mojom.js');
  }
  var service_worker_event_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom', 'service_worker_event_status.mojom.js');
  }
  var service_worker_fetch_handler_bypass_option$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_bypass_option.mojom', 'service_worker_fetch_handler_bypass_option.mojom.js');
  }
  var service_worker_fetch_handler_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom', 'service_worker_fetch_handler_type.mojom.js');
  }
  var service_worker_fetch_response_callback$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom', 'service_worker_fetch_response_callback.mojom.js');
  }
  var service_worker_object$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_object.mojom', 'service_worker_object.mojom.js');
  }
  var service_worker_router_rule$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom', 'service_worker_router_rule.mojom.js');
  }
  var web_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom', '../use_counter/metrics/web_feature.mojom.js');
  }
  var service_worker_running_status_callback$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_running_status_callback.mojom', 'service_worker_running_status_callback.mojom.js');
  }



  function ServiceWorkerRouterData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterData.prototype.initDefaults_ = function() {
    this.routerRules = null;
    this.initial_running_status_$flag = false;
    this.initial_running_status_$value = 0;
    this.runningStatusReceiver = new bindings.InterfaceRequest();
    this.remoteCacheStorage = new cache_storage$.CacheStoragePtr();
  };
  ServiceWorkerRouterData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterData.routerRules
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, service_worker_router_rule$.ServiceWorkerRouterRules, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ServiceWorkerRouterData.initial_running_status_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, service_worker_embedded_worker_status$.ServiceWorkerEmbeddedWorkerStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterData.runningStatusReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterData.remoteCacheStorage
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 20, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterData.encodedSize = codec.kStructHeaderSize + 32;

  ServiceWorkerRouterData.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.routerRules =
        decoder.decodeStructPointer(service_worker_router_rule$.ServiceWorkerRouterRules);
    packed = decoder.readUint8();
    val.initial_running_status_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.initial_running_status_$value =
        decoder.decodeStruct(new codec.Enum(service_worker_embedded_worker_status$.ServiceWorkerEmbeddedWorkerStatus));
    val.runningStatusReceiver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    val.remoteCacheStorage =
        decoder.decodeStruct(new codec.Interface(cache_storage$.CacheStoragePtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerRouterData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(service_worker_router_rule$.ServiceWorkerRouterRules, val.routerRules);
    packed = 0;
    packed |= (val.initial_running_status_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.initial_running_status_$value);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.runningStatusReceiver);
    encoder.encodeStruct(new codec.Interface(cache_storage$.CacheStoragePtr), val.remoteCacheStorage);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ControllerServiceWorkerInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ControllerServiceWorkerInfo.prototype.initDefaults_ = function() {
    this.mode = controller_service_worker_mode$.ControllerServiceWorkerMode.kNoController;
    this.fetchHandlerType = service_worker_fetch_handler_type$.ServiceWorkerFetchHandlerType.kNoHandler;
    this.fetchHandlerBypassOption = service_worker_fetch_handler_bypass_option$.ServiceWorkerFetchHandlerBypassOption.kDefault;
    this.needRouterEvaluate = false;
    this.sha256ScriptChecksum = null;
    this.routerData = null;
    this.remoteController = new ControllerServiceWorkerPtr();
    this.clientId = null;
    this.fetchRequestWindowId = null;
    this.objectInfo = null;
    this.usedFeatures = null;
  };
  ControllerServiceWorkerInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ControllerServiceWorkerInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerInfo.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, controller_service_worker_mode$.ControllerServiceWorkerMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerInfo.fetchHandlerType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, service_worker_fetch_handler_type$.ServiceWorkerFetchHandlerType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerInfo.fetchHandlerBypassOption
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, service_worker_fetch_handler_bypass_option$.ServiceWorkerFetchHandlerBypassOption);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerInfo.sha256ScriptChecksum
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;



    // validate ControllerServiceWorkerInfo.routerData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ServiceWorkerRouterData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerInfo.remoteController
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 32, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerInfo.clientId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerInfo.fetchRequestWindowId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerInfo.objectInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, service_worker_object$.ServiceWorkerObjectInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerInfo.usedFeatures
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 64, 4, new codec.Enum(web_feature$.WebFeature), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ControllerServiceWorkerInfo.encodedSize = codec.kStructHeaderSize + 72;

  ControllerServiceWorkerInfo.decode = function(decoder) {
    var packed;
    var val = new ControllerServiceWorkerInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(controller_service_worker_mode$.ControllerServiceWorkerMode));
    val.fetchHandlerType =
        decoder.decodeStruct(new codec.Enum(service_worker_fetch_handler_type$.ServiceWorkerFetchHandlerType));
    val.fetchHandlerBypassOption =
        decoder.decodeStruct(new codec.Enum(service_worker_fetch_handler_bypass_option$.ServiceWorkerFetchHandlerBypassOption));
    packed = decoder.readUint8();
    val.needRouterEvaluate = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sha256ScriptChecksum =
        decoder.decodeStruct(codec.String);
    val.routerData =
        decoder.decodeStructPointer(ServiceWorkerRouterData);
    val.remoteController =
        decoder.decodeStruct(new codec.NullableInterface(ControllerServiceWorkerPtr));
    val.clientId =
        decoder.decodeStruct(codec.String);
    val.fetchRequestWindowId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.objectInfo =
        decoder.decodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo);
    val.usedFeatures =
        decoder.decodeArrayPointer(new codec.Enum(web_feature$.WebFeature));
    return val;
  };

  ControllerServiceWorkerInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ControllerServiceWorkerInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.encodeStruct(codec.Int32, val.fetchHandlerType);
    encoder.encodeStruct(codec.Int32, val.fetchHandlerBypassOption);
    packed = 0;
    packed |= (val.needRouterEvaluate & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.sha256ScriptChecksum);
    encoder.encodeStructPointer(ServiceWorkerRouterData, val.routerData);
    encoder.encodeStruct(new codec.NullableInterface(ControllerServiceWorkerPtr), val.remoteController);
    encoder.encodeStruct(codec.String, val.clientId);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.fetchRequestWindowId);
    encoder.encodeStructPointer(service_worker_object$.ServiceWorkerObjectInfo, val.objectInfo);
    encoder.encodeArrayPointer(new codec.Enum(web_feature$.WebFeature), val.usedFeatures);
  };
  function ControllerServiceWorker_DispatchFetchEventForSubresource_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ControllerServiceWorker_DispatchFetchEventForSubresource_Params.prototype.initDefaults_ = function() {
    this.params = null;
    this.responseCallback = new service_worker_fetch_response_callback$.ServiceWorkerFetchResponseCallbackPtr();
  };
  ControllerServiceWorker_DispatchFetchEventForSubresource_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ControllerServiceWorker_DispatchFetchEventForSubresource_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorker_DispatchFetchEventForSubresource_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, dispatch_fetch_event_params$.DispatchFetchEventParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorker_DispatchFetchEventForSubresource_Params.responseCallback
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ControllerServiceWorker_DispatchFetchEventForSubresource_Params.encodedSize = codec.kStructHeaderSize + 16;

  ControllerServiceWorker_DispatchFetchEventForSubresource_Params.decode = function(decoder) {
    var packed;
    var val = new ControllerServiceWorker_DispatchFetchEventForSubresource_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(dispatch_fetch_event_params$.DispatchFetchEventParams);
    val.responseCallback =
        decoder.decodeStruct(new codec.Interface(service_worker_fetch_response_callback$.ServiceWorkerFetchResponseCallbackPtr));
    return val;
  };

  ControllerServiceWorker_DispatchFetchEventForSubresource_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ControllerServiceWorker_DispatchFetchEventForSubresource_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(dispatch_fetch_event_params$.DispatchFetchEventParams, val.params);
    encoder.encodeStruct(new codec.Interface(service_worker_fetch_response_callback$.ServiceWorkerFetchResponseCallbackPtr), val.responseCallback);
  };
  function ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_event_status$.ServiceWorkerEventStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(service_worker_event_status$.ServiceWorkerEventStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ControllerServiceWorker_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ControllerServiceWorker_Clone_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.crossOriginEmbedderPolicy = null;
    this.coepReporter = new cross_origin_embedder_policy$.CrossOriginEmbedderPolicyReporterPtr();
    this.documentIsolationPolicy = null;
    this.dipReporter = new document_isolation_policy$.DocumentIsolationPolicyReporterPtr();
  };
  ControllerServiceWorker_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ControllerServiceWorker_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorker_Clone_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorker_Clone_Params.crossOriginEmbedderPolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, cross_origin_embedder_policy$.CrossOriginEmbedderPolicy, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorker_Clone_Params.coepReporter
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorker_Clone_Params.documentIsolationPolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, document_isolation_policy$.DocumentIsolationPolicy, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorker_Clone_Params.dipReporter
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 32, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ControllerServiceWorker_Clone_Params.encodedSize = codec.kStructHeaderSize + 40;

  ControllerServiceWorker_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new ControllerServiceWorker_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.crossOriginEmbedderPolicy =
        decoder.decodeStructPointer(cross_origin_embedder_policy$.CrossOriginEmbedderPolicy);
    val.coepReporter =
        decoder.decodeStruct(new codec.NullableInterface(cross_origin_embedder_policy$.CrossOriginEmbedderPolicyReporterPtr));
    val.documentIsolationPolicy =
        decoder.decodeStructPointer(document_isolation_policy$.DocumentIsolationPolicy);
    val.dipReporter =
        decoder.decodeStruct(new codec.NullableInterface(document_isolation_policy$.DocumentIsolationPolicyReporterPtr));
    return val;
  };

  ControllerServiceWorker_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ControllerServiceWorker_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(cross_origin_embedder_policy$.CrossOriginEmbedderPolicy, val.crossOriginEmbedderPolicy);
    encoder.encodeStruct(new codec.NullableInterface(cross_origin_embedder_policy$.CrossOriginEmbedderPolicyReporterPtr), val.coepReporter);
    encoder.encodeStructPointer(document_isolation_policy$.DocumentIsolationPolicy, val.documentIsolationPolicy);
    encoder.encodeStruct(new codec.NullableInterface(document_isolation_policy$.DocumentIsolationPolicyReporterPtr), val.dipReporter);
  };
  function ControllerServiceWorkerConnector_UpdateController_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ControllerServiceWorkerConnector_UpdateController_Params.prototype.initDefaults_ = function() {
    this.controller = new ControllerServiceWorkerPtr();
  };
  ControllerServiceWorkerConnector_UpdateController_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ControllerServiceWorkerConnector_UpdateController_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ControllerServiceWorkerConnector_UpdateController_Params.controller
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ControllerServiceWorkerConnector_UpdateController_Params.encodedSize = codec.kStructHeaderSize + 8;

  ControllerServiceWorkerConnector_UpdateController_Params.decode = function(decoder) {
    var packed;
    var val = new ControllerServiceWorkerConnector_UpdateController_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.controller =
        decoder.decodeStruct(new codec.NullableInterface(ControllerServiceWorkerPtr));
    return val;
  };

  ControllerServiceWorkerConnector_UpdateController_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ControllerServiceWorkerConnector_UpdateController_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.NullableInterface(ControllerServiceWorkerPtr), val.controller);
  };
  var kControllerServiceWorker_DispatchFetchEventForSubresource_Name = 0;
  var kControllerServiceWorker_Clone_Name = 1;

  function ControllerServiceWorkerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ControllerServiceWorker,
                                                   handleOrPtrInfo);
  }

  function ControllerServiceWorkerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ControllerServiceWorker, associatedInterfacePtrInfo);
  }

  ControllerServiceWorkerAssociatedPtr.prototype =
      Object.create(ControllerServiceWorkerPtr.prototype);
  ControllerServiceWorkerAssociatedPtr.prototype.constructor =
      ControllerServiceWorkerAssociatedPtr;

  function ControllerServiceWorkerProxy(receiver) {
    this.receiver_ = receiver;
  }
  ControllerServiceWorkerPtr.prototype.dispatchFetchEventForSubresource = function() {
    return ControllerServiceWorkerProxy.prototype.dispatchFetchEventForSubresource
        .apply(this.ptr.getProxy(), arguments);
  };

  ControllerServiceWorkerProxy.prototype.dispatchFetchEventForSubresource = function(params, responseCallback) {
    var params_ = new ControllerServiceWorker_DispatchFetchEventForSubresource_Params();
    params_.params = params;
    params_.responseCallback = responseCallback;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kControllerServiceWorker_DispatchFetchEventForSubresource_Name,
          codec.align(ControllerServiceWorker_DispatchFetchEventForSubresource_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ControllerServiceWorker_DispatchFetchEventForSubresource_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ControllerServiceWorkerPtr.prototype.clone = function() {
    return ControllerServiceWorkerProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  ControllerServiceWorkerProxy.prototype.clone = function(receiver, crossOriginEmbedderPolicy, coepReporter, documentIsolationPolicy, dipReporter) {
    var params_ = new ControllerServiceWorker_Clone_Params();
    params_.receiver = receiver;
    params_.crossOriginEmbedderPolicy = crossOriginEmbedderPolicy;
    params_.coepReporter = coepReporter;
    params_.documentIsolationPolicy = documentIsolationPolicy;
    params_.dipReporter = dipReporter;
    var builder = new codec.MessageV0Builder(
        kControllerServiceWorker_Clone_Name,
        codec.align(ControllerServiceWorker_Clone_Params.encodedSize));
    builder.encodeStruct(ControllerServiceWorker_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ControllerServiceWorkerStub(delegate) {
    this.delegate_ = delegate;
  }
  ControllerServiceWorkerStub.prototype.dispatchFetchEventForSubresource = function(params, responseCallback) {
    return this.delegate_ && this.delegate_.dispatchFetchEventForSubresource && this.delegate_.dispatchFetchEventForSubresource(params, responseCallback);
  }
  ControllerServiceWorkerStub.prototype.clone = function(receiver, crossOriginEmbedderPolicy, coepReporter, documentIsolationPolicy, dipReporter) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(receiver, crossOriginEmbedderPolicy, coepReporter, documentIsolationPolicy, dipReporter);
  }

  ControllerServiceWorkerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kControllerServiceWorker_Clone_Name:
      var params = reader.decodeStruct(ControllerServiceWorker_Clone_Params);
      this.clone(params.receiver, params.crossOriginEmbedderPolicy, params.coepReporter, params.documentIsolationPolicy, params.dipReporter);
      return true;
    default:
      return false;
    }
  };

  ControllerServiceWorkerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kControllerServiceWorker_DispatchFetchEventForSubresource_Name:
      var params = reader.decodeStruct(ControllerServiceWorker_DispatchFetchEventForSubresource_Params);
      this.dispatchFetchEventForSubresource(params.params, params.responseCallback).then(function(response) {
        var responseParams =
            new ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kControllerServiceWorker_DispatchFetchEventForSubresource_Name,
            codec.align(ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateControllerServiceWorkerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kControllerServiceWorker_DispatchFetchEventForSubresource_Name:
        if (message.expectsResponse())
          paramsClass = ControllerServiceWorker_DispatchFetchEventForSubresource_Params;
      break;
      case kControllerServiceWorker_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ControllerServiceWorker_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateControllerServiceWorkerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kControllerServiceWorker_DispatchFetchEventForSubresource_Name:
        if (message.isResponse())
          paramsClass = ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ControllerServiceWorker = {
    name: 'blink.mojom.ControllerServiceWorker',
    kVersion: 0,
    ptrClass: ControllerServiceWorkerPtr,
    proxyClass: ControllerServiceWorkerProxy,
    stubClass: ControllerServiceWorkerStub,
    validateRequest: validateControllerServiceWorkerRequest,
    validateResponse: validateControllerServiceWorkerResponse,
  };
  ControllerServiceWorkerStub.prototype.validator = validateControllerServiceWorkerRequest;
  ControllerServiceWorkerProxy.prototype.validator = validateControllerServiceWorkerResponse;
  var kControllerServiceWorkerConnector_UpdateController_Name = 0;

  function ControllerServiceWorkerConnectorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ControllerServiceWorkerConnector,
                                                   handleOrPtrInfo);
  }

  function ControllerServiceWorkerConnectorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ControllerServiceWorkerConnector, associatedInterfacePtrInfo);
  }

  ControllerServiceWorkerConnectorAssociatedPtr.prototype =
      Object.create(ControllerServiceWorkerConnectorPtr.prototype);
  ControllerServiceWorkerConnectorAssociatedPtr.prototype.constructor =
      ControllerServiceWorkerConnectorAssociatedPtr;

  function ControllerServiceWorkerConnectorProxy(receiver) {
    this.receiver_ = receiver;
  }
  ControllerServiceWorkerConnectorPtr.prototype.updateController = function() {
    return ControllerServiceWorkerConnectorProxy.prototype.updateController
        .apply(this.ptr.getProxy(), arguments);
  };

  ControllerServiceWorkerConnectorProxy.prototype.updateController = function(controller) {
    var params_ = new ControllerServiceWorkerConnector_UpdateController_Params();
    params_.controller = controller;
    var builder = new codec.MessageV0Builder(
        kControllerServiceWorkerConnector_UpdateController_Name,
        codec.align(ControllerServiceWorkerConnector_UpdateController_Params.encodedSize));
    builder.encodeStruct(ControllerServiceWorkerConnector_UpdateController_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ControllerServiceWorkerConnectorStub(delegate) {
    this.delegate_ = delegate;
  }
  ControllerServiceWorkerConnectorStub.prototype.updateController = function(controller) {
    return this.delegate_ && this.delegate_.updateController && this.delegate_.updateController(controller);
  }

  ControllerServiceWorkerConnectorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kControllerServiceWorkerConnector_UpdateController_Name:
      var params = reader.decodeStruct(ControllerServiceWorkerConnector_UpdateController_Params);
      this.updateController(params.controller);
      return true;
    default:
      return false;
    }
  };

  ControllerServiceWorkerConnectorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateControllerServiceWorkerConnectorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kControllerServiceWorkerConnector_UpdateController_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ControllerServiceWorkerConnector_UpdateController_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateControllerServiceWorkerConnectorResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ControllerServiceWorkerConnector = {
    name: 'blink.mojom.ControllerServiceWorkerConnector',
    kVersion: 0,
    ptrClass: ControllerServiceWorkerConnectorPtr,
    proxyClass: ControllerServiceWorkerConnectorProxy,
    stubClass: ControllerServiceWorkerConnectorStub,
    validateRequest: validateControllerServiceWorkerConnectorRequest,
    validateResponse: null,
  };
  ControllerServiceWorkerConnectorStub.prototype.validator = validateControllerServiceWorkerConnectorRequest;
  ControllerServiceWorkerConnectorProxy.prototype.validator = null;
  exports.ServiceWorkerRouterData = ServiceWorkerRouterData;
  exports.ControllerServiceWorkerInfo = ControllerServiceWorkerInfo;
  exports.ControllerServiceWorker = ControllerServiceWorker;
  exports.ControllerServiceWorkerPtr = ControllerServiceWorkerPtr;
  exports.ControllerServiceWorkerAssociatedPtr = ControllerServiceWorkerAssociatedPtr;
  exports.ControllerServiceWorkerConnector = ControllerServiceWorkerConnector;
  exports.ControllerServiceWorkerConnectorPtr = ControllerServiceWorkerConnectorPtr;
  exports.ControllerServiceWorkerConnectorAssociatedPtr = ControllerServiceWorkerConnectorAssociatedPtr;
})();