// third_party/blink/public/mojom/serial/serial.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/serial/serial.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/serial/serial.mojom-params-data.h"
#include "third_party/blink/public/mojom/serial/serial.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/serial/serial.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/serial/serial.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "third_party/blink/renderer/platform/mojo/bluetooth_mojom_traits.h"


namespace blink::mojom::blink {
SerialPortInfo::SerialPortInfo()
    : token(),
      usb_vendor_id(),
      has_usb_vendor_id(false),
      usb_product_id(),
      has_usb_product_id(false),
      bluetooth_service_class_id(),
      connected() {}

SerialPortInfo::SerialPortInfo(
    const ::base::UnguessableToken& token_in,
    uint16_t usb_vendor_id_in,
    bool has_usb_vendor_id_in,
    uint16_t usb_product_id_in,
    bool has_usb_product_id_in,
    const ::blink::String& bluetooth_service_class_id_in,
    bool connected_in)
    : token(std::move(token_in)),
      usb_vendor_id(std::move(usb_vendor_id_in)),
      has_usb_vendor_id(std::move(has_usb_vendor_id_in)),
      usb_product_id(std::move(usb_product_id_in)),
      has_usb_product_id(std::move(has_usb_product_id_in)),
      bluetooth_service_class_id(std::move(bluetooth_service_class_id_in)),
      connected(std::move(connected_in)) {}

SerialPortInfo::~SerialPortInfo() = default;

void SerialPortInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usb_vendor_id"), this->usb_vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_usb_vendor_id"), this->has_usb_vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usb_product_id"), this->usb_product_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_usb_product_id"), this->has_usb_product_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bluetooth_service_class_id"), this->bluetooth_service_class_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connected"), this->connected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SerialPortInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SerialPortFilter::SerialPortFilter()
    : vendor_id(),
      has_vendor_id(),
      product_id(),
      has_product_id(),
      bluetooth_service_class_id() {}

SerialPortFilter::SerialPortFilter(
    uint32_t vendor_id_in,
    bool has_vendor_id_in,
    uint16_t product_id_in,
    bool has_product_id_in,
    const ::blink::String& bluetooth_service_class_id_in)
    : vendor_id(std::move(vendor_id_in)),
      has_vendor_id(std::move(has_vendor_id_in)),
      product_id(std::move(product_id_in)),
      has_product_id(std::move(has_product_id_in)),
      bluetooth_service_class_id(std::move(bluetooth_service_class_id_in)) {}

SerialPortFilter::~SerialPortFilter() = default;

void SerialPortFilter::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_vendor_id"), this->has_vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_id"), this->product_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_product_id"), this->has_product_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bluetooth_service_class_id"), this->bluetooth_service_class_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SerialPortFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SerialService::IPCStableHashFunction SerialService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SerialService>(message.name())) {
    case messages::SerialService::kSetClient: {
      return &SerialService::SetClient_Sym::IPCStableHash;
    }
    case messages::SerialService::kGetPorts: {
      return &SerialService::GetPorts_Sym::IPCStableHash;
    }
    case messages::SerialService::kRequestPort: {
      return &SerialService::RequestPort_Sym::IPCStableHash;
    }
    case messages::SerialService::kOpenPort: {
      return &SerialService::OpenPort_Sym::IPCStableHash;
    }
    case messages::SerialService::kForgetPort: {
      return &SerialService::ForgetPort_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SerialService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SerialService>(message.name())) {
      case messages::SerialService::kSetClient:
            return "Receive blink::mojom::SerialService::SetClient";
      case messages::SerialService::kGetPorts:
            return "Receive blink::mojom::SerialService::GetPorts";
      case messages::SerialService::kRequestPort:
            return "Receive blink::mojom::SerialService::RequestPort";
      case messages::SerialService::kOpenPort:
            return "Receive blink::mojom::SerialService::OpenPort";
      case messages::SerialService::kForgetPort:
            return "Receive blink::mojom::SerialService::ForgetPort";
    }
  } else {
    switch (static_cast<messages::SerialService>(message.name())) {
      case messages::SerialService::kSetClient:
            return "Receive reply blink::mojom::SerialService::SetClient";
      case messages::SerialService::kGetPorts:
            return "Receive reply blink::mojom::SerialService::GetPorts";
      case messages::SerialService::kRequestPort:
            return "Receive reply blink::mojom::SerialService::RequestPort";
      case messages::SerialService::kOpenPort:
            return "Receive reply blink::mojom::SerialService::OpenPort";
      case messages::SerialService::kForgetPort:
            return "Receive reply blink::mojom::SerialService::ForgetPort";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SerialService::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64a35f23;  // IPCStableHash for blink::mojom::SerialService::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SerialService::GetPorts_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf597daf4;  // IPCStableHash for blink::mojom::SerialService::GetPorts
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SerialService::RequestPort_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21c16bfe;  // IPCStableHash for blink::mojom::SerialService::RequestPort
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SerialService::OpenPort_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15a45162;  // IPCStableHash for blink::mojom::SerialService::OpenPort
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SerialService::ForgetPort_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2f2ef0a5;  // IPCStableHash for blink::mojom::SerialService::ForgetPort
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SerialService_GetPorts_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialService_GetPorts_ForwardToCallback(
      SerialService::GetPortsCallback callback
      ) : callback_(std::move(callback)) {
  }

  SerialService_GetPorts_ForwardToCallback(const SerialService_GetPorts_ForwardToCallback&) = delete;
  SerialService_GetPorts_ForwardToCallback& operator=(const SerialService_GetPorts_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SerialService::GetPortsCallback callback_;
};

class SerialService_RequestPort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialService_RequestPort_ForwardToCallback(
      SerialService::RequestPortCallback callback
      ) : callback_(std::move(callback)) {
  }

  SerialService_RequestPort_ForwardToCallback(const SerialService_RequestPort_ForwardToCallback&) = delete;
  SerialService_RequestPort_ForwardToCallback& operator=(const SerialService_RequestPort_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SerialService::RequestPortCallback callback_;
};

class SerialService_OpenPort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialService_OpenPort_ForwardToCallback(
      SerialService::OpenPortCallback callback
      ) : callback_(std::move(callback)) {
  }

  SerialService_OpenPort_ForwardToCallback(const SerialService_OpenPort_ForwardToCallback&) = delete;
  SerialService_OpenPort_ForwardToCallback& operator=(const SerialService_OpenPort_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SerialService::OpenPortCallback callback_;
};

class SerialService_ForgetPort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialService_ForgetPort_ForwardToCallback(
      SerialService::ForgetPortCallback callback
      ) : callback_(std::move(callback)) {
  }

  SerialService_ForgetPort_ForwardToCallback(const SerialService_ForgetPort_ForwardToCallback&) = delete;
  SerialService_ForgetPort_ForwardToCallback& operator=(const SerialService_ForgetPort_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SerialService::ForgetPortCallback callback_;
};

SerialServiceProxy::SerialServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SerialServiceProxy::SetClient(
    ::mojo::PendingRemote<SerialServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SerialService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<SerialServiceClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialService::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SerialServiceClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in SerialService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SerialServiceProxy::GetPorts(
    GetPortsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SerialService::GetPorts");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialService::kGetPorts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_GetPorts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("GetPorts");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialService_GetPorts_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SerialServiceProxy::RequestPort(
    ::blink::Vector<SerialPortFilterPtr> in_filters, const ::blink::Vector<::blink::String>& in_allowed_bluetooth_service_class_ids, RequestPortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SerialService::RequestPort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filters"), in_filters,
                        "<value of type ::blink::Vector<SerialPortFilterPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed_bluetooth_service_class_ids"), in_allowed_bluetooth_service_class_ids,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialService::kRequestPort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_RequestPort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filters)::BaseType>
      filters_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SerialPortFilterDataView>>(
    in_filters,
    filters_fragment,
    &filters_validate_params);

  params->filters.Set(
      filters_fragment.is_null() ? nullptr : filters_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filters.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filters in SerialService.RequestPort request");
  mojo::internal::MessageFragment<
      typename decltype(params->allowed_bluetooth_service_class_ids)::BaseType>
      allowed_bluetooth_service_class_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& allowed_bluetooth_service_class_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
    in_allowed_bluetooth_service_class_ids,
    allowed_bluetooth_service_class_ids_fragment,
    &allowed_bluetooth_service_class_ids_validate_params);

  params->allowed_bluetooth_service_class_ids.Set(
      allowed_bluetooth_service_class_ids_fragment.is_null() ? nullptr : allowed_bluetooth_service_class_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->allowed_bluetooth_service_class_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null allowed_bluetooth_service_class_ids in SerialService.RequestPort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("RequestPort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialService_RequestPort_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SerialServiceProxy::OpenPort(
    const ::base::UnguessableToken& in_token, ::device::mojom::blink::SerialConnectionOptionsPtr in_options, ::mojo::PendingRemote<::device::mojom::blink::SerialPortClient> in_client, OpenPortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SerialService::OpenPort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::device::mojom::blink::SerialConnectionOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::device::mojom::blink::SerialPortClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialService::kOpenPort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_OpenPort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in SerialService.OpenPort request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::SerialConnectionOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in SerialService.OpenPort request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SerialPortClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in SerialService.OpenPort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("OpenPort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialService_OpenPort_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SerialServiceProxy::ForgetPort(
    const ::base::UnguessableToken& in_token, ForgetPortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SerialService::ForgetPort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialService::kForgetPort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_ForgetPort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in SerialService.ForgetPort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("ForgetPort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialService_ForgetPort_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SerialService_GetPorts_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SerialService::GetPortsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SerialService_GetPorts_ProxyToResponder> proxy(
        new SerialService_GetPorts_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SerialService_GetPorts_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialService_GetPorts_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SerialService_GetPorts_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SerialService::GetPortsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<SerialPortInfoPtr> in_ports);
};

bool SerialService_GetPorts_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SerialService_GetPorts_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialService_GetPorts_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SerialService.1
  bool success = true;
  ::blink::Vector<SerialPortInfoPtr> p_ports{};
  SerialService_GetPorts_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPorts(&p_ports))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_ports));
  }
  return true;
}

void SerialService_GetPorts_ProxyToResponder::Run(
    ::blink::Vector<SerialPortInfoPtr> in_ports) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SerialService::GetPorts", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ports"), in_ports,
                        "<value of type ::blink::Vector<SerialPortInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialService::kGetPorts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_GetPorts_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ports)::BaseType>
      ports_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SerialPortInfoDataView>>(
    in_ports,
    ports_fragment,
    &ports_validate_params);

  params->ports.Set(
      ports_fragment.is_null() ? nullptr : ports_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ports.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ports in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("GetPorts");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialService_RequestPort_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SerialService::RequestPortCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SerialService_RequestPort_ProxyToResponder> proxy(
        new SerialService_RequestPort_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SerialService_RequestPort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialService_RequestPort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SerialService_RequestPort_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SerialService::RequestPortCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SerialPortInfoPtr in_port);
};

bool SerialService_RequestPort_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SerialService_RequestPort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialService_RequestPort_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SerialService.2
  bool success = true;
  SerialPortInfoPtr p_port{};
  SerialService_RequestPort_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPort(&p_port))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_port));
  }
  return true;
}

void SerialService_RequestPort_ProxyToResponder::Run(
    SerialPortInfoPtr in_port) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SerialService::RequestPort", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type SerialPortInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialService::kRequestPort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_RequestPort_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->port)::BaseType> port_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SerialPortInfoDataView>(
    in_port,
    port_fragment);

  params->port.Set(
      port_fragment.is_null() ? nullptr : port_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("RequestPort");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialService_OpenPort_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SerialService::OpenPortCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SerialService_OpenPort_ProxyToResponder> proxy(
        new SerialService_OpenPort_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SerialService_OpenPort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialService_OpenPort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SerialService_OpenPort_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SerialService::OpenPortCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::device::mojom::blink::SerialPort> in_port);
};

bool SerialService_OpenPort_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SerialService_OpenPort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialService_OpenPort_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SerialService.3
  bool success = true;
  ::mojo::PendingRemote<::device::mojom::blink::SerialPort> p_port{};
  SerialService_OpenPort_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_port =
        input_data_view.TakePort<decltype(p_port)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_port));
  }
  return true;
}

void SerialService_OpenPort_ProxyToResponder::Run(
    ::mojo::PendingRemote<::device::mojom::blink::SerialPort> in_port) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SerialService::OpenPort", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type ::mojo::PendingRemote<::device::mojom::blink::SerialPort>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialService::kOpenPort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_OpenPort_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SerialPortInterfaceBase>>(
    in_port,
    &params->port,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("OpenPort");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialService_ForgetPort_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SerialService::ForgetPortCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SerialService_ForgetPort_ProxyToResponder> proxy(
        new SerialService_ForgetPort_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SerialService_ForgetPort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialService_ForgetPort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SerialService_ForgetPort_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SerialService::ForgetPortCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool SerialService_ForgetPort_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SerialService_ForgetPort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialService_ForgetPort_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SerialService.4
  bool success = true;
  SerialService_ForgetPort_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void SerialService_ForgetPort_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::SerialService::ForgetPort");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialService::kForgetPort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialService_ForgetPort_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialService::Name_);
  message.set_method_name("ForgetPort");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SerialServiceStubDispatch::Accept(
    SerialService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SerialService>(message->header()->name)) {
    case messages::SerialService::kSetClient: {
      DCHECK(message->is_serialized());
      internal::SerialService_SetClient_Params_Data* params =
          reinterpret_cast<internal::SerialService_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SerialService.0
      bool success = true;
      ::mojo::PendingRemote<SerialServiceClient> p_client{};
      SerialService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
    case messages::SerialService::kGetPorts: {
      break;
    }
    case messages::SerialService::kRequestPort: {
      break;
    }
    case messages::SerialService::kOpenPort: {
      break;
    }
    case messages::SerialService::kForgetPort: {
      break;
    }
  }
  return false;
}

// static
bool SerialServiceStubDispatch::AcceptWithResponder(
    SerialService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SerialService>(message->header()->name)) {
    case messages::SerialService::kSetClient: {
      break;
    }
    case messages::SerialService::kGetPorts: {
      internal::SerialService_GetPorts_Params_Data* params =
          reinterpret_cast<
              internal::SerialService_GetPorts_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SerialService.1
      bool success = true;
      SerialService_GetPorts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialService::Name_, 1, false);
        return false;
      }
      auto callback =
          SerialService_GetPorts_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPorts(std::move(callback));
      return true;
    }
    case messages::SerialService::kRequestPort: {
      internal::SerialService_RequestPort_Params_Data* params =
          reinterpret_cast<
              internal::SerialService_RequestPort_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SerialService.2
      bool success = true;
      ::blink::Vector<SerialPortFilterPtr> p_filters{};
      ::blink::Vector<::blink::String> p_allowed_bluetooth_service_class_ids{};
      SerialService_RequestPort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilters(&p_filters))
        success = false;
      if (success && !input_data_view.ReadAllowedBluetoothServiceClassIds(&p_allowed_bluetooth_service_class_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialService::Name_, 2, false);
        return false;
      }
      auto callback =
          SerialService_RequestPort_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPort(        
        std::move(p_filters), 
        std::move(p_allowed_bluetooth_service_class_ids), std::move(callback));
      return true;
    }
    case messages::SerialService::kOpenPort: {
      internal::SerialService_OpenPort_Params_Data* params =
          reinterpret_cast<
              internal::SerialService_OpenPort_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SerialService.3
      bool success = true;
      ::base::UnguessableToken p_token{};
      ::device::mojom::blink::SerialConnectionOptionsPtr p_options{};
      ::mojo::PendingRemote<::device::mojom::blink::SerialPortClient> p_client{};
      SerialService_OpenPort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialService::Name_, 3, false);
        return false;
      }
      auto callback =
          SerialService_OpenPort_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenPort(        
        std::move(p_token), 
        std::move(p_options), 
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::SerialService::kForgetPort: {
      internal::SerialService_ForgetPort_Params_Data* params =
          reinterpret_cast<
              internal::SerialService_ForgetPort_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SerialService.4
      bool success = true;
      ::base::UnguessableToken p_token{};
      SerialService_ForgetPort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialService::Name_, 4, false);
        return false;
      }
      auto callback =
          SerialService_ForgetPort_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForgetPort(        
        std::move(p_token), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSerialServiceValidationInfo[] = {
    { &internal::SerialService_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SerialService_GetPorts_Params_Data::Validate,
     &internal::SerialService_GetPorts_ResponseParams_Data::Validate},
    { &internal::SerialService_RequestPort_Params_Data::Validate,
     &internal::SerialService_RequestPort_ResponseParams_Data::Validate},
    { &internal::SerialService_OpenPort_Params_Data::Validate,
     &internal::SerialService_OpenPort_ResponseParams_Data::Validate},
    { &internal::SerialService_ForgetPort_Params_Data::Validate,
     &internal::SerialService_ForgetPort_ResponseParams_Data::Validate},
};

bool SerialServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SerialService::Name_,
    kSerialServiceValidationInfo);
}

bool SerialServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::SerialService::Name_,
    kSerialServiceValidationInfo);
}
// The declaration includes the definition on other builds.

SerialServiceClient::IPCStableHashFunction SerialServiceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SerialServiceClient>(message.name())) {
    case messages::SerialServiceClient::kOnPortConnectedStateChanged: {
      return &SerialServiceClient::OnPortConnectedStateChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SerialServiceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SerialServiceClient>(message.name())) {
      case messages::SerialServiceClient::kOnPortConnectedStateChanged:
            return "Receive blink::mojom::SerialServiceClient::OnPortConnectedStateChanged";
    }
  } else {
    switch (static_cast<messages::SerialServiceClient>(message.name())) {
      case messages::SerialServiceClient::kOnPortConnectedStateChanged:
            return "Receive reply blink::mojom::SerialServiceClient::OnPortConnectedStateChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SerialServiceClient::OnPortConnectedStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10608050;  // IPCStableHash for blink::mojom::SerialServiceClient::OnPortConnectedStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SerialServiceClientProxy::SerialServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SerialServiceClientProxy::OnPortConnectedStateChanged(
    SerialPortInfoPtr in_port_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SerialServiceClient::OnPortConnectedStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_info"), in_port_info,
                        "<value of type SerialPortInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SerialServiceClient::kOnPortConnectedStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SerialServiceClient_OnPortConnectedStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->port_info)::BaseType> port_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SerialPortInfoDataView>(
    in_port_info,
    port_info_fragment);

  params->port_info.Set(
      port_info_fragment.is_null() ? nullptr : port_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->port_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null port_info in SerialServiceClient.OnPortConnectedStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialServiceClient::Name_);
  message.set_method_name("OnPortConnectedStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SerialServiceClientStubDispatch::Accept(
    SerialServiceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SerialServiceClient>(message->header()->name)) {
    case messages::SerialServiceClient::kOnPortConnectedStateChanged: {
      DCHECK(message->is_serialized());
      internal::SerialServiceClient_OnPortConnectedStateChanged_Params_Data* params =
          reinterpret_cast<internal::SerialServiceClient_OnPortConnectedStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SerialServiceClient.0
      bool success = true;
      SerialPortInfoPtr p_port_info{};
      SerialServiceClient_OnPortConnectedStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPortInfo(&p_port_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPortConnectedStateChanged(        
        std::move(p_port_info));
      return true;
    }
  }
  return false;
}

// static
bool SerialServiceClientStubDispatch::AcceptWithResponder(
    SerialServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SerialServiceClient>(message->header()->name)) {
    case messages::SerialServiceClient::kOnPortConnectedStateChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSerialServiceClientValidationInfo[] = {
    { &internal::SerialServiceClient_OnPortConnectedStateChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool SerialServiceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SerialServiceClient::Name_,
    kSerialServiceClientValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SerialPortInfo::DataView, ::blink::mojom::blink::SerialPortInfoPtr>::Read(
    ::blink::mojom::blink::SerialPortInfo::DataView input,
    ::blink::mojom::blink::SerialPortInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SerialPortInfoPtr result(::blink::mojom::blink::SerialPortInfo::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success)
        result->usb_vendor_id = input.usb_vendor_id();
      if (success)
        result->has_usb_vendor_id = input.has_usb_vendor_id();
      if (success)
        result->usb_product_id = input.usb_product_id();
      if (success)
        result->has_usb_product_id = input.has_usb_product_id();
      if (success && !input.ReadBluetoothServiceClassId(&result->bluetooth_service_class_id))
        success = false;
      if (success)
        result->connected = input.connected();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SerialPortFilter::DataView, ::blink::mojom::blink::SerialPortFilterPtr>::Read(
    ::blink::mojom::blink::SerialPortFilter::DataView input,
    ::blink::mojom::blink::SerialPortFilterPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SerialPortFilterPtr result(::blink::mojom::blink::SerialPortFilter::New());
  
      if (success)
        result->vendor_id = input.vendor_id();
      if (success)
        result->has_vendor_id = input.has_vendor_id();
      if (success)
        result->product_id = input.product_id();
      if (success)
        result->has_product_id = input.has_product_id();
      if (success && !input.ReadBluetoothServiceClassId(&result->bluetooth_service_class_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void SerialServiceInterceptorForTesting::SetClient(::mojo::PendingRemote<SerialServiceClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
void SerialServiceInterceptorForTesting::GetPorts(GetPortsCallback callback) {
  GetForwardingInterface()->GetPorts(std::move(callback));
}
void SerialServiceInterceptorForTesting::RequestPort(::blink::Vector<SerialPortFilterPtr> filters, const ::blink::Vector<::blink::String>& allowed_bluetooth_service_class_ids, RequestPortCallback callback) {
  GetForwardingInterface()->RequestPort(
    std::move(filters)
    , 
    std::move(allowed_bluetooth_service_class_ids)
    , std::move(callback));
}
void SerialServiceInterceptorForTesting::OpenPort(const ::base::UnguessableToken& token, ::device::mojom::blink::SerialConnectionOptionsPtr options, ::mojo::PendingRemote<::device::mojom::blink::SerialPortClient> client, OpenPortCallback callback) {
  GetForwardingInterface()->OpenPort(
    std::move(token)
    , 
    std::move(options)
    , 
    std::move(client)
    , std::move(callback));
}
void SerialServiceInterceptorForTesting::ForgetPort(const ::base::UnguessableToken& token, ForgetPortCallback callback) {
  GetForwardingInterface()->ForgetPort(
    std::move(token)
    , std::move(callback));
}
SerialServiceAsyncWaiter::SerialServiceAsyncWaiter(
    SerialService* proxy) : proxy_(proxy) {}

SerialServiceAsyncWaiter::~SerialServiceAsyncWaiter() = default;


void SerialServiceAsyncWaiter::GetPorts(
    ::blink::Vector<SerialPortInfoPtr>* out_ports) {
  base::RunLoop loop;
  proxy_->GetPorts(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<SerialPortInfoPtr>* out_ports
,
             ::blink::Vector<SerialPortInfoPtr> ports) {*out_ports = std::move(ports);
            loop->Quit();
          },
          &loop,
          out_ports));
  loop.Run();
}

::blink::Vector<SerialPortInfoPtr> SerialServiceAsyncWaiter::GetPorts(
    ) {
  ::blink::Vector<SerialPortInfoPtr> async_wait_result;
  GetPorts(&async_wait_result);
  return async_wait_result;
}

void SerialServiceAsyncWaiter::RequestPort(
    ::blink::Vector<SerialPortFilterPtr> filters, const ::blink::Vector<::blink::String>& allowed_bluetooth_service_class_ids, SerialPortInfoPtr* out_port) {
  base::RunLoop loop;
  proxy_->RequestPort(
      std::move(filters),
      std::move(allowed_bluetooth_service_class_ids),
      base::BindOnce(
          [](base::RunLoop* loop,
             SerialPortInfoPtr* out_port
,
             SerialPortInfoPtr port) {*out_port = std::move(port);
            loop->Quit();
          },
          &loop,
          out_port));
  loop.Run();
}

SerialPortInfoPtr SerialServiceAsyncWaiter::RequestPort(
    ::blink::Vector<SerialPortFilterPtr> filters, const ::blink::Vector<::blink::String>& allowed_bluetooth_service_class_ids) {
  SerialPortInfoPtr async_wait_result;
  RequestPort(std::move(filters),std::move(allowed_bluetooth_service_class_ids),&async_wait_result);
  return async_wait_result;
}

void SerialServiceAsyncWaiter::OpenPort(
    const ::base::UnguessableToken& token, ::device::mojom::blink::SerialConnectionOptionsPtr options, ::mojo::PendingRemote<::device::mojom::blink::SerialPortClient> client, ::mojo::PendingRemote<::device::mojom::blink::SerialPort>* out_port) {
  base::RunLoop loop;
  proxy_->OpenPort(
      std::move(token),
      std::move(options),
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<::device::mojom::blink::SerialPort>* out_port
,
             ::mojo::PendingRemote<::device::mojom::blink::SerialPort> port) {*out_port = std::move(port);
            loop->Quit();
          },
          &loop,
          out_port));
  loop.Run();
}

::mojo::PendingRemote<::device::mojom::blink::SerialPort> SerialServiceAsyncWaiter::OpenPort(
    const ::base::UnguessableToken& token, ::device::mojom::blink::SerialConnectionOptionsPtr options, ::mojo::PendingRemote<::device::mojom::blink::SerialPortClient> client) {
  ::mojo::PendingRemote<::device::mojom::blink::SerialPort> async_wait_result;
  OpenPort(std::move(token),std::move(options),std::move(client),&async_wait_result);
  return async_wait_result;
}

void SerialServiceAsyncWaiter::ForgetPort(
    const ::base::UnguessableToken& token) {
  base::RunLoop loop;
  proxy_->ForgetPort(
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void SerialServiceClientInterceptorForTesting::OnPortConnectedStateChanged(SerialPortInfoPtr port_info) {
  GetForwardingInterface()->OnPortConnectedStateChanged(
    std::move(port_info)
    );
}
SerialServiceClientAsyncWaiter::SerialServiceClientAsyncWaiter(
    SerialServiceClient* proxy) : proxy_(proxy) {}

SerialServiceClientAsyncWaiter::~SerialServiceClientAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif