// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/scroll/scroll_enums.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class PLATFORM_EXPORT ScrollAlignment {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollAlignment, T>::value>;
  using DataView = ScrollAlignmentDataView;
  using Data_ = internal::ScrollAlignment_Data;
  using Behavior = ScrollAlignment_Behavior;

  template <typename... Args>
  static ScrollAlignmentPtr New(Args&&... args) {
    return ScrollAlignmentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollAlignmentPtr From(const U& u) {
    return mojo::TypeConverter<ScrollAlignmentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollAlignment>::Convert(*this);
  }


  ScrollAlignment();

  ScrollAlignment(
      ScrollAlignment::Behavior rect_visible,
      ScrollAlignment::Behavior rect_hidden,
      ScrollAlignment::Behavior rect_partial);


  ~ScrollAlignment();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollAlignmentPtr>
  ScrollAlignmentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollAlignment::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollAlignment::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollAlignment::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollAlignment_UnserializedMessageContext<
            UserType, ScrollAlignment::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollAlignment::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollAlignment::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollAlignment_UnserializedMessageContext<
            UserType, ScrollAlignment::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollAlignment::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ScrollAlignment::Behavior rect_visible;
  
  ScrollAlignment::Behavior rect_hidden;
  
  ScrollAlignment::Behavior rect_partial;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT FocusedEditableParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FocusedEditableParams, T>::value>;
  using DataView = FocusedEditableParamsDataView;
  using Data_ = internal::FocusedEditableParams_Data;

  template <typename... Args>
  static FocusedEditableParamsPtr New(Args&&... args) {
    return FocusedEditableParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FocusedEditableParamsPtr From(const U& u) {
    return mojo::TypeConverter<FocusedEditableParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FocusedEditableParams>::Convert(*this);
  }


  FocusedEditableParams();

  FocusedEditableParams(
      const ::gfx::Vector2dF& relative_location,
      const ::gfx::SizeF& size,
      bool can_zoom);


  ~FocusedEditableParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FocusedEditableParamsPtr>
  FocusedEditableParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FocusedEditableParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FocusedEditableParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FocusedEditableParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FocusedEditableParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FocusedEditableParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FocusedEditableParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FocusedEditableParams_UnserializedMessageContext<
            UserType, FocusedEditableParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FocusedEditableParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FocusedEditableParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FocusedEditableParams_UnserializedMessageContext<
            UserType, FocusedEditableParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FocusedEditableParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Vector2dF relative_location;
  
  ::gfx::SizeF size;
  
  bool can_zoom;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FocusedEditableParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FocusedEditableParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FocusedEditableParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FocusedEditableParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ScrollIntoViewParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollIntoViewParams, T>::value>;
  using DataView = ScrollIntoViewParamsDataView;
  using Data_ = internal::ScrollIntoViewParams_Data;

  template <typename... Args>
  static ScrollIntoViewParamsPtr New(Args&&... args) {
    return ScrollIntoViewParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollIntoViewParamsPtr From(const U& u) {
    return mojo::TypeConverter<ScrollIntoViewParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollIntoViewParams>::Convert(*this);
  }


  ScrollIntoViewParams();

  ScrollIntoViewParams(
      ScrollAlignmentPtr align_x,
      ScrollAlignmentPtr align_y,
      ::blink::mojom::blink::ScrollType type,
      bool make_visible_in_visual_viewport,
      ::blink::mojom::blink::ScrollBehavior behavior,
      bool is_for_scroll_sequence,
      FocusedEditableParamsPtr for_focused_editable,
      bool cross_origin_boundaries);

ScrollIntoViewParams(const ScrollIntoViewParams&) = delete;
ScrollIntoViewParams& operator=(const ScrollIntoViewParams&) = delete;

  ~ScrollIntoViewParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollIntoViewParamsPtr>
  ScrollIntoViewParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollIntoViewParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollIntoViewParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollIntoViewParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollIntoViewParams_UnserializedMessageContext<
            UserType, ScrollIntoViewParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollIntoViewParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollIntoViewParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollIntoViewParams_UnserializedMessageContext<
            UserType, ScrollIntoViewParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollIntoViewParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ScrollAlignmentPtr align_x;
  
  ScrollAlignmentPtr align_y;
  
  ::blink::mojom::blink::ScrollType type;
  
  bool make_visible_in_visual_viewport;
  
  ::blink::mojom::blink::ScrollBehavior behavior;
  
  bool is_for_scroll_sequence;
  
  FocusedEditableParamsPtr for_focused_editable;
  
  bool cross_origin_boundaries;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ScrollAlignmentPtr ScrollAlignment::Clone() const {
  return New(
      mojo::Clone(rect_visible),
      mojo::Clone(rect_hidden),
      mojo::Clone(rect_partial)
  );
}

template <typename T, ScrollAlignment::EnableIfSame<T>*>
bool ScrollAlignment::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rect_visible, other_struct.rect_visible))
    return false;
  if (!mojo::Equals(this->rect_hidden, other_struct.rect_hidden))
    return false;
  if (!mojo::Equals(this->rect_partial, other_struct.rect_partial))
    return false;
  return true;
}

template <typename T, ScrollAlignment::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rect_visible < rhs.rect_visible)
    return true;
  if (rhs.rect_visible < lhs.rect_visible)
    return false;
  if (lhs.rect_hidden < rhs.rect_hidden)
    return true;
  if (rhs.rect_hidden < lhs.rect_hidden)
    return false;
  if (lhs.rect_partial < rhs.rect_partial)
    return true;
  if (rhs.rect_partial < lhs.rect_partial)
    return false;
  return false;
}
template <typename StructPtrType>
FocusedEditableParamsPtr FocusedEditableParams::Clone() const {
  return New(
      mojo::Clone(relative_location),
      mojo::Clone(size),
      mojo::Clone(can_zoom)
  );
}

template <typename T, FocusedEditableParams::EnableIfSame<T>*>
bool FocusedEditableParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->relative_location, other_struct.relative_location))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->can_zoom, other_struct.can_zoom))
    return false;
  return true;
}

template <typename T, FocusedEditableParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.relative_location < rhs.relative_location)
    return true;
  if (rhs.relative_location < lhs.relative_location)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.can_zoom < rhs.can_zoom)
    return true;
  if (rhs.can_zoom < lhs.can_zoom)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollIntoViewParamsPtr ScrollIntoViewParams::Clone() const {
  return New(
      mojo::Clone(align_x),
      mojo::Clone(align_y),
      mojo::Clone(type),
      mojo::Clone(make_visible_in_visual_viewport),
      mojo::Clone(behavior),
      mojo::Clone(is_for_scroll_sequence),
      mojo::Clone(for_focused_editable),
      mojo::Clone(cross_origin_boundaries)
  );
}

template <typename T, ScrollIntoViewParams::EnableIfSame<T>*>
bool ScrollIntoViewParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->align_x, other_struct.align_x))
    return false;
  if (!mojo::Equals(this->align_y, other_struct.align_y))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->make_visible_in_visual_viewport, other_struct.make_visible_in_visual_viewport))
    return false;
  if (!mojo::Equals(this->behavior, other_struct.behavior))
    return false;
  if (!mojo::Equals(this->is_for_scroll_sequence, other_struct.is_for_scroll_sequence))
    return false;
  if (!mojo::Equals(this->for_focused_editable, other_struct.for_focused_editable))
    return false;
  if (!mojo::Equals(this->cross_origin_boundaries, other_struct.cross_origin_boundaries))
    return false;
  return true;
}

template <typename T, ScrollIntoViewParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.align_x < rhs.align_x)
    return true;
  if (rhs.align_x < lhs.align_x)
    return false;
  if (lhs.align_y < rhs.align_y)
    return true;
  if (rhs.align_y < lhs.align_y)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.make_visible_in_visual_viewport < rhs.make_visible_in_visual_viewport)
    return true;
  if (rhs.make_visible_in_visual_viewport < lhs.make_visible_in_visual_viewport)
    return false;
  if (lhs.behavior < rhs.behavior)
    return true;
  if (rhs.behavior < lhs.behavior)
    return false;
  if (lhs.is_for_scroll_sequence < rhs.is_for_scroll_sequence)
    return true;
  if (rhs.is_for_scroll_sequence < lhs.is_for_scroll_sequence)
    return false;
  if (lhs.for_focused_editable < rhs.for_focused_editable)
    return true;
  if (rhs.for_focused_editable < lhs.for_focused_editable)
    return false;
  if (lhs.cross_origin_boundaries < rhs.cross_origin_boundaries)
    return true;
  if (rhs.cross_origin_boundaries < lhs.cross_origin_boundaries)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ScrollAlignment::DataView,
                                         ::blink::mojom::blink::ScrollAlignmentPtr> {
  static bool IsNull(const ::blink::mojom::blink::ScrollAlignmentPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ScrollAlignmentPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ScrollAlignment::rect_visible) rect_visible(
      const ::blink::mojom::blink::ScrollAlignmentPtr& input) {
    return input->rect_visible;
  }

  static decltype(::blink::mojom::blink::ScrollAlignment::rect_hidden) rect_hidden(
      const ::blink::mojom::blink::ScrollAlignmentPtr& input) {
    return input->rect_hidden;
  }

  static decltype(::blink::mojom::blink::ScrollAlignment::rect_partial) rect_partial(
      const ::blink::mojom::blink::ScrollAlignmentPtr& input) {
    return input->rect_partial;
  }

  static bool Read(::blink::mojom::blink::ScrollAlignment::DataView input, ::blink::mojom::blink::ScrollAlignmentPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FocusedEditableParams::DataView,
                                         ::blink::mojom::blink::FocusedEditableParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::FocusedEditableParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FocusedEditableParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FocusedEditableParams::relative_location)& relative_location(
      const ::blink::mojom::blink::FocusedEditableParamsPtr& input) {
    return input->relative_location;
  }

  static const decltype(::blink::mojom::blink::FocusedEditableParams::size)& size(
      const ::blink::mojom::blink::FocusedEditableParamsPtr& input) {
    return input->size;
  }

  static decltype(::blink::mojom::blink::FocusedEditableParams::can_zoom) can_zoom(
      const ::blink::mojom::blink::FocusedEditableParamsPtr& input) {
    return input->can_zoom;
  }

  static bool Read(::blink::mojom::blink::FocusedEditableParams::DataView input, ::blink::mojom::blink::FocusedEditableParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ScrollIntoViewParams::DataView,
                                         ::blink::mojom::blink::ScrollIntoViewParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ScrollIntoViewParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ScrollIntoViewParams::align_x)& align_x(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->align_x;
  }

  static const decltype(::blink::mojom::blink::ScrollIntoViewParams::align_y)& align_y(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->align_y;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::type) type(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->type;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::make_visible_in_visual_viewport) make_visible_in_visual_viewport(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->make_visible_in_visual_viewport;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::behavior) behavior(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->behavior;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::is_for_scroll_sequence) is_for_scroll_sequence(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->is_for_scroll_sequence;
  }

  static const decltype(::blink::mojom::blink::ScrollIntoViewParams::for_focused_editable)& for_focused_editable(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->for_focused_editable;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::cross_origin_boundaries) cross_origin_boundaries(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->cross_origin_boundaries;
  }

  static bool Read(::blink::mojom::blink::ScrollIntoViewParams::DataView input, ::blink::mojom::blink::ScrollIntoViewParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_BLINK_H_