// third_party/blink/public/mojom/script_source_location.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/script_source_location.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }



  function ScriptSourceLocation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ScriptSourceLocation.prototype.initDefaults_ = function() {
    this.url = null;
    this.functionName = null;
    this.lineNumber = 0;
    this.columnNumber = 0;
  };
  ScriptSourceLocation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ScriptSourceLocation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScriptSourceLocation.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScriptSourceLocation.functionName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ScriptSourceLocation.encodedSize = codec.kStructHeaderSize + 32;

  ScriptSourceLocation.decode = function(decoder) {
    var packed;
    var val = new ScriptSourceLocation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.functionName =
        decoder.decodeStruct(codec.String);
    val.lineNumber =
        decoder.decodeStruct(codec.Uint64);
    val.columnNumber =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  ScriptSourceLocation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ScriptSourceLocation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.functionName);
    encoder.encodeStruct(codec.Uint64, val.lineNumber);
    encoder.encodeStruct(codec.Uint64, val.columnNumber);
  };
  exports.ScriptSourceLocation = ScriptSourceLocation;
})();