// third_party/blink/public/mojom/renderer_preferences.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/renderer_preferences.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/renderer_preferences.mojom-params-data.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/renderer_preferences.mojom-import-headers.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-test-utils.h"
#include "components/content_settings/core/common/content_settings_param_traits.h"


namespace blink::mojom {
RendererPreferences::RendererPreferences()
    : can_accept_load_drops(true),
      should_antialias_text(true),
      hinting(mojo::internal::ConvertEnumValue<::gfx::mojom::Hinting, ::gfx::FontRenderParams::Hinting>(::gfx::mojom::Hinting::kMedium)),
      use_autohinter(false),
      use_bitmaps(false),
      subpixel_rendering(mojo::internal::ConvertEnumValue<::gfx::mojom::SubpixelRendering, ::gfx::FontRenderParams::SubpixelRendering>(::gfx::mojom::SubpixelRendering::kNone)),
      use_subpixel_positioning(false),
      focus_ring_color(0xFFE59700U),
      active_selection_bg_color(0xFF1967D2U),
      active_selection_fg_color(0xFFFFFFFFU),
      inactive_selection_bg_color(0xFFC8C8C8U),
      inactive_selection_fg_color(0xFF323232U),
      browser_handles_all_top_level_requests(false),
      caret_blink_interval(),
      use_custom_colors(true),
      enable_referrers(true),
      allow_cross_origin_auth_prompt(false),
      enable_do_not_track(false),
      enable_encrypted_media(true),
      webrtc_ip_handling_policy(),
      webrtc_ip_handling_urls(),
      webrtc_post_quantum_key_agreement(),
      webrtc_udp_min_port(0U),
      webrtc_udp_max_port(0U),
      webrtc_local_ips_allowed_urls(),
      user_agent_override(),
      accept_languages(),
      send_subresource_notification(false),
      plugin_fullscreen_allowed(true),
      caret_browsing_enabled(false),
      explicitly_allowed_network_ports(),
      view_source_line_wrap_enabled(false) {}

RendererPreferences::RendererPreferences(
    bool can_accept_load_drops_in,
    bool should_antialias_text_in,
    ::gfx::FontRenderParams::Hinting hinting_in,
    bool use_autohinter_in,
    bool use_bitmaps_in,
    ::gfx::FontRenderParams::SubpixelRendering subpixel_rendering_in,
    bool use_subpixel_positioning_in,
    uint32_t focus_ring_color_in,
    uint32_t active_selection_bg_color_in,
    uint32_t active_selection_fg_color_in,
    uint32_t inactive_selection_bg_color_in,
    uint32_t inactive_selection_fg_color_in,
    bool browser_handles_all_top_level_requests_in,
    std::optional<::base::TimeDelta> caret_blink_interval_in,
    bool use_custom_colors_in,
    bool enable_referrers_in,
    bool allow_cross_origin_auth_prompt_in,
    bool enable_do_not_track_in,
    bool enable_encrypted_media_in,
    ::blink::mojom::WebRtcIpHandlingPolicy webrtc_ip_handling_policy_in,
    std::vector<::blink::WebRtcIpHandlingUrlEntry> webrtc_ip_handling_urls_in,
    std::optional<bool> webrtc_post_quantum_key_agreement_in,
    uint16_t webrtc_udp_min_port_in,
    uint16_t webrtc_udp_max_port_in,
    std::vector<std::string> webrtc_local_ips_allowed_urls_in,
    const ::blink::UserAgentOverride& user_agent_override_in,
    const std::string& accept_languages_in,
    bool send_subresource_notification_in,
    bool plugin_fullscreen_allowed_in,
    bool caret_browsing_enabled_in,
    std::vector<uint16_t> explicitly_allowed_network_ports_in,
    bool view_source_line_wrap_enabled_in)
    : can_accept_load_drops(std::move(can_accept_load_drops_in)),
      should_antialias_text(std::move(should_antialias_text_in)),
      hinting(std::move(hinting_in)),
      use_autohinter(std::move(use_autohinter_in)),
      use_bitmaps(std::move(use_bitmaps_in)),
      subpixel_rendering(std::move(subpixel_rendering_in)),
      use_subpixel_positioning(std::move(use_subpixel_positioning_in)),
      focus_ring_color(std::move(focus_ring_color_in)),
      active_selection_bg_color(std::move(active_selection_bg_color_in)),
      active_selection_fg_color(std::move(active_selection_fg_color_in)),
      inactive_selection_bg_color(std::move(inactive_selection_bg_color_in)),
      inactive_selection_fg_color(std::move(inactive_selection_fg_color_in)),
      browser_handles_all_top_level_requests(std::move(browser_handles_all_top_level_requests_in)),
      caret_blink_interval(std::move(caret_blink_interval_in)),
      use_custom_colors(std::move(use_custom_colors_in)),
      enable_referrers(std::move(enable_referrers_in)),
      allow_cross_origin_auth_prompt(std::move(allow_cross_origin_auth_prompt_in)),
      enable_do_not_track(std::move(enable_do_not_track_in)),
      enable_encrypted_media(std::move(enable_encrypted_media_in)),
      webrtc_ip_handling_policy(std::move(webrtc_ip_handling_policy_in)),
      webrtc_ip_handling_urls(std::move(webrtc_ip_handling_urls_in)),
      webrtc_post_quantum_key_agreement(std::move(webrtc_post_quantum_key_agreement_in)),
      webrtc_udp_min_port(std::move(webrtc_udp_min_port_in)),
      webrtc_udp_max_port(std::move(webrtc_udp_max_port_in)),
      webrtc_local_ips_allowed_urls(std::move(webrtc_local_ips_allowed_urls_in)),
      user_agent_override(std::move(user_agent_override_in)),
      accept_languages(std::move(accept_languages_in)),
      send_subresource_notification(std::move(send_subresource_notification_in)),
      plugin_fullscreen_allowed(std::move(plugin_fullscreen_allowed_in)),
      caret_browsing_enabled(std::move(caret_browsing_enabled_in)),
      explicitly_allowed_network_ports(std::move(explicitly_allowed_network_ports_in)),
      view_source_line_wrap_enabled(std::move(view_source_line_wrap_enabled_in)) {}

RendererPreferences::~RendererPreferences() = default;

void RendererPreferences::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_accept_load_drops"), this->can_accept_load_drops,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_antialias_text"), this->should_antialias_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hinting"), this->hinting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::FontRenderParams::Hinting>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_autohinter"), this->use_autohinter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_bitmaps"), this->use_bitmaps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subpixel_rendering"), this->subpixel_rendering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::FontRenderParams::SubpixelRendering>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_subpixel_positioning"), this->use_subpixel_positioning,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "focus_ring_color"), this->focus_ring_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_selection_bg_color"), this->active_selection_bg_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_selection_fg_color"), this->active_selection_fg_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inactive_selection_bg_color"), this->inactive_selection_bg_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inactive_selection_fg_color"), this->inactive_selection_fg_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_handles_all_top_level_requests"), this->browser_handles_all_top_level_requests,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "caret_blink_interval"), this->caret_blink_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_custom_colors"), this->use_custom_colors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_referrers"), this->enable_referrers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_cross_origin_auth_prompt"), this->allow_cross_origin_auth_prompt,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_do_not_track"), this->enable_do_not_track,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_encrypted_media"), this->enable_encrypted_media,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webrtc_ip_handling_policy"), this->webrtc_ip_handling_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::WebRtcIpHandlingPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webrtc_ip_handling_urls"), this->webrtc_ip_handling_urls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::WebRtcIpHandlingUrlEntry>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webrtc_post_quantum_key_agreement"), this->webrtc_post_quantum_key_agreement,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webrtc_udp_min_port"), this->webrtc_udp_min_port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webrtc_udp_max_port"), this->webrtc_udp_max_port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webrtc_local_ips_allowed_urls"), this->webrtc_local_ips_allowed_urls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_agent_override"), this->user_agent_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::UserAgentOverride&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_languages"), this->accept_languages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_subresource_notification"), this->send_subresource_notification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plugin_fullscreen_allowed"), this->plugin_fullscreen_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "caret_browsing_enabled"), this->caret_browsing_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "explicitly_allowed_network_ports"), this->explicitly_allowed_network_ports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_source_line_wrap_enabled"), this->view_source_line_wrap_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RendererPreferences::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::RendererPreferences::DataView, ::blink::mojom::RendererPreferencesPtr>::Read(
    ::blink::mojom::RendererPreferences::DataView input,
    ::blink::mojom::RendererPreferencesPtr* output) {
  bool success = true;
  ::blink::mojom::RendererPreferencesPtr result(::blink::mojom::RendererPreferences::New());
  
      if (success)
        result->can_accept_load_drops = input.can_accept_load_drops();
      if (success)
        result->should_antialias_text = input.should_antialias_text();
      if (success && !input.ReadHinting(&result->hinting))
        success = false;
      if (success)
        result->use_autohinter = input.use_autohinter();
      if (success)
        result->use_bitmaps = input.use_bitmaps();
      if (success && !input.ReadSubpixelRendering(&result->subpixel_rendering))
        success = false;
      if (success)
        result->use_subpixel_positioning = input.use_subpixel_positioning();
      if (success)
        result->focus_ring_color = input.focus_ring_color();
      if (success)
        result->active_selection_bg_color = input.active_selection_bg_color();
      if (success)
        result->active_selection_fg_color = input.active_selection_fg_color();
      if (success)
        result->inactive_selection_bg_color = input.inactive_selection_bg_color();
      if (success)
        result->inactive_selection_fg_color = input.inactive_selection_fg_color();
      if (success)
        result->browser_handles_all_top_level_requests = input.browser_handles_all_top_level_requests();
      if (success && !input.ReadCaretBlinkInterval(&result->caret_blink_interval))
        success = false;
      if (success)
        result->use_custom_colors = input.use_custom_colors();
      if (success)
        result->enable_referrers = input.enable_referrers();
      if (success)
        result->allow_cross_origin_auth_prompt = input.allow_cross_origin_auth_prompt();
      if (success)
        result->enable_do_not_track = input.enable_do_not_track();
      if (success)
        result->enable_encrypted_media = input.enable_encrypted_media();
      if (success && !input.ReadWebrtcIpHandlingPolicy(&result->webrtc_ip_handling_policy))
        success = false;
      if (success && !input.ReadWebrtcIpHandlingUrls(&result->webrtc_ip_handling_urls))
        success = false;
      if (success) {
        result->webrtc_post_quantum_key_agreement = input.webrtc_post_quantum_key_agreement();
      }
      if (success)
        result->webrtc_udp_min_port = input.webrtc_udp_min_port();
      if (success)
        result->webrtc_udp_max_port = input.webrtc_udp_max_port();
      if (success && !input.ReadWebrtcLocalIpsAllowedUrls(&result->webrtc_local_ips_allowed_urls))
        success = false;
      if (success && !input.ReadUserAgentOverride(&result->user_agent_override))
        success = false;
      if (success && !input.ReadAcceptLanguages(&result->accept_languages))
        success = false;
      if (success)
        result->send_subresource_notification = input.send_subresource_notification();
      if (success)
        result->plugin_fullscreen_allowed = input.plugin_fullscreen_allowed();
      if (success)
        result->caret_browsing_enabled = input.caret_browsing_enabled();
      if (success && !input.ReadExplicitlyAllowedNetworkPorts(&result->explicitly_allowed_network_ports))
        success = false;
      if (success)
        result->view_source_line_wrap_enabled = input.view_source_line_wrap_enabled();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {




}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif