// third_party/blink/public/mojom/renderer_preference_watcher.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/renderer_preference_watcher.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/renderer_preference_watcher.mojom-params-data.h"
#include "third_party/blink/public/mojom/renderer_preference_watcher.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/renderer_preference_watcher.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/renderer_preference_watcher.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

RendererPreferenceWatcher::IPCStableHashFunction RendererPreferenceWatcher::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererPreferenceWatcher>(message.name())) {
    case messages::RendererPreferenceWatcher::kNotifyUpdate: {
      return &RendererPreferenceWatcher::NotifyUpdate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererPreferenceWatcher::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererPreferenceWatcher>(message.name())) {
      case messages::RendererPreferenceWatcher::kNotifyUpdate:
            return "Receive blink::mojom::RendererPreferenceWatcher::NotifyUpdate";
    }
  } else {
    switch (static_cast<messages::RendererPreferenceWatcher>(message.name())) {
      case messages::RendererPreferenceWatcher::kNotifyUpdate:
            return "Receive reply blink::mojom::RendererPreferenceWatcher::NotifyUpdate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererPreferenceWatcher::NotifyUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61720918;  // IPCStableHash for blink::mojom::RendererPreferenceWatcher::NotifyUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RendererPreferenceWatcherProxy::RendererPreferenceWatcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererPreferenceWatcherProxy::NotifyUpdate(
    const ::blink::RendererPreferences& in_new_prefs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RendererPreferenceWatcher::NotifyUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_prefs"), in_new_prefs,
                        "<value of type const ::blink::RendererPreferences&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererPreferenceWatcher::kNotifyUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RendererPreferenceWatcher_NotifyUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_prefs)::BaseType> new_prefs_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RendererPreferencesDataView>(
    in_new_prefs,
    new_prefs_fragment);

  params->new_prefs.Set(
      new_prefs_fragment.is_null() ? nullptr : new_prefs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_prefs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_prefs in RendererPreferenceWatcher.NotifyUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererPreferenceWatcher::Name_);
  message.set_method_name("NotifyUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RendererPreferenceWatcherStubDispatch::Accept(
    RendererPreferenceWatcher* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererPreferenceWatcher>(message->header()->name)) {
    case messages::RendererPreferenceWatcher::kNotifyUpdate: {
      DCHECK(message->is_serialized());
      internal::RendererPreferenceWatcher_NotifyUpdate_Params_Data* params =
          reinterpret_cast<internal::RendererPreferenceWatcher_NotifyUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererPreferenceWatcher.0
      bool success = true;
      ::blink::RendererPreferences p_new_prefs{};
      RendererPreferenceWatcher_NotifyUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewPrefs(&p_new_prefs))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererPreferenceWatcher::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyUpdate(        
        std::move(p_new_prefs));
      return true;
    }
  }
  return false;
}

// static
bool RendererPreferenceWatcherStubDispatch::AcceptWithResponder(
    RendererPreferenceWatcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererPreferenceWatcher>(message->header()->name)) {
    case messages::RendererPreferenceWatcher::kNotifyUpdate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRendererPreferenceWatcherValidationInfo[] = {
    { &internal::RendererPreferenceWatcher_NotifyUpdate_Params_Data::Validate,
     nullptr /* no response */},
};

bool RendererPreferenceWatcherRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::RendererPreferenceWatcher::Name_,
    kRendererPreferenceWatcherValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void RendererPreferenceWatcherInterceptorForTesting::NotifyUpdate(const ::blink::RendererPreferences& new_prefs) {
  GetForwardingInterface()->NotifyUpdate(
    std::move(new_prefs)
    );
}
RendererPreferenceWatcherAsyncWaiter::RendererPreferenceWatcherAsyncWaiter(
    RendererPreferenceWatcher* proxy) : proxy_(proxy) {}

RendererPreferenceWatcherAsyncWaiter::~RendererPreferenceWatcherAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif