// third_party/blink/public/mojom/render_accessibility.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/render_accessibility.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var ax_enums$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/ax_enums.mojom', '../../../../ui/accessibility/ax_enums.mojom.js');
  }
  var ax_action_data$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_action_data.mojom', '../../../../ui/accessibility/mojom/ax_action_data.mojom.js');
  }
  var ax_event$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_event.mojom', '../../../../ui/accessibility/mojom/ax_event.mojom.js');
  }
  var ax_mode$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_mode.mojom', '../../../../ui/accessibility/mojom/ax_mode.mojom.js');
  }
  var ax_relative_bounds$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_relative_bounds.mojom', '../../../../ui/accessibility/mojom/ax_relative_bounds.mojom.js');
  }
  var ax_tree_id$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_id.mojom', '../../../../ui/accessibility/mojom/ax_tree_id.mojom.js');
  }
  var ax_tree_update$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_update.mojom', '../../../../ui/accessibility/mojom/ax_tree_update.mojom.js');
  }
  var ax_updates_and_events$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_updates_and_events.mojom', '../../../../ui/accessibility/mojom/ax_updates_and_events.mojom.js');
  }
  var ax_location_and_scroll_updates$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_location_and_scroll_updates.mojom', '../../../../ui/accessibility/mojom/ax_location_and_scroll_updates.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', 'tokens/tokens.mojom.js');
  }



  function HitTestResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HitTestResponse.prototype.initDefaults_ = function() {
    this.stitchedChildTreeId = null;
    this.hitFrameToken = null;
    this.hitFrameTransformedPoint = null;
    this.hitNodeId = 0;
  };
  HitTestResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HitTestResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HitTestResponse.stitchedChildTreeId
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ax_tree_id$.AXTreeID, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HitTestResponse.hitFrameToken
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, tokens$.FrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HitTestResponse.hitFrameTransformedPoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HitTestResponse.encodedSize = codec.kStructHeaderSize + 48;

  HitTestResponse.decode = function(decoder) {
    var packed;
    var val = new HitTestResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.stitchedChildTreeId =
        decoder.decodeStruct(ax_tree_id$.AXTreeID);
    val.hitFrameToken =
        decoder.decodeStruct(tokens$.FrameToken);
    val.hitFrameTransformedPoint =
        decoder.decodeStructPointer(geometry$.Point);
    val.hitNodeId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HitTestResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HitTestResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ax_tree_id$.AXTreeID, val.stitchedChildTreeId);
    encoder.encodeStruct(tokens$.FrameToken, val.hitFrameToken);
    encoder.encodeStructPointer(geometry$.Point, val.hitFrameTransformedPoint);
    encoder.encodeStruct(codec.Int32, val.hitNodeId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RenderAccessibilityHost_HandleAXEvents_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderAccessibilityHost_HandleAXEvents_Params.prototype.initDefaults_ = function() {
    this.eventsAndUpdates = null;
    this.locationAndScrollUpdates = null;
    this.resetToken = 0;
  };
  RenderAccessibilityHost_HandleAXEvents_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderAccessibilityHost_HandleAXEvents_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderAccessibilityHost_HandleAXEvents_Params.eventsAndUpdates
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ax_updates_and_events$.AXUpdatesAndEvents, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderAccessibilityHost_HandleAXEvents_Params.locationAndScrollUpdates
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ax_location_and_scroll_updates$.AXLocationAndScrollUpdates, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RenderAccessibilityHost_HandleAXEvents_Params.encodedSize = codec.kStructHeaderSize + 24;

  RenderAccessibilityHost_HandleAXEvents_Params.decode = function(decoder) {
    var packed;
    var val = new RenderAccessibilityHost_HandleAXEvents_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.eventsAndUpdates =
        decoder.decodeStructPointer(ax_updates_and_events$.AXUpdatesAndEvents);
    val.locationAndScrollUpdates =
        decoder.decodeStructPointer(ax_location_and_scroll_updates$.AXLocationAndScrollUpdates);
    val.resetToken =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RenderAccessibilityHost_HandleAXEvents_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderAccessibilityHost_HandleAXEvents_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ax_updates_and_events$.AXUpdatesAndEvents, val.eventsAndUpdates);
    encoder.encodeStructPointer(ax_location_and_scroll_updates$.AXLocationAndScrollUpdates, val.locationAndScrollUpdates);
    encoder.encodeStruct(codec.Uint32, val.resetToken);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RenderAccessibilityHost_HandleAXEvents_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderAccessibilityHost_HandleAXEvents_ResponseParams.prototype.initDefaults_ = function() {
  };
  RenderAccessibilityHost_HandleAXEvents_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderAccessibilityHost_HandleAXEvents_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RenderAccessibilityHost_HandleAXEvents_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  RenderAccessibilityHost_HandleAXEvents_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RenderAccessibilityHost_HandleAXEvents_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RenderAccessibilityHost_HandleAXEvents_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderAccessibilityHost_HandleAXEvents_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function RenderAccessibilityHost_HandleAXLocationChanges_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderAccessibilityHost_HandleAXLocationChanges_Params.prototype.initDefaults_ = function() {
    this.changes = null;
    this.resetToken = 0;
  };
  RenderAccessibilityHost_HandleAXLocationChanges_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderAccessibilityHost_HandleAXLocationChanges_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderAccessibilityHost_HandleAXLocationChanges_Params.changes
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ax_location_and_scroll_updates$.AXLocationAndScrollUpdates, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RenderAccessibilityHost_HandleAXLocationChanges_Params.encodedSize = codec.kStructHeaderSize + 16;

  RenderAccessibilityHost_HandleAXLocationChanges_Params.decode = function(decoder) {
    var packed;
    var val = new RenderAccessibilityHost_HandleAXLocationChanges_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.changes =
        decoder.decodeStructPointer(ax_location_and_scroll_updates$.AXLocationAndScrollUpdates);
    val.resetToken =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RenderAccessibilityHost_HandleAXLocationChanges_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderAccessibilityHost_HandleAXLocationChanges_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ax_location_and_scroll_updates$.AXLocationAndScrollUpdates, val.changes);
    encoder.encodeStruct(codec.Uint32, val.resetToken);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RenderAccessibility_SetMode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderAccessibility_SetMode_Params.prototype.initDefaults_ = function() {
    this.axMode = null;
    this.resetToken = 0;
  };
  RenderAccessibility_SetMode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderAccessibility_SetMode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderAccessibility_SetMode_Params.axMode
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ax_mode$.AXMode, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RenderAccessibility_SetMode_Params.encodedSize = codec.kStructHeaderSize + 16;

  RenderAccessibility_SetMode_Params.decode = function(decoder) {
    var packed;
    var val = new RenderAccessibility_SetMode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.axMode =
        decoder.decodeStructPointer(ax_mode$.AXMode);
    val.resetToken =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RenderAccessibility_SetMode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderAccessibility_SetMode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ax_mode$.AXMode, val.axMode);
    encoder.encodeStruct(codec.Uint32, val.resetToken);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RenderAccessibility_FatalError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderAccessibility_FatalError_Params.prototype.initDefaults_ = function() {
  };
  RenderAccessibility_FatalError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderAccessibility_FatalError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RenderAccessibility_FatalError_Params.encodedSize = codec.kStructHeaderSize + 0;

  RenderAccessibility_FatalError_Params.decode = function(decoder) {
    var packed;
    var val = new RenderAccessibility_FatalError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RenderAccessibility_FatalError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderAccessibility_FatalError_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RenderAccessibility_HitTest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderAccessibility_HitTest_Params.prototype.initDefaults_ = function() {
    this.point = null;
    this.eventToFire = 0;
    this.requestId = 0;
  };
  RenderAccessibility_HitTest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderAccessibility_HitTest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderAccessibility_HitTest_Params.point
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderAccessibility_HitTest_Params.eventToFire
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ax_enums$.Event);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RenderAccessibility_HitTest_Params.encodedSize = codec.kStructHeaderSize + 16;

  RenderAccessibility_HitTest_Params.decode = function(decoder) {
    var packed;
    var val = new RenderAccessibility_HitTest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.point =
        decoder.decodeStructPointer(geometry$.Point);
    val.eventToFire =
        decoder.decodeStruct(new codec.Enum(ax_enums$.Event));
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  RenderAccessibility_HitTest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderAccessibility_HitTest_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Point, val.point);
    encoder.encodeStruct(codec.Int32, val.eventToFire);
    encoder.encodeStruct(codec.Int32, val.requestId);
  };
  function RenderAccessibility_HitTest_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderAccessibility_HitTest_ResponseParams.prototype.initDefaults_ = function() {
    this.hitTestResponse = null;
  };
  RenderAccessibility_HitTest_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderAccessibility_HitTest_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderAccessibility_HitTest_ResponseParams.hitTestResponse
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, HitTestResponse, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RenderAccessibility_HitTest_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RenderAccessibility_HitTest_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RenderAccessibility_HitTest_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.hitTestResponse =
        decoder.decodeStructPointer(HitTestResponse);
    return val;
  };

  RenderAccessibility_HitTest_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderAccessibility_HitTest_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(HitTestResponse, val.hitTestResponse);
  };
  function RenderAccessibility_PerformAction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderAccessibility_PerformAction_Params.prototype.initDefaults_ = function() {
    this.actionData = null;
  };
  RenderAccessibility_PerformAction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderAccessibility_PerformAction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RenderAccessibility_PerformAction_Params.actionData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ax_action_data$.AXActionData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RenderAccessibility_PerformAction_Params.encodedSize = codec.kStructHeaderSize + 8;

  RenderAccessibility_PerformAction_Params.decode = function(decoder) {
    var packed;
    var val = new RenderAccessibility_PerformAction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.actionData =
        decoder.decodeStructPointer(ax_action_data$.AXActionData);
    return val;
  };

  RenderAccessibility_PerformAction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderAccessibility_PerformAction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ax_action_data$.AXActionData, val.actionData);
  };
  function RenderAccessibility_Reset_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RenderAccessibility_Reset_Params.prototype.initDefaults_ = function() {
    this.resetToken = 0;
  };
  RenderAccessibility_Reset_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RenderAccessibility_Reset_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RenderAccessibility_Reset_Params.encodedSize = codec.kStructHeaderSize + 8;

  RenderAccessibility_Reset_Params.decode = function(decoder) {
    var packed;
    var val = new RenderAccessibility_Reset_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resetToken =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RenderAccessibility_Reset_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RenderAccessibility_Reset_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.resetToken);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kRenderAccessibilityHost_HandleAXEvents_Name = 0;
  var kRenderAccessibilityHost_HandleAXLocationChanges_Name = 1;

  function RenderAccessibilityHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RenderAccessibilityHost,
                                                   handleOrPtrInfo);
  }

  function RenderAccessibilityHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RenderAccessibilityHost, associatedInterfacePtrInfo);
  }

  RenderAccessibilityHostAssociatedPtr.prototype =
      Object.create(RenderAccessibilityHostPtr.prototype);
  RenderAccessibilityHostAssociatedPtr.prototype.constructor =
      RenderAccessibilityHostAssociatedPtr;

  function RenderAccessibilityHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  RenderAccessibilityHostPtr.prototype.handleAXEvents = function() {
    return RenderAccessibilityHostProxy.prototype.handleAXEvents
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderAccessibilityHostProxy.prototype.handleAXEvents = function(eventsAndUpdates, locationAndScrollUpdates, resetToken) {
    var params_ = new RenderAccessibilityHost_HandleAXEvents_Params();
    params_.eventsAndUpdates = eventsAndUpdates;
    params_.locationAndScrollUpdates = locationAndScrollUpdates;
    params_.resetToken = resetToken;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRenderAccessibilityHost_HandleAXEvents_Name,
          codec.align(RenderAccessibilityHost_HandleAXEvents_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RenderAccessibilityHost_HandleAXEvents_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RenderAccessibilityHost_HandleAXEvents_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RenderAccessibilityHostPtr.prototype.handleAXLocationChanges = function() {
    return RenderAccessibilityHostProxy.prototype.handleAXLocationChanges
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderAccessibilityHostProxy.prototype.handleAXLocationChanges = function(changes, resetToken) {
    var params_ = new RenderAccessibilityHost_HandleAXLocationChanges_Params();
    params_.changes = changes;
    params_.resetToken = resetToken;
    var builder = new codec.MessageV0Builder(
        kRenderAccessibilityHost_HandleAXLocationChanges_Name,
        codec.align(RenderAccessibilityHost_HandleAXLocationChanges_Params.encodedSize));
    builder.encodeStruct(RenderAccessibilityHost_HandleAXLocationChanges_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RenderAccessibilityHostStub(delegate) {
    this.delegate_ = delegate;
  }
  RenderAccessibilityHostStub.prototype.handleAXEvents = function(eventsAndUpdates, locationAndScrollUpdates, resetToken) {
    return this.delegate_ && this.delegate_.handleAXEvents && this.delegate_.handleAXEvents(eventsAndUpdates, locationAndScrollUpdates, resetToken);
  }
  RenderAccessibilityHostStub.prototype.handleAXLocationChanges = function(changes, resetToken) {
    return this.delegate_ && this.delegate_.handleAXLocationChanges && this.delegate_.handleAXLocationChanges(changes, resetToken);
  }

  RenderAccessibilityHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRenderAccessibilityHost_HandleAXLocationChanges_Name:
      var params = reader.decodeStruct(RenderAccessibilityHost_HandleAXLocationChanges_Params);
      this.handleAXLocationChanges(params.changes, params.resetToken);
      return true;
    default:
      return false;
    }
  };

  RenderAccessibilityHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRenderAccessibilityHost_HandleAXEvents_Name:
      var params = reader.decodeStruct(RenderAccessibilityHost_HandleAXEvents_Params);
      this.handleAXEvents(params.eventsAndUpdates, params.locationAndScrollUpdates, params.resetToken).then(function(response) {
        var responseParams =
            new RenderAccessibilityHost_HandleAXEvents_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kRenderAccessibilityHost_HandleAXEvents_Name,
            codec.align(RenderAccessibilityHost_HandleAXEvents_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RenderAccessibilityHost_HandleAXEvents_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateRenderAccessibilityHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRenderAccessibilityHost_HandleAXEvents_Name:
        if (message.expectsResponse())
          paramsClass = RenderAccessibilityHost_HandleAXEvents_Params;
      break;
      case kRenderAccessibilityHost_HandleAXLocationChanges_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RenderAccessibilityHost_HandleAXLocationChanges_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRenderAccessibilityHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kRenderAccessibilityHost_HandleAXEvents_Name:
        if (message.isResponse())
          paramsClass = RenderAccessibilityHost_HandleAXEvents_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var RenderAccessibilityHost = {
    name: 'blink.mojom.RenderAccessibilityHost',
    kVersion: 0,
    ptrClass: RenderAccessibilityHostPtr,
    proxyClass: RenderAccessibilityHostProxy,
    stubClass: RenderAccessibilityHostStub,
    validateRequest: validateRenderAccessibilityHostRequest,
    validateResponse: validateRenderAccessibilityHostResponse,
  };
  RenderAccessibilityHostStub.prototype.validator = validateRenderAccessibilityHostRequest;
  RenderAccessibilityHostProxy.prototype.validator = validateRenderAccessibilityHostResponse;
  var kRenderAccessibility_SetMode_Name = 0;
  var kRenderAccessibility_FatalError_Name = 1;
  var kRenderAccessibility_HitTest_Name = 2;
  var kRenderAccessibility_PerformAction_Name = 3;
  var kRenderAccessibility_Reset_Name = 4;

  function RenderAccessibilityPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RenderAccessibility,
                                                   handleOrPtrInfo);
  }

  function RenderAccessibilityAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RenderAccessibility, associatedInterfacePtrInfo);
  }

  RenderAccessibilityAssociatedPtr.prototype =
      Object.create(RenderAccessibilityPtr.prototype);
  RenderAccessibilityAssociatedPtr.prototype.constructor =
      RenderAccessibilityAssociatedPtr;

  function RenderAccessibilityProxy(receiver) {
    this.receiver_ = receiver;
  }
  RenderAccessibilityPtr.prototype.setMode = function() {
    return RenderAccessibilityProxy.prototype.setMode
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderAccessibilityProxy.prototype.setMode = function(axMode, resetToken) {
    var params_ = new RenderAccessibility_SetMode_Params();
    params_.axMode = axMode;
    params_.resetToken = resetToken;
    var builder = new codec.MessageV0Builder(
        kRenderAccessibility_SetMode_Name,
        codec.align(RenderAccessibility_SetMode_Params.encodedSize));
    builder.encodeStruct(RenderAccessibility_SetMode_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RenderAccessibilityPtr.prototype.fatalError = function() {
    return RenderAccessibilityProxy.prototype.fatalError
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderAccessibilityProxy.prototype.fatalError = function() {
    var params_ = new RenderAccessibility_FatalError_Params();
    var builder = new codec.MessageV0Builder(
        kRenderAccessibility_FatalError_Name,
        codec.align(RenderAccessibility_FatalError_Params.encodedSize));
    builder.encodeStruct(RenderAccessibility_FatalError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RenderAccessibilityPtr.prototype.hitTest = function() {
    return RenderAccessibilityProxy.prototype.hitTest
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderAccessibilityProxy.prototype.hitTest = function(point, eventToFire, requestId) {
    var params_ = new RenderAccessibility_HitTest_Params();
    params_.point = point;
    params_.eventToFire = eventToFire;
    params_.requestId = requestId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRenderAccessibility_HitTest_Name,
          codec.align(RenderAccessibility_HitTest_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RenderAccessibility_HitTest_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RenderAccessibility_HitTest_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RenderAccessibilityPtr.prototype.performAction = function() {
    return RenderAccessibilityProxy.prototype.performAction
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderAccessibilityProxy.prototype.performAction = function(actionData) {
    var params_ = new RenderAccessibility_PerformAction_Params();
    params_.actionData = actionData;
    var builder = new codec.MessageV0Builder(
        kRenderAccessibility_PerformAction_Name,
        codec.align(RenderAccessibility_PerformAction_Params.encodedSize));
    builder.encodeStruct(RenderAccessibility_PerformAction_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RenderAccessibilityPtr.prototype.reset = function() {
    return RenderAccessibilityProxy.prototype.reset
        .apply(this.ptr.getProxy(), arguments);
  };

  RenderAccessibilityProxy.prototype.reset = function(resetToken) {
    var params_ = new RenderAccessibility_Reset_Params();
    params_.resetToken = resetToken;
    var builder = new codec.MessageV0Builder(
        kRenderAccessibility_Reset_Name,
        codec.align(RenderAccessibility_Reset_Params.encodedSize));
    builder.encodeStruct(RenderAccessibility_Reset_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RenderAccessibilityStub(delegate) {
    this.delegate_ = delegate;
  }
  RenderAccessibilityStub.prototype.setMode = function(axMode, resetToken) {
    return this.delegate_ && this.delegate_.setMode && this.delegate_.setMode(axMode, resetToken);
  }
  RenderAccessibilityStub.prototype.fatalError = function() {
    return this.delegate_ && this.delegate_.fatalError && this.delegate_.fatalError();
  }
  RenderAccessibilityStub.prototype.hitTest = function(point, eventToFire, requestId) {
    return this.delegate_ && this.delegate_.hitTest && this.delegate_.hitTest(point, eventToFire, requestId);
  }
  RenderAccessibilityStub.prototype.performAction = function(actionData) {
    return this.delegate_ && this.delegate_.performAction && this.delegate_.performAction(actionData);
  }
  RenderAccessibilityStub.prototype.reset = function(resetToken) {
    return this.delegate_ && this.delegate_.reset && this.delegate_.reset(resetToken);
  }

  RenderAccessibilityStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRenderAccessibility_SetMode_Name:
      var params = reader.decodeStruct(RenderAccessibility_SetMode_Params);
      this.setMode(params.axMode, params.resetToken);
      return true;
    case kRenderAccessibility_FatalError_Name:
      var params = reader.decodeStruct(RenderAccessibility_FatalError_Params);
      this.fatalError();
      return true;
    case kRenderAccessibility_PerformAction_Name:
      var params = reader.decodeStruct(RenderAccessibility_PerformAction_Params);
      this.performAction(params.actionData);
      return true;
    case kRenderAccessibility_Reset_Name:
      var params = reader.decodeStruct(RenderAccessibility_Reset_Params);
      this.reset(params.resetToken);
      return true;
    default:
      return false;
    }
  };

  RenderAccessibilityStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRenderAccessibility_HitTest_Name:
      var params = reader.decodeStruct(RenderAccessibility_HitTest_Params);
      this.hitTest(params.point, params.eventToFire, params.requestId).then(function(response) {
        var responseParams =
            new RenderAccessibility_HitTest_ResponseParams();
        responseParams.hitTestResponse = response.hitTestResponse;
        var builder = new codec.MessageV1Builder(
            kRenderAccessibility_HitTest_Name,
            codec.align(RenderAccessibility_HitTest_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RenderAccessibility_HitTest_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateRenderAccessibilityRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRenderAccessibility_SetMode_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RenderAccessibility_SetMode_Params;
      break;
      case kRenderAccessibility_FatalError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RenderAccessibility_FatalError_Params;
      break;
      case kRenderAccessibility_HitTest_Name:
        if (message.expectsResponse())
          paramsClass = RenderAccessibility_HitTest_Params;
      break;
      case kRenderAccessibility_PerformAction_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RenderAccessibility_PerformAction_Params;
      break;
      case kRenderAccessibility_Reset_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RenderAccessibility_Reset_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRenderAccessibilityResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kRenderAccessibility_HitTest_Name:
        if (message.isResponse())
          paramsClass = RenderAccessibility_HitTest_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var RenderAccessibility = {
    name: 'blink.mojom.RenderAccessibility',
    kVersion: 0,
    ptrClass: RenderAccessibilityPtr,
    proxyClass: RenderAccessibilityProxy,
    stubClass: RenderAccessibilityStub,
    validateRequest: validateRenderAccessibilityRequest,
    validateResponse: validateRenderAccessibilityResponse,
  };
  RenderAccessibilityStub.prototype.validator = validateRenderAccessibilityRequest;
  RenderAccessibilityProxy.prototype.validator = validateRenderAccessibilityResponse;
  exports.HitTestResponse = HitTestResponse;
  exports.RenderAccessibilityHost = RenderAccessibilityHost;
  exports.RenderAccessibilityHostPtr = RenderAccessibilityHostPtr;
  exports.RenderAccessibilityHostAssociatedPtr = RenderAccessibilityHostAssociatedPtr;
  exports.RenderAccessibility = RenderAccessibility;
  exports.RenderAccessibilityPtr = RenderAccessibilityPtr;
  exports.RenderAccessibilityAssociatedPtr = RenderAccessibilityAssociatedPtr;
})();