// third_party/blink/public/mojom/render_accessibility.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/render_accessibility.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_action_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"
#include "ui/accessibility/mojom/ax_mode.mojom-shared.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/accessibility/mojom/ax_updates_and_events.mojom-shared.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"

#include "third_party/blink/public/mojom/render_accessibility.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::HitTestResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HitTestResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HitTestResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::stitched_child_tree_id(input)) in_stitched_child_tree_id = Traits::stitched_child_tree_id(input);
      mojo::internal::MessageFragment<decltype(fragment->stitched_child_tree_id)>
          stitched_child_tree_id_fragment(fragment.message());
      stitched_child_tree_id_fragment.Claim(&fragment->stitched_child_tree_id);
      
      mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView, send_validation>(
        in_stitched_child_tree_id,
        stitched_child_tree_id_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->stitched_child_tree_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stitched_child_tree_id in HitTestResponse struct");

      decltype(Traits::hit_frame_token(input)) in_hit_frame_token = Traits::hit_frame_token(input);
      mojo::internal::MessageFragment<decltype(fragment->hit_frame_token)>
          hit_frame_token_fragment(fragment.message());
      hit_frame_token_fragment.Claim(&fragment->hit_frame_token);
      
      mojo::internal::Serialize<::blink::mojom::FrameTokenDataView, send_validation>(
        in_hit_frame_token,
        hit_frame_token_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hit_frame_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hit_frame_token in HitTestResponse struct");

      decltype(Traits::hit_frame_transformed_point(input)) in_hit_frame_transformed_point = Traits::hit_frame_transformed_point(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hit_frame_transformed_point)::BaseType> hit_frame_transformed_point_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_hit_frame_transformed_point,
        hit_frame_transformed_point_fragment);

      fragment->hit_frame_transformed_point.Set(
          hit_frame_transformed_point_fragment.is_null() ? nullptr : hit_frame_transformed_point_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hit_frame_transformed_point.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hit_frame_transformed_point in HitTestResponse struct");

      fragment->hit_node_id = Traits::hit_node_id(input);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_SEND_VALIDATION_H_