// third_party/blink/public/mojom/render_accessibility.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace blink::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RenderAccessibilityHost_HandleAXEvents_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::ax::mojom::internal::AXUpdatesAndEvents_Data> events_and_updates;
  mojo::internal::Pointer<::ax::mojom::internal::AXLocationAndScrollUpdates_Data> location_and_scroll_updates;
  uint32_t reset_token;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RenderAccessibilityHost_HandleAXEvents_Params_Data>;

  RenderAccessibilityHost_HandleAXEvents_Params_Data();
  ~RenderAccessibilityHost_HandleAXEvents_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibilityHost_HandleAXEvents_Params_Data) == 32,
              "Bad sizeof(RenderAccessibilityHost_HandleAXEvents_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data>;

  RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data();
  ~RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data() = delete;
};
static_assert(sizeof(RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data) == 8,
              "Bad sizeof(RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RenderAccessibilityHost_HandleAXLocationChanges_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::ax::mojom::internal::AXLocationAndScrollUpdates_Data> changes;
  uint32_t reset_token;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RenderAccessibilityHost_HandleAXLocationChanges_Params_Data>;

  RenderAccessibilityHost_HandleAXLocationChanges_Params_Data();
  ~RenderAccessibilityHost_HandleAXLocationChanges_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibilityHost_HandleAXLocationChanges_Params_Data) == 24,
              "Bad sizeof(RenderAccessibilityHost_HandleAXLocationChanges_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RenderAccessibility_SetMode_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::ax::mojom::internal::AXMode_Data> ax_mode;
  uint32_t reset_token;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RenderAccessibility_SetMode_Params_Data>;

  RenderAccessibility_SetMode_Params_Data();
  ~RenderAccessibility_SetMode_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_SetMode_Params_Data) == 24,
              "Bad sizeof(RenderAccessibility_SetMode_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RenderAccessibility_FatalError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<RenderAccessibility_FatalError_Params_Data>;

  RenderAccessibility_FatalError_Params_Data();
  ~RenderAccessibility_FatalError_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_FatalError_Params_Data) == 8,
              "Bad sizeof(RenderAccessibility_FatalError_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RenderAccessibility_HitTest_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Point_Data> point;
  int32_t event_to_fire;
  int32_t request_id;

 private:
  friend class mojo::internal::MessageFragment<RenderAccessibility_HitTest_Params_Data>;

  RenderAccessibility_HitTest_Params_Data();
  ~RenderAccessibility_HitTest_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_HitTest_Params_Data) == 24,
              "Bad sizeof(RenderAccessibility_HitTest_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RenderAccessibility_HitTest_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::HitTestResponse_Data> hit_test_response;

 private:
  friend class mojo::internal::MessageFragment<RenderAccessibility_HitTest_ResponseParams_Data>;

  RenderAccessibility_HitTest_ResponseParams_Data();
  ~RenderAccessibility_HitTest_ResponseParams_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_HitTest_ResponseParams_Data) == 16,
              "Bad sizeof(RenderAccessibility_HitTest_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RenderAccessibility_PerformAction_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::ax::mojom::internal::AXActionData_Data> action_data;

 private:
  friend class mojo::internal::MessageFragment<RenderAccessibility_PerformAction_Params_Data>;

  RenderAccessibility_PerformAction_Params_Data();
  ~RenderAccessibility_PerformAction_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_PerformAction_Params_Data) == 16,
              "Bad sizeof(RenderAccessibility_PerformAction_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) RenderAccessibility_Reset_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t reset_token;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RenderAccessibility_Reset_Params_Data>;

  RenderAccessibility_Reset_Params_Data();
  ~RenderAccessibility_Reset_Params_Data() = delete;
};
static_assert(sizeof(RenderAccessibility_Reset_Params_Data) == 16,
              "Bad sizeof(RenderAccessibility_Reset_Params_Data)");

}  // namespace internal


class RenderAccessibilityHost_HandleAXEvents_ParamsDataView {
 public:
  RenderAccessibilityHost_HandleAXEvents_ParamsDataView() = default;

  RenderAccessibilityHost_HandleAXEvents_ParamsDataView(
      internal::RenderAccessibilityHost_HandleAXEvents_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEventsAndUpdatesDataView(
      ::ax::mojom::AXUpdatesAndEventsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventsAndUpdates(UserType* output) {
    
    auto* pointer = data_->events_and_updates.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXUpdatesAndEventsDataView>(
        pointer, output, message_);
  }
  inline void GetLocationAndScrollUpdatesDataView(
      ::ax::mojom::AXLocationAndScrollUpdatesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocationAndScrollUpdates(UserType* output) {
    
    auto* pointer = data_->location_and_scroll_updates.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXLocationAndScrollUpdatesDataView>(
        pointer, output, message_);
  }
  uint32_t reset_token() const {
    return data_->reset_token;
  }
 private:
  internal::RenderAccessibilityHost_HandleAXEvents_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderAccessibilityHost_HandleAXEvents_ResponseParamsDataView {
 public:
  RenderAccessibilityHost_HandleAXEvents_ResponseParamsDataView() = default;

  RenderAccessibilityHost_HandleAXEvents_ResponseParamsDataView(
      internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data* data_ = nullptr;
};


class RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView {
 public:
  RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView() = default;

  RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView(
      internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetChangesDataView(
      ::ax::mojom::AXLocationAndScrollUpdatesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChanges(UserType* output) {
    
    auto* pointer = data_->changes.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXLocationAndScrollUpdatesDataView>(
        pointer, output, message_);
  }
  uint32_t reset_token() const {
    return data_->reset_token;
  }
 private:
  internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderAccessibility_SetMode_ParamsDataView {
 public:
  RenderAccessibility_SetMode_ParamsDataView() = default;

  RenderAccessibility_SetMode_ParamsDataView(
      internal::RenderAccessibility_SetMode_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAxModeDataView(
      ::ax::mojom::AXModeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAxMode(UserType* output) {
    
    auto* pointer = data_->ax_mode.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXModeDataView>(
        pointer, output, message_);
  }
  uint32_t reset_token() const {
    return data_->reset_token;
  }
 private:
  internal::RenderAccessibility_SetMode_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderAccessibility_FatalError_ParamsDataView {
 public:
  RenderAccessibility_FatalError_ParamsDataView() = default;

  RenderAccessibility_FatalError_ParamsDataView(
      internal::RenderAccessibility_FatalError_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RenderAccessibility_FatalError_Params_Data* data_ = nullptr;
};


class RenderAccessibility_HitTest_ParamsDataView {
 public:
  RenderAccessibility_HitTest_ParamsDataView() = default;

  RenderAccessibility_HitTest_ParamsDataView(
      internal::RenderAccessibility_HitTest_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPointDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoint(UserType* output) {
    
    auto* pointer = data_->point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEventToFire(UserType* output) const {
    auto data_value = data_->event_to_fire;
    return mojo::internal::Deserialize<::ax::mojom::Event>(
        data_value, output);
  }
  ::ax::mojom::Event event_to_fire() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Event>(data_->event_to_fire));
  }
  int32_t request_id() const {
    return data_->request_id;
  }
 private:
  internal::RenderAccessibility_HitTest_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderAccessibility_HitTest_ResponseParamsDataView {
 public:
  RenderAccessibility_HitTest_ResponseParamsDataView() = default;

  RenderAccessibility_HitTest_ResponseParamsDataView(
      internal::RenderAccessibility_HitTest_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHitTestResponseDataView(
      HitTestResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHitTestResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::HitTestResponseDataView, UserType>(),
    "Attempting to read the optional `hit_test_response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHitTestResponse` instead "
    "of `ReadHitTestResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hit_test_response.Get();
    return mojo::internal::Deserialize<::blink::mojom::HitTestResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::RenderAccessibility_HitTest_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderAccessibility_PerformAction_ParamsDataView {
 public:
  RenderAccessibility_PerformAction_ParamsDataView() = default;

  RenderAccessibility_PerformAction_ParamsDataView(
      internal::RenderAccessibility_PerformAction_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetActionDataDataView(
      ::ax::mojom::AXActionDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActionData(UserType* output) {
    
    auto* pointer = data_->action_data.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXActionDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::RenderAccessibility_PerformAction_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderAccessibility_Reset_ParamsDataView {
 public:
  RenderAccessibility_Reset_ParamsDataView() = default;

  RenderAccessibility_Reset_ParamsDataView(
      internal::RenderAccessibility_Reset_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t reset_token() const {
    return data_->reset_token;
  }
 private:
  internal::RenderAccessibility_Reset_Params_Data* data_ = nullptr;
};

inline void RenderAccessibilityHost_HandleAXEvents_ParamsDataView::GetEventsAndUpdatesDataView(
    ::ax::mojom::AXUpdatesAndEventsDataView* output) {
  auto pointer = data_->events_and_updates.Get();
  *output = ::ax::mojom::AXUpdatesAndEventsDataView(pointer, message_);
}
inline void RenderAccessibilityHost_HandleAXEvents_ParamsDataView::GetLocationAndScrollUpdatesDataView(
    ::ax::mojom::AXLocationAndScrollUpdatesDataView* output) {
  auto pointer = data_->location_and_scroll_updates.Get();
  *output = ::ax::mojom::AXLocationAndScrollUpdatesDataView(pointer, message_);
}




inline void RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView::GetChangesDataView(
    ::ax::mojom::AXLocationAndScrollUpdatesDataView* output) {
  auto pointer = data_->changes.Get();
  *output = ::ax::mojom::AXLocationAndScrollUpdatesDataView(pointer, message_);
}


inline void RenderAccessibility_SetMode_ParamsDataView::GetAxModeDataView(
    ::ax::mojom::AXModeDataView* output) {
  auto pointer = data_->ax_mode.Get();
  *output = ::ax::mojom::AXModeDataView(pointer, message_);
}




inline void RenderAccessibility_HitTest_ParamsDataView::GetPointDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->point.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}


inline void RenderAccessibility_HitTest_ResponseParamsDataView::GetHitTestResponseDataView(
    HitTestResponseDataView* output) {
  auto pointer = data_->hit_test_response.Get();
  *output = HitTestResponseDataView(pointer, message_);
}


inline void RenderAccessibility_PerformAction_ParamsDataView::GetActionDataDataView(
    ::ax::mojom::AXActionDataDataView* output) {
  auto pointer = data_->action_data.Get();
  *output = ::ax::mojom::AXActionDataDataView(pointer, message_);
}





}  // blink::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_PARAMS_DATA_H_