// third_party/blink/public/mojom/printing/web_printing.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/printing/web_printing.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/printing/web_printing.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/printing/web_printing.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class WebPrintJobStateObserverProxy;

template <typename ImplRefTraits>
class WebPrintJobStateObserverStub;

class WebPrintJobStateObserverRequestValidator;


class BLINK_COMMON_EXPORT WebPrintJobStateObserver
    : public WebPrintJobStateObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebPrintJobStateObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebPrintJobStateObserverInterfaceBase;
  using Proxy_ = WebPrintJobStateObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebPrintJobStateObserverStub<ImplRefTraits>;

  using RequestValidator_ = WebPrintJobStateObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnWebPrintJobUpdateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnWebPrintJobUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebPrintJobStateObserver() = default;

  virtual void OnWebPrintJobUpdate(WebPrintJobUpdatePtr update) = 0;
};

class WebPrintJobControllerProxy;

template <typename ImplRefTraits>
class WebPrintJobControllerStub;

class WebPrintJobControllerRequestValidator;


class BLINK_COMMON_EXPORT WebPrintJobController
    : public WebPrintJobControllerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebPrintJobController";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebPrintJobControllerInterfaceBase;
  using Proxy_ = WebPrintJobControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebPrintJobControllerStub<ImplRefTraits>;

  using RequestValidator_ = WebPrintJobControllerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCancelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebPrintJobController() = default;

  virtual void Cancel() = 0;
};

class WebPrinterProxy;

template <typename ImplRefTraits>
class WebPrinterStub;

class WebPrinterRequestValidator;
class WebPrinterResponseValidator;


class BLINK_COMMON_EXPORT WebPrinter
    : public WebPrinterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebPrinter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebPrinterInterfaceBase;
  using Proxy_ = WebPrinterProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebPrinterStub<ImplRefTraits>;

  using RequestValidator_ = WebPrinterRequestValidator;
  using ResponseValidator_ = WebPrinterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kFetchAttributesMinVersion = 0,
    kPrintMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FetchAttributes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Print_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebPrinter() = default;

  using FetchAttributesCallback = base::OnceCallback<void(WebPrinterFetchResultPtr)>;
  using FetchAttributesMojoCallback = base::OnceCallback<void(WebPrinterFetchResultPtr)>;

  virtual void FetchAttributes(FetchAttributesCallback callback) = 0;

  using PrintCallback = base::OnceCallback<void(WebPrintResultPtr)>;
  using PrintMojoCallback = base::OnceCallback<void(WebPrintResultPtr)>;

  virtual void Print(::mojo::PendingRemote<::blink::mojom::Blob> document, WebPrintJobTemplateAttributesPtr attributes, PrintCallback callback) = 0;
};

class WebPrintingServiceProxy;

template <typename ImplRefTraits>
class WebPrintingServiceStub;

class WebPrintingServiceRequestValidator;
class WebPrintingServiceResponseValidator;


class BLINK_COMMON_EXPORT WebPrintingService
    : public WebPrintingServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebPrintingService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebPrintingServiceInterfaceBase;
  using Proxy_ = WebPrintingServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebPrintingServiceStub<ImplRefTraits>;

  using RequestValidator_ = WebPrintingServiceRequestValidator;
  using ResponseValidator_ = WebPrintingServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPrintersMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetPrinters_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebPrintingService() = default;

  using GetPrintersCallback = base::OnceCallback<void(GetPrintersResultPtr)>;
  using GetPrintersMojoCallback = base::OnceCallback<void(GetPrintersResultPtr)>;

  virtual void GetPrinters(GetPrintersCallback callback) = 0;
};



class BLINK_COMMON_EXPORT WebPrintJobStateObserverProxy
    : public WebPrintJobStateObserver {
 public:
  using InterfaceType = WebPrintJobStateObserver;

  explicit WebPrintJobStateObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnWebPrintJobUpdate(WebPrintJobUpdatePtr update) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT WebPrintJobControllerProxy
    : public WebPrintJobController {
 public:
  using InterfaceType = WebPrintJobController;

  explicit WebPrintJobControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Cancel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT WebPrinterProxy
    : public WebPrinter {
 public:
  using InterfaceType = WebPrinter;

  explicit WebPrinterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FetchAttributes(FetchAttributesCallback callback) final;
  
  void Print(::mojo::PendingRemote<::blink::mojom::Blob> document, WebPrintJobTemplateAttributesPtr attributes, PrintCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT WebPrintingServiceProxy
    : public WebPrintingService {
 public:
  using InterfaceType = WebPrintingService;

  explicit WebPrintingServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetPrinters(GetPrintersCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT WebPrintJobStateObserverStubDispatch {
 public:
  static bool Accept(WebPrintJobStateObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebPrintJobStateObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebPrintJobStateObserver>>
class WebPrintJobStateObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebPrintJobStateObserverStub() = default;
  ~WebPrintJobStateObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPrintJobStateObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPrintJobStateObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebPrintJobControllerStubDispatch {
 public:
  static bool Accept(WebPrintJobController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebPrintJobController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebPrintJobController>>
class WebPrintJobControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebPrintJobControllerStub() = default;
  ~WebPrintJobControllerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPrintJobControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPrintJobControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebPrinterStubDispatch {
 public:
  static bool Accept(WebPrinter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebPrinter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebPrinter>>
class WebPrinterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebPrinterStub() = default;
  ~WebPrinterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPrinterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPrinterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebPrintingServiceStubDispatch {
 public:
  static bool Accept(WebPrintingService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebPrintingService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebPrintingService>>
class WebPrintingServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebPrintingServiceStub() = default;
  ~WebPrintingServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPrintingServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPrintingServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebPrintJobStateObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebPrintJobControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebPrinterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebPrintingServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebPrinterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebPrintingServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class BLINK_COMMON_EXPORT WebPrintingRange {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPrintingRange, T>::value>;
  using DataView = WebPrintingRangeDataView;
  using Data_ = internal::WebPrintingRange_Data;

  template <typename... Args>
  static WebPrintingRangePtr New(Args&&... args) {
    return WebPrintingRangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPrintingRangePtr From(const U& u) {
    return mojo::TypeConverter<WebPrintingRangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrintingRange>::Convert(*this);
  }


  WebPrintingRange();

  WebPrintingRange(
      uint32_t from,
      uint32_t to);


  ~WebPrintingRange();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPrintingRangePtr>
  WebPrintingRangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPrintingRange::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPrintingRange::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPrintingRange::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintingRange::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintingRange::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrintingRange::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPrintingRange_UnserializedMessageContext<
            UserType, WebPrintingRange::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPrintingRange::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPrintingRange::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPrintingRange_UnserializedMessageContext<
            UserType, WebPrintingRange::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPrintingRange::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t from;
  
  uint32_t to;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPrintingRange::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPrintingRange::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPrintingRange::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPrintingRange::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class BLINK_COMMON_EXPORT WebPrintJobUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPrintJobUpdate, T>::value>;
  using DataView = WebPrintJobUpdateDataView;
  using Data_ = internal::WebPrintJobUpdate_Data;

  template <typename... Args>
  static WebPrintJobUpdatePtr New(Args&&... args) {
    return WebPrintJobUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPrintJobUpdatePtr From(const U& u) {
    return mojo::TypeConverter<WebPrintJobUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrintJobUpdate>::Convert(*this);
  }


  WebPrintJobUpdate();

  WebPrintJobUpdate(
      WebPrintJobState state,
      uint32_t pages_printed);


  ~WebPrintJobUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPrintJobUpdatePtr>
  WebPrintJobUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPrintJobUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPrintJobUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPrintJobUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintJobUpdate::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintJobUpdate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrintJobUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPrintJobUpdate_UnserializedMessageContext<
            UserType, WebPrintJobUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPrintJobUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPrintJobUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPrintJobUpdate_UnserializedMessageContext<
            UserType, WebPrintJobUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPrintJobUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebPrintJobState state;
  
  uint32_t pages_printed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPrintJobUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPrintJobUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPrintJobUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPrintJobUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT WebPrintingMediaSizeDimension {
 public:
  using DataView = WebPrintingMediaSizeDimensionDataView;
  using Data_ = internal::WebPrintingMediaSizeDimension_Data;
  using Tag = Data_::WebPrintingMediaSizeDimension_Tag;

  template <typename... Args>
  static WebPrintingMediaSizeDimensionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |range|.
  static WebPrintingMediaSizeDimensionPtr NewRange(
      WebPrintingRangePtr value);
  // Construct an instance holding |value|.
  static WebPrintingMediaSizeDimensionPtr NewValue(
      uint32_t value);

  template <typename U>
  static WebPrintingMediaSizeDimensionPtr From(const U& u) {
    return mojo::TypeConverter<WebPrintingMediaSizeDimensionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrintingMediaSizeDimension>::Convert(*this);
  }
  ~WebPrintingMediaSizeDimension();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebPrintingMediaSizeDimension(const WebPrintingMediaSizeDimension& other) = delete;
  WebPrintingMediaSizeDimension& operator=(const WebPrintingMediaSizeDimension& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebPrintingMediaSizeDimensionPtr>
  WebPrintingMediaSizeDimensionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebPrintingMediaSizeDimension>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebPrintingMediaSizeDimension>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_range() const { return tag_ == Tag::kRange; }
  const WebPrintingRangePtr& get_range() const {
    CHECK(tag_ == Tag::kRange);
    return data_.range;
  }
  WebPrintingRangePtr& get_range() {
    CHECK(tag_ == Tag::kRange);
    return data_.range;
  }
  void set_range(WebPrintingRangePtr range);

  bool is_value() const { return tag_ == Tag::kValue; }
  uint32_t get_value() const {
    CHECK(tag_ == Tag::kValue);
    return data_.value;
  }
  void set_value(uint32_t value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrintingMediaSizeDimension::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebPrintingMediaSizeDimension::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRange)>,
        WebPrintingRangePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
        uint32_t value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    WebPrintingRangePtr range;
    uint32_t value;
  };

  WebPrintingMediaSizeDimension(
      std::in_place_index_t<static_cast<size_t>(Tag::kRange)>,
      WebPrintingRangePtr value);
  WebPrintingMediaSizeDimension(
      std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
      uint32_t value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT GetPrintersResult {
 public:
  using DataView = GetPrintersResultDataView;
  using Data_ = internal::GetPrintersResult_Data;
  using Tag = Data_::GetPrintersResult_Tag;

  template <typename... Args>
  static GetPrintersResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |printers|.
  static GetPrintersResultPtr NewPrinters(
      std::vector<WebPrinterInfoPtr> value);
  // Construct an instance holding |error|.
  static GetPrintersResultPtr NewError(
      GetPrintersError value);

  template <typename U>
  static GetPrintersResultPtr From(const U& u) {
    return mojo::TypeConverter<GetPrintersResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetPrintersResult>::Convert(*this);
  }
  ~GetPrintersResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GetPrintersResult(const GetPrintersResult& other) = delete;
  GetPrintersResult& operator=(const GetPrintersResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GetPrintersResultPtr>
  GetPrintersResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetPrintersResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetPrintersResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_printers() const { return tag_ == Tag::kPrinters; }
  const std::vector<WebPrinterInfoPtr>& get_printers() const {
    CHECK(tag_ == Tag::kPrinters);
    return data_.printers;
  }
  std::vector<WebPrinterInfoPtr>& get_printers() {
    CHECK(tag_ == Tag::kPrinters);
    return data_.printers;
  }
  void set_printers(std::vector<WebPrinterInfoPtr> printers);

  bool is_error() const { return tag_ == Tag::kError; }
  GetPrintersError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(GetPrintersError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetPrintersResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GetPrintersResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPrinters)>,
        std::vector<WebPrinterInfoPtr> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        GetPrintersError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<WebPrinterInfoPtr> printers;
    GetPrintersError error;
  };

  GetPrintersResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kPrinters)>,
      std::vector<WebPrinterInfoPtr> value);
  GetPrintersResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      GetPrintersError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT WebPrinterFetchResult {
 public:
  using DataView = WebPrinterFetchResultDataView;
  using Data_ = internal::WebPrinterFetchResult_Data;
  using Tag = Data_::WebPrinterFetchResult_Tag;

  template <typename... Args>
  static WebPrinterFetchResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |printer_attributes|.
  static WebPrinterFetchResultPtr NewPrinterAttributes(
      WebPrinterAttributesPtr value);
  // Construct an instance holding |error|.
  static WebPrinterFetchResultPtr NewError(
      WebPrinterFetchError value);

  template <typename U>
  static WebPrinterFetchResultPtr From(const U& u) {
    return mojo::TypeConverter<WebPrinterFetchResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrinterFetchResult>::Convert(*this);
  }
  ~WebPrinterFetchResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebPrinterFetchResult(const WebPrinterFetchResult& other) = delete;
  WebPrinterFetchResult& operator=(const WebPrinterFetchResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebPrinterFetchResultPtr>
  WebPrinterFetchResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebPrinterFetchResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebPrinterFetchResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_printer_attributes() const { return tag_ == Tag::kPrinterAttributes; }
  const WebPrinterAttributesPtr& get_printer_attributes() const {
    CHECK(tag_ == Tag::kPrinterAttributes);
    return data_.printer_attributes;
  }
  WebPrinterAttributesPtr& get_printer_attributes() {
    CHECK(tag_ == Tag::kPrinterAttributes);
    return data_.printer_attributes;
  }
  void set_printer_attributes(WebPrinterAttributesPtr printer_attributes);

  bool is_error() const { return tag_ == Tag::kError; }
  WebPrinterFetchError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(WebPrinterFetchError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrinterFetchResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebPrinterFetchResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPrinterAttributes)>,
        WebPrinterAttributesPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        WebPrinterFetchError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    WebPrinterAttributesPtr printer_attributes;
    WebPrinterFetchError error;
  };

  WebPrinterFetchResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kPrinterAttributes)>,
      WebPrinterAttributesPtr value);
  WebPrinterFetchResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      WebPrinterFetchError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT WebPrintResult {
 public:
  using DataView = WebPrintResultDataView;
  using Data_ = internal::WebPrintResult_Data;
  using Tag = Data_::WebPrintResult_Tag;

  template <typename... Args>
  static WebPrintResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |print_job_info|.
  static WebPrintResultPtr NewPrintJobInfo(
      WebPrintJobInfoPtr value);
  // Construct an instance holding |error|.
  static WebPrintResultPtr NewError(
      WebPrintError value);

  template <typename U>
  static WebPrintResultPtr From(const U& u) {
    return mojo::TypeConverter<WebPrintResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrintResult>::Convert(*this);
  }
  ~WebPrintResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebPrintResult(const WebPrintResult& other) = delete;
  WebPrintResult& operator=(const WebPrintResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebPrintResultPtr>
  WebPrintResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebPrintResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebPrintResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_print_job_info() const { return tag_ == Tag::kPrintJobInfo; }
  const WebPrintJobInfoPtr& get_print_job_info() const {
    CHECK(tag_ == Tag::kPrintJobInfo);
    return data_.print_job_info;
  }
  WebPrintJobInfoPtr& get_print_job_info() {
    CHECK(tag_ == Tag::kPrintJobInfo);
    return data_.print_job_info;
  }
  void set_print_job_info(WebPrintJobInfoPtr print_job_info);

  bool is_error() const { return tag_ == Tag::kError; }
  WebPrintError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(WebPrintError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrintResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebPrintResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPrintJobInfo)>,
        WebPrintJobInfoPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        WebPrintError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    WebPrintJobInfoPtr print_job_info;
    WebPrintError error;
  };

  WebPrintResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kPrintJobInfo)>,
      WebPrintJobInfoPtr value);
  WebPrintResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      WebPrintError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT WebPrinterInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPrinterInfo, T>::value>;
  using DataView = WebPrinterInfoDataView;
  using Data_ = internal::WebPrinterInfo_Data;

  template <typename... Args>
  static WebPrinterInfoPtr New(Args&&... args) {
    return WebPrinterInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPrinterInfoPtr From(const U& u) {
    return mojo::TypeConverter<WebPrinterInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrinterInfo>::Convert(*this);
  }


  WebPrinterInfo();

  WebPrinterInfo(
      const std::string& printer_name,
      const std::string& printer_id,
      ::mojo::PendingRemote<WebPrinter> printer_remote);

WebPrinterInfo(const WebPrinterInfo&) = delete;
WebPrinterInfo& operator=(const WebPrinterInfo&) = delete;

  ~WebPrinterInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPrinterInfoPtr>
  WebPrinterInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPrinterInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPrinterInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPrinterInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrinterInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPrinterInfo_UnserializedMessageContext<
            UserType, WebPrinterInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPrinterInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPrinterInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPrinterInfo_UnserializedMessageContext<
            UserType, WebPrinterInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPrinterInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string printer_name;
  
  std::string printer_id;
  
  ::mojo::PendingRemote<WebPrinter> printer_remote;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPrinterInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPrinterInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPrinterInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPrinterInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT WebPrintingMediaSize {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPrintingMediaSize, T>::value>;
  using DataView = WebPrintingMediaSizeDataView;
  using Data_ = internal::WebPrintingMediaSize_Data;

  template <typename... Args>
  static WebPrintingMediaSizePtr New(Args&&... args) {
    return WebPrintingMediaSizePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPrintingMediaSizePtr From(const U& u) {
    return mojo::TypeConverter<WebPrintingMediaSizePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrintingMediaSize>::Convert(*this);
  }


  WebPrintingMediaSize();

  WebPrintingMediaSize(
      WebPrintingMediaSizeDimensionPtr x_dimension,
      WebPrintingMediaSizeDimensionPtr y_dimension);

WebPrintingMediaSize(const WebPrintingMediaSize&) = delete;
WebPrintingMediaSize& operator=(const WebPrintingMediaSize&) = delete;

  ~WebPrintingMediaSize();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPrintingMediaSizePtr>
  WebPrintingMediaSizePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPrintingMediaSize::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPrintingMediaSize::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPrintingMediaSize::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintingMediaSize::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintingMediaSize::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrintingMediaSize::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPrintingMediaSize_UnserializedMessageContext<
            UserType, WebPrintingMediaSize::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPrintingMediaSize::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPrintingMediaSize::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPrintingMediaSize_UnserializedMessageContext<
            UserType, WebPrintingMediaSize::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPrintingMediaSize::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebPrintingMediaSizeDimensionPtr x_dimension;
  
  WebPrintingMediaSizeDimensionPtr y_dimension;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPrintingMediaSize::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPrintingMediaSize::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPrintingMediaSize::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPrintingMediaSize::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebPrintingMediaCollection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPrintingMediaCollection, T>::value>;
  using DataView = WebPrintingMediaCollectionDataView;
  using Data_ = internal::WebPrintingMediaCollection_Data;

  template <typename... Args>
  static WebPrintingMediaCollectionPtr New(Args&&... args) {
    return WebPrintingMediaCollectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPrintingMediaCollectionPtr From(const U& u) {
    return mojo::TypeConverter<WebPrintingMediaCollectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrintingMediaCollection>::Convert(*this);
  }


  WebPrintingMediaCollection();

  WebPrintingMediaCollection(
      WebPrintingMediaSizePtr media_size,
      const std::string& media_size_name);

WebPrintingMediaCollection(const WebPrintingMediaCollection&) = delete;
WebPrintingMediaCollection& operator=(const WebPrintingMediaCollection&) = delete;

  ~WebPrintingMediaCollection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPrintingMediaCollectionPtr>
  WebPrintingMediaCollectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPrintingMediaCollection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPrintingMediaCollection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPrintingMediaCollection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintingMediaCollection::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintingMediaCollection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrintingMediaCollection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPrintingMediaCollection_UnserializedMessageContext<
            UserType, WebPrintingMediaCollection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPrintingMediaCollection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPrintingMediaCollection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPrintingMediaCollection_UnserializedMessageContext<
            UserType, WebPrintingMediaCollection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPrintingMediaCollection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebPrintingMediaSizePtr media_size;
  
  std::string media_size_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPrintingMediaCollection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPrintingMediaCollection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPrintingMediaCollection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPrintingMediaCollection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebPrinterAttributes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPrinterAttributes, T>::value>;
  using DataView = WebPrinterAttributesDataView;
  using Data_ = internal::WebPrinterAttributes_Data;

  template <typename... Args>
  static WebPrinterAttributesPtr New(Args&&... args) {
    return WebPrinterAttributesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPrinterAttributesPtr From(const U& u) {
    return mojo::TypeConverter<WebPrinterAttributesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrinterAttributes>::Convert(*this);
  }


  WebPrinterAttributes();

  WebPrinterAttributes(
      uint32_t copies_default,
      WebPrintingRangePtr copies_supported,
      WebPrintingMediaCollectionPtr media_col_default,
      std::vector<WebPrintingMediaCollectionPtr> media_col_database,
      const std::optional<std::string>& media_source_default,
      std::vector<std::string> media_source_supported,
      WebPrintingMultipleDocumentHandling multiple_document_handling_default,
      std::vector<WebPrintingMultipleDocumentHandling> multiple_document_handling_supported,
      WebPrintingOrientationRequested orientation_requested_default,
      std::vector<WebPrintingOrientationRequested> orientation_requested_supported,
      const ::gfx::Size& printer_resolution_default,
      std::vector<::gfx::Size> printer_resolution_supported,
      WebPrintColorMode print_color_mode_default,
      std::vector<WebPrintColorMode> print_color_mode_supported,
      std::optional<WebPrintQuality> print_quality_default,
      std::vector<WebPrintQuality> print_quality_supported,
      WebPrinterState printer_state,
      const std::string& printer_state_message,
      std::vector<WebPrinterStateReason> printer_state_reasons,
      std::optional<WebPrintingSides> sides_default,
      std::vector<WebPrintingSides> sides_supported,
      const std::string& printer_id);

WebPrinterAttributes(const WebPrinterAttributes&) = delete;
WebPrinterAttributes& operator=(const WebPrinterAttributes&) = delete;

  ~WebPrinterAttributes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPrinterAttributesPtr>
  WebPrinterAttributesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPrinterAttributes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPrinterAttributes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPrinterAttributes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrinterAttributes::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrinterAttributes::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrinterAttributes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPrinterAttributes_UnserializedMessageContext<
            UserType, WebPrinterAttributes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPrinterAttributes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPrinterAttributes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPrinterAttributes_UnserializedMessageContext<
            UserType, WebPrinterAttributes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPrinterAttributes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t copies_default;
  
  WebPrintingRangePtr copies_supported;
  
  WebPrintingMediaCollectionPtr media_col_default;
  
  std::vector<WebPrintingMediaCollectionPtr> media_col_database;
  
  std::optional<std::string> media_source_default;
  
  std::vector<std::string> media_source_supported;
  
  WebPrintingMultipleDocumentHandling multiple_document_handling_default;
  
  std::vector<WebPrintingMultipleDocumentHandling> multiple_document_handling_supported;
  
  WebPrintingOrientationRequested orientation_requested_default;
  
  std::vector<WebPrintingOrientationRequested> orientation_requested_supported;
  
  ::gfx::Size printer_resolution_default;
  
  std::vector<::gfx::Size> printer_resolution_supported;
  
  WebPrintColorMode print_color_mode_default;
  
  std::vector<WebPrintColorMode> print_color_mode_supported;
  
  std::optional<WebPrintQuality> print_quality_default;
  
  std::vector<WebPrintQuality> print_quality_supported;
  
  WebPrinterState printer_state;
  
  std::string printer_state_message;
  
  std::vector<WebPrinterStateReason> printer_state_reasons;
  
  std::optional<WebPrintingSides> sides_default;
  
  std::vector<WebPrintingSides> sides_supported;
  
  std::string printer_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPrinterAttributes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPrinterAttributes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPrinterAttributes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPrinterAttributes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebPrintingMediaCollectionRequested {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPrintingMediaCollectionRequested, T>::value>;
  using DataView = WebPrintingMediaCollectionRequestedDataView;
  using Data_ = internal::WebPrintingMediaCollectionRequested_Data;

  template <typename... Args>
  static WebPrintingMediaCollectionRequestedPtr New(Args&&... args) {
    return WebPrintingMediaCollectionRequestedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPrintingMediaCollectionRequestedPtr From(const U& u) {
    return mojo::TypeConverter<WebPrintingMediaCollectionRequestedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrintingMediaCollectionRequested>::Convert(*this);
  }


  WebPrintingMediaCollectionRequested();

  explicit WebPrintingMediaCollectionRequested(
      const ::gfx::Size& media_size);


  ~WebPrintingMediaCollectionRequested();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPrintingMediaCollectionRequestedPtr>
  WebPrintingMediaCollectionRequestedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPrintingMediaCollectionRequested::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPrintingMediaCollectionRequested::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPrintingMediaCollectionRequested::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintingMediaCollectionRequested::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintingMediaCollectionRequested::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrintingMediaCollectionRequested::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPrintingMediaCollectionRequested_UnserializedMessageContext<
            UserType, WebPrintingMediaCollectionRequested::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPrintingMediaCollectionRequested::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPrintingMediaCollectionRequested::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPrintingMediaCollectionRequested_UnserializedMessageContext<
            UserType, WebPrintingMediaCollectionRequested::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPrintingMediaCollectionRequested::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Size media_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPrintingMediaCollectionRequested::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPrintingMediaCollectionRequested::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPrintingMediaCollectionRequested::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPrintingMediaCollectionRequested::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebPrintJobTemplateAttributes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPrintJobTemplateAttributes, T>::value>;
  using DataView = WebPrintJobTemplateAttributesDataView;
  using Data_ = internal::WebPrintJobTemplateAttributes_Data;

  template <typename... Args>
  static WebPrintJobTemplateAttributesPtr New(Args&&... args) {
    return WebPrintJobTemplateAttributesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPrintJobTemplateAttributesPtr From(const U& u) {
    return mojo::TypeConverter<WebPrintJobTemplateAttributesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrintJobTemplateAttributes>::Convert(*this);
  }


  WebPrintJobTemplateAttributes();

  WebPrintJobTemplateAttributes(
      const std::string& job_name,
      uint32_t copies,
      WebPrintingMediaCollectionRequestedPtr media_col,
      const std::optional<std::string>& media_source,
      std::optional<WebPrintingMultipleDocumentHandling> multiple_document_handling,
      std::optional<WebPrintingOrientationRequested> orientation_requested,
      const std::optional<::gfx::Size>& printer_resolution,
      std::optional<WebPrintColorMode> print_color_mode,
      std::optional<WebPrintQuality> print_quality,
      std::optional<WebPrintingSides> sides);

WebPrintJobTemplateAttributes(const WebPrintJobTemplateAttributes&) = delete;
WebPrintJobTemplateAttributes& operator=(const WebPrintJobTemplateAttributes&) = delete;

  ~WebPrintJobTemplateAttributes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPrintJobTemplateAttributesPtr>
  WebPrintJobTemplateAttributesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPrintJobTemplateAttributes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPrintJobTemplateAttributes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPrintJobTemplateAttributes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintJobTemplateAttributes::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPrintJobTemplateAttributes::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrintJobTemplateAttributes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPrintJobTemplateAttributes_UnserializedMessageContext<
            UserType, WebPrintJobTemplateAttributes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPrintJobTemplateAttributes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPrintJobTemplateAttributes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPrintJobTemplateAttributes_UnserializedMessageContext<
            UserType, WebPrintJobTemplateAttributes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPrintJobTemplateAttributes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string job_name;
  
  uint32_t copies;
  
  WebPrintingMediaCollectionRequestedPtr media_col;
  
  std::optional<std::string> media_source;
  
  std::optional<WebPrintingMultipleDocumentHandling> multiple_document_handling;
  
  std::optional<WebPrintingOrientationRequested> orientation_requested;
  
  std::optional<::gfx::Size> printer_resolution;
  
  std::optional<WebPrintColorMode> print_color_mode;
  
  std::optional<WebPrintQuality> print_quality;
  
  std::optional<WebPrintingSides> sides;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPrintJobTemplateAttributes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPrintJobTemplateAttributes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPrintJobTemplateAttributes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPrintJobTemplateAttributes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT WebPrintJobInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPrintJobInfo, T>::value>;
  using DataView = WebPrintJobInfoDataView;
  using Data_ = internal::WebPrintJobInfo_Data;

  template <typename... Args>
  static WebPrintJobInfoPtr New(Args&&... args) {
    return WebPrintJobInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPrintJobInfoPtr From(const U& u) {
    return mojo::TypeConverter<WebPrintJobInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPrintJobInfo>::Convert(*this);
  }


  WebPrintJobInfo();

  WebPrintJobInfo(
      const std::string& job_name,
      uint32_t job_pages,
      ::mojo::PendingReceiver<WebPrintJobStateObserver> observer,
      ::mojo::PendingRemote<WebPrintJobController> controller);

WebPrintJobInfo(const WebPrintJobInfo&) = delete;
WebPrintJobInfo& operator=(const WebPrintJobInfo&) = delete;

  ~WebPrintJobInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPrintJobInfoPtr>
  WebPrintJobInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPrintJobInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPrintJobInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPrintJobInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPrintJobInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPrintJobInfo_UnserializedMessageContext<
            UserType, WebPrintJobInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPrintJobInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPrintJobInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPrintJobInfo_UnserializedMessageContext<
            UserType, WebPrintJobInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPrintJobInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string job_name;
  
  uint32_t job_pages;
  
  ::mojo::PendingReceiver<WebPrintJobStateObserver> observer;
  
  ::mojo::PendingRemote<WebPrintJobController> controller;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPrintJobInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPrintJobInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPrintJobInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPrintJobInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
WebPrintingMediaSizeDimensionPtr WebPrintingMediaSizeDimension::Clone() const {
  switch (tag_) {
    case Tag::kRange:
      return NewRange(
          mojo::Clone(data_.range));
    case Tag::kValue:
      return NewValue(
          mojo::Clone(data_.value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebPrintingMediaSizeDimension>::value>::type*>
bool WebPrintingMediaSizeDimension::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kRange:
      return mojo::Equals(data_.range, other.data_.range);
    case Tag::kValue:
      return mojo::Equals(data_.value, other.data_.value);
  }

  return false;
}
template <typename UnionPtrType>
GetPrintersResultPtr GetPrintersResult::Clone() const {
  switch (tag_) {
    case Tag::kPrinters:
      return NewPrinters(
          mojo::Clone(data_.printers));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GetPrintersResult>::value>::type*>
bool GetPrintersResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPrinters:
      return mojo::Equals(data_.printers, other.data_.printers);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
WebPrinterFetchResultPtr WebPrinterFetchResult::Clone() const {
  switch (tag_) {
    case Tag::kPrinterAttributes:
      return NewPrinterAttributes(
          mojo::Clone(data_.printer_attributes));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebPrinterFetchResult>::value>::type*>
bool WebPrinterFetchResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPrinterAttributes:
      return mojo::Equals(data_.printer_attributes, other.data_.printer_attributes);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
WebPrintResultPtr WebPrintResult::Clone() const {
  switch (tag_) {
    case Tag::kPrintJobInfo:
      return NewPrintJobInfo(
          mojo::Clone(data_.print_job_info));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebPrintResult>::value>::type*>
bool WebPrintResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPrintJobInfo:
      return mojo::Equals(data_.print_job_info, other.data_.print_job_info);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
WebPrinterInfoPtr WebPrinterInfo::Clone() const {
  return New(
      mojo::Clone(printer_name),
      mojo::Clone(printer_id),
      mojo::Clone(printer_remote)
  );
}

template <typename T, WebPrinterInfo::EnableIfSame<T>*>
bool WebPrinterInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->printer_name, other_struct.printer_name))
    return false;
  if (!mojo::Equals(this->printer_id, other_struct.printer_id))
    return false;
  if (!mojo::Equals(this->printer_remote, other_struct.printer_remote))
    return false;
  return true;
}

template <typename T, WebPrinterInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.printer_name < rhs.printer_name)
    return true;
  if (rhs.printer_name < lhs.printer_name)
    return false;
  if (lhs.printer_id < rhs.printer_id)
    return true;
  if (rhs.printer_id < lhs.printer_id)
    return false;
  if (lhs.printer_remote < rhs.printer_remote)
    return true;
  if (rhs.printer_remote < lhs.printer_remote)
    return false;
  return false;
}
template <typename StructPtrType>
WebPrintingRangePtr WebPrintingRange::Clone() const {
  return New(
      mojo::Clone(from),
      mojo::Clone(to)
  );
}

template <typename T, WebPrintingRange::EnableIfSame<T>*>
bool WebPrintingRange::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->from, other_struct.from))
    return false;
  if (!mojo::Equals(this->to, other_struct.to))
    return false;
  return true;
}

template <typename T, WebPrintingRange::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.from < rhs.from)
    return true;
  if (rhs.from < lhs.from)
    return false;
  if (lhs.to < rhs.to)
    return true;
  if (rhs.to < lhs.to)
    return false;
  return false;
}
template <typename StructPtrType>
WebPrintingMediaSizePtr WebPrintingMediaSize::Clone() const {
  return New(
      mojo::Clone(x_dimension),
      mojo::Clone(y_dimension)
  );
}

template <typename T, WebPrintingMediaSize::EnableIfSame<T>*>
bool WebPrintingMediaSize::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x_dimension, other_struct.x_dimension))
    return false;
  if (!mojo::Equals(this->y_dimension, other_struct.y_dimension))
    return false;
  return true;
}

template <typename T, WebPrintingMediaSize::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x_dimension < rhs.x_dimension)
    return true;
  if (rhs.x_dimension < lhs.x_dimension)
    return false;
  if (lhs.y_dimension < rhs.y_dimension)
    return true;
  if (rhs.y_dimension < lhs.y_dimension)
    return false;
  return false;
}
template <typename StructPtrType>
WebPrintingMediaCollectionPtr WebPrintingMediaCollection::Clone() const {
  return New(
      mojo::Clone(media_size),
      mojo::Clone(media_size_name)
  );
}

template <typename T, WebPrintingMediaCollection::EnableIfSame<T>*>
bool WebPrintingMediaCollection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->media_size, other_struct.media_size))
    return false;
  if (!mojo::Equals(this->media_size_name, other_struct.media_size_name))
    return false;
  return true;
}

template <typename T, WebPrintingMediaCollection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.media_size < rhs.media_size)
    return true;
  if (rhs.media_size < lhs.media_size)
    return false;
  if (lhs.media_size_name < rhs.media_size_name)
    return true;
  if (rhs.media_size_name < lhs.media_size_name)
    return false;
  return false;
}
template <typename StructPtrType>
WebPrinterAttributesPtr WebPrinterAttributes::Clone() const {
  return New(
      mojo::Clone(copies_default),
      mojo::Clone(copies_supported),
      mojo::Clone(media_col_default),
      mojo::Clone(media_col_database),
      mojo::Clone(media_source_default),
      mojo::Clone(media_source_supported),
      mojo::Clone(multiple_document_handling_default),
      mojo::Clone(multiple_document_handling_supported),
      mojo::Clone(orientation_requested_default),
      mojo::Clone(orientation_requested_supported),
      mojo::Clone(printer_resolution_default),
      mojo::Clone(printer_resolution_supported),
      mojo::Clone(print_color_mode_default),
      mojo::Clone(print_color_mode_supported),
      mojo::Clone(print_quality_default),
      mojo::Clone(print_quality_supported),
      mojo::Clone(printer_state),
      mojo::Clone(printer_state_message),
      mojo::Clone(printer_state_reasons),
      mojo::Clone(sides_default),
      mojo::Clone(sides_supported),
      mojo::Clone(printer_id)
  );
}

template <typename T, WebPrinterAttributes::EnableIfSame<T>*>
bool WebPrinterAttributes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->copies_default, other_struct.copies_default))
    return false;
  if (!mojo::Equals(this->copies_supported, other_struct.copies_supported))
    return false;
  if (!mojo::Equals(this->media_col_default, other_struct.media_col_default))
    return false;
  if (!mojo::Equals(this->media_col_database, other_struct.media_col_database))
    return false;
  if (!mojo::Equals(this->media_source_default, other_struct.media_source_default))
    return false;
  if (!mojo::Equals(this->media_source_supported, other_struct.media_source_supported))
    return false;
  if (!mojo::Equals(this->multiple_document_handling_default, other_struct.multiple_document_handling_default))
    return false;
  if (!mojo::Equals(this->multiple_document_handling_supported, other_struct.multiple_document_handling_supported))
    return false;
  if (!mojo::Equals(this->orientation_requested_default, other_struct.orientation_requested_default))
    return false;
  if (!mojo::Equals(this->orientation_requested_supported, other_struct.orientation_requested_supported))
    return false;
  if (!mojo::Equals(this->printer_resolution_default, other_struct.printer_resolution_default))
    return false;
  if (!mojo::Equals(this->printer_resolution_supported, other_struct.printer_resolution_supported))
    return false;
  if (!mojo::Equals(this->print_color_mode_default, other_struct.print_color_mode_default))
    return false;
  if (!mojo::Equals(this->print_color_mode_supported, other_struct.print_color_mode_supported))
    return false;
  if (!mojo::Equals(this->print_quality_default, other_struct.print_quality_default))
    return false;
  if (!mojo::Equals(this->print_quality_supported, other_struct.print_quality_supported))
    return false;
  if (!mojo::Equals(this->printer_state, other_struct.printer_state))
    return false;
  if (!mojo::Equals(this->printer_state_message, other_struct.printer_state_message))
    return false;
  if (!mojo::Equals(this->printer_state_reasons, other_struct.printer_state_reasons))
    return false;
  if (!mojo::Equals(this->sides_default, other_struct.sides_default))
    return false;
  if (!mojo::Equals(this->sides_supported, other_struct.sides_supported))
    return false;
  if (!mojo::Equals(this->printer_id, other_struct.printer_id))
    return false;
  return true;
}

template <typename T, WebPrinterAttributes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.copies_default < rhs.copies_default)
    return true;
  if (rhs.copies_default < lhs.copies_default)
    return false;
  if (lhs.copies_supported < rhs.copies_supported)
    return true;
  if (rhs.copies_supported < lhs.copies_supported)
    return false;
  if (lhs.media_col_default < rhs.media_col_default)
    return true;
  if (rhs.media_col_default < lhs.media_col_default)
    return false;
  if (lhs.media_col_database < rhs.media_col_database)
    return true;
  if (rhs.media_col_database < lhs.media_col_database)
    return false;
  if (lhs.media_source_default < rhs.media_source_default)
    return true;
  if (rhs.media_source_default < lhs.media_source_default)
    return false;
  if (lhs.media_source_supported < rhs.media_source_supported)
    return true;
  if (rhs.media_source_supported < lhs.media_source_supported)
    return false;
  if (lhs.multiple_document_handling_default < rhs.multiple_document_handling_default)
    return true;
  if (rhs.multiple_document_handling_default < lhs.multiple_document_handling_default)
    return false;
  if (lhs.multiple_document_handling_supported < rhs.multiple_document_handling_supported)
    return true;
  if (rhs.multiple_document_handling_supported < lhs.multiple_document_handling_supported)
    return false;
  if (lhs.orientation_requested_default < rhs.orientation_requested_default)
    return true;
  if (rhs.orientation_requested_default < lhs.orientation_requested_default)
    return false;
  if (lhs.orientation_requested_supported < rhs.orientation_requested_supported)
    return true;
  if (rhs.orientation_requested_supported < lhs.orientation_requested_supported)
    return false;
  if (lhs.printer_resolution_default < rhs.printer_resolution_default)
    return true;
  if (rhs.printer_resolution_default < lhs.printer_resolution_default)
    return false;
  if (lhs.printer_resolution_supported < rhs.printer_resolution_supported)
    return true;
  if (rhs.printer_resolution_supported < lhs.printer_resolution_supported)
    return false;
  if (lhs.print_color_mode_default < rhs.print_color_mode_default)
    return true;
  if (rhs.print_color_mode_default < lhs.print_color_mode_default)
    return false;
  if (lhs.print_color_mode_supported < rhs.print_color_mode_supported)
    return true;
  if (rhs.print_color_mode_supported < lhs.print_color_mode_supported)
    return false;
  if (lhs.print_quality_default < rhs.print_quality_default)
    return true;
  if (rhs.print_quality_default < lhs.print_quality_default)
    return false;
  if (lhs.print_quality_supported < rhs.print_quality_supported)
    return true;
  if (rhs.print_quality_supported < lhs.print_quality_supported)
    return false;
  if (lhs.printer_state < rhs.printer_state)
    return true;
  if (rhs.printer_state < lhs.printer_state)
    return false;
  if (lhs.printer_state_message < rhs.printer_state_message)
    return true;
  if (rhs.printer_state_message < lhs.printer_state_message)
    return false;
  if (lhs.printer_state_reasons < rhs.printer_state_reasons)
    return true;
  if (rhs.printer_state_reasons < lhs.printer_state_reasons)
    return false;
  if (lhs.sides_default < rhs.sides_default)
    return true;
  if (rhs.sides_default < lhs.sides_default)
    return false;
  if (lhs.sides_supported < rhs.sides_supported)
    return true;
  if (rhs.sides_supported < lhs.sides_supported)
    return false;
  if (lhs.printer_id < rhs.printer_id)
    return true;
  if (rhs.printer_id < lhs.printer_id)
    return false;
  return false;
}
template <typename StructPtrType>
WebPrintingMediaCollectionRequestedPtr WebPrintingMediaCollectionRequested::Clone() const {
  return New(
      mojo::Clone(media_size)
  );
}

template <typename T, WebPrintingMediaCollectionRequested::EnableIfSame<T>*>
bool WebPrintingMediaCollectionRequested::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->media_size, other_struct.media_size))
    return false;
  return true;
}

template <typename T, WebPrintingMediaCollectionRequested::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.media_size < rhs.media_size)
    return true;
  if (rhs.media_size < lhs.media_size)
    return false;
  return false;
}
template <typename StructPtrType>
WebPrintJobTemplateAttributesPtr WebPrintJobTemplateAttributes::Clone() const {
  return New(
      mojo::Clone(job_name),
      mojo::Clone(copies),
      mojo::Clone(media_col),
      mojo::Clone(media_source),
      mojo::Clone(multiple_document_handling),
      mojo::Clone(orientation_requested),
      mojo::Clone(printer_resolution),
      mojo::Clone(print_color_mode),
      mojo::Clone(print_quality),
      mojo::Clone(sides)
  );
}

template <typename T, WebPrintJobTemplateAttributes::EnableIfSame<T>*>
bool WebPrintJobTemplateAttributes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->job_name, other_struct.job_name))
    return false;
  if (!mojo::Equals(this->copies, other_struct.copies))
    return false;
  if (!mojo::Equals(this->media_col, other_struct.media_col))
    return false;
  if (!mojo::Equals(this->media_source, other_struct.media_source))
    return false;
  if (!mojo::Equals(this->multiple_document_handling, other_struct.multiple_document_handling))
    return false;
  if (!mojo::Equals(this->orientation_requested, other_struct.orientation_requested))
    return false;
  if (!mojo::Equals(this->printer_resolution, other_struct.printer_resolution))
    return false;
  if (!mojo::Equals(this->print_color_mode, other_struct.print_color_mode))
    return false;
  if (!mojo::Equals(this->print_quality, other_struct.print_quality))
    return false;
  if (!mojo::Equals(this->sides, other_struct.sides))
    return false;
  return true;
}

template <typename T, WebPrintJobTemplateAttributes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.job_name < rhs.job_name)
    return true;
  if (rhs.job_name < lhs.job_name)
    return false;
  if (lhs.copies < rhs.copies)
    return true;
  if (rhs.copies < lhs.copies)
    return false;
  if (lhs.media_col < rhs.media_col)
    return true;
  if (rhs.media_col < lhs.media_col)
    return false;
  if (lhs.media_source < rhs.media_source)
    return true;
  if (rhs.media_source < lhs.media_source)
    return false;
  if (lhs.multiple_document_handling < rhs.multiple_document_handling)
    return true;
  if (rhs.multiple_document_handling < lhs.multiple_document_handling)
    return false;
  if (lhs.orientation_requested < rhs.orientation_requested)
    return true;
  if (rhs.orientation_requested < lhs.orientation_requested)
    return false;
  if (lhs.printer_resolution < rhs.printer_resolution)
    return true;
  if (rhs.printer_resolution < lhs.printer_resolution)
    return false;
  if (lhs.print_color_mode < rhs.print_color_mode)
    return true;
  if (rhs.print_color_mode < lhs.print_color_mode)
    return false;
  if (lhs.print_quality < rhs.print_quality)
    return true;
  if (rhs.print_quality < lhs.print_quality)
    return false;
  if (lhs.sides < rhs.sides)
    return true;
  if (rhs.sides < lhs.sides)
    return false;
  return false;
}
template <typename StructPtrType>
WebPrintJobUpdatePtr WebPrintJobUpdate::Clone() const {
  return New(
      mojo::Clone(state),
      mojo::Clone(pages_printed)
  );
}

template <typename T, WebPrintJobUpdate::EnableIfSame<T>*>
bool WebPrintJobUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->pages_printed, other_struct.pages_printed))
    return false;
  return true;
}

template <typename T, WebPrintJobUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.pages_printed < rhs.pages_printed)
    return true;
  if (rhs.pages_printed < lhs.pages_printed)
    return false;
  return false;
}
template <typename StructPtrType>
WebPrintJobInfoPtr WebPrintJobInfo::Clone() const {
  return New(
      mojo::Clone(job_name),
      mojo::Clone(job_pages),
      mojo::Clone(observer),
      mojo::Clone(controller)
  );
}

template <typename T, WebPrintJobInfo::EnableIfSame<T>*>
bool WebPrintJobInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->job_name, other_struct.job_name))
    return false;
  if (!mojo::Equals(this->job_pages, other_struct.job_pages))
    return false;
  if (!mojo::Equals(this->observer, other_struct.observer))
    return false;
  if (!mojo::Equals(this->controller, other_struct.controller))
    return false;
  return true;
}

template <typename T, WebPrintJobInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.job_name < rhs.job_name)
    return true;
  if (rhs.job_name < lhs.job_name)
    return false;
  if (lhs.job_pages < rhs.job_pages)
    return true;
  if (rhs.job_pages < lhs.job_pages)
    return false;
  if (lhs.observer < rhs.observer)
    return true;
  if (rhs.observer < lhs.observer)
    return false;
  if (lhs.controller < rhs.controller)
    return true;
  if (rhs.controller < lhs.controller)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPrinterInfo::DataView,
                                         ::blink::mojom::WebPrinterInfoPtr> {
  static bool IsNull(const ::blink::mojom::WebPrinterInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrinterInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebPrinterInfo::printer_name)& printer_name(
      const ::blink::mojom::WebPrinterInfoPtr& input) {
    return input->printer_name;
  }

  static const decltype(::blink::mojom::WebPrinterInfo::printer_id)& printer_id(
      const ::blink::mojom::WebPrinterInfoPtr& input) {
    return input->printer_id;
  }

  static  decltype(::blink::mojom::WebPrinterInfo::printer_remote)& printer_remote(
       ::blink::mojom::WebPrinterInfoPtr& input) {
    return input->printer_remote;
  }

  static bool Read(::blink::mojom::WebPrinterInfo::DataView input, ::blink::mojom::WebPrinterInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPrintingRange::DataView,
                                         ::blink::mojom::WebPrintingRangePtr> {
  static bool IsNull(const ::blink::mojom::WebPrintingRangePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrintingRangePtr* output) { output->reset(); }

  static decltype(::blink::mojom::WebPrintingRange::from) from(
      const ::blink::mojom::WebPrintingRangePtr& input) {
    return input->from;
  }

  static decltype(::blink::mojom::WebPrintingRange::to) to(
      const ::blink::mojom::WebPrintingRangePtr& input) {
    return input->to;
  }

  static bool Read(::blink::mojom::WebPrintingRange::DataView input, ::blink::mojom::WebPrintingRangePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPrintingMediaSize::DataView,
                                         ::blink::mojom::WebPrintingMediaSizePtr> {
  static bool IsNull(const ::blink::mojom::WebPrintingMediaSizePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrintingMediaSizePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebPrintingMediaSize::x_dimension)& x_dimension(
      const ::blink::mojom::WebPrintingMediaSizePtr& input) {
    return input->x_dimension;
  }

  static const decltype(::blink::mojom::WebPrintingMediaSize::y_dimension)& y_dimension(
      const ::blink::mojom::WebPrintingMediaSizePtr& input) {
    return input->y_dimension;
  }

  static bool Read(::blink::mojom::WebPrintingMediaSize::DataView input, ::blink::mojom::WebPrintingMediaSizePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPrintingMediaCollection::DataView,
                                         ::blink::mojom::WebPrintingMediaCollectionPtr> {
  static bool IsNull(const ::blink::mojom::WebPrintingMediaCollectionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrintingMediaCollectionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebPrintingMediaCollection::media_size)& media_size(
      const ::blink::mojom::WebPrintingMediaCollectionPtr& input) {
    return input->media_size;
  }

  static const decltype(::blink::mojom::WebPrintingMediaCollection::media_size_name)& media_size_name(
      const ::blink::mojom::WebPrintingMediaCollectionPtr& input) {
    return input->media_size_name;
  }

  static bool Read(::blink::mojom::WebPrintingMediaCollection::DataView input, ::blink::mojom::WebPrintingMediaCollectionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPrinterAttributes::DataView,
                                         ::blink::mojom::WebPrinterAttributesPtr> {
  static bool IsNull(const ::blink::mojom::WebPrinterAttributesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrinterAttributesPtr* output) { output->reset(); }

  static decltype(::blink::mojom::WebPrinterAttributes::copies_default) copies_default(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->copies_default;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::copies_supported)& copies_supported(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->copies_supported;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::media_col_default)& media_col_default(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->media_col_default;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::media_col_database)& media_col_database(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->media_col_database;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::media_source_default)& media_source_default(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->media_source_default;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::media_source_supported)& media_source_supported(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->media_source_supported;
  }

  static decltype(::blink::mojom::WebPrinterAttributes::multiple_document_handling_default) multiple_document_handling_default(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->multiple_document_handling_default;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::multiple_document_handling_supported)& multiple_document_handling_supported(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->multiple_document_handling_supported;
  }

  static decltype(::blink::mojom::WebPrinterAttributes::orientation_requested_default) orientation_requested_default(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->orientation_requested_default;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::orientation_requested_supported)& orientation_requested_supported(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->orientation_requested_supported;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::printer_resolution_default)& printer_resolution_default(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->printer_resolution_default;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::printer_resolution_supported)& printer_resolution_supported(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->printer_resolution_supported;
  }

  static decltype(::blink::mojom::WebPrinterAttributes::print_color_mode_default) print_color_mode_default(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->print_color_mode_default;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::print_color_mode_supported)& print_color_mode_supported(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->print_color_mode_supported;
  }

  static decltype(::blink::mojom::WebPrinterAttributes::print_quality_default) print_quality_default(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->print_quality_default;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::print_quality_supported)& print_quality_supported(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->print_quality_supported;
  }

  static decltype(::blink::mojom::WebPrinterAttributes::printer_state) printer_state(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->printer_state;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::printer_state_message)& printer_state_message(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->printer_state_message;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::printer_state_reasons)& printer_state_reasons(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->printer_state_reasons;
  }

  static decltype(::blink::mojom::WebPrinterAttributes::sides_default) sides_default(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->sides_default;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::sides_supported)& sides_supported(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->sides_supported;
  }

  static const decltype(::blink::mojom::WebPrinterAttributes::printer_id)& printer_id(
      const ::blink::mojom::WebPrinterAttributesPtr& input) {
    return input->printer_id;
  }

  static bool Read(::blink::mojom::WebPrinterAttributes::DataView input, ::blink::mojom::WebPrinterAttributesPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPrintingMediaCollectionRequested::DataView,
                                         ::blink::mojom::WebPrintingMediaCollectionRequestedPtr> {
  static bool IsNull(const ::blink::mojom::WebPrintingMediaCollectionRequestedPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrintingMediaCollectionRequestedPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebPrintingMediaCollectionRequested::media_size)& media_size(
      const ::blink::mojom::WebPrintingMediaCollectionRequestedPtr& input) {
    return input->media_size;
  }

  static bool Read(::blink::mojom::WebPrintingMediaCollectionRequested::DataView input, ::blink::mojom::WebPrintingMediaCollectionRequestedPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPrintJobTemplateAttributes::DataView,
                                         ::blink::mojom::WebPrintJobTemplateAttributesPtr> {
  static bool IsNull(const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrintJobTemplateAttributesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebPrintJobTemplateAttributes::job_name)& job_name(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->job_name;
  }

  static decltype(::blink::mojom::WebPrintJobTemplateAttributes::copies) copies(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->copies;
  }

  static const decltype(::blink::mojom::WebPrintJobTemplateAttributes::media_col)& media_col(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->media_col;
  }

  static const decltype(::blink::mojom::WebPrintJobTemplateAttributes::media_source)& media_source(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->media_source;
  }

  static decltype(::blink::mojom::WebPrintJobTemplateAttributes::multiple_document_handling) multiple_document_handling(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->multiple_document_handling;
  }

  static decltype(::blink::mojom::WebPrintJobTemplateAttributes::orientation_requested) orientation_requested(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->orientation_requested;
  }

  static const decltype(::blink::mojom::WebPrintJobTemplateAttributes::printer_resolution)& printer_resolution(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->printer_resolution;
  }

  static decltype(::blink::mojom::WebPrintJobTemplateAttributes::print_color_mode) print_color_mode(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->print_color_mode;
  }

  static decltype(::blink::mojom::WebPrintJobTemplateAttributes::print_quality) print_quality(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->print_quality;
  }

  static decltype(::blink::mojom::WebPrintJobTemplateAttributes::sides) sides(
      const ::blink::mojom::WebPrintJobTemplateAttributesPtr& input) {
    return input->sides;
  }

  static bool Read(::blink::mojom::WebPrintJobTemplateAttributes::DataView input, ::blink::mojom::WebPrintJobTemplateAttributesPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPrintJobUpdate::DataView,
                                         ::blink::mojom::WebPrintJobUpdatePtr> {
  static bool IsNull(const ::blink::mojom::WebPrintJobUpdatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrintJobUpdatePtr* output) { output->reset(); }

  static decltype(::blink::mojom::WebPrintJobUpdate::state) state(
      const ::blink::mojom::WebPrintJobUpdatePtr& input) {
    return input->state;
  }

  static decltype(::blink::mojom::WebPrintJobUpdate::pages_printed) pages_printed(
      const ::blink::mojom::WebPrintJobUpdatePtr& input) {
    return input->pages_printed;
  }

  static bool Read(::blink::mojom::WebPrintJobUpdate::DataView input, ::blink::mojom::WebPrintJobUpdatePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebPrintJobInfo::DataView,
                                         ::blink::mojom::WebPrintJobInfoPtr> {
  static bool IsNull(const ::blink::mojom::WebPrintJobInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrintJobInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebPrintJobInfo::job_name)& job_name(
      const ::blink::mojom::WebPrintJobInfoPtr& input) {
    return input->job_name;
  }

  static decltype(::blink::mojom::WebPrintJobInfo::job_pages) job_pages(
      const ::blink::mojom::WebPrintJobInfoPtr& input) {
    return input->job_pages;
  }

  static  decltype(::blink::mojom::WebPrintJobInfo::observer)& observer(
       ::blink::mojom::WebPrintJobInfoPtr& input) {
    return input->observer;
  }

  static  decltype(::blink::mojom::WebPrintJobInfo::controller)& controller(
       ::blink::mojom::WebPrintJobInfoPtr& input) {
    return input->controller;
  }

  static bool Read(::blink::mojom::WebPrintJobInfo::DataView input, ::blink::mojom::WebPrintJobInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::WebPrintingMediaSizeDimension::DataView,
                                        ::blink::mojom::WebPrintingMediaSizeDimensionPtr> {
  static bool IsNull(const ::blink::mojom::WebPrintingMediaSizeDimensionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrintingMediaSizeDimensionPtr* output) { output->reset(); }

  static ::blink::mojom::WebPrintingMediaSizeDimension::Tag GetTag(const ::blink::mojom::WebPrintingMediaSizeDimensionPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::WebPrintingRangePtr& range(const ::blink::mojom::WebPrintingMediaSizeDimensionPtr& input) {
    return input->get_range();
  }

  static  uint32_t value(const ::blink::mojom::WebPrintingMediaSizeDimensionPtr& input) {
    return input->get_value();
  }

  static bool Read(::blink::mojom::WebPrintingMediaSizeDimension::DataView input, ::blink::mojom::WebPrintingMediaSizeDimensionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::GetPrintersResult::DataView,
                                        ::blink::mojom::GetPrintersResultPtr> {
  static bool IsNull(const ::blink::mojom::GetPrintersResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetPrintersResultPtr* output) { output->reset(); }

  static ::blink::mojom::GetPrintersResult::Tag GetTag(const ::blink::mojom::GetPrintersResultPtr& input) {
    return input->which();
  }

  static  std::vector<::blink::mojom::WebPrinterInfoPtr>& printers( ::blink::mojom::GetPrintersResultPtr& input) {
    return input->get_printers();
  }

  static  ::blink::mojom::GetPrintersError error(const ::blink::mojom::GetPrintersResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::blink::mojom::GetPrintersResult::DataView input, ::blink::mojom::GetPrintersResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::WebPrinterFetchResult::DataView,
                                        ::blink::mojom::WebPrinterFetchResultPtr> {
  static bool IsNull(const ::blink::mojom::WebPrinterFetchResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrinterFetchResultPtr* output) { output->reset(); }

  static ::blink::mojom::WebPrinterFetchResult::Tag GetTag(const ::blink::mojom::WebPrinterFetchResultPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::WebPrinterAttributesPtr& printer_attributes(const ::blink::mojom::WebPrinterFetchResultPtr& input) {
    return input->get_printer_attributes();
  }

  static  ::blink::mojom::WebPrinterFetchError error(const ::blink::mojom::WebPrinterFetchResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::blink::mojom::WebPrinterFetchResult::DataView input, ::blink::mojom::WebPrinterFetchResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::WebPrintResult::DataView,
                                        ::blink::mojom::WebPrintResultPtr> {
  static bool IsNull(const ::blink::mojom::WebPrintResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebPrintResultPtr* output) { output->reset(); }

  static ::blink::mojom::WebPrintResult::Tag GetTag(const ::blink::mojom::WebPrintResultPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::WebPrintJobInfoPtr& print_job_info( ::blink::mojom::WebPrintResultPtr& input) {
    return input->get_print_job_info();
  }

  static  ::blink::mojom::WebPrintError error(const ::blink::mojom::WebPrintResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::blink::mojom::WebPrintResult::DataView input, ::blink::mojom::WebPrintResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_H_