// third_party/blink/public/mojom/printing/web_printing.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/printing/web_printing.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/printing/web_printing.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* WebPrintingMultipleDocumentHandlingToStringHelper(WebPrintingMultipleDocumentHandling value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrintingMultipleDocumentHandling::kSeparateDocumentsCollatedCopies:
      return "kSeparateDocumentsCollatedCopies";
    case WebPrintingMultipleDocumentHandling::kSeparateDocumentsUncollatedCopies:
      return "kSeparateDocumentsUncollatedCopies";
    default:
      return nullptr;
  }
}

std::string WebPrintingMultipleDocumentHandlingToString(WebPrintingMultipleDocumentHandling value) {
  const char *str = WebPrintingMultipleDocumentHandlingToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrintingMultipleDocumentHandling value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrintingMultipleDocumentHandling value) {
  return os << WebPrintingMultipleDocumentHandlingToString(value);
}

NOINLINE static const char* WebPrintingSidesToStringHelper(WebPrintingSides value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrintingSides::kOneSided:
      return "kOneSided";
    case WebPrintingSides::kTwoSidedLongEdge:
      return "kTwoSidedLongEdge";
    case WebPrintingSides::kTwoSidedShortEdge:
      return "kTwoSidedShortEdge";
    default:
      return nullptr;
  }
}

std::string WebPrintingSidesToString(WebPrintingSides value) {
  const char *str = WebPrintingSidesToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrintingSides value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrintingSides value) {
  return os << WebPrintingSidesToString(value);
}

NOINLINE static const char* WebPrintQualityToStringHelper(WebPrintQuality value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrintQuality::kDraft:
      return "kDraft";
    case WebPrintQuality::kNormal:
      return "kNormal";
    case WebPrintQuality::kHigh:
      return "kHigh";
    default:
      return nullptr;
  }
}

std::string WebPrintQualityToString(WebPrintQuality value) {
  const char *str = WebPrintQualityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrintQuality value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrintQuality value) {
  return os << WebPrintQualityToString(value);
}

NOINLINE static const char* WebPrintColorModeToStringHelper(WebPrintColorMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrintColorMode::kColor:
      return "kColor";
    case WebPrintColorMode::kMonochrome:
      return "kMonochrome";
    default:
      return nullptr;
  }
}

std::string WebPrintColorModeToString(WebPrintColorMode value) {
  const char *str = WebPrintColorModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrintColorMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrintColorMode value) {
  return os << WebPrintColorModeToString(value);
}

NOINLINE static const char* WebPrintingOrientationRequestedToStringHelper(WebPrintingOrientationRequested value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrintingOrientationRequested::kPortrait:
      return "kPortrait";
    case WebPrintingOrientationRequested::kLandscape:
      return "kLandscape";
    default:
      return nullptr;
  }
}

std::string WebPrintingOrientationRequestedToString(WebPrintingOrientationRequested value) {
  const char *str = WebPrintingOrientationRequestedToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrintingOrientationRequested value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrintingOrientationRequested value) {
  return os << WebPrintingOrientationRequestedToString(value);
}

NOINLINE static const char* WebPrinterStateToStringHelper(WebPrinterState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrinterState::kIdle:
      return "kIdle";
    case WebPrinterState::kProcessing:
      return "kProcessing";
    case WebPrinterState::kStopped:
      return "kStopped";
    default:
      return nullptr;
  }
}

std::string WebPrinterStateToString(WebPrinterState value) {
  const char *str = WebPrinterStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrinterState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrinterState value) {
  return os << WebPrinterStateToString(value);
}

NOINLINE static const char* WebPrinterStateReasonToStringHelper(WebPrinterStateReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrinterStateReason::kNone:
      return "kNone";
    case WebPrinterStateReason::kOther:
      return "kOther";
    case WebPrinterStateReason::kConnectingToDevice:
      return "kConnectingToDevice";
    case WebPrinterStateReason::kCoverOpen:
      return "kCoverOpen";
    case WebPrinterStateReason::kDeveloperEmpty:
      return "kDeveloperEmpty";
    case WebPrinterStateReason::kDeveloperLow:
      return "kDeveloperLow";
    case WebPrinterStateReason::kDoorOpen:
      return "kDoorOpen";
    case WebPrinterStateReason::kFuserOverTemp:
      return "kFuserOverTemp";
    case WebPrinterStateReason::kFuserUnderTemp:
      return "kFuserUnderTemp";
    case WebPrinterStateReason::kInputTrayMissing:
      return "kInputTrayMissing";
    case WebPrinterStateReason::kInterlockOpen:
      return "kInterlockOpen";
    case WebPrinterStateReason::kInterpreterResourceUnavailable:
      return "kInterpreterResourceUnavailable";
    case WebPrinterStateReason::kMarkerSupplyEmpty:
      return "kMarkerSupplyEmpty";
    case WebPrinterStateReason::kMarkerSupplyLow:
      return "kMarkerSupplyLow";
    case WebPrinterStateReason::kMarkerWasteAlmostFull:
      return "kMarkerWasteAlmostFull";
    case WebPrinterStateReason::kMarkerWasteFull:
      return "kMarkerWasteFull";
    case WebPrinterStateReason::kMediaEmpty:
      return "kMediaEmpty";
    case WebPrinterStateReason::kMediaJam:
      return "kMediaJam";
    case WebPrinterStateReason::kMediaLow:
      return "kMediaLow";
    case WebPrinterStateReason::kMediaNeeded:
      return "kMediaNeeded";
    case WebPrinterStateReason::kMovingToPaused:
      return "kMovingToPaused";
    case WebPrinterStateReason::kOpcLifeOver:
      return "kOpcLifeOver";
    case WebPrinterStateReason::kOpcNearEol:
      return "kOpcNearEol";
    case WebPrinterStateReason::kOutputAreaAlmostFull:
      return "kOutputAreaAlmostFull";
    case WebPrinterStateReason::kOutputAreaFull:
      return "kOutputAreaFull";
    case WebPrinterStateReason::kOutputTrayMissing:
      return "kOutputTrayMissing";
    case WebPrinterStateReason::kPaused:
      return "kPaused";
    case WebPrinterStateReason::kShutdown:
      return "kShutdown";
    case WebPrinterStateReason::kSpoolAreaFull:
      return "kSpoolAreaFull";
    case WebPrinterStateReason::kStoppedPartly:
      return "kStoppedPartly";
    case WebPrinterStateReason::kStopping:
      return "kStopping";
    case WebPrinterStateReason::kTimedOut:
      return "kTimedOut";
    case WebPrinterStateReason::kTonerEmpty:
      return "kTonerEmpty";
    case WebPrinterStateReason::kTonerLow:
      return "kTonerLow";
    case WebPrinterStateReason::kCupsPkiExpired:
      return "kCupsPkiExpired";
    default:
      return nullptr;
  }
}

std::string WebPrinterStateReasonToString(WebPrinterStateReason value) {
  const char *str = WebPrinterStateReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrinterStateReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrinterStateReason value) {
  return os << WebPrinterStateReasonToString(value);
}

NOINLINE static const char* WebPrintJobStateToStringHelper(WebPrintJobState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrintJobState::kPending:
      return "kPending";
    case WebPrintJobState::kProcessing:
      return "kProcessing";
    case WebPrintJobState::kCompleted:
      return "kCompleted";
    case WebPrintJobState::kCanceled:
      return "kCanceled";
    case WebPrintJobState::kAborted:
      return "kAborted";
    default:
      return nullptr;
  }
}

std::string WebPrintJobStateToString(WebPrintJobState value) {
  const char *str = WebPrintJobStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrintJobState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrintJobState value) {
  return os << WebPrintJobStateToString(value);
}

NOINLINE static const char* GetPrintersErrorToStringHelper(GetPrintersError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GetPrintersError::kUserPermissionDenied:
      return "kUserPermissionDenied";
    default:
      return nullptr;
  }
}

std::string GetPrintersErrorToString(GetPrintersError value) {
  const char *str = GetPrintersErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GetPrintersError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GetPrintersError value) {
  return os << GetPrintersErrorToString(value);
}

NOINLINE static const char* WebPrinterFetchErrorToStringHelper(WebPrinterFetchError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrinterFetchError::kPrinterUnreachable:
      return "kPrinterUnreachable";
    case WebPrinterFetchError::kUserPermissionDenied:
      return "kUserPermissionDenied";
    default:
      return nullptr;
  }
}

std::string WebPrinterFetchErrorToString(WebPrinterFetchError value) {
  const char *str = WebPrinterFetchErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrinterFetchError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrinterFetchError value) {
  return os << WebPrinterFetchErrorToString(value);
}

NOINLINE static const char* WebPrintErrorToStringHelper(WebPrintError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebPrintError::kPrinterUnreachable:
      return "kPrinterUnreachable";
    case WebPrintError::kDocumentMalformed:
      return "kDocumentMalformed";
    case WebPrintError::kPrintJobTemplateAttributesMismatch:
      return "kPrintJobTemplateAttributesMismatch";
    case WebPrintError::kUserPermissionDenied:
      return "kUserPermissionDenied";
    default:
      return nullptr;
  }
}

std::string WebPrintErrorToString(WebPrintError value) {
  const char *str = WebPrintErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebPrintError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebPrintError value) {
  return os << WebPrintErrorToString(value);
}

namespace internal {
// static
bool WebPrintingMediaSizeDimension_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebPrintingMediaSizeDimension_Data* object = static_cast<const WebPrintingMediaSizeDimension_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebPrintingMediaSizeDimension_Tag::kRange: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_range, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_range, validation_context))
        return false;
      return true;
    }
    case WebPrintingMediaSizeDimension_Tag::kValue: {

      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebPrintingMediaSizeDimension");
      return false;
    }
  }
}
// static
bool GetPrintersResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GetPrintersResult_Data* object = static_cast<const GetPrintersResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GetPrintersResult_Tag::kPrinters: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_printers, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& printers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_printers, validation_context,
                                             &printers_validate_params)) {
        return false;
      }
      return true;
    }
    case GetPrintersResult_Tag::kError: {


      if (!::blink::mojom::internal::GetPrintersError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GetPrintersResult");
      return false;
    }
  }
}
// static
bool WebPrinterFetchResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebPrinterFetchResult_Data* object = static_cast<const WebPrinterFetchResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebPrinterFetchResult_Tag::kPrinterAttributes: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_printer_attributes, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_printer_attributes, validation_context))
        return false;
      return true;
    }
    case WebPrinterFetchResult_Tag::kError: {


      if (!::blink::mojom::internal::WebPrinterFetchError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebPrinterFetchResult");
      return false;
    }
  }
}
// static
bool WebPrintResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebPrintResult_Data* object = static_cast<const WebPrintResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebPrintResult_Tag::kPrintJobInfo: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_print_job_info, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_print_job_info, validation_context))
        return false;
      return true;
    }
    case WebPrintResult_Tag::kError: {


      if (!::blink::mojom::internal::WebPrintError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebPrintResult");
      return false;
    }
  }
}


// static
bool WebPrinterInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrinterInfo_Data* object =
      static_cast<const WebPrinterInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& printer_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->printer_name, validation_context,
                                         &printer_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& printer_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->printer_id, validation_context,
                                         &printer_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->printer_remote, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->printer_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebPrinterInfo_Data::WebPrinterInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintingRange_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintingRange_Data* object =
      static_cast<const WebPrintingRange_Data*>(data);

  return true;
}

WebPrintingRange_Data::WebPrintingRange_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintingMediaSize_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintingMediaSize_Data* object =
      static_cast<const WebPrintingMediaSize_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->x_dimension, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->x_dimension, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->y_dimension, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->y_dimension, validation_context))
    return false;

  return true;
}

WebPrintingMediaSize_Data::WebPrintingMediaSize_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintingMediaCollection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintingMediaCollection_Data* object =
      static_cast<const WebPrintingMediaCollection_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->media_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_size_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_size_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_size_name, validation_context,
                                         &media_size_name_validate_params)) {
    return false;
  }

  return true;
}

WebPrintingMediaCollection_Data::WebPrintingMediaCollection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrinterAttributes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 160, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrinterAttributes_Data* object =
      static_cast<const WebPrinterAttributes_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->copies_supported, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->copies_supported, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_col_default, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->media_col_default, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_col_database, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_col_database_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_col_database, validation_context,
                                         &media_col_database_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& media_source_default_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_source_default, validation_context,
                                         &media_source_default_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_source_supported, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_source_supported_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->media_source_supported, validation_context,
                                         &media_source_supported_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::WebPrintingMultipleDocumentHandling_Data
        ::Validate(object->multiple_document_handling_default, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->multiple_document_handling_supported, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& multiple_document_handling_supported_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintingMultipleDocumentHandling_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->multiple_document_handling_supported, validation_context,
                                         &multiple_document_handling_supported_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::WebPrintingOrientationRequested_Data
        ::Validate(object->orientation_requested_default, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->orientation_requested_supported, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& orientation_requested_supported_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintingOrientationRequested_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->orientation_requested_supported, validation_context,
                                         &orientation_requested_supported_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_resolution_default, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->printer_resolution_default, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_resolution_supported, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& printer_resolution_supported_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->printer_resolution_supported, validation_context,
                                         &printer_resolution_supported_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::WebPrintColorMode_Data
        ::Validate(object->print_color_mode_default, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->print_color_mode_supported, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& print_color_mode_supported_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintColorMode_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->print_color_mode_supported, validation_context,
                                         &print_color_mode_supported_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::WebPrintQuality_Data
        ::Validate(object->print_quality_default_$value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->print_quality_supported, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& print_quality_supported_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintQuality_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->print_quality_supported, validation_context,
                                         &print_quality_supported_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::WebPrinterState_Data
        ::Validate(object->printer_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_state_message, 19, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& printer_state_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->printer_state_message, validation_context,
                                         &printer_state_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_state_reasons, 20, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& printer_state_reasons_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrinterStateReason_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->printer_state_reasons, validation_context,
                                         &printer_state_reasons_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::WebPrintingSides_Data
        ::Validate(object->sides_default_$value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sides_supported, 23, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sides_supported_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintingSides_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->sides_supported, validation_context,
                                         &sides_supported_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printer_id, 24, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& printer_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->printer_id, validation_context,
                                         &printer_id_validate_params)) {
    return false;
  }

  return true;
}

WebPrinterAttributes_Data::WebPrinterAttributes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintingMediaCollectionRequested_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintingMediaCollectionRequested_Data* object =
      static_cast<const WebPrintingMediaCollectionRequested_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->media_size, validation_context))
    return false;

  return true;
}

WebPrintingMediaCollectionRequested_Data::WebPrintingMediaCollectionRequested_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintJobTemplateAttributes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintJobTemplateAttributes_Data* object =
      static_cast<const WebPrintJobTemplateAttributes_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->job_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& job_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->job_name, validation_context,
                                         &job_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->media_col, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& media_source_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_source, validation_context,
                                         &media_source_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::WebPrintingMultipleDocumentHandling_Data
        ::Validate(object->multiple_document_handling_$value, validation_context))
    return false;


  if (!::blink::mojom::internal::WebPrintingOrientationRequested_Data
        ::Validate(object->orientation_requested_$value, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->printer_resolution, validation_context))
    return false;


  if (!::blink::mojom::internal::WebPrintColorMode_Data
        ::Validate(object->print_color_mode_$value, validation_context))
    return false;


  if (!::blink::mojom::internal::WebPrintQuality_Data
        ::Validate(object->print_quality_$value, validation_context))
    return false;


  if (!::blink::mojom::internal::WebPrintingSides_Data
        ::Validate(object->sides_$value, validation_context))
    return false;

  return true;
}

WebPrintJobTemplateAttributes_Data::WebPrintJobTemplateAttributes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintJobUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintJobUpdate_Data* object =
      static_cast<const WebPrintJobUpdate_Data*>(data);


  if (!::blink::mojom::internal::WebPrintJobState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

WebPrintJobUpdate_Data::WebPrintJobUpdate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintJobInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintJobInfo_Data* object =
      static_cast<const WebPrintJobInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->job_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& job_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->job_name, validation_context,
                                         &job_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->controller, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->controller,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebPrintJobInfo_Data::WebPrintJobInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintJobStateObserver_OnWebPrintJobUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintJobStateObserver_OnWebPrintJobUpdate_Params_Data* object =
      static_cast<const WebPrintJobStateObserver_OnWebPrintJobUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update, validation_context))
    return false;

  return true;
}

WebPrintJobStateObserver_OnWebPrintJobUpdate_Params_Data::WebPrintJobStateObserver_OnWebPrintJobUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintJobController_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintJobController_Cancel_Params_Data* object =
      static_cast<const WebPrintJobController_Cancel_Params_Data*>(data);

  return true;
}

WebPrintJobController_Cancel_Params_Data::WebPrintJobController_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrinter_FetchAttributes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrinter_FetchAttributes_Params_Data* object =
      static_cast<const WebPrinter_FetchAttributes_Params_Data*>(data);

  return true;
}

WebPrinter_FetchAttributes_Params_Data::WebPrinter_FetchAttributes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrinter_FetchAttributes_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrinter_FetchAttributes_ResponseParams_Data* object =
      static_cast<const WebPrinter_FetchAttributes_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebPrinter_FetchAttributes_ResponseParams_Data::WebPrinter_FetchAttributes_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrinter_Print_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrinter_Print_Params_Data* object =
      static_cast<const WebPrinter_Print_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->document, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->document,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attributes, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attributes, validation_context))
    return false;

  return true;
}

WebPrinter_Print_Params_Data::WebPrinter_Print_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrinter_Print_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrinter_Print_ResponseParams_Data* object =
      static_cast<const WebPrinter_Print_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebPrinter_Print_ResponseParams_Data::WebPrinter_Print_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintingService_GetPrinters_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintingService_GetPrinters_Params_Data* object =
      static_cast<const WebPrintingService_GetPrinters_Params_Data*>(data);

  return true;
}

WebPrintingService_GetPrinters_Params_Data::WebPrintingService_GetPrinters_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPrintingService_GetPrinters_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPrintingService_GetPrinters_ResponseParams_Data* object =
      static_cast<const WebPrintingService_GetPrinters_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebPrintingService_GetPrinters_ResponseParams_Data::WebPrintingService_GetPrinters_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrintingMultipleDocumentHandling>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrintingMultipleDocumentHandling value) {
  return std::move(context).WriteString(::blink::mojom::WebPrintingMultipleDocumentHandlingToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrintingSides>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrintingSides value) {
  return std::move(context).WriteString(::blink::mojom::WebPrintingSidesToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrintQuality>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrintQuality value) {
  return std::move(context).WriteString(::blink::mojom::WebPrintQualityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrintColorMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrintColorMode value) {
  return std::move(context).WriteString(::blink::mojom::WebPrintColorModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrintingOrientationRequested>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrintingOrientationRequested value) {
  return std::move(context).WriteString(::blink::mojom::WebPrintingOrientationRequestedToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrinterState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrinterState value) {
  return std::move(context).WriteString(::blink::mojom::WebPrinterStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrinterStateReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrinterStateReason value) {
  return std::move(context).WriteString(::blink::mojom::WebPrinterStateReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrintJobState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrintJobState value) {
  return std::move(context).WriteString(::blink::mojom::WebPrintJobStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::GetPrintersError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::GetPrintersError value) {
  return std::move(context).WriteString(::blink::mojom::GetPrintersErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrinterFetchError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrinterFetchError value) {
  return std::move(context).WriteString(::blink::mojom::WebPrinterFetchErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebPrintError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebPrintError value) {
  return std::move(context).WriteString(::blink::mojom::WebPrintErrorToString(value));
}

} // namespace perfetto