// third_party/blink/public/mojom/prerender/prerender.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/prerender/prerender.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/prerender/prerender.mojom-params-data.h"
#include "third_party/blink/public/mojom/prerender/prerender.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/prerender/prerender.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/prerender/prerender.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
PrerenderAttributes::PrerenderAttributes()
    : url(),
      trigger_type(),
      referrer(),
      view_size() {}

PrerenderAttributes::PrerenderAttributes(
    const ::blink::KURL& url_in,
    PrerenderTriggerType trigger_type_in,
    ::blink::mojom::blink::ReferrerPtr referrer_in,
    const ::gfx::Size& view_size_in)
    : url(std::move(url_in)),
      trigger_type(std::move(trigger_type_in)),
      referrer(std::move(referrer_in)),
      view_size(std::move(view_size_in)) {}

PrerenderAttributes::~PrerenderAttributes() = default;

void PrerenderAttributes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_type"), this->trigger_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PrerenderTriggerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_size"), this->view_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrerenderAttributes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

NoStatePrefetchProcessor::IPCStableHashFunction NoStatePrefetchProcessor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NoStatePrefetchProcessor>(message.name())) {
    case messages::NoStatePrefetchProcessor::kStart: {
      return &NoStatePrefetchProcessor::Start_Sym::IPCStableHash;
    }
    case messages::NoStatePrefetchProcessor::kCancel: {
      return &NoStatePrefetchProcessor::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NoStatePrefetchProcessor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NoStatePrefetchProcessor>(message.name())) {
      case messages::NoStatePrefetchProcessor::kStart:
            return "Receive blink::mojom::NoStatePrefetchProcessor::Start";
      case messages::NoStatePrefetchProcessor::kCancel:
            return "Receive blink::mojom::NoStatePrefetchProcessor::Cancel";
    }
  } else {
    switch (static_cast<messages::NoStatePrefetchProcessor>(message.name())) {
      case messages::NoStatePrefetchProcessor::kStart:
            return "Receive reply blink::mojom::NoStatePrefetchProcessor::Start";
      case messages::NoStatePrefetchProcessor::kCancel:
            return "Receive reply blink::mojom::NoStatePrefetchProcessor::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NoStatePrefetchProcessor::Start_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f6cd5e7;  // IPCStableHash for blink::mojom::NoStatePrefetchProcessor::Start
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NoStatePrefetchProcessor::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2c3cd17;  // IPCStableHash for blink::mojom::NoStatePrefetchProcessor::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NoStatePrefetchProcessorProxy::NoStatePrefetchProcessorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NoStatePrefetchProcessorProxy::Start(
    PrerenderAttributesPtr in_prerender_attribute) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::NoStatePrefetchProcessor::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prerender_attribute"), in_prerender_attribute,
                        "<value of type PrerenderAttributesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NoStatePrefetchProcessor::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NoStatePrefetchProcessor_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prerender_attribute)::BaseType> prerender_attribute_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PrerenderAttributesDataView>(
    in_prerender_attribute,
    prerender_attribute_fragment);

  params->prerender_attribute.Set(
      prerender_attribute_fragment.is_null() ? nullptr : prerender_attribute_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->prerender_attribute.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null prerender_attribute in NoStatePrefetchProcessor.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NoStatePrefetchProcessor::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NoStatePrefetchProcessorProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::NoStatePrefetchProcessor::Cancel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NoStatePrefetchProcessor::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::NoStatePrefetchProcessor_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NoStatePrefetchProcessor::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NoStatePrefetchProcessorStubDispatch::Accept(
    NoStatePrefetchProcessor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NoStatePrefetchProcessor>(message->header()->name)) {
    case messages::NoStatePrefetchProcessor::kStart: {
      DCHECK(message->is_serialized());
      internal::NoStatePrefetchProcessor_Start_Params_Data* params =
          reinterpret_cast<internal::NoStatePrefetchProcessor_Start_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NoStatePrefetchProcessor.0
      bool success = true;
      PrerenderAttributesPtr p_prerender_attribute{};
      NoStatePrefetchProcessor_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrerenderAttribute(&p_prerender_attribute))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NoStatePrefetchProcessor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        
        std::move(p_prerender_attribute));
      return true;
    }
    case messages::NoStatePrefetchProcessor::kCancel: {
      DCHECK(message->is_serialized());
      internal::NoStatePrefetchProcessor_Cancel_Params_Data* params =
          reinterpret_cast<internal::NoStatePrefetchProcessor_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NoStatePrefetchProcessor.1
      bool success = true;
      NoStatePrefetchProcessor_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NoStatePrefetchProcessor::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        );
      return true;
    }
  }
  return false;
}

// static
bool NoStatePrefetchProcessorStubDispatch::AcceptWithResponder(
    NoStatePrefetchProcessor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NoStatePrefetchProcessor>(message->header()->name)) {
    case messages::NoStatePrefetchProcessor::kStart: {
      break;
    }
    case messages::NoStatePrefetchProcessor::kCancel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNoStatePrefetchProcessorValidationInfo[] = {
    { &internal::NoStatePrefetchProcessor_Start_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NoStatePrefetchProcessor_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool NoStatePrefetchProcessorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::NoStatePrefetchProcessor::Name_,
    kNoStatePrefetchProcessorValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PrerenderAttributes::DataView, ::blink::mojom::blink::PrerenderAttributesPtr>::Read(
    ::blink::mojom::blink::PrerenderAttributes::DataView input,
    ::blink::mojom::blink::PrerenderAttributesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PrerenderAttributesPtr result(::blink::mojom::blink::PrerenderAttributes::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTriggerType(&result->trigger_type))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadViewSize(&result->view_size))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void NoStatePrefetchProcessorInterceptorForTesting::Start(PrerenderAttributesPtr prerender_attribute) {
  GetForwardingInterface()->Start(
    std::move(prerender_attribute)
    );
}
void NoStatePrefetchProcessorInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
NoStatePrefetchProcessorAsyncWaiter::NoStatePrefetchProcessorAsyncWaiter(
    NoStatePrefetchProcessor* proxy) : proxy_(proxy) {}

NoStatePrefetchProcessorAsyncWaiter::~NoStatePrefetchProcessorAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif